/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenHelper;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeProjectOpenProcessor
extends CidrProjectOpenProcessor {
    private static final Key<OpenProjectSpec> DATA_KEY = Key.create((String)"CMAKE_FILE_TO_OPEN_KEY");
    public static final List<String> SUPPORTED_FILES = ContainerUtil.immutableList((Object[])new String[]{"CMakeLists.txt", "CMakeCache.txt"});
    private static final ProjectOpenHelper.SupportedFileChecker CHECKER = new ProjectOpenHelper.SupportedFileChecker(){

        @Override
        public boolean isSupportedFile(@NotNull VirtualFile file) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            return this.isSupportedFile(file.getName());
        }

        @Override
        public boolean isSupportedFile(@NotNull String fileName) {
            if (fileName == null) {
                1.$$$reportNull$$$0(1);
            }
            for (String each : SUPPORTED_FILES) {
                if (!FileUtil.namesEqual((String)each, (String)fileName)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor$1";
            objectArray[2] = "isSupportedFile";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ProjectOpenHelper<OpenProjectSpec> ourProjectOpenHelper = new ProjectOpenHelper<OpenProjectSpec>(DATA_KEY, CHECKER);

    public CMakeProjectOpenProcessor() {
        super("CMake Project", ourProjectOpenHelper);
    }

    @NotNull
    public static ProjectOpenHelper<OpenProjectSpec> getHelper() {
        ProjectOpenHelper<OpenProjectSpec> projectOpenHelper = ourProjectOpenHelper;
        if (projectOpenHelper == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return projectOpenHelper;
    }

    @Override
    public boolean canOpenProject(VirtualFile file) {
        if ((file = CMakeProjectOpenProcessor.findSupportedSubFile(file)) == null) {
            return false;
        }
        return super.canOpenProject(file);
    }

    @Nullable
    public static VirtualFile findSupportedSubFile(@NotNull VirtualFile file) {
        if (file == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        if (file.isDirectory()) {
            for (String each : SUPPORTED_FILES) {
                VirtualFile supportedFile = file.findChild(each);
                if (supportedFile == null) continue;
                return supportedFile;
            }
            return null;
        }
        return CHECKER.isSupportedFile(file) ? file : null;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        if ((virtualFile = CMakeProjectOpenProcessor.findSupportedSubFile(virtualFile)) == null) {
            return null;
        }
        Pair<VirtualFile, OpenProjectSpec> spec = CMakeProjectOpenProcessor.createOpenProjectSpec(virtualFile);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && ((OpenProjectSpec)spec.second).generationDir != null && !((OpenProjectSpec)spec.second).isInSourceGeneration()) {
            String generatorWarning = "";
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            CMakeGeneratorType generatorType = CMakeGeneratorType.fromGeneratorSpec(((OpenProjectSpec)spec.second).generator);
            if (generatorType == null || !generatorType.isSupported()) {
                CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
                generatorWarning = "\nThis project was generated using " + ((OpenProjectSpec)spec.second).generator + " generator, which is not supported by " + productName + ".\nIt will be regenerated using " + CMakeGenerator.getGeneratorSpec(toolchain == null ? null : toolchain.getToolSet(), false);
            }
            String relativeSourcePath = FileUtil.getRelativePath((File)((OpenProjectSpec)spec.second).generationDir, (File)((OpenProjectSpec)spec.second).sourceDir);
            if (Messages.showOkCancelDialog((Project)projectToClose, (String)("Selected directory contains generated CMake files.\nDo you want to open the source directory " + (relativeSourcePath == null ? ((OpenProjectSpec)spec.second).sourceDir : relativeSourcePath) + "?\n" + generatorWarning), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.yes", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return null;
            }
        }
        return ourProjectOpenHelper.openProject((VirtualFile)spec.first, projectToClose, forceOpenInNewFrame, (OpenProjectSpec)spec.second);
    }

    @NotNull
    private static Pair<VirtualFile, OpenProjectSpec> createOpenProjectSpec(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        File selectedDir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile.getParent());
        File cacheIOFile = new File(selectedDir, "CMakeCache.txt");
        VirtualFile cmakeListsFile = virtualFile;
        File sourceDir = selectedDir;
        File generationDir = null;
        String buildType = null;
        String generator = null;
        if (cacheIOFile.exists()) {
            generationDir = selectedDir;
            try {
                VirtualFile cacheVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(cacheIOFile);
                CMakeCacheFile cacheFile = new CMakeCacheFile(cacheIOFile, cacheVFile == null ? "UTF-8" : cacheVFile.getCharset().name());
                CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
                String sourceDirPathFromCache = Cygwin.toLocalPath(cacheFile.getVariableValue("CMAKE_HOME_DIRECTORY"), toolchain == null ? null : toolchain.getCygwin());
                if (sourceDirPathFromCache != null) {
                    File cmakeLists = new File(sourceDirPathFromCache + "/" + "CMakeLists.txt");
                    VirtualFile cmakeListsFileFromCache = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(cmakeLists);
                    if (cmakeListsFileFromCache != null) {
                        cmakeListsFile = cmakeListsFileFromCache;
                        sourceDir = new File(sourceDirPathFromCache);
                        buildType = cacheFile.getVariableValue("CMAKE_BUILD_TYPE");
                        generator = cacheFile.getVariableValue("CMAKE_GENERATOR");
                    }
                }
            }
            catch (CMakeException e) {
                CPPLog.LOG.warn((Throwable)e);
            }
        }
        Pair pair2 = Pair.create((Object)cmakeListsFile, (Object)new OpenProjectSpec(sourceDir, generationDir, buildType, generator));
        if (pair2 == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        return pair2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenProjectSpec";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSupportedSubFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOpenProjectSpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OpenProjectSpec {
        @NotNull
        public final File sourceDir;
        @Nullable
        public final File generationDir;
        @Nullable
        public final String buildType;
        @Nullable
        public final String generator;

        public OpenProjectSpec(@NotNull File sourceDir, @Nullable File generationDir, @Nullable String buildType, @Nullable String generator) {
            if (sourceDir == null) {
                OpenProjectSpec.$$$reportNull$$$0(0);
            }
            this.sourceDir = sourceDir;
            this.generationDir = generationDir;
            this.buildType = buildType;
            this.generator = generator;
        }

        public boolean isInSourceGeneration() {
            return FileUtil.filesEqual((File)this.sourceDir, (File)this.generationDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor$OpenProjectSpec", "<init>"));
        }
    }
}

