/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PredefinedVariables;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.CPPPathManager;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.toolchains.CMake;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeRunner {
    private static final String FIX_CYGWIN_PERMISSIONS_KEY = "cidr.cygwin.cmakePermissionsFix";
    private static final boolean FIX_CYGWIN_PERMISSIONS = Registry.is((String)"cidr.cygwin.cmakePermissionsFix");
    private static final Pattern CYGWIN_ERROR_PATTERN = Pattern.compile(".+directory \\W/cygdrive/.+ does not exist.*", 32);
    private static final Pattern MINGW_ANTIVIRUS_ERROR_PATTERN = Pattern.compile(".*file STRINGS.*a\\.exe.*cannot be read.*", 40);
    private static final Semaphore ourCygwinCopyLock = new Semaphore(1);
    private static volatile boolean ourCygwinPermissionsFixed = false;
    private static volatile boolean ourEmulateCMakeExecutionErrorInTests = false;

    public static void setEmulateCMakeExecutionErrorInTests(boolean emulate) {
        ourEmulateCMakeExecutionErrorInTests = emulate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CMakeOutput runCMake(@NotNull CMakeRunnerStep.Parameters parameters) throws CMakeException {
        if (parameters == null) {
            CMakeRunner.$$$reportNull$$$0(0);
        }
        final CMakeEnvironment environment = parameters.getCMakeEnvironment();
        GeneralCommandLine cl = CMakeRunner.buildCommandLine(environment, parameters.getOutputDir(), parameters.getParameters(), parameters.isPassSystemEnvironment(), parameters.getAdditionalEnvironment());
        cl.addParameter(environment.toEnvPath(parameters.getProjectDir().getPath()));
        cl.setRedirectErrorStream(true);
        ProcessOutput output = null;
        final StringBuilder cmakeDiagnostics = new StringBuilder();
        try {
            BaseProcessHandler process2;
            if (ourEmulateCMakeExecutionErrorInTests) {
                throw new CMakeException("Emulated CMake error");
            }
            CPPLog.LOG.info("Executing CMake: " + cl.getCommandLineString());
            try {
                process2 = environment.createProcess(cl, false, false);
            }
            catch (ExecutionException e) {
                throw new CMakeException(e);
            }
            Runnable shutdownHook = new Runnable(){

                @Override
                public void run() {
                    environment.killProcessTree(process2);
                }
            };
            ShutDownTracker.getInstance().registerShutdownTask(shutdownHook);
            process2.addProcessListener((ProcessListener)new ProcessAdapter(){
                private final CPPToolSet toolset;
                private final boolean shouldScan;
                private volatile StringBuffer buffer;
                {
                    this.toolset = environment.getToolSet();
                    this.shouldScan = this.toolset != null && (this.toolset.isCygwin() || this.toolset.isMinGW());
                    this.buffer = this.shouldScan ? new StringBuffer() : null;
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    StringBuffer buffer;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((buffer = this.buffer) == null) {
                        return;
                    }
                    buffer.append(event.getText());
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    StringBuffer buffer;
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if ((buffer = this.buffer) == null) {
                        return;
                    }
                    this.buffer = null;
                    for (String diagnostic : CMakeRunner.analyzeCMakeOutput(buffer, this.toolset)) {
                        cmakeDiagnostics.append(diagnostic);
                        String[] lines = StringUtil.splitByLines((String)diagnostic);
                        int len = Arrays.stream(lines).map(line -> line.length()).max(Integer::compareTo).orElse(0);
                        String header = StringUtil.repeat((String)"-", (int)len);
                        String indent = "  ";
                        StringBuilder cmakeErrorText = new StringBuilder();
                        cmakeErrorText.append("\nCMake Error:\n");
                        cmakeErrorText.append("  ").append(header).append("\n");
                        for (String each : lines) {
                            cmakeErrorText.append("  ").append(each).append("\n");
                        }
                        cmakeErrorText.append("  ").append(header).append("\n");
                        process2.notifyTextAvailable(cmakeErrorText.toString(), ProcessOutputTypes.SYSTEM);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            try {
                parameters.getListener().processStarted((ProcessHandler)process2);
                output = CidrToolsUtil.runWithProgress(process2, 0);
                if (output.isCancelled()) {
                    throw new ProcessCanceledException();
                }
            }
            finally {
                ShutDownTracker.getInstance().unregisterShutdownTask(shutdownHook);
                shutdownHook.run();
            }
            CPPLog.LOG.info((output != null ? "CMake exit code: " + output.getExitCode() : "No output") + " for command: " + cl.getCommandLineString());
        }
        catch (Throwable throwable) {
            CPPLog.LOG.info((output != null ? "CMake exit code: " + output.getExitCode() : "No output") + " for command: " + cl.getCommandLineString());
            throw throwable;
        }
        CMakeOutput cMakeOutput = new CMakeOutput(output.getExitCode(), output.getStdout(), cmakeDiagnostics);
        if (cMakeOutput == null) {
            CMakeRunner.$$$reportNull$$$0(1);
        }
        return cMakeOutput;
    }

    private static List<String> analyzeCMakeOutput(StringBuffer output, @Nullable CPPToolSet toolSet) {
        String diagnostic = null;
        if (toolSet != null) {
            if (toolSet.isCygwin() && CYGWIN_ERROR_PATTERN.matcher(output).matches()) {
                diagnostic = "Selected CMake might be incompatible with the Cygwin environment.\nIn order to run on Cygwin, CMake needs to be specially compiled.\nPlease select either CMake bundled with " + ApplicationNamesInfo.getInstance().getProductName() + " or CMake from the Cygwin installation.\n";
            } else if (toolSet.isMinGW() && MINGW_ANTIVIRUS_ERROR_PATTERN.matcher(output).matches()) {
                diagnostic = "Antivirus software might have incorrectly identified files generated by CMake as malicious.\nTo workaround this problem, please exclude the project dir and '" + toolSet.getHomePath() + "' from the scanning.\n";
            }
        }
        return ContainerUtil.createMaybeSingletonList(diagnostic);
    }

    @NotNull
    public static GeneralCommandLine buildCommandLine(@NotNull CMakeEnvironment environment, @NotNull File outputDir, @NotNull List<String> parameters, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment) throws CMakeException {
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(2);
        }
        if (outputDir == null) {
            CMakeRunner.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            CMakeRunner.$$$reportNull$$$0(4);
        }
        if (additionalEnvironment == null) {
            CMakeRunner.$$$reportNull$$$0(5);
        }
        GeneralCommandLine generalCommandLine = CMakeRunner.buildCommandLine(environment, outputDir, parameters, passSystemEnvironment, additionalEnvironment, false);
        if (generalCommandLine == null) {
            CMakeRunner.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    @NotNull
    public static GeneralCommandLine buildCommandLine(@NotNull CMakeEnvironment environment, @NotNull File outputDir, @NotNull List<String> parameters, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment, boolean usePty) throws CMakeException {
        PtyCommandLine cl;
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(7);
        }
        if (outputDir == null) {
            CMakeRunner.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            CMakeRunner.$$$reportNull$$$0(9);
        }
        if (additionalEnvironment == null) {
            CMakeRunner.$$$reportNull$$$0(10);
        }
        if (usePty) {
            cl = new PtyCommandLine();
            cl.setConsoleMode(false);
            CPPToolSet toolSet = environment.getToolSet();
            if (toolSet != null && toolSet.isCygwin()) {
                cl.setUseCygwinLaunch(true);
            }
        } else {
            cl = new GeneralCommandLine();
        }
        cl.withParentEnvironmentType(passSystemEnvironment ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        cl.setExePath(CMakeRunner.getCMakeExecutableWithFixedCygwinPermissions(environment).getExecutablePath());
        try {
            environment.prepare((GeneralCommandLine)cl, CidrToolEnvironment.PrepareFor.BUILD);
        }
        catch (ExecutionException e) {
            throw new CMakeException(e);
        }
        for (String variable : PredefinedVariables.getIDEVariables()) {
            cl.withEnvironment(variable, "TRUE");
        }
        cl.getEnvironment().putAll(additionalEnvironment);
        cl.setWorkDirectory(outputDir);
        cl.addParameters(parameters);
        PtyCommandLine ptyCommandLine = cl;
        if (ptyCommandLine == null) {
            CMakeRunner.$$$reportNull$$$0(11);
        }
        return ptyCommandLine;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static CMake getCMakeExecutableWithFixedCygwinPermissions(@NotNull CMakeEnvironment environment) throws CMakeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static CMake doGetCMakeExecutableWithFixedCygwinPermissions(@NotNull CMakeEnvironment environment) throws CMakeException {
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(14);
        }
        CMake cmake = environment.getCMake();
        CPPToolSet toolset = environment.getToolSet();
        if (toolset == null || !toolset.isCygwin() || !FIX_CYGWIN_PERMISSIONS) {
            CMake cMake = cmake;
            if (cMake == null) {
                CMakeRunner.$$$reportNull$$$0(15);
            }
            return cMake;
        }
        File cmakeExecutable = cmake.getExecutable();
        boolean isBundledCygwinCMake = FileUtil.filesEqual((File)cmakeExecutable, (File)CPPPathManager.getBundledCMakeBinary(true));
        if (!isBundledCygwinCMake) {
            CMake cMake = cmake;
            if (cMake == null) {
                CMakeRunner.$$$reportNull$$$0(16);
            }
            return cMake;
        }
        File cmakeCopyHome = new File(PathManager.getSystemPath(), "cygwin_cmake");
        CMake cmakeCopy = new CMake(new File(cmakeCopyHome, "bin/" + cmakeExecutable.getName()), environment);
        if (ourCygwinPermissionsFixed) {
            CMake cMake = cmakeCopy;
            if (cMake == null) {
                CMakeRunner.$$$reportNull$$$0(17);
            }
            return cMake;
        }
        String bundledCMakeVersion = cmake.readVersion();
        if (bundledCMakeVersion == null) {
            CMake cMake = cmake;
            if (cMake == null) {
                CMakeRunner.$$$reportNull$$$0(18);
            }
            return cMake;
        }
        File flagFile = new File(cmakeCopyHome, "copied_flag_and_version.txt");
        String copyVersion = null;
        try {
            copyVersion = FileUtil.loadFile((File)flagFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bundledCMakeVersion.equals(copyVersion)) {
            CPPLog.LOG.info("Updating Cygwin CMake in " + cmakeCopyHome);
            File bundledCMakeHome = cmake.getExecutable().getParentFile().getParentFile();
            try {
                if (!FileUtil.delete((File)cmakeCopyHome)) {
                    throw new IOException("Cannot delete directory " + cmakeCopyHome);
                }
                FileUtil.copyDir((File)bundledCMakeHome, (File)cmakeCopyHome, pathname -> {
                    ProgressManager.checkCanceled();
                    return true;
                });
                copyVersion = cmakeCopy.readVersion();
                if (!bundledCMakeVersion.equals(copyVersion)) {
                    throw new IOException("Cannot execute CMake: " + cmakeCopy.getExecutable());
                }
                FileUtil.writeToFile((File)flagFile, (String)"");
                CMakeRunner.updateCMakePermissions(environment, toolset, cmakeCopyHome);
                FileUtil.writeToFile((File)flagFile, (String)copyVersion);
                if (!copyVersion.equals(FileUtil.loadFile((File)flagFile))) {
                    throw new IOException("Cannot write " + flagFile);
                }
            }
            catch (IOException e) {
                throw CMakeRunner.newPermissionsException(cmakeCopyHome, bundledCMakeHome, e);
            }
            catch (ExecutionException e) {
                throw CMakeRunner.newPermissionsException(cmakeCopyHome, bundledCMakeHome, (Exception)((Object)e));
            }
        }
        ourCygwinPermissionsFixed = true;
        CMake cMake = cmakeCopy;
        if (cMake == null) {
            CMakeRunner.$$$reportNull$$$0(19);
        }
        return cMake;
    }

    private static void updateCMakePermissions(@NotNull CMakeEnvironment environment, @NotNull CPPToolSet toolset, @NotNull File cmakeHome) throws ExecutionException {
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(20);
        }
        if (toolset == null) {
            CMakeRunner.$$$reportNull$$$0(21);
        }
        if (cmakeHome == null) {
            CMakeRunner.$$$reportNull$$$0(22);
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        cl.setExePath(toolset.getSubFilePath("bin/chmod.exe"));
        cl.addParameters(new String[]{"-R", "u+rwx", environment.toEnvPath(cmakeHome.getPath())});
        CPPLog.LOG.info("Fixing CMake permissions for Cygwin: " + cl.getCommandLineString());
        ProcessOutput output = CidrToolsUtil.runWithProgress(new CapturingProcessHandler(cl));
        if (output.getExitCode() != 0) {
            throw new ExecutionException(output.getStderr() + "\nProcess exited with code " + output.getExitCode());
        }
    }

    private static CMakeException newPermissionsException(@NotNull File cmakeHome, @NotNull File originalCMakeHome, @NotNull Exception cause) throws CMakeException {
        if (cmakeHome == null) {
            CMakeRunner.$$$reportNull$$$0(23);
        }
        if (originalCMakeHome == null) {
            CMakeRunner.$$$reportNull$$$0(24);
        }
        if (cause == null) {
            CMakeRunner.$$$reportNull$$$0(25);
        }
        return new CMakeException("Failed to update files permissions inside " + cmakeHome + "\n \nCygwin requires correct permissions for the CMake files, otherwise CMake will fail to generate the project.\nIDE tried to work this around, but failed; you can do this workaround manually:\n  1) copy " + originalCMakeHome + " to " + cmakeHome + "\n  2) in Cygwin console execute 'chmod -R u+rwx " + cmakeHome + "'\nFor more information check http://trentm.com/2005/03/cygwin-ntfs-permissions-badness.html\n \nTo disable this workaround in future, set '" + FIX_CYGWIN_PERMISSIONS_KEY + "' to 'false' in Registry (use Find Action).\n \n\nFailure reason: " + cause.getMessage(), cause);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolset";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeHome";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalCMakeHome";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "runCMake";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCMake";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateCMakePermissions";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newPermissionsException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CMakeOutput {
        private final int myExitCode;
        @NotNull
        private final CharSequence myOutput;
        @NotNull
        private final CharSequence myDiagnostics;

        public CMakeOutput(int exitCode, @NotNull CharSequence output, @NotNull CharSequence diagnostics) {
            if (output == null) {
                CMakeOutput.$$$reportNull$$$0(0);
            }
            if (diagnostics == null) {
                CMakeOutput.$$$reportNull$$$0(1);
            }
            this.myExitCode = exitCode;
            this.myOutput = output;
            this.myDiagnostics = diagnostics;
        }

        public int getExitCode() {
            return this.myExitCode;
        }

        @NotNull
        public CharSequence getOutput() {
            CharSequence charSequence = this.myOutput;
            if (charSequence == null) {
                CMakeOutput.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        @NotNull
        public CharSequence getDiagnostics() {
            CharSequence charSequence = this.myDiagnostics;
            if (charSequence == null) {
                CMakeOutput.$$$reportNull$$$0(3);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnostics";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner$CMakeOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner$CMakeOutput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiagnostics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        default public void processStarted(@NotNull ProcessHandler handler) {
            if (handler == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/cidr/cpp/cmake/CMakeRunner$Listener", "processStarted"));
        }
    }
}

