/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.cpp.CPPSettingsUtil;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.CMakeSettingsKt;
import com.jetbrains.cidr.cpp.cmake.CMakeSettingsListener;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CMakeSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002\"#B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020 H\u0016R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "isAutoReloadEnabled", "()Z", "setAutoReloadEnabled", "(Z)V", "pauseToolchainsListener", "getPauseToolchainsListener", "setPauseToolchainsListener", "", "Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings$Profile;", "profiles", "getProfiles", "()Ljava/util/List;", "setProfiles", "(Ljava/util/List;)V", "getBoolean", "", "def", "getState", "loadConfig", "element", "migrateFromSingleProfile", "migrateFromSharedBuildOptions", "loadState", "", "projectOpened", "Companion", "Profile", "intellij.clion"})
public final class CMakeSettings
extends AbstractProjectComponent
implements PersistentStateComponent<Element> {
    private volatile boolean isAutoReloadEnabled;
    @NotNull
    private volatile List<Profile> profiles;
    private volatile boolean pauseToolchainsListener;
    public static final Companion Companion = new Companion(null);

    public final boolean isAutoReloadEnabled() {
        return this.isAutoReloadEnabled;
    }

    public final void setAutoReloadEnabled(boolean value) {
        boolean old = this.isAutoReloadEnabled;
        this.isAutoReloadEnabled = value;
        if (old != this.isAutoReloadEnabled) {
            Project project2 = this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
            ((CMakeSettingsListener)project2.getMessageBus().syncPublisher(CMakeSettingsListener.Companion.getTOPIC())).autoReloadChanged();
        }
    }

    @NotNull
    public final List<Profile> getProfiles() {
        return this.profiles;
    }

    public final void setProfiles(@NotNull List<Profile> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        List<Profile> old = this.profiles;
        List<Profile> list = Collections.unmodifiableList(value);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(value)");
        this.profiles = list;
        if (Intrinsics.areEqual(old, this.profiles) ^ true) {
            Project project2 = this.myProject;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
            ((CMakeSettingsListener)project2.getMessageBus().syncPublisher(CMakeSettingsListener.Companion.getTOPIC())).profilesChanged();
        }
    }

    public final boolean getPauseToolchainsListener() {
        return this.pauseToolchainsListener;
    }

    public final void setPauseToolchainsListener(boolean bl) {
        this.pauseToolchainsListener = bl;
    }

    public void projectOpened() {
        Project project2 = this.myProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myProject");
        project2.getMessageBus().connect((Disposable)this.myProject).subscribe(CPPToolchainsListener.TOPIC, (Object)new CPPToolchainsListener(this){
            final /* synthetic */ CMakeSettings this$0;

            /*
             * WARNING - void declaration
             */
            public void toolchainsRenamed(@NotNull Map<String, String> renamed) {
                Collection<void> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(renamed, (String)"renamed");
                if (this.this$0.getPauseToolchainsListener()) {
                    return;
                }
                Iterable iterable = this.this$0.getProfiles();
                CMakeSettings cMakeSettings = this.this$0;
                void var3_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    Profile profile2;
                    void it;
                    Profile profile3 = (Profile)item$iv$iv;
                    collection = destination$iv$iv;
                    Map<String, String> map2 = renamed;
                    String string = it.getToolchainName();
                    if (map2.get(string) == null) {
                        profile2 = it;
                    } else {
                        String newToolchainName;
                        String regeneratedName = CMakeSettings.Companion.generateProfileName(it.getName(), it.getBuildType(), (Ref<String>)Ref.create((Object)it.getToolchainName()), it.getBuildType(), newToolchainName, new Function<String, String>(this, renamed){
                            final /* synthetic */ projectOpened.1 this$0;
                            final /* synthetic */ Map $renamed$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$renamed$inlined = map2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final String apply(@NotNull String it) {
                                Collection<String> collection;
                                void $receiver$iv$iv;
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                Iterable $receiver$iv = this.this$0.this$0.getProfiles();
                                String string = it;
                                Iterable iterable = $receiver$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                                for (T item$iv$iv : $receiver$iv$iv) {
                                    void it2;
                                    Profile profile2 = (Profile)item$iv$iv;
                                    collection = destination$iv$iv;
                                    String string2 = it2.getName();
                                    collection.add(string2);
                                }
                                collection = (List)destination$iv$iv;
                                return CPPSettingsUtil.suggestNextName(string, (List<String>)collection);
                            }
                        });
                        profile2 = it.withName(regeneratedName).withToolchainName(newToolchainName);
                    }
                    void var16_13 = profile2;
                    collection.add(var16_13);
                }
                collection = (List)destination$iv$iv;
                cMakeSettings.setProfiles((List<Profile>)collection);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Nullable
    public Element getState() {
        Element stateElement = new Element("state");
        if (this.isAutoReloadEnabled != CMakeSettingsKt.getDEFAULT_AUTO_RELOAD_ENABLED()) {
            stateElement.setAttribute("AUTO_RELOAD", String.valueOf(this.isAutoReloadEnabled));
        }
        Element configsElement = new Element("configurations");
        for (Profile each : this.profiles) {
            Object it;
            Object object;
            Element configElement = new Element("configuration");
            configElement.setAttribute("PROFILE_NAME", each.getName());
            if (Intrinsics.areEqual((Object)each.getBuildType(), (Object)"Default") ^ true) {
                configElement.setAttribute("CONFIG_NAME", each.getBuildType());
            }
            String string = each.getToolchainName();
            if (string != null) {
                it = object = string;
                configElement.setAttribute("TOOLCHAIN_NAME", (String)it);
            }
            String string2 = each.getGenerationOptions();
            if (string2 != null) {
                it = object = string2;
                configElement.setAttribute("GENERATION_OPTIONS", (String)it);
            }
            if (each.getPassSystemEnvironment() != CMakeSettingsKt.getDEFAULT_PASS_SYSTEM_ENV()) {
                configElement.setAttribute("GENERATION_PASS_SYSTEM_ENVIRONMENT", String.valueOf(each.getPassSystemEnvironment()));
            }
            if (!(object = each.getAdditionalEnvironment()).isEmpty()) {
                Element envElement = new Element("ADDITIONAL_GENERATION_ENVIRONMENT");
                EnvironmentVariablesComponent.writeExternal((Element)envElement, each.getAdditionalEnvironment());
                configElement.addContent(envElement);
            }
            File file = each.getGenerationDir();
            if (file != null) {
                it = object = file;
                configElement.setAttribute("GENERATION_DIR", FileUtil.toSystemIndependentName((String)((File)it).getPath()));
            }
            String string3 = each.getBuildOptions();
            if (string3 != null) {
                it = object = string3;
                configElement.setAttribute("BUILD_OPTIONS", (String)it);
            }
            configsElement.addContent(configElement);
        }
        stateElement.addContent(configsElement);
        return stateElement;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.setAutoReloadEnabled(this.getBoolean(element.getAttributeValue("AUTO_RELOAD"), CMakeSettingsKt.getDEFAULT_AUTO_RELOAD_ENABLED()));
        ArrayList<Profile> newProfiles = new ArrayList<Profile>();
        String buildOptions = element.getAttributeValue("ADDITIONAL_BUILD_OPTIONS");
        if (element.getAttributeValue("GENERATION_PASS_SYSTEM_ENVIRONMENT") != null) {
            newProfiles.add(this.loadConfig(element, CMakeSettingsKt.getDEFAULT_BUILD_TYPE(), buildOptions));
        } else {
            Element element2 = element.getChild("configurations");
            if (element2 != null) {
                void $receiver$iv;
                Element element3;
                Element it = element3 = element2;
                List list = it.getChildren("configuration");
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"it.getChildren(\"configuration\")");
                Iterable iterable = list;
                Collection destination$iv = newProfiles;
                for (Object item$iv : $receiver$iv) {
                    void it2;
                    Element element4 = (Element)item$iv;
                    Collection collection = destination$iv;
                    void v2 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    Profile profile2 = CMakeSettings.loadConfig$default(this, (Element)v2, null, buildOptions, 2, null);
                    collection.add(profile2);
                }
                ArrayList cfr_ignored_0 = (ArrayList)destination$iv;
            }
        }
        this.setProfiles((List<Profile>)newProfiles);
    }

    private final Profile loadConfig(Element element, String migrateFromSingleProfile, String migrateFromSharedBuildOptions) {
        String string;
        File file;
        Profile profile2;
        Element it;
        Object object;
        Map env = new LinkedHashMap();
        Element element2 = element.getChild("ADDITIONAL_GENERATION_ENVIRONMENT");
        if (element2 != null) {
            it = object = element2;
            EnvironmentVariablesComponent.readExternal((Element)it, (Map)env);
        }
        Profile profile3 = profile2;
        Profile profile4 = profile2;
        String string2 = element.getAttributeValue("PROFILE_NAME");
        String string3 = migrateFromSingleProfile;
        if (string3 == null) {
            string3 = element.getAttributeValue("CONFIG_NAME");
        }
        String string4 = element.getAttributeValue("TOOLCHAIN_NAME");
        String string5 = element.getAttributeValue("GENERATION_OPTIONS");
        boolean bl = this.getBoolean(element.getAttributeValue("GENERATION_PASS_SYSTEM_ENVIRONMENT"), CMakeSettingsKt.getDEFAULT_PASS_SYSTEM_ENV());
        Map map2 = env;
        String string6 = element.getAttributeValue("GENERATION_DIR");
        if (string6 != null) {
            object = string6;
            Map map3 = map2;
            boolean bl2 = bl;
            String string7 = string5;
            String string8 = string4;
            String string9 = string3;
            String string10 = string2;
            Profile profile5 = profile3;
            Profile profile6 = profile4;
            it = object;
            File file2 = new File((String)it);
            profile4 = profile6;
            profile3 = profile5;
            string2 = string10;
            string3 = string9;
            string4 = string8;
            string5 = string7;
            bl = bl2;
            map2 = map3;
            file = file2;
        } else {
            file = null;
        }
        if ((string = migrateFromSharedBuildOptions) == null) {
            string = element.getAttributeValue("BUILD_OPTIONS");
        }
        profile3(string2, string3, string4, string5, bl, map2, file, string);
        return profile4;
    }

    static /* bridge */ /* synthetic */ Profile loadConfig$default(CMakeSettings cMakeSettings, Element element, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return cMakeSettings.loadConfig(element, string, string2);
    }

    private final boolean getBoolean(String value, boolean def) {
        boolean bl;
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            bl = def;
        } else {
            String string = value;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public CMakeSettings(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.isAutoReloadEnabled = CMakeSettingsKt.getDEFAULT_AUTO_RELOAD_ENABLED();
        this.profiles = CollectionsKt.listOf((Object)new Profile());
    }

    @JvmStatic
    @NotNull
    public static final CMakeSettings getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    @NotNull
    public static final String getCurrentDefaultBuildOptions(@Nullable CPPToolchains.Toolchain toolchain) {
        return Companion.getCurrentDefaultBuildOptions(toolchain);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> normalizeEnvironment(@NotNull Map<String, String> env) {
        return Companion.normalizeEnvironment(env);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getOptionsList(@Nullable String options) {
        return Companion.getOptionsList(options);
    }

    @JvmStatic
    @NotNull
    public static final String normalizeBuildType(@Nullable String name2) {
        return Companion.normalizeBuildType(name2);
    }

    @JvmStatic
    @Nullable
    public static final String normalizeProfileName(@Nullable String name2) {
        return Companion.normalizeProfileName(name2);
    }

    @JvmStatic
    private static final String normalizeToolchainName(String name2) {
        return CMakeSettings.Companion.normalizeToolchainName(name2);
    }

    @JvmStatic
    @NotNull
    public static final String getEffectiveProfileName(@Nullable String specifiedName, @Nullable String buildType, @Nullable String toolchainName) {
        return Companion.getEffectiveProfileName(specifiedName, buildType, toolchainName);
    }

    @JvmStatic
    private static final boolean shouldIncludeToolchainNameIntoProfileName(String toolchainName) {
        return CMakeSettings.Companion.shouldIncludeToolchainNameIntoProfileName(toolchainName);
    }

    @JvmStatic
    @NotNull
    public static final String generateProfileName(@Nullable String currentProfileName, @Nullable String previousBuildType, @Nullable Ref<String> previousToolchainNameHolder, @NotNull String newBuildType, @Nullable String newToolchainName, @NotNull Function<String, String> selectNextProfileName) {
        return Companion.generateProfileName(currentProfileName, previousBuildType, previousToolchainNameHolder, newBuildType, newToolchainName, selectNextProfileName);
    }

    @JvmStatic
    @Nullable
    public static final String normalizeOptions(@Nullable String options) {
        return Companion.normalizeOptions(options);
    }

    @JvmStatic
    public static final long calcProfilesHash(@NotNull List<? extends Pair<Profile, ? extends CPPToolchains.Toolchain>> profiles) {
        return Companion.calcProfilesHash(profiles);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B_\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010Bg\b\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\b\u0010#\u001a\u0004\u0018\u00010$J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010*\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\"\u0010+\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fJ\u0010\u0010,\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010-\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010.\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u0010\u0010/\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016\u00a8\u00060"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings$Profile;", "", "()V", "buildType", "", "(Ljava/lang/String;)V", "name", "toolchainName", "generationOptions", "passSystemEnvironment", "", "additionalEnvironment", "", "generationDir", "Ljava/io/File;", "buildOptions", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/Map;Ljava/io/File;Ljava/lang/String;)V", "safe", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/Map;Ljava/io/File;Ljava/lang/String;Z)V", "getAdditionalEnvironment", "()Ljava/util/Map;", "getBuildOptions", "()Ljava/lang/String;", "getBuildType", "getGenerationDir", "()Ljava/io/File;", "getGenerationOptions", "getName", "getPassSystemEnvironment", "()Z", "getToolchainName", "equals", "other", "getEffectiveBuildOptionsList", "", "toolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "getEffectiveGenerationOptionsList", "hashCode", "", "toString", "withBuildOptions", "withBuildType", "withEnvironment", "withGenerationDir", "withGenerationOptions", "withName", "withToolchainName", "intellij.clion"})
    public static final class Profile {
        @NotNull
        private final String name;
        @NotNull
        private final String buildType;
        @Nullable
        private final String toolchainName;
        @Nullable
        private final String generationOptions;
        @NotNull
        private final Map<String, String> additionalEnvironment;
        @Nullable
        private final String buildOptions;
        private final boolean passSystemEnvironment;
        @Nullable
        private final File generationDir;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getBuildType() {
            return this.buildType;
        }

        @Nullable
        public final String getToolchainName() {
            return this.toolchainName;
        }

        @Nullable
        public final String getGenerationOptions() {
            return this.generationOptions;
        }

        @NotNull
        public final List<String> getEffectiveGenerationOptionsList(@Nullable CPPToolchains.Toolchain toolchain) {
            Object object;
            ArrayList result = new ArrayList();
            CPPToolchains.Toolchain toolchain2 = toolchain;
            if (toolchain2 != null) {
                String string;
                Collection collection;
                String it;
                String string2;
                object = toolchain2;
                CPPToolchains.Toolchain $receiver = object;
                String string3 = $receiver.getCustomMakeToolPath();
                if (string3 != null) {
                    it = string2 = string3;
                    collection = result;
                    string = "-DCMAKE_MAKE_PROGRAM=" + FileUtil.toSystemIndependentName((String)it);
                    collection.add(string);
                }
                String string4 = $receiver.getCustomCCompilerPath();
                if (string4 != null) {
                    it = string2 = string4;
                    collection = result;
                    string = "-DCMAKE_C_COMPILER=" + FileUtil.toSystemIndependentName((String)it);
                    collection.add(string);
                }
                String string5 = $receiver.getCustomCXXCompilerPath();
                if (string5 != null) {
                    it = string2 = string5;
                    collection = result;
                    string = "-DCMAKE_CXX_COMPILER=" + FileUtil.toSystemIndependentName((String)it);
                    collection.add(string);
                }
            }
            object = result;
            Iterable iterable = Companion.getOptionsList(this.generationOptions);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
            return result;
        }

        @NotNull
        public final Map<String, String> getAdditionalEnvironment() {
            return this.additionalEnvironment;
        }

        @Nullable
        public final String getBuildOptions() {
            return this.buildOptions;
        }

        @NotNull
        public final List<String> getEffectiveBuildOptionsList(@NotNull CPPToolchains.Toolchain toolchain) {
            Intrinsics.checkParameterIsNotNull((Object)toolchain, (String)"toolchain");
            String string = this.buildOptions;
            if (string == null) {
                string = Companion.getCurrentDefaultBuildOptions(toolchain);
            }
            return Companion.getOptionsList(string);
        }

        @NotNull
        public final Profile withName(@Nullable String name2) {
            return new Profile(name2, this.buildType, this.toolchainName, this.generationOptions, this.passSystemEnvironment, this.additionalEnvironment, this.generationDir, this.buildOptions);
        }

        @NotNull
        public final Profile withBuildType(@Nullable String buildType) {
            return new Profile(this.name, buildType, this.toolchainName, this.generationOptions, this.passSystemEnvironment, this.additionalEnvironment, this.generationDir, this.buildOptions);
        }

        @NotNull
        public final Profile withToolchainName(@Nullable String toolchainName) {
            return new Profile(this.name, this.buildType, toolchainName, this.generationOptions, this.passSystemEnvironment, this.additionalEnvironment, this.generationDir, this.buildOptions);
        }

        @NotNull
        public final Profile withGenerationOptions(@Nullable String generationOptions) {
            return new Profile(this.name, this.buildType, this.toolchainName, generationOptions, this.passSystemEnvironment, this.additionalEnvironment, this.generationDir, this.buildOptions);
        }

        @NotNull
        public final Profile withEnvironment(boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment) {
            Intrinsics.checkParameterIsNotNull(additionalEnvironment, (String)"additionalEnvironment");
            return new Profile(this.name, this.buildType, this.toolchainName, this.generationOptions, passSystemEnvironment, additionalEnvironment, this.generationDir, this.buildOptions);
        }

        @NotNull
        public final Profile withGenerationDir(@Nullable File generationDir) {
            return new Profile(this.name, this.buildType, this.toolchainName, this.generationOptions, this.passSystemEnvironment, this.additionalEnvironment, generationDir, this.buildOptions);
        }

        @NotNull
        public final Profile withBuildOptions(@Nullable String buildOptions) {
            return new Profile(this.name, this.buildType, this.toolchainName, this.generationOptions, this.passSystemEnvironment, this.additionalEnvironment, this.generationDir, buildOptions);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass()) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.cmake.CMakeSettings.Profile");
            }
            Profile cfr_ignored_0 = (Profile)object2;
            if (this.passSystemEnvironment != ((Profile)other).passSystemEnvironment) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.name, (Object)((Profile)other).name) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.buildType, (Object)((Profile)other).buildType) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.toolchainName, (Object)((Profile)other).toolchainName) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.generationDir, (Object)((Profile)other).generationDir) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.generationOptions, (Object)((Profile)other).generationOptions) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual(this.additionalEnvironment, ((Profile)other).additionalEnvironment) ^ true) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.buildOptions, (Object)((Profile)other).buildOptions) ^ true);
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.passSystemEnvironment);
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.buildType.hashCode();
            String string = this.toolchainName;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            File file = this.generationDir;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            String string2 = this.generationOptions;
            result = 31 * result + (string2 != null ? string2.hashCode() : 0);
            result = 31 * result + ((Object)this.additionalEnvironment).hashCode();
            String string3 = this.buildOptions;
            result = 31 * result + (string3 != null ? string3.hashCode() : 0);
            return result;
        }

        @NotNull
        public String toString() {
            return "Configuration(name=" + this.name + ", buildType=" + this.buildType + ", toolchainName=" + this.toolchainName + ", passSystemEnvironment=" + this.passSystemEnvironment + ", generationOptions=" + this.generationOptions + ", additionalEnvironment=" + this.additionalEnvironment + ", generationDir=" + this.generationDir + ", buildOptions=" + this.buildOptions + ')';
        }

        public final boolean getPassSystemEnvironment() {
            return this.passSystemEnvironment;
        }

        @Nullable
        public final File getGenerationDir() {
            return this.generationDir;
        }

        private Profile(String name2, String buildType, String toolchainName, String generationOptions, boolean passSystemEnvironment, Map<String, String> additionalEnvironment, File generationDir, String buildOptions, boolean safe) {
            Map<String, String> map2;
            this.passSystemEnvironment = passSystemEnvironment;
            this.generationDir = generationDir;
            this.name = Companion.getEffectiveProfileName(name2, buildType, toolchainName);
            this.buildType = Companion.normalizeBuildType(buildType);
            this.toolchainName = Companion.normalizeToolchainName(toolchainName);
            this.generationOptions = Companion.normalizeOptions(generationOptions);
            if (safe) {
                map2 = additionalEnvironment;
            } else {
                Map<String, String> map3 = Collections.unmodifiableMap(Companion.normalizeEnvironment(additionalEnvironment));
                map2 = map3;
                Intrinsics.checkExpressionValueIsNotNull(map3, (String)"Collections.unmodifiable\u2026t(additionalEnvironment))");
            }
            this.additionalEnvironment = map2;
            this.buildOptions = Companion.normalizeOptions(buildOptions);
        }

        public Profile() {
            this(CMakeSettingsKt.getDEFAULT_BUILD_TYPE());
        }

        public Profile(@Nullable String buildType) {
            this(null, buildType, null, null, CMakeSettingsKt.getDEFAULT_PASS_SYSTEM_ENV(), MapsKt.emptyMap(), null, null, true);
        }

        public Profile(@Nullable String name2, @Nullable String buildType, @Nullable String toolchainName, @Nullable String generationOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment, @Nullable File generationDir, @Nullable String buildOptions) {
            Intrinsics.checkParameterIsNotNull(additionalEnvironment, (String)"additionalEnvironment");
            this(name2, buildType, toolchainName, generationOptions, passSystemEnvironment, additionalEnvironment, generationDir, buildOptions, false);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0006H\u0007JT\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J&\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010#\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0007J(\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0&H\u0007J\u0014\u0010(\u001a\u0004\u0018\u00010\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010)\u001a\u0004\u0018\u00010\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010*\u001a\u0004\u0018\u00010\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0003J\u0012\u0010+\u001a\u00020,2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0003\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings$Companion;", "", "()V", "calcProfilesHash", "", "profiles", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings$Profile;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "generateProfileName", "", "currentProfileName", "previousBuildType", "previousToolchainNameHolder", "Lcom/intellij/openapi/util/Ref;", "newBuildType", "newToolchainName", "selectNextProfileName", "Ljava/util/function/Function;", "getCurrentDefaultBuildOptions", "toolchain", "getDefaultBuildProcesses", "", "cpuCount", "getEffectiveProfileName", "specifiedName", "buildType", "toolchainName", "getInstance", "Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getOptionsList", "options", "normalizeBuildType", "name", "normalizeEnvironment", "", "env", "normalizeOptions", "normalizeProfileName", "normalizeToolchainName", "shouldIncludeToolchainNameIntoProfileName", "", "intellij.clion"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CMakeSettings getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = project2.getComponent(CMakeSettings.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (CMakeSettings)((Object)object);
        }

        @JvmStatic
        @NotNull
        public final String getCurrentDefaultBuildOptions(@Nullable CPPToolchains.Toolchain toolchain) {
            CPPToolchains.Toolchain toolchain2 = toolchain;
            if (Intrinsics.areEqual((Object)((Object)(toolchain2 != null ? toolchain2.getToolSetKind() : null)), (Object)((Object)CPPToolSet.Kind.MSVC))) {
                return "";
            }
            return "-j " + this.getDefaultBuildProcesses(Runtime.getRuntime().availableProcessors());
        }

        public final int getDefaultBuildProcesses(int cpuCount) {
            return Math.max(1, (int)Math.ceil((double)cpuCount / 2.0));
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> normalizeEnvironment(@NotNull Map<String, String> env) {
            Intrinsics.checkParameterIsNotNull(env, (String)"env");
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(env.size());
            Map<String, String> map2 = env;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                entry2 = entry;
                String value = entry2.getValue();
                if (StringUtil.isEmptyOrSpaces((String)key)) continue;
                result.put(key, StringUtil.notNullize((String)StringUtil.trim((String)value)));
            }
            Map<String, String> map3 = Collections.unmodifiableMap((Map)result);
            Intrinsics.checkExpressionValueIsNotNull(map3, (String)"Collections.unmodifiableMap(result)");
            return map3;
        }

        @JvmStatic
        @NotNull
        public final List<String> getOptionsList(@Nullable String options) {
            if (options == null) {
                return CollectionsKt.emptyList();
            }
            SmartList result = new SmartList();
            CommandLineTokenizer tokenizer = new CommandLineTokenizer(options, true);
            while (tokenizer.hasMoreTokens()) {
                result.add((Object)tokenizer.nextToken());
            }
            List<String> list = Collections.unmodifiableList((List)result);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(result)");
            return list;
        }

        @JvmStatic
        @NotNull
        public final String normalizeBuildType(@Nullable String name2) {
            String string;
            String string2;
            String string3 = name2;
            if (string3 != null) {
                String string4;
                String string5 = string4 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            } else {
                string2 = null;
            }
            if ((string = StringKt.nullize$default(string2, (boolean)false, (int)1, null)) == null) {
                string = "Default";
            }
            return string;
        }

        @JvmStatic
        @Nullable
        public final String normalizeProfileName(@Nullable String name2) {
            String string;
            String string2 = name2;
            if (string2 != null) {
                String string3;
                String string4 = string3 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else {
                string = null;
            }
            return StringKt.nullize$default(string, (boolean)false, (int)1, null);
        }

        @JvmStatic
        private final String normalizeToolchainName(String name2) {
            return CPPToolchains.Toolchain.normalizeToolchainName(name2);
        }

        @JvmStatic
        @NotNull
        public final String getEffectiveProfileName(@Nullable String specifiedName, @Nullable String buildType, @Nullable String toolchainName) {
            String string = this.normalizeProfileName(specifiedName);
            if (string != null) {
                String string2;
                String it = string2 = string;
                return it;
            }
            String string3 = this.normalizeBuildType(buildType);
            String string4 = this.normalizeToolchainName(toolchainName);
            Function<String, String> function = Function.identity();
            Intrinsics.checkExpressionValueIsNotNull(function, (String)"Function.identity()");
            return this.generateProfileName(null, null, null, string3, string4, function);
        }

        @JvmStatic
        private final boolean shouldIncludeToolchainNameIntoProfileName(String toolchainName) {
            CharSequence charSequence = toolchainName;
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)toolchainName, (Object)CPPToolchains.Toolchain.DEFAULT) && !Intrinsics.areEqual((Object)toolchainName, (Object)"Unnamed");
        }

        @JvmStatic
        @NotNull
        public final String generateProfileName(@Nullable String currentProfileName, @Nullable String previousBuildType, @Nullable Ref<String> previousToolchainNameHolder, @NotNull String newBuildType, @Nullable String newToolchainName, @NotNull Function<String, String> selectNextProfileName) {
            Intrinsics.checkParameterIsNotNull((Object)newBuildType, (String)"newBuildType");
            Intrinsics.checkParameterIsNotNull(selectNextProfileName, (String)"selectNextProfileName");
            generateProfileName.1 doGenerate$ = generateProfileName.1.INSTANCE;
            if (currentProfileName == null) {
                String string = selectNextProfileName.apply(doGenerate$.invoke(newBuildType, newToolchainName));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"selectNextProfileName.ap\u2026dType, newToolchainName))");
                return string;
            }
            if (previousBuildType == null || previousToolchainNameHolder == null) {
                return currentProfileName;
            }
            String originalGeneratedName = doGenerate$.invoke(previousBuildType, (String)previousToolchainNameHolder.get());
            if (Intrinsics.areEqual((Object)CPPSettingsUtil.extractBaseName(originalGeneratedName), (Object)CPPSettingsUtil.extractBaseName(currentProfileName)) ^ true) {
                return currentProfileName;
            }
            return this.generateProfileName(null, null, null, newBuildType, newToolchainName, selectNextProfileName);
        }

        @JvmStatic
        @Nullable
        public final String normalizeOptions(@Nullable String options) {
            return StringUtil.nullize((String)StringUtil.trim((String)options));
        }

        @JvmStatic
        public final long calcProfilesHash(@NotNull List<? extends Pair<Profile, ? extends CPPToolchains.Toolchain>> profiles) {
            Intrinsics.checkParameterIsNotNull(profiles, (String)"profiles");
            CRC32 crc = new CRC32();
            Function1 updateNullableString2 = (Function1)new Function1<String, Unit>(crc){
                final /* synthetic */ CRC32 $crc;

                @Nullable
                public final Unit invoke(@Nullable String s) {
                    Unit unit;
                    this.$crc.update(s == null ? 0 : 1);
                    String string = s;
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        String string3 = s;
                        CRC32 cRC32 = this.$crc;
                        Charset charset = Charsets.UTF_8;
                        byte[] byArray = string3.getBytes(charset);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                        byte[] byArray2 = byArray;
                        cRC32.update(byArray2);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.$crc = cRC32;
                    super(1);
                }
            };
            Iterable $receiver$iv = profiles;
            for (Object element$iv : $receiver$iv) {
                Pair $config_toolchain = (Pair)element$iv;
                Profile config = (Profile)$config_toolchain.component1();
                CPPToolchains.Toolchain toolchain = (CPPToolchains.Toolchain)$config_toolchain.component2();
                String string = config.getName();
                CRC32 cRC32 = crc;
                Object object = Charsets.UTF_8;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                cRC32.update(byArray2);
                string = config.getBuildType();
                cRC32 = crc;
                object = Charsets.UTF_8;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray3 = string3.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
                byArray2 = byArray3;
                cRC32.update(byArray2);
                updateNullableString2.invoke((Object)config.getToolchainName());
                Object $receiver$iv2 = config.getEffectiveGenerationOptionsList(toolchain);
                object = $receiver$iv2.iterator();
                while (object.hasNext()) {
                    Object element$iv2 = object.next();
                    String it = (String)element$iv2;
                    updateNullableString2.invoke((Object)it);
                }
                crc.update(config.getPassSystemEnvironment() ? 1 : 0);
                crc.update(config.getAdditionalEnvironment().size());
                object = $receiver$iv2 = config.getAdditionalEnvironment();
                Iterator iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv3;
                    Map.Entry it = element$iv3 = iterator.next();
                    updateNullableString2.invoke(it.getKey());
                    updateNullableString2.invoke(it.getValue());
                }
                File file = config.getGenerationDir();
                updateNullableString2.invoke((Object)(file != null ? file.getPath() : null));
                updateNullableString2.invoke((Object)config.getBuildOptions());
            }
            return crc.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

