/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeCacheFileType;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class EditCMakeCacheAction
extends DumbAwareAction {
    @Nullable
    private final File myCacheFile;

    public EditCMakeCacheAction(@Nullable File generationDir) {
        super(CPPBundle.message("cmake.action.editCmakeCache", new Object[0]), null, CMakeCacheFileType.INSTANCE.getIcon());
        this.myCacheFile = generationDir == null ? null : new File(generationDir, "CMakeCache.txt");
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(EditCMakeCacheAction.getEventProject((AnActionEvent)e) != null && this.myCacheFile != null && this.myCacheFile.exists());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = EditCMakeCacheAction.getEventProject((AnActionEvent)e);
        if (project2 == null || this.myCacheFile == null) {
            return;
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(this.myCacheFile);
        if (vFile != null) {
            new OpenFileDescriptor(project2, vFile, -1).navigate(true);
        }
    }
}

