/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class LoadCMakeProjectAction
extends DumbAwareAction {
    public static final String ID = "CMake.LoadCMakeProject";

    public LoadCMakeProjectAction() {
        super(CPPBundle.message("cmake.action.loadCMakeProject", new Object[0]));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project2 = LoadCMakeProjectAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible(project2 != null && LoadCMakeProjectAction.getProjectDirToLoad(e) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = LoadCMakeProjectAction.getEventProject((AnActionEvent)e);
        File projectDirToLoad = LoadCMakeProjectAction.getProjectDirToLoad(e);
        if (project2 != null && projectDirToLoad != null) {
            CMakeWorkspace.getInstance(project2).selectProjectDir(projectDirToLoad);
        }
    }

    @Nullable
    private static File getProjectDirToLoad(AnActionEvent e) {
        Project project2 = LoadCMakeProjectAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (!LoadCMakeProjectAction.isCMakeLists(file)) {
            return null;
        }
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(project2);
        File parentDir = VfsUtilCore.virtualToIoFile((VirtualFile)file.getParent());
        if (workspace.isInitialized() && FileUtil.filesEqual((File)workspace.getProjectDir(), (File)parentDir)) {
            return null;
        }
        return parentDir;
    }

    public static boolean isCMakeLists(VirtualFile file) {
        return file != null && !file.isDirectory() && FileUtil.namesEqual((String)file.getName(), (String)"CMakeLists.txt");
    }

    public static void selectAndLoadCMakeProject(Project project2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return LoadCMakeProjectAction.isCMakeLists(file);
            }
        };
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(project2);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project2, (VirtualFile)workspace.getEffectiveContentRoot(), file -> workspace.selectProjectDir(VfsUtilCore.virtualToIoFile((VirtualFile)(file.isDirectory() ? file : file.getParent()))));
    }
}

