/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgument;
import com.jetbrains.cidr.cpp.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cidr.cpp.cmake.settings.Case;
import icons.CLionIcons;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCompletionUtils {
    @NotNull
    public static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList) {
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(0);
        }
        if (argumentList == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(1);
        }
        LookupElementBuilder lookupElementBuilder = CMakeCompletionUtils.createStandardCommandItem(command, boldCompletion, true, putCaretInsideParentheses, argumentList, null);
        if (lookupElementBuilder == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(2);
        }
        return lookupElementBuilder;
    }

    @NotNull
    private static LookupElementBuilder createStandardCommandItem(@NotNull String command, boolean boldCompletion, boolean addParentheses, boolean putCaretInsideParentheses, @NotNull List<CMakeArgument> argumentList, @Nullable Object equalsObject) {
        LookupElementBuilder lookupElementBuilder;
        if (command == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(3);
        }
        if (argumentList == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(4);
        }
        if (addParentheses || putCaretInsideParentheses) {
            StringBuilder argumentsBuilder = new StringBuilder();
            argumentsBuilder.append('(');
            for (CMakeArgument argument : argumentList) {
                argumentsBuilder.append(argument.getLiteralNotNull().getText()).append(' ');
            }
            if (!argumentList.isEmpty()) {
                argumentsBuilder.deleteCharAt(argumentsBuilder.length() - 1);
            }
            argumentsBuilder.append(')');
            lookupElementBuilder = LookupElementBuilder.create((Object)new String(command + argumentsBuilder + (equalsObject != null ? equalsObject.toString() : "")), (String)command);
            lookupElementBuilder = lookupElementBuilder.withTailText(argumentsBuilder.toString());
        } else {
            lookupElementBuilder = LookupElementBuilder.create((Object)new String(command), (String)command);
        }
        if (boldCompletion) {
            lookupElementBuilder = lookupElementBuilder.bold();
        }
        if (addParentheses) {
            lookupElementBuilder = putCaretInsideParentheses || !argumentList.isEmpty() ? lookupElementBuilder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)) : lookupElementBuilder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false));
        }
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder;
        if (lookupElementBuilder2 == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(5);
        }
        return lookupElementBuilder2;
    }

    @NotNull
    public static String convertCommandToProperCase(@Nullable Project project2, @NotNull String textToComplete) {
        if (textToComplete == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(6);
        }
        CMakeCodeStyleSettings cMakeSettings = (CMakeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(CMakeCodeStyleSettings.class);
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.DO_NOT_CHANGE.getValue()) {
            String string = textToComplete;
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_LOWER.getValue()) {
            String string = textToComplete.toLowerCase(Locale.getDefault());
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (cMakeSettings.FORCE_COMMANDS_CASE == Case.TO_UPPER.getValue()) {
            String string = textToComplete.toUpperCase(Locale.getDefault());
            if (string == null) {
                CMakeCompletionUtils.$$$reportNull$$$0(9);
            }
            return string;
        }
        if ("" == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(10);
        }
        return "";
    }

    public static LookupElement createCommandItem(@NotNull String textToComplete, @NotNull String filename, @NotNull List<CMakeArgument> argumentsInCompletion, boolean isFunctionName, boolean addParentheses) {
        if (textToComplete == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(11);
        }
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(12);
        }
        if (argumentsInCompletion == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(13);
        }
        Icon icon = CMakeCompletionUtils.getRoutineIcon(isFunctionName);
        LookupElementBuilder lookupElementBuilder = CMakeCompletionUtils.createStandardCommandItem(textToComplete, false, addParentheses, false, argumentsInCompletion, filename + isFunctionName).withIcon(icon);
        return lookupElementBuilder.appendTailText(CMakeCompletionUtils.getStandardCMakeCompletionTailText(filename), true);
    }

    @NotNull
    private static String getStandardCMakeCompletionTailText(@NotNull String filename) {
        if (filename == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(14);
        }
        String string = " (in " + filename + ")";
        if (string == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static Icon getRoutineIcon(boolean isFunctionName) {
        Icon icon = isFunctionName ? CMakeCompletionUtils.getFunctionIcon() : CMakeCompletionUtils.getMacroIcon();
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(16);
        }
        return icon;
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getMacroIcon() {
        Icon icon = CLionIcons.CMake_Macro;
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(17);
        }
        return icon;
    }

    @Contract(pure=true)
    @NotNull
    public static Icon getFunctionIcon() {
        Icon icon = CLionIcons.CMake_Function;
        if (icon == null) {
            CMakeCompletionUtils.$$$reportNull$$$0(18);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/completion/CMakeCompletionUtils";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToComplete";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsInCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/completion/CMakeCompletionUtils";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStandardCommandItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCommandToProperCase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardCMakeCompletionTailText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroIcon";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStandardCommandItem";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertCommandToProperCase";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCommandItem";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStandardCMakeCompletionTailText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

