/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.completion.contributors;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.cpp.cmake.completion.CMakeCompletionContributor;
import com.jetbrains.cidr.cpp.cmake.completion.contributors.AbstractCMakeCompletionContributor;
import com.jetbrains.cidr.cpp.cmake.completion.contributors.providers.CMakeEnvironmentVariableProvider;
import com.jetbrains.cidr.cpp.cmake.completion.contributors.providers.CMakeSetAndUnsetPlainVariableProvider;
import com.jetbrains.cidr.cpp.cmake.completion.contributors.providers.CMakeVariableProvider;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeTokenTypes;

public class CMakeVariableCompletionContributor
extends AbstractCMakeCompletionContributor {
    public static final String SET_AND_UNSET_STRING_PATTERN = "(?i)(un)?set";
    public static final StringPattern SET_AND_UNSET_PATTERN = StandardPatterns.string().matches("(?i)(un)?set");
    private static final TokenSet VARIABLE_COMPLETION_PSI_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.LITERAL, CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS});

    @Override
    public void extendContributor(CMakeCompletionContributor contributor) {
        CMakeVariableProvider variableProvider = new CMakeVariableProvider();
        CMakeEnvironmentVariableProvider environmentVariableProvider = new CMakeEnvironmentVariableProvider();
        for (IElementType type : VARIABLE_COMPLETION_PSI_ELEMENTS.getTypes()) {
            contributor.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)type), variableProvider);
            contributor.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)type), variableProvider);
            contributor.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)type), environmentVariableProvider);
        }
        contributor.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)CMakeTokenTypes.LITERAL).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)CMakeTokenTypes.LPAR).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText((ElementPattern)SET_AND_UNSET_PATTERN))), new CMakeSetAndUnsetPlainVariableProvider());
    }

    public static boolean shouldAutoPopup(PsiElement position, char typedChar) {
        IElementType type = position.getNode().getElementType();
        return '{' == typedChar && VARIABLE_COMPLETION_PSI_ELEMENTS.contains(type) && StringUtil.containsChar((String)position.getText(), (char)'$');
    }
}

