/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.completion.contributors.providers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.completion.contributors.providers.AbstractCMakeCaseSensitiveCompletionProvider;
import com.jetbrains.cidr.cpp.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeCommandName;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CMakeCommandProvider
extends AbstractCMakeCaseSensitiveCompletionProvider {
    public static final String[] CMAKE_COMMANDS = (String[])ContainerUtil.map((Object[])ContainerUtil.filter((Object[])CMakeStandardCommands.values(), command -> !command.isLexerToken()).toArray(new CMakeStandardCommands[0]), commands -> commands.getCommandName(), (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
    private static final Set<String> CMAKE_COMMANDS_AS_SET = ContainerUtil.newHashSet((Object[])CMAKE_COMMANDS);

    public CMakeCommandProvider() {
        super(CMAKE_COMMANDS);
    }

    public static boolean isStandardCommand(String command) {
        return CMAKE_COMMANDS_AS_SET.contains(command.toLowerCase(Locale.US));
    }

    public static boolean isIncludeCommand(@NotNull CMakeCommandName cMakeCommandName) {
        if (cMakeCommandName == null) {
            CMakeCommandProvider.$$$reportNull$$$0(0);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.INCLUDE_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddLibraryCommand(@NotNull CMakeCommandName cMakeCommandName) {
        if (cMakeCommandName == null) {
            CMakeCommandProvider.$$$reportNull$$$0(1);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_LIBRARY_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddExecutableCommand(@NotNull CMakeCommandName cMakeCommandName) {
        if (cMakeCommandName == null) {
            CMakeCommandProvider.$$$reportNull$$$0(2);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_EXECUTABLE_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddCustomTargetCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_CUSTOM_TARGET_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isFltkWrapUiCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.FLTK_WRAP_UI_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isQtWrapCppCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.QT_WRAP_CPP_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isQtWrapUiCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.QT_WRAP_UI_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetPropertyCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetSourceFilesPropertiesCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isTryCompileCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.TRY_COMPILE_COMMAND_NAME, cMakeCommandName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "cMakeCommandName";
        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/completion/contributors/providers/CMakeCommandProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludeCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAddLibraryCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAddExecutableCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

