/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.CMakeOutputFilter;
import com.jetbrains.cidr.cpp.cmake.console.ErrorMatcher;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.execution.DimmableFilter;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeConsoleViewImpl
extends ConsoleViewImpl {
    public static final String WARNING_MATCH = "warning";
    public static final String ERROR_MATCH = "error";
    private static final Pattern ERROR_PATTERN = Pattern.compile(".*(?:(?:\\((\\d{1,5})\\))|:(\\d{1,5})):(?:\\d+:)?(?: \\w+)? (warning|error)(?: \\w+)?:.*");
    private final EventDispatcher<MessageListener> myDispatcher;
    private final TIntArrayList myErrorLines;
    private final TIntArrayList myWarningLines;
    private boolean myNavigatedOnce;

    public CMakeConsoleViewImpl(@NotNull Project project2, @NotNull GlobalSearchScope searchScope, boolean viewer, boolean usePredefinedMessageFilter) {
        if (project2 == null) {
            CMakeConsoleViewImpl.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            CMakeConsoleViewImpl.$$$reportNull$$$0(1);
        }
        super(project2, searchScope, viewer, usePredefinedMessageFilter);
        this.myDispatcher = EventDispatcher.create(MessageListener.class);
        this.myErrorLines = new TIntArrayList();
        this.myWarningLines = new TIntArrayList();
    }

    private boolean isPotentialMatch(CharSequence multilineFragment) {
        if (StringUtil.contains((CharSequence)multilineFragment, (CharSequence)WARNING_MATCH) || StringUtil.contains((CharSequence)multilineFragment, (CharSequence)ERROR_MATCH)) {
            return true;
        }
        for (Filter each : this.myFilters.getFilters()) {
            if (!(each instanceof ErrorMatcher) || !((ErrorMatcher)each).isPotentialMatch(multilineFragment)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CMakeConsoleMessageType match(CharSequence line) {
        Matcher m = ERROR_PATTERN.matcher(line);
        if (m.matches()) {
            return ERROR_MATCH.equals(m.group(m.groupCount())) ? CMakeConsoleMessageType.ERROR : CMakeConsoleMessageType.WARNING;
        }
        for (Filter each : this.myFilters.getFilters()) {
            CMakeConsoleMessageType match;
            if (!(each instanceof ErrorMatcher) || (match = ((ErrorMatcher)each).match(line)) == null) continue;
            return match;
        }
        return null;
    }

    @NotNull
    protected EditorEx doCreateConsoleEditor() {
        EditorEx editor = super.doCreateConsoleEditor();
        editor.getDocument().addDocumentListener(new DocumentListener(){

            private void processLine(int lineNumber, CharSequence line) {
                CMakeConsoleMessageType match = CMakeConsoleViewImpl.this.match(line);
                if (match != null) {
                    boolean isError;
                    boolean bl = isError = match == CMakeConsoleMessageType.ERROR;
                    if (isError && CMakeConsoleViewImpl.this.myErrorLines.isEmpty()) {
                        CMakeConsoleViewImpl.this.getEditor().getCaretModel().moveToLogicalPosition(new LogicalPosition(lineNumber - 1, 0));
                        CMakeConsoleViewImpl.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                    }
                    (isError ? CMakeConsoleViewImpl.this.myErrorLines : CMakeConsoleViewImpl.this.myWarningLines).add(lineNumber);
                    CMakeConsoleViewImpl.this.notifyMessageReported(isError ? CMakeConsoleMessageType.ERROR : CMakeConsoleMessageType.WARNING);
                }
            }

            public void documentChanged(DocumentEvent e) {
                if (!CMakeConsoleViewImpl.this.isPotentialMatch(e.getNewFragment())) {
                    return;
                }
                Document document = e.getDocument();
                int startLine = document.getLineNumber(e.getOffset());
                int endLine = document.getLineNumber(e.getOffset() + e.getNewLength());
                for (int lineNumber = startLine; lineNumber <= endLine; ++lineNumber) {
                    int lineStart = document.getLineStartOffset(lineNumber);
                    int lineEnd = document.getLineEndOffset(lineNumber);
                    this.processLine(lineNumber, document.getImmutableCharSequence().subSequence(lineStart, lineEnd));
                }
            }
        });
        editor.getSettings().setCaretRowShown(true);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            CMakeConsoleViewImpl.$$$reportNull$$$0(2);
        }
        return editorEx;
    }

    @Nullable
    protected OccurenceNavigator.OccurenceInfo calcNextOccurrence(int delta) {
        TIntArrayList list;
        TIntArrayList tIntArrayList = list = !this.myErrorLines.isEmpty() ? this.myErrorLines : this.myWarningLines;
        if (list.isEmpty()) {
            return null;
        }
        boolean forward = delta > 0;
        int currentLineIndex = list.binarySearch(this.getEditor().getCaretModel().getLogicalPosition().line);
        if (!forward && currentLineIndex == -1 || forward && this.myNavigatedOnce && currentLineIndex == -(list.size() + 1)) {
            return null;
        }
        if (currentLineIndex < 0) {
            currentLineIndex = Math.abs(currentLineIndex + 1);
            if (!forward) {
                --currentLineIndex;
            } else if (!this.myNavigatedOnce && currentLineIndex == list.size()) {
                currentLineIndex = 0;
            }
        } else {
            currentLineIndex += forward ? 1 : -1;
        }
        if (currentLineIndex < 0 || currentLineIndex >= list.size()) {
            return null;
        }
        final int line = list.getQuick(currentLineIndex);
        return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                HyperlinkInfo hl;
                CMakeConsoleViewImpl.this.myNavigatedOnce = true;
                CMakeConsoleViewImpl.this.getEditor().getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
                CMakeConsoleViewImpl.this.getEditor().getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                CMakeConsoleViewImpl.this.flushPendingFilters();
                RangeHighlighter range = (RangeHighlighter)ContainerUtil.getFirstItem((Collection)CMakeConsoleViewImpl.this.getHyperlinks().findAllHyperlinksOnLine(line), null);
                HyperlinkInfo hyperlinkInfo = hl = range == null ? null : EditorHyperlinkSupport.getHyperlinkInfo((RangeHighlighter)range);
                if (hl != null) {
                    hl.navigate(CMakeConsoleViewImpl.this.getProject());
                }
            }
        }, currentLineIndex + 1, list.size());
    }

    private void flushPendingFilters() {
        this.getHyperlinks().waitForPendingFilters(1000L);
    }

    private void notifyMessageReported(@NotNull CMakeConsoleMessageType type) {
        if (type == null) {
            CMakeConsoleViewImpl.$$$reportNull$$$0(3);
        }
        ((MessageListener)this.myDispatcher.getMulticaster()).messageReported(type);
    }

    public void addMessageListener(@NotNull MessageListener listener2) {
        if (listener2 == null) {
            CMakeConsoleViewImpl.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public String getNextOccurenceActionName() {
        return CPPBundle.message("build.nextOccurrence", CPPBundle.message(!this.myErrorLines.isEmpty() ? "build.error" : "build.warning", new Object[0]));
    }

    public String getPreviousOccurenceActionName() {
        return CPPBundle.message("build.previousOccurrence", CPPBundle.message(!this.myErrorLines.isEmpty() ? "build.error" : "build.warning", new Object[0]));
    }

    public void scrollToEnd() {
        if (this.myErrorLines.isEmpty()) {
            super.scrollToEnd();
        }
    }

    public void dimHighlighting() {
        for (Filter each : this.myFilters.getFilters()) {
            if (each instanceof DimmableFilter) {
                ((DimmableFilter)each).dimHighlighting();
                continue;
            }
            if (each instanceof UrlFilter) continue;
            CPPLog.LOG.warn("Filter doesn't support dimming: " + each.getClass().getName());
        }
    }

    @NotNull
    public List<CMakeMessage> finishAndGetMessages() {
        this.flushDeferredText();
        this.flushPendingFilters();
        for (Filter each : this.myFilters.getFilters()) {
            if (!(each instanceof CMakeOutputFilter)) continue;
            List<CMakeMessage> list = ((CMakeOutputFilter)each).finishAndGetMessages();
            if (list == null) {
                CMakeConsoleViewImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        throw new RuntimeException("CMakeOutputFilter not found");
    }

    public String toString() {
        return "CMakeConsoleViewImpl{myErrorLines=" + this.myErrorLines + ", myWarningLines=" + this.myWarningLines + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/console/CMakeConsoleViewImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/console/CMakeConsoleViewImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "finishAndGetMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyMessageReported";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessageListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MessageListener
    extends EventListener {
        public void messageReported(@NotNull CMakeConsoleMessageType var1);
    }
}

