/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.cpp.cmake.formatting.CMakeCodeBlock;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeFormattingUtils {
    public static boolean textBetweenChildrenContainsLineBreak(@NotNull CMakeCodeBlock child1, @NotNull CMakeCodeBlock child2) {
        if (child1 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(0);
        }
        if (child2 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(1);
        }
        return CMakeFormattingUtils.textBetweenChildrenContainsLineBreak(child1.getNode(), child2.getNode());
    }

    public static boolean textBetweenChildrenContainsLineBreak(@NotNull ASTNode child1, @NotNull ASTNode child2) {
        if (child1 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(2);
        }
        if (child2 == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(3);
        }
        PsiElement firstPsiElement = child1.getPsi();
        int to = child2.getTextRange().getStartOffset();
        PsiElement nextElement = firstPsiElement;
        while (nextElement != null && nextElement.getTextRange().getStartOffset() < to) {
            ASTNode nextElementNode;
            if ((nextElement = PsiTreeUtil.nextLeaf((PsiElement)nextElement)) == null || (nextElementNode = nextElement.getNode()).getElementType() != TokenType.WHITE_SPACE || !StringUtil.containsLineBreak((CharSequence)nextElementNode.getText())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> T rparShouldBeIndented(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node, @Nullable T offset, @Nullable T zeroOffset) {
        if (parentNode == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(4);
        }
        if (node == null) {
            CMakeFormattingUtils.$$$reportNull$$$0(5);
        }
        if (node.getElementType() == CMakeTokenTypes.RPAR) {
            ASTNode parentAstNode = parentNode.getNode();
            ASTNode probableFirstArgument = parentAstNode.findChildByType(CMakeTokenTypes.C_MAKE_ARGUMENT);
            ASTNode probableFirstArgumentComment = parentAstNode.findChildByType(CMakeTokenTypes.COMMENT);
            ASTNode firstActualArgument = probableFirstArgument;
            if (probableFirstArgument == null) {
                firstActualArgument = probableFirstArgumentComment;
            } else if (probableFirstArgumentComment != null) {
                ASTNode aSTNode = firstActualArgument = probableFirstArgument.getStartOffset() < probableFirstArgumentComment.getStartOffset() ? probableFirstArgument : probableFirstArgumentComment;
            }
            if (firstActualArgument != null) {
                boolean leftParenthesisAndFirstArgumentAreOnTheSameLine;
                ASTNode whitespaceNode = parentAstNode.findChildByType(TokenType.WHITE_SPACE);
                boolean bl = leftParenthesisAndFirstArgumentAreOnTheSameLine = whitespaceNode == null || whitespaceNode.getStartOffset() >= firstActualArgument.getTextRange().getEndOffset() || !StringUtil.containsLineBreak((CharSequence)whitespaceNode.getText());
                if (parentAstNode.getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS && leftParenthesisAndFirstArgumentAreOnTheSameLine) {
                    return offset;
                }
                return zeroOffset;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/formatting/CMakeFormattingUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "textBetweenChildrenContainsLineBreak";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rparShouldBeIndented";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

