/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.formatting;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeElementTypes;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeFile;
import com.jetbrains.cidr.cpp.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cidr.cpp.cmake.settings.Case;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakePreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        PsiFile containingFile;
        if (element == null) {
            CMakePreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CMakePreFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = containingFile = (psiElement = element.getPsi()) == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(containingFile instanceof CMakeFile)) {
            TextRange textRange = range;
            if (textRange == null) {
                CMakePreFormatProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = new MyFormatter(psiElement).process(range);
        if (textRange == null) {
            CMakePreFormatProcessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/formatting/CMakePreFormatProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/formatting/CMakePreFormatProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFormatter {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final PsiElement myElement;
        @NotNull
        protected final PsiDocumentManager myDocumentManager;
        @Nullable
        protected final Document myDocument;
        protected final CMakeCodeStyleSettings myCMakeCodeStyleSettings;

        public MyFormatter(@NotNull PsiElement element) {
            if (element == null) {
                MyFormatter.$$$reportNull$$$0(0);
            }
            this.myProject = element.getProject();
            this.myElement = element;
            this.myCMakeCodeStyleSettings = (CMakeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(CMakeCodeStyleSettings.class);
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            this.myDocument = this.myDocumentManager.getDocument(element.getContainingFile());
        }

        @NotNull
        private TextRange process(final @NotNull TextRange range) {
            if (range == null) {
                MyFormatter.$$$reportNull$$$0(1);
            }
            if (this.myDocument == null || this.myCMakeCodeStyleSettings == null || this.myCMakeCodeStyleSettings.hasDoNotChangeFileSettings()) {
                TextRange textRange = range;
                if (textRange == null) {
                    MyFormatter.$$$reportNull$$$0(2);
                }
                return textRange;
            }
            final ArrayList functionsToChangeCase = ContainerUtil.newArrayList();
            this.myElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    IElementType type;
                    ASTNode currentNode;
                    TextRange nodeRange;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (range.intersects(nodeRange = (currentNode = element.getNode()).getTextRange()) && this.intersectWithEditable(element) && ((type = currentNode.getElementType()) == CMakeElementTypes.ID || MyFormatter.isFunctionOrMacroName(currentNode, type) || MyFormatter.isKeyword(type))) {
                        functionsToChangeCase.add(nodeRange);
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/cpp/cmake/formatting/CMakePreFormatProcessor$MyFormatter$1", "visitElement"));
                }
            });
            CharSequence charSequence = this.myDocument.getCharsSequence();
            DocumentUtil.executeInBulk((Document)this.myDocument, (boolean)true, () -> {
                PairProcessor processor2 = (range1, s) -> {
                    TextRange shifted = TextRange.create((int)range1.getStartOffset(), (int)range1.getEndOffset());
                    if (this.myDocument.getText(shifted).equals(s)) {
                        return true;
                    }
                    if (this.myDocument.getRangeGuard(shifted.getStartOffset(), shifted.getEndOffset()) != null) {
                        return true;
                    }
                    this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), (CharSequence)s);
                    return true;
                };
                MyFormatter.processNames(functionsToChangeCase, charSequence, (PairProcessor<TextRange, String>)processor2, Case.resolveByValue(this.myCMakeCodeStyleSettings.FORCE_COMMANDS_CASE));
            });
            if (this.myDocumentManager.isUncommited(this.myDocument)) {
                this.myDocumentManager.commitDocument(this.myDocument);
            }
            TextRange textRange = range;
            if (textRange == null) {
                MyFormatter.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        private static boolean isFunctionOrMacroName(@NotNull ASTNode currentNode, @NotNull IElementType currentNodeType) {
            if (currentNode == null) {
                MyFormatter.$$$reportNull$$$0(4);
            }
            if (currentNodeType == null) {
                MyFormatter.$$$reportNull$$$0(5);
            }
            if (currentNodeType != CMakeElementTypes.C_MAKE_ARGUMENT) {
                return false;
            }
            ASTNode possibleCommandArguments = currentNode.getTreeParent();
            if (possibleCommandArguments == null || possibleCommandArguments.getElementType() != CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS || possibleCommandArguments.getFirstChildNode().getTreeNext() != currentNode) {
                return false;
            }
            ASTNode possibleFunctionOrMacroNode = possibleCommandArguments.getTreeParent();
            return possibleFunctionOrMacroNode != null && CMakeElementTypes.CMAKE_FUNCTION_AND_MACRO_NAME_HOLDERS.contains(possibleFunctionOrMacroNode.getElementType());
        }

        private static boolean isKeyword(@NotNull IElementType currentNodeType) {
            if (currentNodeType == null) {
                MyFormatter.$$$reportNull$$$0(6);
            }
            return CMakeElementTypes.KEYWORDS.contains(currentNodeType);
        }

        private boolean intersectWithEditable(@NotNull PsiElement element) {
            if (element == null) {
                MyFormatter.$$$reportNull$$$0(7);
            }
            if (!(this.myDocument instanceof DocumentWindow)) {
                return true;
            }
            return !InjectedLanguageManager.getInstance((Project)this.myProject).intersectWithAllEditableFragments(element.getContainingFile(), element.getNode().getTextRange()).isEmpty();
        }

        private static void processNames(@NotNull List<TextRange> functionRanges, @NotNull CharSequence charSequence, @NotNull PairProcessor<TextRange, String> processor2, @Nullable Case mode) {
            if (functionRanges == null) {
                MyFormatter.$$$reportNull$$$0(8);
            }
            if (charSequence == null) {
                MyFormatter.$$$reportNull$$$0(9);
            }
            if (processor2 == null) {
                MyFormatter.$$$reportNull$$$0(10);
            }
            if (mode == null) {
                return;
            }
            if (mode == Case.DO_NOT_CHANGE) {
                return;
            }
            for (TextRange range : functionRanges) {
                String text = charSequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
                String newText = mode.apply(text);
                processor2.process((Object)range, (Object)newText);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/formatting/CMakePreFormatProcessor$MyFormatter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentNode";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentNodeType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionRanges";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charSequence";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/formatting/CMakePreFormatProcessor$MyFormatter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isFunctionOrMacroName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isKeyword";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWithEditable";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "processNames";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

