/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeSettingsFileParser;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CMakeCacheFileParser
extends CMakeSettingsFileParser<CMakeVariable> {
    @NotNull
    private StringBuilder myDescriptionBuilder = new StringBuilder();

    CMakeCacheFileParser() {
    }

    @Override
    protected void cleanup() {
        this.myDescriptionBuilder.setLength(0);
    }

    @Override
    protected void preprocess(@NotNull String line) {
        if (line == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(0);
        }
        if (line.startsWith("//")) {
            this.myDescriptionBuilder.append(StringUtil.trimStart((String)line, (String)"//"));
        } else if (line.isEmpty()) {
            this.myDescriptionBuilder.setLength(0);
        }
    }

    @Override
    @NotNull
    protected Pair<String, CMakeVariable> parseVariable(@NotNull String name2, @NotNull String value) {
        if (name2 == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(1);
        }
        if (value == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(2);
        }
        String typeString = null;
        int colon = name2.indexOf(":");
        if (colon >= 0) {
            typeString = name2.substring(colon + 1).trim();
            name2 = name2.substring(0, colon).trim();
        }
        CMakeVariable.Type type = CMakeVariable.Type.UNINITIALIZED;
        if (typeString != null) {
            try {
                type = CMakeVariable.Type.valueOf(typeString);
            }
            catch (IllegalArgumentException e) {
                CPPLog.LOG.warn("Unknown CMake variable type: " + name2 + ":" + typeString);
            }
        }
        String description = this.myDescriptionBuilder.toString();
        this.myDescriptionBuilder.setLength(0);
        Pair pair2 = Pair.create((Object)name2, (Object)new CMakeVariable(name2, description, type, value));
        if (pair2 == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(3);
        }
        return pair2;
    }

    public Pair<String, Map<String, CMakeVariable>> parseAndUpdate(@NotNull File file, @NotNull String encoding, Map<String, String> varsToUpdate) throws CMakeException {
        if (file == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(4);
        }
        if (encoding == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(5);
        }
        return this.parseAndUpdate(CMakeCacheFileParser.loadText(file, encoding), varsToUpdate);
    }

    public Pair<String, Map<String, CMakeVariable>> parseAndUpdate(@NotNull String text, Map<String, String> varsToUpdate) {
        if (text == null) {
            CMakeCacheFileParser.$$$reportNull$$$0(6);
        }
        Pair result = this.parse(text, lineAndVar -> {
            String line = (String)lineAndVar.first;
            CMakeVariable var = (CMakeVariable)lineAndVar.second;
            String varName = var.getName();
            if (!varsToUpdate.containsKey(varName)) {
                return lineAndVar;
            }
            String newValue = (String)varsToUpdate.get(varName);
            line = line.substring(0, line.indexOf("=") + 1) + StringUtil.notNullize((String)newValue);
            return Pair.create((Object)line, (Object)new CMakeVariable(varName, var.getDescription(), var.getType(), newValue));
        });
        return Pair.create((Object)result.first, this.toUniqueMap((LinkedMultiMap)result.second));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCacheFileParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCacheFileParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseVariable";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAndUpdate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

