/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeConfigurationSettings
implements Serializable {
    @NotNull
    private final CMakeCompiler myCompiler;
    @Nullable
    private final File myCompilerExecutable;
    @NotNull
    private final List<String> myFlags;
    @NotNull
    private final List<String> myDefines;

    public CMakeConfigurationSettings(@NotNull CMakeCompiler compiler, @Nullable File compilerExecutable, @NotNull List<String> flags, @NotNull List<String> defines) {
        if (compiler == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(0);
        }
        if (flags == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(1);
        }
        if (defines == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(2);
        }
        this.myCompiler = compiler;
        this.myCompilerExecutable = compilerExecutable;
        this.myFlags = Collections.unmodifiableList(flags);
        this.myDefines = Collections.unmodifiableList(defines);
    }

    @NotNull
    public CMakeCompiler getCompiler() {
        CMakeCompiler cMakeCompiler = this.myCompiler;
        if (cMakeCompiler == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(3);
        }
        return cMakeCompiler;
    }

    @Nullable
    public File getCompilerExecutable() {
        return this.myCompilerExecutable;
    }

    @NotNull
    public List<String> getFlags() {
        List<String> list = this.myFlags;
        if (list == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getDefines() {
        List<String> list = this.myDefines;
        if (list == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(5);
        }
        return list;
    }

    public String toString() {
        return "ConfigurationSettings: {compilers='" + this.myCompiler + "'@'" + this.myCompiler + "', flags='" + this.myFlags + "', defines='" + this.myDefines + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CMakeConfigurationSettings settings = (CMakeConfigurationSettings)o;
        if (!this.myCompiler.equals(settings.myCompiler)) {
            return false;
        }
        if (!FileUtil.filesEqual((File)this.myCompilerExecutable, (File)settings.myCompilerExecutable)) {
            return false;
        }
        if (!this.myFlags.equals(settings.myFlags)) {
            return false;
        }
        return this.myDefines.equals(settings.myDefines);
    }

    public int hashCode() {
        int result = this.myCompiler.hashCode();
        result = 31 * result + FileUtil.fileHashCode((File)this.myCompilerExecutable);
        result = 31 * result + this.myFlags.hashCode();
        result = 31 * result + this.myDefines.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfigurationSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

