/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCodeBlocks;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFlagsFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMakeFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeElementFactory;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeFile;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeGenerator {
    public static final String CMAKE_FILES_FOLDER = "CMakeFiles";
    private static final Pattern CMAKE_COMPILER_FILE_PATTERN = Pattern.compile("CMakeFiles/(?:[^/]+/)?CMake(\\w+)Compiler\\.cmake", SystemInfo.isFileSystemCaseSensitive ? 0 : 2);
    private static final THashMap<String, OCLanguageKind> PREDEFINED_EXTENSION_TO_LANGUAGE_MAP = new THashMap();
    private static List<String> ourEmulateCMakeExecutionErrorInProfiles;
    @Nullable
    private static List<Pair<String, String>> ourEmulateProductNotFoundForTargetAndProfile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myProjectDir;
    @NotNull
    private final List<Parameters> myParameters;
    @Nullable
    private final String myPreferredEncoding;
    @NotNull
    private final Charset myDefaultCharset;

    public static void setEmulateCMakeExecutionErrorInTests(String ... emulateInProfiles) {
        ourEmulateCMakeExecutionErrorInProfiles = emulateInProfiles == null || emulateInProfiles.length == 0 ? null : Arrays.asList(emulateInProfiles);
    }

    @SafeVarargs
    public static void setEmulateProductNotFoundInTests(Pair<String, String> ... targetAndProfiles) {
        ourEmulateProductNotFoundForTargetAndProfile = targetAndProfiles == null || targetAndProfiles.length == 0 ? null : Arrays.asList(targetAndProfiles);
    }

    public CMakeGenerator(@NotNull Project project2, @NotNull File projectDir, @NotNull List<Parameters> parameters, @Nullable String preferredEncoding, @NotNull Charset defaultCharset) {
        if (project2 == null) {
            CMakeGenerator.$$$reportNull$$$0(0);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            CMakeGenerator.$$$reportNull$$$0(2);
        }
        if (defaultCharset == null) {
            CMakeGenerator.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myProjectDir = new File(FileUtil.toCanonicalPath((String)projectDir.getPath()));
        this.myParameters = parameters;
        this.myPreferredEncoding = preferredEncoding;
        this.myDefaultCharset = defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CMakeModel generate(@Nullable CMakeModel previousModel, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeGenerator.$$$reportNull$$$0(4);
        }
        long before = System.currentTimeMillis();
        CMakeModel cMakeModel = this.doGenerate(previousModel, indicator);
        CMakeModel cMakeModel2 = cMakeModel;
        if (cMakeModel2 == null) {
            CMakeGenerator.$$$reportNull$$$0(5);
        }
        return cMakeModel2;
        finally {
            long after2 = System.currentTimeMillis();
            CPPLog.LOG.info("CMake generation took " + StringUtil.formatDuration((long)(after2 - before)));
        }
    }

    private CMakeModel doGenerate(@Nullable CMakeModel previousModel, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeGenerator.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        THashSet cmakeDependencyFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        cmakeDependencyFiles.add((Object)CMakeGenerator.getCMakeListsFile(this.myProjectDir));
        THashSet headerAndResourceFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        THashMap extensions = new THashMap();
        ExecutorCompletionService<ProfileGenerationResult> completionService = new ExecutorCompletionService<ProfileGenerationResult>(AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CMakeGenerator pool", (int)Runtime.getRuntime().availableProcessors()));
        Condition isInSourceGeneration = each -> FileUtil.filesEqual((File)this.myProjectDir, (File)each.generationDir);
        boolean hasInSourceCache = new File(this.myProjectDir, "CMakeCache.txt").exists();
        boolean hasInSourceGenerationParameters = ContainerUtil.find(this.myParameters, (Condition)isInSourceGeneration) != null;
        THashMap alreadyUsedGenerationDirs = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        ArrayList<Object> submitted = new ArrayList<Object>(this.myParameters.size());
        for (int i = 0; i < this.myParameters.size(); ++i) {
            Object dirIsAlreadyUsedBy;
            boolean isLast;
            Parameters each2 = this.myParameters.get(i);
            boolean bl = isLast = i == this.myParameters.size() - 1;
            if ((hasInSourceGenerationParameters || hasInSourceCache) && !isInSourceGeneration.value((Object)each2)) {
                if (hasInSourceGenerationParameters) {
                    String reason = hasInSourceCache ? "CMakeCache.txt is found in the project dir, only in-source generation will be performed." : "Only in-source generation will be performed.";
                    each2.listener.message(CMakeMessage.fatalError("Cannot generate '" + each2.profileName + "' into " + each2.generationDir + "\n" + reason, CMakeGenerator.getCMakeListsFile(this.myProjectDir)));
                    continue;
                }
                hasInSourceGenerationParameters = true;
                each2 = new Parameters(each2.profileId, each2.profileName, each2.buildType, this.myProjectDir, each2.additionalOptions, each2.passSystemEnvironment, each2.additionalEnvironment, each2.listener, each2.environment);
            }
            if ((dirIsAlreadyUsedBy = (String)alreadyUsedGenerationDirs.get(each2.generationDir)) == null) {
                alreadyUsedGenerationDirs.put(each2.generationDir, each2.profileName);
            }
            try {
                this.prepareGenerationDirectory(each2.environment, each2.generationDir, each2.additionalOptions, (String)dirIsAlreadyUsedBy);
            }
            catch (CMakeException e) {
                each2.listener.message(CMakeMessage.fromException(e, CMakeGenerator.getCMakeListsFile(this.myProjectDir)));
                continue;
            }
            Parameters finalEach = each2;
            Callable<ProfileGenerationResult> callable = () -> {
                if (indicator == null) {
                    CMakeGenerator.$$$reportNull$$$0(55);
                }
                ProfileGenerationResult result = new ProfileGenerationResult(finalEach, previousModel);
                ProgressManager.getInstance().runProcess(() -> result.doGenerate((Set)cmakeDependencyFiles, (Set)headerAndResourceFiles, (Map)extensions), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
                return result;
            };
            if (isLast) {
                FutureResult result = new FutureResult();
                try {
                    result.set((Object)callable.call());
                }
                catch (Throwable e) {
                    result.setException(e);
                }
                submitted.add(result);
                continue;
            }
            submitted.add(completionService.submit(callable));
        }
        ArrayList<ProfileGenerationResult> profileGenerationResults = new ArrayList<ProfileGenerationResult>();
        String projectName = null;
        ProgressManager.checkCanceled();
        ProcessCanceledException pce = null;
        for (Object each3 : submitted) {
            ProfileGenerationResult result = null;
            try {
                result = (ProfileGenerationResult)each3.get();
            }
            catch (InterruptedException e) {
                pce = new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    pce = (ProcessCanceledException)e.getCause();
                }
                CPPLog.LOG.error((Throwable)e);
            }
            if (result == null) continue;
            profileGenerationResults.add(result);
            if (result.loadedCacheFile == null) continue;
            projectName = result.loadedCacheFile.getProjectName();
        }
        if (pce != null) {
            throw pce;
        }
        ProgressManager.checkCanceled();
        projectName = StringUtil.notNullize(projectName, (String)"Project");
        List<CMakeTarget> targets = this.convertToTargets(projectName, profileGenerationResults);
        headerAndResourceFiles.removeAll((Collection)cmakeDependencyFiles);
        for (CMakeTarget eachTarget : targets) {
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                headerAndResourceFiles.removeAll(eachConfig.getSources());
            }
        }
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.forEach((ext, kind) -> {
            OCLanguageKind cfr_ignored_0 = (OCLanguageKind)extensions.put(ext, kind);
        });
        headerAndResourceFiles.compact();
        cmakeDependencyFiles.compact();
        extensions.compact();
        List configurationData = ContainerUtil.map(profileGenerationResults, it -> new CMakeModelConfigurationData(it.parameters.profileId, it.parameters.profileName, it.parameters.generationDir, it.cacheIOFile, it.cacheIOFileEncoding, it.registeredBuildTypes));
        return new CMakeModel(projectName, (Set<File>)cmakeDependencyFiles, (Set<File>)headerAndResourceFiles, targets, (Map<String, OCLanguageKind>)extensions, configurationData);
    }

    @NotNull
    private List<CMakeTarget> convertToTargets(@NotNull String projectName, @NotNull List<ProfileGenerationResult> generationResults) {
        if (projectName == null) {
            CMakeGenerator.$$$reportNull$$$0(7);
        }
        if (generationResults == null) {
            CMakeGenerator.$$$reportNull$$$0(8);
        }
        Map targetsWithConfigs = CMakeGenerator.createOrderedTargetKeysMap();
        for (ProfileGenerationResult eachGenerationResult : generationResults) {
            for (PerProfileTargetInfo eachTarget : eachGenerationResult.targetInfos) {
                Pair targetInfoAndConfigs = targetsWithConfigs.computeIfAbsent(eachTarget.targetName, k -> {
                    if (generationResults == null) {
                        CMakeGenerator.$$$reportNull$$$0(54);
                    }
                    return new Pair((Object)eachTarget, new ArrayList(generationResults.size()));
                });
                CMakeCodeBlocks codeBlocksProject = eachGenerationResult.codeBlocksProject;
                String targetTypeString = codeBlocksProject == null ? null : codeBlocksProject.getTargetTypes().get(eachTarget.targetName);
                ((List)targetInfoAndConfigs.second).add(new CMakeConfiguration(eachGenerationResult.parameters.profileId, eachGenerationResult.parameters.profileName, eachGenerationResult.actualBuildType, eachTarget.generatedDir, eachTarget.targetDir, eachTarget.perLanguageSettings, ContainerUtil.notNullize(eachTarget.linkerFlags), eachTarget.sources, eachTarget.productFile, eachTarget.buildWorkingDir, CMakeConfiguration.TargetType.fromString(targetTypeString)));
            }
        }
        ArrayList sortedTargetsWithConfigs = new ArrayList();
        sortedTargetsWithConfigs.addAll(targetsWithConfigs.values());
        Collections.sort(sortedTargetsWithConfigs, new Comparator<Pair<PerProfileTargetInfo, List<CMakeConfiguration>>>(){
            final PerTargetInfoComparator myBaseComparator;
            {
                this.myBaseComparator = new PerTargetInfoComparator();
            }

            @Override
            public int compare(Pair<PerProfileTargetInfo, List<CMakeConfiguration>> o1, Pair<PerProfileTargetInfo, List<CMakeConfiguration>> o2) {
                return this.myBaseComparator.compare((PerProfileTargetInfo)o1.first, (PerProfileTargetInfo)o2.first);
            }
        });
        ArrayList<CMakeTarget> result = new ArrayList<CMakeTarget>(sortedTargetsWithConfigs.size());
        for (Pair eachTargetWithConfigs : sortedTargetsWithConfigs) {
            CMakeTarget target = new CMakeTarget(projectName, ((PerProfileTargetInfo)eachTargetWithConfigs.first).targetName, (List)eachTargetWithConfigs.second);
            for (CMakeConfiguration eachConfiguration : (List)eachTargetWithConfigs.second) {
                eachConfiguration.initTarget(target);
            }
            result.add(target);
        }
        ArrayList<CMakeTarget> arrayList = result;
        if (arrayList == null) {
            CMakeGenerator.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public void prepareGenerationDirectory(@NotNull CMakeEnvironment environment, @NotNull File generationDir, @NotNull List<String> options, @Nullable String dirIsAlreadyUsed) throws CMakeException {
        File cacheFile;
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(10);
        }
        if (generationDir == null) {
            CMakeGenerator.$$$reportNull$$$0(11);
        }
        if (options == null) {
            CMakeGenerator.$$$reportNull$$$0(12);
        }
        Function<String, String> formatMessage = text -> {
            if (generationDir == null) {
                CMakeGenerator.$$$reportNull$$$0(53);
            }
            return "Cannot generate into " + generationDir + "\n" + text + "\n\nPlease either delete it manually or select another generation directory";
        };
        if (dirIsAlreadyUsed != null) {
            throw new CMakeException(formatMessage.apply("This directory is already used for '" + dirIsAlreadyUsed + "' profile"));
        }
        if (generationDir.exists() && !generationDir.isDirectory()) {
            throw new CMakeException(formatMessage.apply("Specified path is not a directory"));
        }
        if (!generationDir.exists() && !generationDir.mkdirs()) {
            throw new CMakeException(formatMessage.apply("Cannot create directory"));
        }
        boolean cleanGeneratedFiles = false;
        boolean errorOnIncompatibleGeneratedFiles = true;
        File envFile = CMakeGenerator.getCMakeFilesIDEFile(generationDir, "environment.txt");
        String currentToolchainAndOptions = environment.calcToolchainHash() + "\nOptions:" + StringUtil.join(options, (String)"\u0000");
        try {
            String prev = FileUtil.loadFile((File)envFile);
            if (currentToolchainAndOptions.equals(prev)) {
                errorOnIncompatibleGeneratedFiles = false;
            } else {
                cleanGeneratedFiles = true;
                CPPLog.LOG.info("CMake will be regenerated due to environment change.\nNew environment: " + currentToolchainAndOptions + "\nOld environment: " + prev);
            }
        }
        catch (IOException prev) {
            // empty catch block
        }
        if (!cleanGeneratedFiles && (cacheFile = new File(generationDir, "CMakeCache.txt")).exists()) {
            try {
                File previousProjectDir;
                CMakeCacheFile cache;
                try {
                    cache = new CMakeCacheFile(cacheFile, this.encodingForFile(cacheFile));
                }
                catch (CMakeException e) {
                    throw new CMakeException(formatMessage.apply("Cannot read " + cacheFile.getName()), e);
                }
                String previousProjectDirValue = cache.getVariableValue("CMAKE_HOME_DIRECTORY");
                File file = previousProjectDir = previousProjectDirValue == null ? null : CMakeGenerator.toLocalFile(environment, previousProjectDirValue);
                if (previousProjectDir == null) {
                    throw new CMakeException(formatMessage.apply("It is already used for unknown project"));
                }
                if (!FileUtil.filesEqual((File)this.myProjectDir, (File)previousProjectDir)) {
                    throw new CMakeException(formatMessage.apply("It is already used for project " + previousProjectDir));
                }
                String previousGenerator = cache.getVariableValue("CMAKE_GENERATOR");
                if (previousGenerator == null) {
                    throw new CMakeException(formatMessage.apply("It was created with unknown generator"));
                }
                if (!previousGenerator.contains(CMakeGenerator.getGeneratorSpec(environment, false))) {
                    throw new CMakeException(formatMessage.apply("It was created with incompatible generator '" + previousGenerator + "'"));
                }
            }
            catch (CMakeException e) {
                if (errorOnIncompatibleGeneratedFiles) {
                    throw e;
                }
                cleanGeneratedFiles = true;
            }
        }
        if (cleanGeneratedFiles) {
            CMakeGenerator.cleanGeneratedCMakeFiles(generationDir);
        }
        try {
            FileUtil.writeToFile((File)envFile, (String)currentToolchainAndOptions);
        }
        catch (IOException e) {
            throw new CMakeException("Cannot save file " + envFile, e);
        }
    }

    public static void cleanGeneratedCMakeFiles(@NotNull File generationDir) {
        if (generationDir == null) {
            CMakeGenerator.$$$reportNull$$$0(13);
        }
        FileUtil.delete((File)new File(generationDir, CMAKE_FILES_FOLDER));
        FileUtil.delete((File)new File(generationDir, "CMakeCache.txt"));
    }

    @NotNull
    public static File getCMakeFilesIDEFile(@NotNull File generationDir, @NotNull String fileName) {
        if (generationDir == null) {
            CMakeGenerator.$$$reportNull$$$0(14);
        }
        if (fileName == null) {
            CMakeGenerator.$$$reportNull$$$0(15);
        }
        String productName = FileUtil.sanitizeFileName((String)StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getProductName()));
        File file = new File(generationDir, "CMakeFiles/" + productName + "-" + fileName);
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    private static File getCMakeListsFile(@NotNull File dir) {
        if (dir == null) {
            CMakeGenerator.$$$reportNull$$$0(17);
        }
        File file = new File(FileUtil.toCanonicalPath((String)new File(dir, "CMakeLists.txt").getPath()));
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(18);
        }
        return file;
    }

    @NotNull
    private static File toLocalFile(@NotNull CMakeEnvironment environment, @NotNull String absolutePath) {
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(19);
        }
        if (absolutePath == null) {
            CMakeGenerator.$$$reportNull$$$0(20);
        }
        File file = CMakeGenerator.toLocalFile(environment, null, absolutePath);
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(21);
        }
        return file;
    }

    @NotNull
    private static File toLocalFile(@NotNull CMakeEnvironment environment, @Nullable File basedir, @NotNull String absoluteOrRelativePath) {
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(22);
        }
        if (absoluteOrRelativePath == null) {
            CMakeGenerator.$$$reportNull$$$0(23);
        }
        File file = new File(environment.toLocalPath(basedir, absoluteOrRelativePath));
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(24);
        }
        return file;
    }

    @NotNull
    private static String toEnvPath(@NotNull CMakeEnvironment environment, @NotNull String absoluteLocalPath) {
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(25);
        }
        if (absoluteLocalPath == null) {
            CMakeGenerator.$$$reportNull$$$0(26);
        }
        String string = environment.toEnvPath(absoluteLocalPath);
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static <T> Map<String, T> createOrderedTargetKeysMap() {
        return new LinkedHashMap();
    }

    private CMakeFile parseCMakeFile(@NotNull File file) throws CMakeException {
        String text;
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(28);
        }
        try {
            text = FileUtil.loadFile((File)file, (String)this.encodingForFile(file));
        }
        catch (IOException e) {
            throw CMakeException.cannotReadFile(file, e);
        }
        return (CMakeFile)((Object)this.runReadActionCanceling(() -> CMakeElementFactory.createFile(this.myProject, text)));
    }

    private List<String> getCMakeVariableValues(@NotNull CMakeFile file, @Nullable String optionName) {
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(29);
        }
        return (List)this.runReadActionCanceling(() -> {
            if (file == null) {
                CMakeGenerator.$$$reportNull$$$0(52);
            }
            return file.findFirstVariableValues(optionName);
        });
    }

    private <T> T runReadActionCanceling(Computable<T> computable) {
        return (T)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            ProgressManager.checkCanceled();
            return computable.compute();
        });
    }

    @NotNull
    private CMakeRunner.CMakeOutput runCMakeGenerator(final @NotNull Parameters parameters) throws CMakeException {
        if (parameters == null) {
            CMakeGenerator.$$$reportNull$$$0(30);
        }
        if (ourEmulateCMakeExecutionErrorInProfiles != null && ourEmulateCMakeExecutionErrorInProfiles.contains(parameters.profileName)) {
            throw new EmulatedCMakeException("Emulated CMake error in " + parameters.profileName);
        }
        ArrayList<String> commandLineOptions = new ArrayList<String>();
        commandLineOptions.add(CMakeGenerator.getBuildTypeOption(parameters.buildType));
        commandLineOptions.addAll(parameters.additionalOptions);
        CMakeRunner.CMakeOutput cMakeOutput = CMakeGenerator.runCMakeGenerator(parameters.environment, this.myProjectDir, parameters.generationDir, true, commandLineOptions, parameters.passSystemEnvironment, parameters.additionalEnvironment, new CMakeRunner.Listener(){

            @Override
            public void processStarted(@NotNull ProcessHandler handler) {
                if (handler == null) {
                    2.$$$reportNull$$$0(0);
                }
                parameters.listener.attachTo(handler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$2", "processStarted"));
            }
        }, true, this.myProject);
        if (cMakeOutput == null) {
            CMakeGenerator.$$$reportNull$$$0(31);
        }
        return cMakeOutput;
    }

    @NotNull
    public static String getBuildTypeOption(@NotNull String buildType) {
        if (buildType == null) {
            CMakeGenerator.$$$reportNull$$$0(32);
        }
        String string = "-DCMAKE_BUILD_TYPE=" + (buildType.equals("Default") ? "" : buildType);
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CMakeEnvironment environment, @NotNull File projectDir, @NotNull File outputDir, @NotNull List<String> commandLineOptions) throws CMakeException {
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(34);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(35);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(36);
        }
        if (commandLineOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(37);
        }
        CMakeRunner.Listener emptyListener = new CMakeRunner.Listener(){};
        CMakeRunner.CMakeOutput cMakeOutput = CMakeGenerator.runCMakeGenerator(environment, projectDir, outputDir, false, commandLineOptions, true, Collections.emptyMap(), emptyListener, false, null);
        if (cMakeOutput == null) {
            CMakeGenerator.$$$reportNull$$$0(38);
        }
        return cMakeOutput;
    }

    @NotNull
    private static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CMakeEnvironment environment, @NotNull File projectDir, @NotNull File outputDir, boolean generateCodeBlocksProject, List<String> commandLineOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment, @NotNull CMakeRunner.Listener listener2, boolean runCustomSteps, Project projectForCustomStepsOrNull) throws CMakeException {
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(39);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(40);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(41);
        }
        if (additionalEnvironment == null) {
            CMakeGenerator.$$$reportNull$$$0(42);
        }
        if (listener2 == null) {
            CMakeGenerator.$$$reportNull$$$0(43);
        }
        ArrayList<String> allParams = new ArrayList<String>(commandLineOptions);
        allParams.add("-G");
        allParams.add(CMakeGenerator.getGeneratorSpec(environment, generateCodeBlocksProject));
        CMakeRunnerStep.Parameters parameters = new CMakeRunnerStep.Parameters(environment, projectDir, outputDir, allParams, passSystemEnvironment, additionalEnvironment, listener2);
        if (runCustomSteps) {
            if (projectForCustomStepsOrNull == null) {
                CPPLog.LOG.error("project must be specified");
            } else {
                for (CMakeRunnerStep eachStep : (CMakeRunnerStep[])Extensions.getExtensions(CMakeRunnerStep.EP_NAME)) {
                    try {
                        eachStep.beforeGeneration(projectForCustomStepsOrNull, parameters);
                    }
                    catch (CMakeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        CPPLog.LOG.warn("Extension thrown exception: " + eachStep, e);
                    }
                }
            }
        }
        CMakeRunner.CMakeOutput cMakeOutput = CMakeRunner.runCMake(parameters);
        if (cMakeOutput == null) {
            CMakeGenerator.$$$reportNull$$$0(44);
        }
        return cMakeOutput;
    }

    @NotNull
    private static String getGeneratorSpec(@NotNull CMakeEnvironment environment, boolean generateCodeBlocksProject) {
        if (environment == null) {
            CMakeGenerator.$$$reportNull$$$0(45);
        }
        String string = CMakeGenerator.getGeneratorSpec(environment.getToolSet(), generateCodeBlocksProject);
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static String getGeneratorSpec(@Nullable CPPToolSet toolSet, boolean generateCodeBlocksProject) {
        CMakeGeneratorType generator = toolSet != null ? (toolSet.isMinGW() ? CMakeGeneratorType.MINGW : (toolSet.isCygwin() || toolSet.isWSL() ? CMakeGeneratorType.UNIX : CMakeGeneratorType.NMAKE)) : CMakeGeneratorType.UNIX;
        String string = (generateCodeBlocksProject ? "CodeBlocks - " : "") + generator.getValue();
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private String encodingForFile(@NotNull File file) {
        String string;
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(48);
        }
        if (this.myPreferredEncoding != null) {
            String string2 = this.myPreferredEncoding;
            if (string2 == null) {
                CMakeGenerator.$$$reportNull$$$0(49);
            }
            return string2;
        }
        try {
            Charset guessedCharset = CharsetToolkit.guessEncoding((File)file, (int)((int)file.length()), (Charset)this.myDefaultCharset);
            string = (guessedCharset == null ? this.myDefaultCharset : guessedCharset).name();
        }
        catch (IOException e) {
            String string3 = this.myDefaultCharset.name();
            if (string3 == null) {
                CMakeGenerator.$$$reportNull$$$0(51);
            }
            return string3;
        }
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(50);
        }
        return string;
    }

    static {
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put((Object)"m", (Object)OCLanguageKind.OBJ_C);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put((Object)"M", (Object)OCLanguageKind.OBJ_CPP);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put((Object)"mm", (Object)OCLanguageKind.OBJ_CPP);
        ourEmulateCMakeExecutionErrorInProfiles = null;
        ourEmulateProductNotFoundForTargetAndProfile = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 2: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 4: 
            case 6: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 8: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationResults";
                break;
            }
            case 10: 
            case 19: 
            case 22: 
            case 25: 
            case 34: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativePath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteLocalPath";
                break;
            }
            case 28: 
            case 29: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineOptions";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToTargets";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFilesIDEFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeListsFile";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
            case 31: 
            case 38: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "runCMakeGenerator";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeOption";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorSpec";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doGenerate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertToTargets";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareGenerationDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanGeneratedCMakeFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFilesIDEFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeListsFile";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toLocalFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseCMakeFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeVariableValues";
                break;
            }
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "runCMakeGenerator";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTypeOption";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorSpec";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "encodingForFile";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCMakeVariableValues$8";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareGenerationDirectory$6";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$convertToTargets$5";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doGenerate$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 38: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PerTargetInfoComparator
    implements Comparator<PerProfileTargetInfo> {
        final File mainCMakeLists;

        private PerTargetInfoComparator() {
            this.mainCMakeLists = CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir);
        }

        @Override
        public int compare(PerProfileTargetInfo o1, PerProfileTargetInfo o2) {
            int result = Comparing.compare((boolean)FileUtil.filesEqual((File)this.mainCMakeLists, (File)o1.cmakeListsFile), (boolean)FileUtil.filesEqual((File)this.mainCMakeLists, (File)o2.cmakeListsFile));
            if (result != 0) {
                return -result;
            }
            if (!FileUtil.filesEqual((File)o1.cmakeListsFile, (File)o2.cmakeListsFile)) {
                result = Comparing.compare((boolean)FileUtil.isAncestor((File)this.mainCMakeLists.getParentFile(), (File)o1.cmakeListsFile.getParentFile(), (boolean)true), (boolean)FileUtil.isAncestor((File)this.mainCMakeLists.getParentFile(), (File)o2.cmakeListsFile.getParentFile(), (boolean)true));
                if (result != 0) {
                    return -result;
                }
                if (FileUtil.isAncestor((File)o1.cmakeListsFile.getParentFile(), (File)o2.cmakeListsFile.getParentFile(), (boolean)true)) {
                    return -1;
                }
                if (FileUtil.isAncestor((File)o2.cmakeListsFile.getParentFile(), (File)o1.cmakeListsFile.getParentFile(), (boolean)true)) {
                    return 1;
                }
                return StringUtil.compare((String)o1.cmakeListsFile.getPath(), (String)o2.cmakeListsFile.getPath(), (boolean)true);
            }
            return StringUtil.compare((String)o1.targetName, (String)o2.targetName, (boolean)true);
        }
    }

    private static class EmulatedCMakeException
    extends CMakeException {
        public EmulatedCMakeException(String message) {
            super(message);
        }
    }

    private static class PerProfileTargetInfo {
        @NotNull
        final CMakeEnvironment environment;
        @NotNull
        final File cmakeListsFile;
        @NotNull
        final File generatedDir;
        @NotNull
        final CMakeCacheFile cacheFile;
        @Nullable
        final CMakeGeneratorType generatorType;
        @NotNull
        final File targetDir;
        @NotNull
        final File buildWorkingDir;
        @NotNull
        final String targetName;
        @NotNull
        final String profileName;
        @NotNull
        Map<OCLanguageKind, CMakeConfigurationSettings> perLanguageSettings;
        @NotNull
        Map<File, CMakeFileSettings> sources;
        @Nullable
        File productFile;
        @Nullable
        List<String> linkerFlags;

        private PerProfileTargetInfo(@NotNull CMakeEnvironment environment, @NotNull File cmakeListsFile, @NotNull File generatedDir, @NotNull CMakeCacheFile cacheFile, @Nullable CMakeGeneratorType generatorType, @NotNull File targetDir, @NotNull String targetName, @NotNull String profileName, @NotNull File buildWorkingDir) {
            if (environment == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(0);
            }
            if (cmakeListsFile == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(1);
            }
            if (generatedDir == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(2);
            }
            if (cacheFile == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(3);
            }
            if (targetDir == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(4);
            }
            if (targetName == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(5);
            }
            if (profileName == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(6);
            }
            if (buildWorkingDir == null) {
                PerProfileTargetInfo.$$$reportNull$$$0(7);
            }
            this.perLanguageSettings = Collections.emptyMap();
            this.sources = Collections.emptyMap();
            this.environment = environment;
            this.cmakeListsFile = cmakeListsFile;
            this.generatedDir = generatedDir;
            this.cacheFile = cacheFile;
            this.generatorType = generatorType;
            this.targetDir = targetDir;
            this.targetName = targetName;
            this.buildWorkingDir = buildWorkingDir;
            this.profileName = profileName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cmakeListsFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "generatedDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cacheFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetDir";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profileName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildWorkingDir";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$PerProfileTargetInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ProfileGenerationResult {
        @NotNull
        final Parameters parameters;
        @Nullable
        final CMakeModel previousModel;
        @NotNull
        String actualBuildType;
        @NotNull
        File cacheIOFile;
        @NotNull
        String cacheIOFileEncoding;
        @Nullable
        CMakeCacheFile loadedCacheFile;
        @Nullable
        CMakeCodeBlocks codeBlocksProject;
        @NotNull
        List<PerProfileTargetInfo> targetInfos;
        @NotNull
        List<String> registeredBuildTypes;
        private boolean hasGenerationError;

        private ProfileGenerationResult(@Nullable Parameters parameters, CMakeModel previousModel) {
            if (parameters == null) {
                ProfileGenerationResult.$$$reportNull$$$0(0);
            }
            this.targetInfos = Collections.emptyList();
            this.registeredBuildTypes = new ArrayList<String>(CMakeModel.DEFAULT_BUILD_TYPES);
            this.hasGenerationError = false;
            this.parameters = parameters;
            this.previousModel = previousModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doGenerate(@NotNull Set<File> cmakeDependencyFiles, @NotNull Set<File> headerAndResourceFiles, @NotNull Map<String, OCLanguageKind> extensions) {
            block21: {
                if (cmakeDependencyFiles == null) {
                    ProfileGenerationResult.$$$reportNull$$$0(1);
                }
                if (headerAndResourceFiles == null) {
                    ProfileGenerationResult.$$$reportNull$$$0(2);
                }
                if (extensions == null) {
                    ProfileGenerationResult.$$$reportNull$$$0(3);
                }
                ProgressManager.checkCanceled();
                long before = System.currentTimeMillis();
                try {
                    CMakeRunner.CMakeOutput output = CMakeGenerator.this.runCMakeGenerator(this.parameters);
                    this.hasGenerationError = output.getExitCode() != 0;
                }
                catch (CMakeException e) {
                    this.hasGenerationError = true;
                    if (!(e instanceof EmulatedCMakeException)) {
                        CPPLog.LOG.info((Throwable)e);
                    }
                    this.parameters.listener.message(CMakeMessage.fromException(e, CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir)));
                }
                finally {
                    long after2 = System.currentTimeMillis();
                    CPPLog.LOG.info("CMake generation for " + this.parameters.profileName + " took " + StringUtil.formatDuration((long)(after2 - before)));
                }
                ProgressManager.checkCanceled();
                this.cacheIOFile = new File(this.parameters.generationDir, "CMakeCache.txt");
                this.cacheIOFileEncoding = CMakeGenerator.this.encodingForFile(this.cacheIOFile);
                this.actualBuildType = this.parameters.buildType;
                try {
                    this.loadedCacheFile = new CMakeCacheFile(this.cacheIOFile, this.cacheIOFileEncoding);
                    String cacheBuildType = this.loadedCacheFile.getVariableValue("CMAKE_BUILD_TYPE");
                    this.actualBuildType = StringUtil.notNullize((String)cacheBuildType, (String)"Default");
                }
                catch (CMakeException e) {
                    if (this.hasGenerationError) break block21;
                    this.parameters.listener.message(CMakeMessage.fromException(e, CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir)));
                }
            }
            ProgressManager.checkCanceled();
            if (this.loadedCacheFile != null) {
                this.codeBlocksProject = this.loadCodeBlocksProject(this.loadedCacheFile);
                this.targetInfos = this.loadTargetInfos(this.loadedCacheFile);
                String specifiedBuildTypes = this.loadedCacheFile.getConfigurationTypesValue();
                if (specifiedBuildTypes != null) {
                    List rawTypes = StringUtil.split((String)specifiedBuildTypes, (String)";");
                    this.registeredBuildTypes = new ArrayList<String>(rawTypes.size());
                    for (String eachType : rawTypes) {
                        ContainerUtil.addIfNotNull(this.registeredBuildTypes, (Object)StringUtil.nullize((String)eachType.trim()));
                    }
                }
                for (PerProfileTargetInfo eachTarget : this.targetInfos) {
                    try {
                        this.loadPerConfigurationTargetInfo(eachTarget);
                    }
                    catch (CMakeException e) {
                        CPPLog.LOG.info((Throwable)e);
                        this.parameters.listener.message(CMakeMessage.fromException(e, eachTarget.cmakeListsFile));
                    }
                }
                Set<File> set = cmakeDependencyFiles;
                synchronized (set) {
                    this.loadConfigResources(this.codeBlocksProject, headerAndResourceFiles, cmakeDependencyFiles);
                    this.loadFileExtensions(extensions);
                }
            }
        }

        @Nullable
        private CMakeFile loadDependenciesFile(@NotNull File generatedDir, @NotNull CMakeListener listener2) {
            File makeFile;
            if (generatedDir == null) {
                ProfileGenerationResult.$$$reportNull$$$0(4);
            }
            if (listener2 == null) {
                ProfileGenerationResult.$$$reportNull$$$0(5);
            }
            if ((makeFile = new File(generatedDir, "CMakeFiles/Makefile.cmake")).exists() || !this.hasGenerationError) {
                try {
                    return CMakeGenerator.this.parseCMakeFile(makeFile);
                }
                catch (CMakeException e) {
                    String text = "Cannot read CMake dependency information from " + makeFile;
                    CPPLog.LOG.warn(text, (Throwable)e);
                    listener2.message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir), null, text));
                }
            }
            return null;
        }

        private void loadConfigResources(@Nullable CMakeCodeBlocks codeBlocks, @NotNull Set<File> resources, @NotNull Set<File> cmakeDependencyFiles) {
            if (resources == null) {
                ProfileGenerationResult.$$$reportNull$$$0(6);
            }
            if (cmakeDependencyFiles == null) {
                ProfileGenerationResult.$$$reportNull$$$0(7);
            }
            if (codeBlocks != null) {
                for (Map.Entry<String, String> each : codeBlocks.getFilePathsWithFolders().entrySet()) {
                    File file = CMakeGenerator.toLocalFile(this.parameters.environment, FileUtil.toCanonicalPath((String)each.getKey(), (boolean)true));
                    if (each.getValue().startsWith("CMake Files\\")) {
                        cmakeDependencyFiles.add(file);
                        continue;
                    }
                    resources.add(file);
                }
            }
        }

        @Nullable
        private CMakeCodeBlocks loadCodeBlocksProject(@NotNull CMakeCacheFile cacheFile) {
            if (cacheFile == null) {
                ProfileGenerationResult.$$$reportNull$$$0(8);
            }
            File codeBlocksFile = new File(this.parameters.generationDir, cacheFile.getProjectNameValueOrDefault() + ".cbp");
            try {
                return CMakeCodeBlocks.load(codeBlocksFile);
            }
            catch (JDOMException e) {
                String text = "Cannot read project file " + codeBlocksFile;
                CPPLog.LOG.warn(text, (Throwable)e);
                this.parameters.listener.message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir), null, text));
            }
            catch (IOException e) {
                String text = "Cannot read project file " + codeBlocksFile;
                CPPLog.LOG.warn(text, (Throwable)e);
                this.parameters.listener.message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir), null, text));
            }
            return null;
        }

        private void loadFileExtensions(Map<String, OCLanguageKind> result) {
            CMakeFile makeFileCMake = this.loadDependenciesFile(this.parameters.generationDir, this.parameters.listener);
            if (makeFileCMake == null) {
                return;
            }
            for (String each : CMakeGenerator.this.getCMakeVariableValues(makeFileCMake, "CMAKE_MAKEFILE_DEPENDS")) {
                String langID;
                OCLanguageKind langKind;
                File file = CMakeGenerator.toLocalFile(this.parameters.environment, each);
                Matcher matcher = CMAKE_COMPILER_FILE_PATTERN.matcher(FileUtil.toSystemIndependentName((String)file.getPath()));
                if (!matcher.matches() || (langKind = this.toLanguageKind(langID = matcher.group(1))) == null) continue;
                try {
                    CMakeFile compilerFile = CMakeGenerator.this.parseCMakeFile(new File(this.parameters.generationDir, file.getPath()));
                    for (String eachExt : CMakeGenerator.this.getCMakeVariableValues(compilerFile, "CMAKE_" + langID + "_SOURCE_FILE_EXTENSIONS")) {
                        result.put(eachExt, langKind);
                    }
                }
                catch (CMakeException e) {
                    CPPLog.LOG.debug((Throwable)e);
                    this.parameters.listener.message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir), null, e.getMessage()));
                }
            }
        }

        private void loadPerConfigurationTargetInfo(@NotNull PerProfileTargetInfo targetInfo) throws CMakeException {
            if (targetInfo == null) {
                ProfileGenerationResult.$$$reportNull$$$0(9);
            }
            CidrCompilerSwitches.Format compilerSwitchesFormat = targetInfo.generatorType == CMakeGeneratorType.MINGW ? CidrCompilerSwitches.Format.MINGW_MAKEFILES : (targetInfo.generatorType == CMakeGeneratorType.NMAKE ? CidrCompilerSwitches.Format.NMAKE_MAKEFILES : CidrCompilerSwitches.Format.GNU_MAKEFILES);
            CMakeFile dependsInfoCmake = CMakeGenerator.this.parseCMakeFile(new File(targetInfo.targetDir, "DependInfo.cmake"));
            ArrayList<Pair> supportedLanguages = new ArrayList<Pair>();
            for (String eachLangID : CMakeGenerator.this.getCMakeVariableValues(dependsInfoCmake, "CMAKE_DEPENDS_LANGUAGES")) {
                OCLanguageKind languageKind = this.toLanguageKind(eachLangID);
                if (languageKind == null) continue;
                supportedLanguages.add(Pair.create((Object)eachLangID, (Object)languageKind));
            }
            File flagsIOFile = new File(targetInfo.targetDir, "flags.make");
            if (flagsIOFile.exists()) {
                CMakeFlagsFile flagsFile = new CMakeFlagsFile(flagsIOFile, CMakeGenerator.this.encodingForFile(flagsIOFile));
                THashMap settingsMap = new THashMap(supportedLanguages.size());
                String adHocTargetFlags = flagsFile.getVariable("_AD_HOC_TARGET_FLAGS_");
                for (Pair eachLang : supportedLanguages) {
                    String langID = (String)eachLang.first;
                    String flags = StringUtil.notNullize((String)flagsFile.getVariable(langID + "_FLAGS"));
                    String defines = StringUtil.notNullize((String)flagsFile.getVariable(langID + "_DEFINES"));
                    String includes = StringUtil.notNullize((String)flagsFile.getVariable(langID + "_INCLUDES"));
                    if (!StringUtil.isEmptyOrSpaces((String)includes)) {
                        flags = includes + " " + flags;
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)adHocTargetFlags)) {
                        flags = flags + "   " + adHocTargetFlags;
                    }
                    String compilerID = (String)ContainerUtil.getFirstItem((List)CMakeGenerator.this.getCMakeVariableValues(dependsInfoCmake, "CMAKE_" + langID + "_COMPILER_ID"));
                    CMakeCompiler compiler = new CMakeCompiler(StringUtil.notNullize((String)compilerID));
                    String compilerPath = StringUtil.nullize((String)flagsFile.getVariable(langID + "_COMPILER"), (boolean)true);
                    if (compilerPath == null) {
                        compilerPath = StringUtil.nullize((String)targetInfo.cacheFile.getVariableValue("CMAKE_" + langID + "_COMPILER"), (boolean)true);
                    }
                    if (compilerPath != null) {
                        try {
                            compilerPath = this.parameters.environment.resolveEnvPathToLocalExecutable((File)targetInfo.buildWorkingDir, (String)compilerPath).path;
                        }
                        catch (com.intellij.execution.ExecutionException e) {
                            throw new CMakeException("Cannot resolve compiler path '" + compilerPath + "': " + e.getMessage(), e);
                        }
                    }
                    File compilerExec = compilerPath == null ? null : new File(compilerPath);
                    settingsMap.put(eachLang.second, (Object)new CMakeConfigurationSettings(compiler, compilerExec, CidrSwitchBuilder.parseArgs(flags, compilerSwitchesFormat), CidrSwitchBuilder.parseArgs(defines, compilerSwitchesFormat)));
                }
                THashMap predefinedLanguageToExistingLanguage = new THashMap();
                THashMap sources = null;
                for (Pair eachLang : supportedLanguages) {
                    String langID = (String)eachLang.first;
                    List values = CMakeGenerator.this.getCMakeVariableValues(dependsInfoCmake, "CMAKE_DEPENDS_CHECK_" + langID);
                    if (values.isEmpty()) continue;
                    int size = values.size();
                    if (sources == null) {
                        sources = new THashMap(size / 2, FileUtil.FILE_HASHING_STRATEGY);
                    } else {
                        sources.ensureCapacity(sources.size() + size / 2);
                    }
                    for (int i = 0; i < size - 1; i += 2) {
                        File source = CMakeGenerator.toLocalFile(targetInfo.environment, (String)values.get(i));
                        File object = CMakeGenerator.toLocalFile(targetInfo.environment, (String)values.get(i + 1));
                        List<String> fileFlags = null;
                        List<String> fileDefines = null;
                        String relativeObjectPath = this.getRelativePath(targetInfo.generatedDir, object);
                        if (relativeObjectPath != null) {
                            String keyPrefixInFlagsFile = FileUtil.toSystemIndependentName((String)relativeObjectPath);
                            String flagsValue = flagsFile.getVariable(keyPrefixInFlagsFile + "_FLAGS");
                            String definesValue = flagsFile.getVariable(keyPrefixInFlagsFile + "_DEFINES");
                            fileFlags = CidrSwitchBuilder.parseArgs(StringUtil.notNullize((String)flagsValue), compilerSwitchesFormat);
                            fileDefines = this.convertPerFileDefines(definesValue);
                        }
                        OCLanguageKind effectiveLang = (OCLanguageKind)eachLang.second;
                        OCLanguageKind predefinedLang = (OCLanguageKind)PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.get((Object)FileUtilRt.getExtension((String)source.getName()));
                        if (predefinedLang != null) {
                            predefinedLanguageToExistingLanguage.put((Object)predefinedLang, (Object)effectiveLang);
                            effectiveLang = predefinedLang;
                        }
                        sources.put((Object)source, (Object)new CMakeFileSettings(effectiveLang, ContainerUtil.notNullize(fileFlags), ContainerUtil.notNullize(fileDefines)));
                    }
                }
                if (sources != null) {
                    targetInfo.sources = sources;
                }
                predefinedLanguageToExistingLanguage.forEach((predefined, existing) -> settingsMap.put(predefined, settingsMap.get(existing)));
                settingsMap.compact();
                targetInfo.perLanguageSettings = settingsMap;
            }
            if (this.hasGenerationError && targetInfo.sources.isEmpty() && targetInfo.perLanguageSettings.isEmpty() && this.previousModel != null) {
                for (CMakeTarget eachTarget : this.previousModel.getTargets()) {
                    for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                        if (!FileUtil.filesEqual((File)eachConfig.getConfigurationAndTargetGenerationDir(), (File)targetInfo.targetDir)) continue;
                        targetInfo.sources = new THashMap(eachConfig.getSourcesMap());
                        targetInfo.perLanguageSettings = new THashMap(eachConfig.getPerLanguageSettingsMap());
                        targetInfo.productFile = eachConfig.getProductFile();
                    }
                }
            } else {
                this.loadProductPathAndLinkerInfo(targetInfo);
            }
        }

        @Nullable
        private OCLanguageKind toLanguageKind(@Nullable String langID) {
            if (langID == null) {
                return null;
            }
            switch (langID) {
                case "C": {
                    return OCLanguageKind.C;
                }
                case "CXX": {
                    return OCLanguageKind.CPP;
                }
            }
            return null;
        }

        @Contract(value="null -> null")
        private List<String> convertPerFileDefines(@Nullable String definesString) {
            if (definesString == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            Runnable append2 = () -> {
                if (current.length() > 0) {
                    result.add("-D" + current.toString().trim());
                }
            };
            int length = definesString.length();
            for (int i = 0; i < length; ++i) {
                char c = definesString.charAt(i);
                if (c == ';') {
                    append2.run();
                    current.setLength(0);
                    continue;
                }
                if (c == '\\' && i < length - 1 && definesString.charAt(i + 1) == ';') {
                    current.append(';');
                    ++i;
                    continue;
                }
                current.append(c);
            }
            append2.run();
            Collections.sort(result);
            return result;
        }

        private void loadProductPathAndLinkerInfo(PerProfileTargetInfo eachTarget) throws CMakeException {
            String relativeTargetPath;
            String canonicalTargetPath;
            String absoluteTargetPath;
            File makeIOFile = new File(eachTarget.targetDir, "build.make");
            String encoding = CMakeGenerator.this.encodingForFile(makeIOFile);
            CMakeMakeFile makeFile = new CMakeMakeFile(makeIOFile, encoding);
            String productName = null;
            boolean emulateNotFound = ourEmulateProductNotFoundForTargetAndProfile != null && ourEmulateProductNotFoundForTargetAndProfile.contains(Pair.create((Object)eachTarget.targetName, (Object)eachTarget.profileName));
            try {
                File canonicalTargetDir = eachTarget.targetDir.getCanonicalFile();
                absoluteTargetPath = eachTarget.targetDir.getPath();
                canonicalTargetPath = canonicalTargetDir.getPath();
                relativeTargetPath = this.getRelativePath(eachTarget.generatedDir.getCanonicalFile(), canonicalTargetDir);
            }
            catch (IOException e) {
                throw new CMakeException(e);
            }
            boolean isNMake = eachTarget.generatorType == CMakeGeneratorType.NMAKE;
            Function<String, String> escapeSpaces = s -> {
                if (!isNMake) {
                    return StringUtil.escapeChar((String)s, (char)' ');
                }
                if (s.indexOf(32) == -1) {
                    return s;
                }
                return '\"' + StringUtil.escapeChar((String)s, (char)'\"') + '\"';
            };
            Function<String, String> unescapeSpaces = s -> {
                if (!isNMake) {
                    return StringUtil.unescapeChar((String)s, (char)' ');
                }
                if (s.startsWith("\"")) {
                    return StringUtil.unescapeChar((String)StringUtil.unquoteString((String)s), (char)'\"');
                }
                return s;
            };
            Function<String, String> convertSeparators = s -> isNMake ? FileUtil.toSystemDependentName((String)s) : FileUtil.toSystemIndependentName((String)s);
            LinkedHashSet<String> keys = new LinkedHashSet<String>(Arrays.asList(escapeSpaces.apply(convertSeparators.apply(relativeTargetPath + "/build")), escapeSpaces.apply(convertSeparators.apply(absoluteTargetPath + "/build")), escapeSpaces.apply(convertSeparators.apply(canonicalTargetPath + "/build")), escapeSpaces.apply(CMakeGenerator.toEnvPath(eachTarget.environment, absoluteTargetPath + "/build")), escapeSpaces.apply(CMakeGenerator.toEnvPath(eachTarget.environment, canonicalTargetPath + "/build"))));
            if (!emulateNotFound) {
                String each;
                Iterator iterator = keys.iterator();
                while (iterator.hasNext() && (productName = makeFile.getRuleDependency(each = (String)iterator.next())) == null) {
                }
            }
            if (productName != null) {
                productName = unescapeSpaces.apply(productName);
                eachTarget.productFile = CMakeGenerator.toLocalFile(eachTarget.environment, eachTarget.generatedDir, productName);
            } else {
                CPPLog.LOG.debug("Unable to determine product file path:\nGenerated dir: " + eachTarget.generatedDir + "\nTarget dir: " + eachTarget.targetDir + "\nTried keys: \n" + StringUtil.join(keys, (String)"\n") + "\nEncoding: " + encoding + "\nMakefile keys: \n" + StringUtil.join(makeFile.getRules(), (String)"\n"));
                this.parameters.listener.message(new CMakeMessage(CMakeMessage.MessageLevel.WARNING, eachTarget.cmakeListsFile, null, CPPBundle.message("cmake.unknownTargetProductPath", eachTarget.targetName)));
            }
            if (eachTarget.generatorType == CMakeGeneratorType.NMAKE) {
                if (eachTarget.productFile != null) {
                    String productFileName = eachTarget.productFile.getName();
                    CMakeMakeFile.Rule linkerRule = (CMakeMakeFile.Rule)ContainerUtil.find(makeFile.getRules(), it -> FileUtil.namesEqual((String)productFileName, (String)PathUtil.getFileName((String)it.getTarget())) && it.getRecipe().contains("link.exe") && it.getRecipe().contains("@<<"));
                    if (linkerRule != null) {
                        int from = linkerRule.getRecipe().indexOf("@<<") + 3;
                        int to = linkerRule.getRecipe().indexOf("<<", from);
                        if (from != -1 && to != -1) {
                            eachTarget.linkerFlags = CidrSwitchBuilder.parseArgs(linkerRule.getRecipe().substring(from, to), CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE);
                        }
                    }
                }
            } else {
                File linkerFile = new File(eachTarget.targetDir, eachTarget.generatorType == CMakeGeneratorType.MINGW ? "linklibs.rsp" : "link.txt");
                if (linkerFile.exists()) {
                    try {
                        eachTarget.linkerFlags = CidrSwitchBuilder.parseArgs(FileUtilRt.loadFile((File)linkerFile, (String)CMakeGenerator.this.encodingForFile(linkerFile)), CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        @NotNull
        private List<PerProfileTargetInfo> loadTargetInfos(@NotNull CMakeCacheFile cache) {
            if (cache == null) {
                ProfileGenerationResult.$$$reportNull$$$0(10);
            }
            Map targets = CMakeGenerator.createOrderedTargetKeysMap();
            this.processTargetDirectories(this.parameters.generationDir, this.parameters.listener, (Processor<File>)((Processor)targetDir -> {
                File cmakeFiles;
                if (cache == null) {
                    ProfileGenerationResult.$$$reportNull$$$0(15);
                }
                for (cmakeFiles = targetDir.getParentFile(); cmakeFiles != null && !FileUtil.namesEqual((String)cmakeFiles.getName(), (String)CMakeGenerator.CMAKE_FILES_FOLDER); cmakeFiles = cmakeFiles.getParentFile()) {
                }
                CPPLog.LOG.assertTrue(cmakeFiles != null, (Object)("Unexpected path to targetDir: " + targetDir));
                File buildWorkingDir = cmakeFiles.getParentFile();
                CPPLog.LOG.assertTrue(new File(buildWorkingDir, "Makefile").exists(), (Object)("No Makefile in working dir: " + buildWorkingDir));
                File cmakeListsFile = CMakeGenerator.getCMakeListsFile(CMakeGenerator.this.myProjectDir);
                try {
                    List cmake_install = FileUtil.loadLines((File)new File(buildWorkingDir, "cmake_install.cmake"));
                    for (String eachLine : cmake_install) {
                        if (!eachLine.startsWith("# Install script for directory:")) continue;
                        cmakeListsFile = CMakeGenerator.getCMakeListsFile(CMakeGenerator.toLocalFile(this.parameters.environment, StringUtil.trimStart((String)eachLine, (String)"# Install script for directory:").trim()));
                    }
                }
                catch (IOException e) {
                    CPPLog.LOG.error("Cannot read cmake directory from " + buildWorkingDir, (Throwable)e);
                }
                String relativeTargetPath = FileUtil.getRelativePath((File)cmakeFiles, (File)targetDir);
                CPPLog.LOG.assertTrue(relativeTargetPath != null);
                File relativeTarget = new File(relativeTargetPath);
                String targetName = new File(relativeTarget.getParentFile(), FileUtil.getNameWithoutExtension((File)relativeTarget)).getPath();
                targetName = FileUtil.toSystemIndependentName((String)targetName);
                PerProfileTargetInfo targetInfo = new PerProfileTargetInfo(this.parameters.environment, cmakeListsFile, this.parameters.generationDir, cache, cache.getGeneratorType(), (File)targetDir, targetName, this.parameters.profileName, buildWorkingDir);
                targets.put(targetInfo.targetName, targetInfo);
                return true;
            }));
            ArrayList<PerProfileTargetInfo> list = new ArrayList<PerProfileTargetInfo>(targets.values());
            list.sort(new PerTargetInfoComparator());
            ArrayList<PerProfileTargetInfo> arrayList = list;
            if (arrayList == null) {
                ProfileGenerationResult.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private boolean processTargetDirectories(@NotNull File configGenerationDir, @NotNull CMakeListener listener2, @NotNull Processor<File> processor2) {
            File targetsListFile;
            if (configGenerationDir == null) {
                ProfileGenerationResult.$$$reportNull$$$0(12);
            }
            if (listener2 == null) {
                ProfileGenerationResult.$$$reportNull$$$0(13);
            }
            if (processor2 == null) {
                ProfileGenerationResult.$$$reportNull$$$0(14);
            }
            if ((targetsListFile = new File(configGenerationDir, "CMakeFiles/TargetDirectories.txt")).exists() || !this.hasGenerationError) {
                try {
                    for (String each : FileUtil.loadLines((File)targetsListFile, (String)CMakeGenerator.this.encodingForFile(targetsListFile))) {
                        File targetDir = CMakeGenerator.toLocalFile(this.parameters.environment, each);
                        if (!targetDir.exists() || processor2.process((Object)targetDir)) continue;
                        return false;
                    }
                }
                catch (IOException e) {
                    listener2.message(CMakeMessage.fromException(CMakeException.cannotReadFile(targetsListFile, e), null));
                }
            }
            return true;
        }

        @Nullable
        private String getRelativePath(File base, File subFile) {
            String result = FileUtil.getRelativePath((File)base, (File)subFile);
            if (result == null) {
                CPPLog.LOG.error("Cannot convert to relative path:\n\tbase=" + base + "\n\tpath=" + subFile + "\n\nIMPORTANT! If you see this problem, we kindly ask you to submit an issue at our tracker\n(https://youtrack.jetbrains.com/issues/CPP) and provide the details, ideally with a sample project.\nIt will help us to track down and fix this problem.\n\n");
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmakeDependencyFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headerAndResourceFiles";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generatedDir";
                    break;
                }
                case 5: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resources";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cacheFile";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetInfo";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$ProfileGenerationResult";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configGenerationDir";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$ProfileGenerationResult";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadTargetInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doGenerate";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadDependenciesFile";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "loadConfigResources";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "loadCodeBlocksProject";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "loadPerConfigurationTargetInfo";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "loadTargetInfos";
                    break;
                }
                case 11: {
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "processTargetDirectories";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$loadTargetInfos$6";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Parameters {
        public final int profileId;
        @NotNull
        public final String profileName;
        @NotNull
        public final String buildType;
        @NotNull
        public final File generationDir;
        @NotNull
        public final List<String> additionalOptions;
        public final boolean passSystemEnvironment;
        @NotNull
        public final Map<String, String> additionalEnvironment;
        @NotNull
        public final CMakeListener listener;
        @NotNull
        public final CMakeEnvironment environment;

        public Parameters(int profileId, @NotNull String profileName, @NotNull String buildType, @NotNull File outputDir, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, Map<String, String> additionalEnvironment, @NotNull CMakeListener listener2, @NotNull CMakeEnvironment environment) {
            if (profileName == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (buildType == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            if (outputDir == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            if (additionalOptions == null) {
                Parameters.$$$reportNull$$$0(3);
            }
            if (listener2 == null) {
                Parameters.$$$reportNull$$$0(4);
            }
            if (environment == null) {
                Parameters.$$$reportNull$$$0(5);
            }
            this.profileId = profileId;
            this.profileName = profileName;
            this.buildType = buildType;
            this.generationDir = new File(FileUtil.toCanonicalPath((String)outputDir.getPath()));
            this.additionalOptions = Collections.unmodifiableList(additionalOptions);
            this.passSystemEnvironment = passSystemEnvironment;
            this.additionalEnvironment = Collections.unmodifiableMap(additionalEnvironment);
            this.listener = listener2;
            this.environment = environment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profileName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "additionalOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "environment";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

