/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeModel
implements Serializable {
    public static final String CMAKE_LISTS_FILE = "CMakeLists.txt";
    public static final String CMAKE_FILES_EXTENSION = ".cmake";
    public static final String CMAKE_CACHE_FILE = "CMakeCache.txt";
    public static final String BUILD_TYPE_DEFAULT = "Default";
    public static final List<String> DEFAULT_BUILD_TYPES = ContainerUtil.immutableList((Object[])new String[]{"Default", "Debug", "Release", "RelWithDebInfo", "MinSizeRel"});
    public static final int SERIALIZATION_VERSION = 108;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final Set<File> myCMakeDependencyFiles;
    @NotNull
    private final Set<File> myHeaderAndResourceFiles;
    @NotNull
    private final List<CMakeTarget> myTargets;
    @NotNull
    private final Map<String, OCLanguageKind> myFileExtensions;
    @NotNull
    private final List<CMakeModelConfigurationData> myConfigurationData;

    public CMakeModel(@NotNull String projectName, @NotNull Set<File> cmakeDependencyFiles, @NotNull Set<File> headerAndResourceFiles, @NotNull List<CMakeTarget> targets, @NotNull Map<String, OCLanguageKind> fileExtensions, @NotNull List<CMakeModelConfigurationData> configurationData) {
        if (projectName == null) {
            CMakeModel.$$$reportNull$$$0(0);
        }
        if (cmakeDependencyFiles == null) {
            CMakeModel.$$$reportNull$$$0(1);
        }
        if (headerAndResourceFiles == null) {
            CMakeModel.$$$reportNull$$$0(2);
        }
        if (targets == null) {
            CMakeModel.$$$reportNull$$$0(3);
        }
        if (fileExtensions == null) {
            CMakeModel.$$$reportNull$$$0(4);
        }
        if (configurationData == null) {
            CMakeModel.$$$reportNull$$$0(5);
        }
        this.myProjectName = projectName;
        this.myCMakeDependencyFiles = Collections.unmodifiableSet(cmakeDependencyFiles);
        this.myHeaderAndResourceFiles = Collections.unmodifiableSet(headerAndResourceFiles);
        this.myTargets = Collections.unmodifiableList(targets);
        this.myFileExtensions = Collections.unmodifiableMap(fileExtensions);
        this.myConfigurationData = Collections.unmodifiableList(configurationData);
    }

    @Nullable
    public static CMakeModel load(@NotNull ObjectInputStream out) throws IOException {
        if (out == null) {
            CMakeModel.$$$reportNull$$$0(6);
        }
        try {
            if (out.readInt() != 108) {
                return null;
            }
            Object object = out.readObject();
            return object instanceof CMakeModel ? (CMakeModel)object : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void save(@NotNull ObjectOutputStream out) throws IOException {
        if (out == null) {
            CMakeModel.$$$reportNull$$$0(7);
        }
        out.writeInt(108);
        out.writeObject(this);
    }

    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            CMakeModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Set<File> getCMakeDependencyFiles() {
        Set<File> set = this.myCMakeDependencyFiles;
        if (set == null) {
            CMakeModel.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Set<File> getHeaderAndResourceFiles() {
        Set<File> set = this.myHeaderAndResourceFiles;
        if (set == null) {
            CMakeModel.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public List<CMakeTarget> getTargets() {
        List<CMakeTarget> list = this.myTargets;
        if (list == null) {
            CMakeModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public Map<String, OCLanguageKind> getFileExtensions() {
        Map<String, OCLanguageKind> map2 = this.myFileExtensions;
        if (map2 == null) {
            CMakeModel.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @NotNull
    public List<CMakeModelConfigurationData> getConfigurationData() {
        List<CMakeModelConfigurationData> list = this.myConfigurationData;
        if (list == null) {
            CMakeModel.$$$reportNull$$$0(13);
        }
        return list;
    }

    public String toString() {
        return this.myProjectName + " [" + this.myTargets.size() + " targets]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeDependencyFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerAndResourceFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationData";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDependencyFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderAndResourceFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

