/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CMakeSettingsFileParser<T> {
    @NotNull
    private final String mySeparator;

    protected CMakeSettingsFileParser() {
        this("=");
    }

    protected CMakeSettingsFileParser(@NotNull String separator) {
        if (separator == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(0);
        }
        this.mySeparator = separator;
    }

    @NotNull
    public LinkedMultiMap<String, T> parse(@NotNull File file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(2);
        }
        LinkedMultiMap<String, T> linkedMultiMap = this.parse(CMakeSettingsFileParser.loadText(file, encoding));
        if (linkedMultiMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(3);
        }
        return linkedMultiMap;
    }

    @NotNull
    public LinkedHashMap<String, T> parseUnique(@NotNull File file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(4);
        }
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(5);
        }
        LinkedHashMap<String, T> linkedHashMap = this.toUniqueMap(this.parse(file, encoding));
        if (linkedHashMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(6);
        }
        return linkedHashMap;
    }

    @NotNull
    protected static String loadText(File file, @NotNull String encoding) throws CMakeException {
        String string;
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(7);
        }
        try {
            string = FileUtil.loadFile((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw CMakeException.cannotReadFile(file, e);
        }
        if (string == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public LinkedMultiMap<String, T> parse(@NotNull String text) {
        if (text == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(9);
        }
        LinkedMultiMap linkedMultiMap = (LinkedMultiMap)this.parse((String)text, null).second;
        if (linkedMultiMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(10);
        }
        return linkedMultiMap;
    }

    @NotNull
    public LinkedHashMap<String, T> parseUnique(@NotNull String text) {
        if (text == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(11);
        }
        LinkedHashMap<String, T> linkedHashMap = this.toUniqueMap(this.parse(text));
        if (linkedHashMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(12);
        }
        return linkedHashMap;
    }

    protected LinkedHashMap<String, T> toUniqueMap(LinkedMultiMap<String, T> multi) {
        LinkedHashMap unique = new LinkedHashMap(this.getEqualityPolicy());
        for (Map.Entry each : multi.entrySet()) {
            Object value = ContainerUtil.getFirstItem((Collection)((Collection)each.getValue()));
            assert (value != null);
            unique.put(each.getKey(), value);
        }
        return unique;
    }

    @NotNull
    protected Pair<String, LinkedMultiMap<String, T>> parse(@NotNull String text, @Nullable Function<Pair<String, T>, Pair<String, T>> transformer) {
        if (text == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(13);
        }
        LinkedMultiMap vars = new LinkedMultiMap<String, T>(){

            protected EqualityPolicy<String> getEqualityPolicy() {
                return CMakeSettingsFileParser.this.getEqualityPolicy();
            }
        };
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(StringUtil.splitByLinesKeepSeparators((String)text)));
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            String eachLine = StringUtil.trimLeading((String)((String)lines.get(i)));
            int newLine = StringUtil.indexOfAny((String)(eachLine = StringUtil.trimLeading((String)this.convertLineAndKeepEOLs(eachLine))), (String)"\r\n");
            String trimmed = newLine == -1 ? eachLine : eachLine.substring(0, newLine);
            String lineSeparators = newLine == -1 ? "" : eachLine.substring(newLine);
            eachLine = trimmed;
            if (eachLine.startsWith("#")) continue;
            this.preprocess(eachLine);
            int eq = eachLine.indexOf(this.mySeparator);
            if (eq < 0) continue;
            Trinity<String, T, Integer> result = this.parseVariable(eachLine.substring(0, eq).trim(), eachLine.substring(eq + 1), i == size - 1 ? Collections.emptyList() : lines.subList(i + 1, size));
            String name2 = (String)result.first;
            Object var = result.second;
            if (transformer != null) {
                Pair transformedLineAndVar = (Pair)transformer.fun((Object)Pair.create((Object)eachLine, (Object)var));
                lines.set(i, (String)transformedLineAndVar.first + lineSeparators);
                var = transformedLineAndVar.second;
            }
            vars.putValue((Object)name2, var);
            i += ((Integer)result.third).intValue();
        }
        this.cleanup();
        Pair pair2 = Pair.create((Object)(transformer == null ? text : StringUtil.join(lines, (String)"")), (Object)vars);
        if (pair2 == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(14);
        }
        return pair2;
    }

    @NotNull
    private EqualityPolicy<String> getEqualityPolicy() {
        final TObjectHashingStrategy<String> strategy = this.getHashingStrategy();
        EqualityPolicy<String> equalityPolicy = new EqualityPolicy<String>(){

            public int getHashCode(String value) {
                return strategy.computeHashCode((Object)value);
            }

            public boolean isEqual(String val1, String val2) {
                return strategy.equals((Object)val1, (Object)val2);
            }
        };
        if (equalityPolicy == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(15);
        }
        return equalityPolicy;
    }

    @NotNull
    protected TObjectHashingStrategy<String> getHashingStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(16);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    protected String convertLineAndKeepEOLs(@NotNull String lineWithEOLs) {
        if (lineWithEOLs == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(17);
        }
        String string = lineWithEOLs;
        if (string == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(18);
        }
        return string;
    }

    protected void preprocess(@NotNull String line) {
        if (line == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(19);
        }
    }

    @NotNull
    protected abstract Pair<String, T> parseVariable(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected Trinity<String, T, Integer> parseVariable(@NotNull String beforeEqual, @NotNull String afterEqual, List<String> remainingLines) {
        if (beforeEqual == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(20);
        }
        if (afterEqual == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(21);
        }
        Pair<String, T> result = this.parseVariable(beforeEqual, afterEqual);
        Trinity trinity = Trinity.create((Object)result.first, (Object)result.second, (Object)0);
        if (trinity == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(22);
        }
        return trinity;
    }

    protected void cleanup() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeSettingsFileParser";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineWithEOLs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeEqual";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeSettingsFileParser";
                break;
            }
            case 3: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUnique";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityPolicy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashingStrategy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineAndKeepEOLs";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseUnique";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertLineAndKeepEOLs";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

