/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.icons.AllIcons;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import icons.CLionIcons;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeTarget
implements Serializable,
CidrBuildTarget<CMakeConfiguration> {
    public static final Icon EXECUTABLE_ICON = CLionIcons.CMakeTarget_Executable;
    public static final Icon LIBRARY_ICON = AllIcons.Modules.Library;
    public static final Icon UTILITY_ICON = CLionIcons.CMakeTarget_Utility;
    public static final Icon META_TARGET_ICON = CLionIcons.CMakeTarget_Meta;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myName;
    @NotNull
    private final List<CMakeConfiguration> myConfigurations;

    public CMakeTarget(@NotNull String projectName, @NotNull String name2, @NotNull List<CMakeConfiguration> configurations) {
        if (projectName == null) {
            CMakeTarget.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            CMakeTarget.$$$reportNull$$$0(1);
        }
        if (configurations == null) {
            CMakeTarget.$$$reportNull$$$0(2);
        }
        this.myProjectName = projectName;
        this.myName = name2;
        this.myConfigurations = Collections.unmodifiableList(configurations);
    }

    @Override
    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            CMakeTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        CMakeConfiguration target = (CMakeConfiguration)ContainerUtil.getFirstItem(this.getBuildConfigurations());
        if (target == null) {
            return null;
        }
        switch (target.getTargetType()) {
            case EXECUTABLE: {
                return EXECUTABLE_ICON;
            }
            case SHARED_LIBRARY: 
            case STATIC_LIBRARY: {
                return LIBRARY_ICON;
            }
            case UTILITY: {
                return UTILITY_ICON;
            }
        }
        return null;
    }

    @Override
    public boolean isExecutable() {
        return ContainerUtil.exists(this.getBuildConfigurations(), configuration -> configuration.getTargetType() == CMakeConfiguration.TargetType.EXECUTABLE);
    }

    public boolean projectNameEquals(@Nullable String name2) {
        return this.myProjectName.equalsIgnoreCase(name2);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CMakeTarget.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public List<CMakeConfiguration> getBuildConfigurations() {
        List<CMakeConfiguration> list = this.myConfigurations;
        if (list == null) {
            CMakeTarget.$$$reportNull$$$0(5);
        }
        return list;
    }

    public String toString() {
        return this.myName + " [" + this.myConfigurations.size() + " configs]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

