/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CMake;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionProjectWizardUtils {
    public static void reformatProjectFiles(@NotNull Project project2, @NotNull VirtualFile cMakeFile, boolean reformatAsCppFiles, VirtualFile ... files) {
        if (project2 == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(0);
        }
        if (cMakeFile == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(1);
        }
        WriteAction.run(() -> {
            if (project2 == null) {
                CLionProjectWizardUtils.$$$reportNull$$$0(7);
            }
            if (cMakeFile == null) {
                CLionProjectWizardUtils.$$$reportNull$$$0(8);
            }
            if (project2.isDisposed()) {
                return;
            }
            StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
                if (project2 == null) {
                    CLionProjectWizardUtils.$$$reportNull$$$0(9);
                }
                if (cMakeFile == null) {
                    CLionProjectWizardUtils.$$$reportNull$$$0(10);
                }
                WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                    if (project2 == null) {
                        CLionProjectWizardUtils.$$$reportNull$$$0(11);
                    }
                    if (cMakeFile == null) {
                        CLionProjectWizardUtils.$$$reportNull$$$0(12);
                    }
                    CLionProjectWizardUtils.reformatFile(project2, cMakeFile, false);
                    Arrays.asList(files).forEach(vf -> {
                        if (project2 == null) {
                            CLionProjectWizardUtils.$$$reportNull$$$0(13);
                        }
                        CLionProjectWizardUtils.reformatFile(project2, vf, reformatAsCppFiles);
                    });
                });
            }));
        });
    }

    public static void refreshProjectDir(VirtualFile projectDir) {
        CLionProjectWizardUtils.refreshProjectDir(projectDir, false);
    }

    public static void refreshProjectDir(VirtualFile projectDir, boolean recursive) {
        CPPLog.LOG.assertTrue(projectDir != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)recursive, (boolean)true, (VirtualFile[])new VirtualFile[]{projectDir});
    }

    static void reformatFile(@NotNull Project project2, @NotNull VirtualFile fileToFormat, boolean asCpp) {
        if (project2 == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(2);
        }
        if (fileToFormat == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(3);
        }
        PsiFile file = PsiManager.getInstance((Project)project2).findFile(fileToFormat);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        if (asCpp) {
            FileDocumentManager manager = FileDocumentManager.getInstance();
            Document document = manager.getDocument(fileToFormat);
            CPPLog.LOG.assertTrue(document != null);
            String oldText = document.getText();
            OCCodeFragment fragment = OCElementFactory.codeFragment(oldText, project2, null, OCTokenTypes.OC_FILE, false, false, OCLanguageKind.CPP);
            fragment.putUserData(OCFormattingModelBuilder.ALWAYS_CREATE_FULL_MODEL, true);
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)fragment);
            String newText = fragment.getText();
            document.setText((CharSequence)newText);
            manager.saveDocument(document);
        } else if (file != null) {
            codeStyleManager.reformatText(file, 0, file.getTextLength());
        }
    }

    @NotNull
    public static String getCMakeMinimumRequiredLine(String versionString) {
        String cmake_minimum_required;
        Version version;
        Version version2 = version = versionString == null ? null : Version.parseVersion((String)versionString);
        if (version != null) {
            String versionToSet = version.lessThan(Integer.valueOf(3)) ? "2.8.4" : version.major + "." + version.minor;
            cmake_minimum_required = "cmake_minimum_required(VERSION " + versionToSet + ")\n";
        } else {
            cmake_minimum_required = "# cmake_minimum_required(VERSION <specify CMake version here>)\n";
        }
        String string = cmake_minimum_required;
        if (string == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getCMakeFileHeader(@NotNull String projectName, @Nullable CMakeProjectSettings settings) {
        if (projectName == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(5);
        }
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        String languageVersionLineForCMake = "";
        if (settings != null) {
            languageVersionLineForCMake = settings.getLanguageVersionLineForCMake();
        }
        String enabledLanguages = settings == null ? "" : settings.getEnabledProjectLanguages();
        String version = CMake.readCMakeVersion(toolchain);
        String string = CLionProjectWizardUtils.getCMakeMinimumRequiredLine(version) + "project(" + projectName + (StringUtil.isEmptyOrSpaces((String)enabledLanguages) ? "" : " " + enabledLanguages) + ")\n\n" + languageVersionLineForCMake;
        if (string == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cMakeFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToFormat";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeMinimumRequiredLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFileHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformatProjectFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformatFile";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFileHeader";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reformatProjectFiles$3";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

