/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CMakeProjectStepAdapter;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeCPPProjectSettings;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeCProjectSettings;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cidr.cpp.toolchains.CMake;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportCMakeProjectStepAdapter
extends CMakeProjectStepAdapter {
    private static final String DIMENSION_KEY = "ImportCMakeProjectWizard";
    public static final String INCLUDE_DIRECTORY_NAME = "include";
    private final FileChooserDescriptor myIconProvider = new OpenProjectFileChooserDescriptor(true);
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JPanel myProgressPanel = new JPanel(new GridBagLayout());
    private final JProgressBar myProgressBar = new JProgressBar();
    private final ProgressIndicatorBase myProgressIndicator = new MyProgressIndicator();
    private final JLabel myTreeLabel = new JLabel("Select project files:");
    private CheckboxTree myTree;
    private CheckboxTree myIncludeDirTree;
    private VirtualFile myImportDir;
    private boolean myScanFinish;

    @Override
    protected void init() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultWeightX(1.0);
        this.myProgressPanel.add((Component)new JLabel("Scanning folders  "), gbc.nextLine().next().weightx(0.0));
        this.myProgressPanel.add((Component)this.myProgressBar, gbc.next());
        this.myProgressPanel.setVisible(false);
        gbc.nextLine().insets.bottom = 5;
        topPanel.add((Component)this.myProgressPanel, gbc);
        gbc.reset();
        topPanel.add((Component)this.myTreeLabel, gbc.nextLine());
        this.myTree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)new MyTreeCellRenderer(true), new CheckedTreeNode(), new CheckboxTreeBase.CheckPolicy(true, true, true, false));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.getEmptyText().setText("Loading...");
        topPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), gbc.nextLine().weighty(1.0).fillCell());
        this.myIncludeDirTree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)new MyTreeCellRenderer(false), new CheckedTreeNode(), new CheckboxTreeBase.CheckPolicy(false, false, false, false));
        this.myIncludeDirTree.getSelectionModel().setSelectionMode(4);
        this.myIncludeDirTree.getEmptyText().setText("Loading...");
        this.myIncludeDirTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myIncludeDirTree), "Center");
        this.myPanel.add((Component)new ExpandedPanel("User Include Directories", topPanel, bottomPanel).getComponent(), "Center");
        Dimension size = DimensionService.getInstance().getSize(DIMENSION_KEY);
        this.myPanel.setPreferredSize((Dimension)(size == null ? JBUI.size((int)640, (int)480) : size));
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        this.myProgressIndicator.cancel();
        DimensionService.getInstance().setSize(DIMENSION_KEY, this.myPanel.getSize());
    }

    @Override
    @NotNull
    public Boolean validate() {
        Boolean bl = this.myScanFinish && ImportCMakeProjectStepAdapter.areFilesChecked(this.getRootNode());
        if (bl == null) {
            ImportCMakeProjectStepAdapter.$$$reportNull$$$0(0);
        }
        return bl;
    }

    public void prepareDirectories(@NotNull VirtualFile importDir) {
        if (importDir == null) {
            ImportCMakeProjectStepAdapter.$$$reportNull$$$0(1);
        }
        this.myImportDir = importDir;
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            CheckedTreeNode root = this.createRootNode();
            if (this.myProgressIndicator.isCanceled()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> this.updateTreeComponents(root));
        }, (ProgressIndicator)this.myProgressIndicator));
    }

    public void testPrepareDirectories(@NotNull VirtualFile importDir) {
        if (importDir == null) {
            ImportCMakeProjectStepAdapter.$$$reportNull$$$0(2);
        }
        this.myImportDir = importDir;
        this.updateTreeComponents(this.createRootNode());
    }

    public CheckedTreeNode getRootNode() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    public CheckedTreeNode getIncludesRootNode() {
        return (CheckedTreeNode)this.myIncludeDirTree.getModel().getRoot();
    }

    public void createProject() throws IOException {
        String localPath;
        String projectName = FileUtil.sanitizeFileName((String)this.myImportDir.getName());
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        String version = CMake.readCMakeVersion(toolchain);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        ImportCMakeProjectStepAdapter.getCheckedFiles(this.getRootNode(), files);
        ImportCMakeProjectStepAdapter.removeSymLinkDuplicates(files);
        CPPLog.LOG.assertTrue(!files.isEmpty());
        boolean isC = files.stream().noneMatch(file -> OCFileTypeHelpers.isCppFile(file.getName()));
        StringBuilder makeContent = new StringBuilder();
        CMakeProjectSettings settings = isC ? new CMakeCProjectSettings() : new CMakeCPPProjectSettings();
        settings.setLanguageVersion("11");
        makeContent.append(CLionProjectWizardUtils.getCMakeFileHeader(projectName, settings));
        makeContent.append('\n');
        ArrayList<VirtualFile> includes = new ArrayList<VirtualFile>();
        ImportCMakeProjectStepAdapter.getCheckedNodes(this.getIncludesRootNode(), includes);
        boolean includesAdded = false;
        for (VirtualFile include : includes) {
            localPath = VfsUtilCore.getRelativePath((VirtualFile)include, (VirtualFile)this.myImportDir);
            if (localPath == null) {
                CPPLog.LOG.error("getRelativePath(" + include.getPresentableUrl() + ", " + this.myImportDir.getPresentableUrl() + ") is null");
                continue;
            }
            if (localPath.length() == 0) {
                localPath = ".";
            }
            makeContent.append("include_directories(").append(CMakeArgumentManipulator.getCMakeLiteralFromValue(localPath)).append(")\n");
            includesAdded = true;
        }
        if (includesAdded) {
            makeContent.append("\n");
        }
        makeContent.append("add_executable(").append(projectName).append("\n");
        for (VirtualFile file2 : files) {
            localPath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.myImportDir);
            if (localPath == null) {
                CPPLog.LOG.error("getRelativePath(" + file2.getPresentableUrl() + ", " + this.myImportDir.getPresentableUrl() + ") is null");
                continue;
            }
            makeContent.append("    ").append(CMakeArgumentManipulator.getCMakeLiteralFromValue(localPath)).append("\n");
        }
        makeContent.setLength(makeContent.length() - 1);
        makeContent.append(")\n");
        File makeFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.myImportDir), "CMakeLists.txt");
        byte[] makeBytes = makeContent.toString().getBytes(CPPEnvironment.getCharset());
        FileUtil.writeToFile((File)makeFile, (byte[])makeBytes);
    }

    private CheckedTreeNode createRootNode() {
        ApplicationManager.getApplication().invokeAndWait(() -> CLionProjectWizardUtils.refreshProjectDir(this.myImportDir, true), ModalityState.stateForComponent((Component)this.myPanel));
        CheckedTreeNode root = new CheckedTreeNode((Object)this.myImportDir);
        VirtualFileVisitor<CheckedTreeNode> visitor = new VirtualFileVisitor<CheckedTreeNode>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ImportCMakeProjectStepAdapter.this.myProgressIndicator.isCanceled()) {
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)ImportCMakeProjectStepAdapter.this.myImportDir);
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (ImportCMakeProjectStepAdapter.this.myImportDir.equals(file)) {
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                if (FileTypeManager.getInstance().isFileIgnored(file) || FileElement.isFileHidden((VirtualFile)file)) {
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)file);
                    if (result == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return result;
                }
                if (file.isDirectory() && file.getName().equals("CMakeFiles")) {
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)file);
                    if (result == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                CheckedTreeNode node = new CheckedTreeNode((Object)file);
                if (!file.isDirectory()) {
                    String fileName = file.getName();
                    node.setChecked(file.getExtension() != null && (OCFileTypeHelpers.isSourceFile(fileName) || OCFileTypeHelpers.isHeaderFile(fileName)));
                }
                ((CheckedTreeNode)this.getCurrentValue()).add((MutableTreeNode)node);
                this.setValueForChildren(node);
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(5);
                }
                return result;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(6);
                }
                Object[] children = file.getChildren();
                Arrays.sort(children, (file1, file2) -> {
                    if (file1.isDirectory() != file2.isDirectory()) {
                        return file1.isDirectory() ? -1 : 1;
                    }
                    return file1.getName().compareToIgnoreCase(file2.getName());
                });
                return ContainerUtil.newArrayList((Object[])children);
            }

            public void afterChildrenVisited(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!file.isDirectory()) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)this.getCurrentValue();
                int count = node.getChildCount();
                boolean checked = false;
                for (int i = 0; i < count; ++i) {
                    CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
                    if (!childNode.isChecked()) continue;
                    checked = true;
                    break;
                }
                node.setChecked(checked);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "afterChildrenVisited";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        visitor.setValueForChildren((Object)root);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myImportDir, (VirtualFileVisitor)visitor);
        return root;
    }

    private void updateTreeComponents(CheckedTreeNode root) {
        this.myTree.setRootVisible(true);
        this.myTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        TreePath path = new TreePath(root);
        this.myTree.expandPath(path);
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            CheckedTreeNode childNode = (CheckedTreeNode)children.nextElement();
            if (!childNode.isChecked()) continue;
            this.myTree.expandPath(path.pathByAddingChild(childNode));
        }
        this.updateIncludes();
        this.myScanFinish = true;
        this.myValidateCallback.run();
        this.myTree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent e) {
                ImportCMakeProjectStepAdapter.this.updateIncludes();
                ImportCMakeProjectStepAdapter.this.myValidateCallback.run();
            }
        });
    }

    private void updateIncludes() {
        CheckedTreeNode rootNode = this.getRootNode();
        if (rootNode.isChecked()) {
            Object oldIncludeRoot = this.myIncludeDirTree.getModel().getRoot();
            if (oldIncludeRoot instanceof CheckedTreeNode) {
                ImportCMakeProjectStepAdapter.synchronizeNodes(rootNode, (CheckedTreeNode)oldIncludeRoot);
                ImportCMakeProjectStepAdapter.checkHeaderDirectories(rootNode, (CheckedTreeNode)oldIncludeRoot);
                ((DefaultTreeModel)this.myIncludeDirTree.getModel()).reload();
            } else {
                CheckedTreeNode includeRootNode = new CheckedTreeNode((Object)this.myImportDir);
                ImportCMakeProjectStepAdapter.convertNodes(rootNode, includeRootNode);
                ImportCMakeProjectStepAdapter.checkHeaderDirectories(rootNode, includeRootNode);
                this.myIncludeDirTree.setRootVisible(true);
                this.myIncludeDirTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)includeRootNode));
            }
            this.expandIncludeDirTree();
        } else {
            this.myIncludeDirTree.setRootVisible(false);
            this.myIncludeDirTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
    }

    private static void convertNodes(CheckedTreeNode node, CheckedTreeNode includeNode) {
        includeNode.setUserObject(node.getUserObject());
        includeNode.setChecked(false);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
            if (!childNode.isChecked() || !((VirtualFile)childNode.getUserObject()).isDirectory()) continue;
            CheckedTreeNode includeChildNode = new CheckedTreeNode();
            includeNode.add((MutableTreeNode)includeChildNode);
            ImportCMakeProjectStepAdapter.convertNodes(childNode, includeChildNode);
        }
    }

    private static void synchronizeNodes(CheckedTreeNode node, CheckedTreeNode includeNode) {
        int count = node.getChildCount();
        CheckedTreeNode lastInsertedIncludeNode = null;
        for (int i = count - 1; i >= 0; --i) {
            CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
            VirtualFile file = (VirtualFile)childNode.getUserObject();
            if (!file.isDirectory()) continue;
            CheckedTreeNode includeChildNode = ImportCMakeProjectStepAdapter.findNodeByUserData(file, includeNode);
            if (childNode.isChecked()) {
                if (includeChildNode == null) {
                    includeChildNode = new CheckedTreeNode();
                    if (lastInsertedIncludeNode == null) {
                        includeNode.add((MutableTreeNode)includeChildNode);
                    } else {
                        includeNode.insert((MutableTreeNode)includeChildNode, includeNode.getIndex((TreeNode)lastInsertedIncludeNode));
                    }
                    ImportCMakeProjectStepAdapter.convertNodes(childNode, includeChildNode);
                } else {
                    ImportCMakeProjectStepAdapter.synchronizeNodes(childNode, includeChildNode);
                }
                lastInsertedIncludeNode = includeChildNode;
                continue;
            }
            if (includeChildNode == null) continue;
            includeNode.remove((MutableTreeNode)includeChildNode);
        }
    }

    private static CheckHeaderStatus checkHeaderDirectories(@NotNull CheckedTreeNode node, @Nullable CheckedTreeNode includeNode) {
        if (node == null) {
            ImportCMakeProjectStepAdapter.$$$reportNull$$$0(3);
        }
        if (!node.isChecked()) {
            return CheckHeaderStatus.IGNORE;
        }
        VirtualFile file = (VirtualFile)node.getUserObject();
        if (file.isDirectory()) {
            if (includeNode == null) {
                return CheckHeaderStatus.IGNORE;
            }
            boolean shouldCheckThis = false;
            if (file.getName().equalsIgnoreCase(INCLUDE_DIRECTORY_NAME)) {
                shouldCheckThis = true;
            }
            int childCount = node.getChildCount();
            ArrayList<CheckHeaderStatus> statuses = new ArrayList<CheckHeaderStatus>(childCount);
            for (int i = 0; i <= childCount - 1; ++i) {
                CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
                CheckedTreeNode childIncludeNode = ImportCMakeProjectStepAdapter.findNodeByUserData(childNode.getUserObject(), includeNode);
                statuses.add(ImportCMakeProjectStepAdapter.checkHeaderDirectories(childNode, childIncludeNode));
            }
            CheckHeaderStatus overallStatus = statuses.stream().reduce(CheckHeaderStatus.IGNORE, (status1, status2) -> status1.merge((CheckHeaderStatus)((Object)status2))).singleFileToDirectory();
            if (shouldCheckThis |= overallStatus != CheckHeaderStatus.IGNORE && (statuses.stream().anyMatch(status -> status == CheckHeaderStatus.HEADER) || statuses.stream().allMatch(status -> status == CheckHeaderStatus.IGNORE || status == CheckHeaderStatus.ALL_HEADERS))) {
                includeNode.setChecked(true);
            }
            return overallStatus;
        }
        return file.getExtension() != null && OCFileTypeHelpers.isHeaderFile(file.getName()) ? CheckHeaderStatus.HEADER : CheckHeaderStatus.NOT_HEADER;
    }

    private void expandIncludeDirTree() {
        TreeUtil.expand((JTree)this.myIncludeDirTree, (int)1);
        Object includeRoot = this.myIncludeDirTree.getModel().getRoot();
        if (!(includeRoot instanceof CheckedTreeNode)) {
            return;
        }
        this.expandIncludeDirTree((CheckedTreeNode)includeRoot, null, false);
    }

    private void expandIncludeDirTree(@NotNull CheckedTreeNode node, @Nullable TreePath pathToParent, boolean parentChecked) {
        if (node == null) {
            ImportCMakeProjectStepAdapter.$$$reportNull$$$0(4);
        }
        boolean checked = node.isChecked();
        TreePath pathToHere = pathToParent == null ? new TreePath(node) : pathToParent.pathByAddingChild(node);
        if (checked && !parentChecked) {
            this.myIncludeDirTree.makeVisible(pathToHere);
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            CheckedTreeNode child = (CheckedTreeNode)node.getChildAt(i);
            this.expandIncludeDirTree(child, pathToHere, checked);
        }
    }

    private static void removeSymLinkDuplicates(List<VirtualFile> files) {
        Iterator<VirtualFile> I = files.iterator();
        while (I.hasNext()) {
            VirtualFile target;
            VirtualFile linkFile = I.next();
            if (linkFile.is(VFileProperty.SYMLINK)) {
                ImportCMakeProjectStepAdapter.removeTarget(files, I, linkFile.getCanonicalFile());
                continue;
            }
            VirtualFile linkDir = linkFile.getParent();
            if (!linkDir.is(VFileProperty.SYMLINK) || (target = linkDir.getCanonicalFile()) == null) continue;
            ImportCMakeProjectStepAdapter.removeTarget(files, I, target.findChild(linkFile.getName()));
        }
    }

    private static void removeTarget(List<VirtualFile> files, Iterator<VirtualFile> I, VirtualFile targetFile) {
        if (targetFile != null) {
            for (VirtualFile file : files) {
                if (!targetFile.equals(file)) continue;
                I.remove();
                break;
            }
        }
    }

    private static CheckedTreeNode findNodeByUserData(Object userData, CheckedTreeNode node) {
        int count = node.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
            if (!userData.equals(childNode.getUserObject())) continue;
            return childNode;
        }
        return null;
    }

    private static void getCheckedFiles(Object object, List<VirtualFile> files) {
        CheckedTreeNode node = (CheckedTreeNode)object;
        if (!node.isChecked()) {
            return;
        }
        VirtualFile file = (VirtualFile)node.getUserObject();
        if (node.isLeaf() && !file.isDirectory()) {
            files.add(file);
            return;
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            ImportCMakeProjectStepAdapter.getCheckedFiles(node.getChildAt(i), files);
        }
    }

    private static void getCheckedNodes(Object object, List<VirtualFile> files) {
        CheckedTreeNode node = (CheckedTreeNode)object;
        VirtualFile file = (VirtualFile)node.getUserObject();
        if (node.isChecked()) {
            files.add(file);
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            ImportCMakeProjectStepAdapter.getCheckedNodes(node.getChildAt(i), files);
        }
    }

    private static boolean areFilesChecked(Object object) {
        CheckedTreeNode node = (CheckedTreeNode)object;
        if (!node.isChecked()) {
            return false;
        }
        if (node.isLeaf() && !((VirtualFile)node.getUserObject()).isDirectory()) {
            return true;
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (!ImportCMakeProjectStepAdapter.areFilesChecked(node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDir";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareDirectories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "testPrepareDirectories";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkHeaderDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandIncludeDirTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final boolean myRootFullName;

        public MyTreeCellRenderer(boolean rootFullName) {
            super(true, false);
            this.myRootFullName = rootFullName;
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (value instanceof CheckedTreeNode && (userObject = ((CheckedTreeNode)value).getUserObject()) instanceof VirtualFile) {
                VirtualFile file = (VirtualFile)userObject;
                ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                textRenderer.append(this.myRootFullName && ImportCMakeProjectStepAdapter.this.myImportDir.equals(file) ? file.getPresentableUrl() : file.getPresentableName());
                textRenderer.setIcon(ImportCMakeProjectStepAdapter.this.myIconProvider.getIcon(file));
            }
        }
    }

    private static class ExpandedPanel
    extends SplitterWithSecondHideable {
        private final RefreshablePanel myRefreshablePanel;

        public ExpandedPanel(String separatorText, JComponent firstComponent, JPanel secondComponent) {
            this(separatorText, firstComponent, secondComponent, new ExpandedListener());
        }

        private ExpandedPanel(String separatorText, JComponent firstComponent, final JPanel secondComponent, ExpandedListener listener2) {
            super(true, separatorText, firstComponent, (SplitterWithSecondHideable.OnOffListener)listener2);
            this.myRefreshablePanel = new RefreshablePanel(){

                public void refresh() {
                }

                public JPanel getPanel() {
                    return secondComponent;
                }
            };
            this.getComponent().setResizeEnabled(false);
            listener2.setExpandedPanel(this);
        }

        protected RefreshablePanel createDetails() {
            return this.myRefreshablePanel;
        }

        protected float getSplitterInitialProportion() {
            return 0.7f;
        }
    }

    private static class ExpandedListener
    implements SplitterWithSecondHideable.OnOffListener<Integer> {
        private ExpandedPanel myExpandedPanel;
        private float myPreviousProportion;

        private ExpandedListener() {
        }

        public void setExpandedPanel(ExpandedPanel expandedPanel) {
            this.myExpandedPanel = expandedPanel;
        }

        public void on(Integer height) {
            this.myExpandedPanel.getComponent().setProportion(this.myPreviousProportion > 0.0f ? this.myPreviousProportion : this.myExpandedPanel.getSplitterInitialProportion());
        }

        public void off(Integer height) {
            this.myPreviousProportion = this.myExpandedPanel.getUsedProportion();
        }
    }

    private class MyProgressIndicator
    extends ProgressIndicatorBase {
        public MyProgressIndicator() {
            this.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    super.cancel();
                    MyProgressIndicator.this.uiStop();
                }
            });
        }

        public void start() {
            super.start();
            UIUtil.invokeAndWaitIfNeeded(() -> {
                ImportCMakeProjectStepAdapter.this.myProgressBar.setIndeterminate(true);
                ImportCMakeProjectStepAdapter.this.myProgressPanel.setVisible(true);
                ImportCMakeProjectStepAdapter.this.myTreeLabel.setVisible(false);
            });
        }

        private void uiStop() {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                ImportCMakeProjectStepAdapter.this.myProgressBar.setIndeterminate(false);
                ImportCMakeProjectStepAdapter.this.myProgressPanel.setVisible(false);
                ImportCMakeProjectStepAdapter.this.myTreeLabel.setVisible(true);
            });
        }

        public void stop() {
            super.stop();
            this.uiStop();
        }

        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                MyProgressIndicator.$$$reportNull$$$0(0);
            }
            super.finish(task);
            this.uiStop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter$MyProgressIndicator", "finish"));
        }
    }

    private static enum CheckHeaderStatus {
        HEADER,
        NOT_HEADER,
        IGNORE,
        ALL_HEADERS,
        SOME_HEADERS,
        NO_HEADERS;


        @NotNull
        CheckHeaderStatus merge(@NotNull CheckHeaderStatus other) {
            if (other == null) {
                CheckHeaderStatus.$$$reportNull$$$0(0);
            }
            if (this == IGNORE) {
                CheckHeaderStatus checkHeaderStatus = other;
                if (checkHeaderStatus == null) {
                    CheckHeaderStatus.$$$reportNull$$$0(1);
                }
                return checkHeaderStatus;
            }
            if (other == IGNORE) {
                CheckHeaderStatus checkHeaderStatus = this;
                if (checkHeaderStatus == null) {
                    CheckHeaderStatus.$$$reportNull$$$0(2);
                }
                return checkHeaderStatus;
            }
            switch (this) {
                case HEADER: {
                    switch (other) {
                        case HEADER: {
                            CheckHeaderStatus checkHeaderStatus = ALL_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(3);
                            }
                            return checkHeaderStatus;
                        }
                        case NOT_HEADER: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(4);
                            }
                            return checkHeaderStatus;
                        }
                        case ALL_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = ALL_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(5);
                            }
                            return checkHeaderStatus;
                        }
                        case SOME_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(6);
                            }
                            return checkHeaderStatus;
                        }
                        case NO_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(7);
                            }
                            return checkHeaderStatus;
                        }
                    }
                }
                case NOT_HEADER: {
                    switch (other) {
                        case HEADER: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(8);
                            }
                            return checkHeaderStatus;
                        }
                        case NOT_HEADER: {
                            CheckHeaderStatus checkHeaderStatus = NO_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(9);
                            }
                            return checkHeaderStatus;
                        }
                        case ALL_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(10);
                            }
                            return checkHeaderStatus;
                        }
                        case SOME_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(11);
                            }
                            return checkHeaderStatus;
                        }
                        case NO_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = NO_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(12);
                            }
                            return checkHeaderStatus;
                        }
                    }
                }
                case ALL_HEADERS: {
                    switch (other) {
                        case HEADER: {
                            CheckHeaderStatus checkHeaderStatus = ALL_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(13);
                            }
                            return checkHeaderStatus;
                        }
                        case NOT_HEADER: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(14);
                            }
                            return checkHeaderStatus;
                        }
                        case ALL_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = ALL_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(15);
                            }
                            return checkHeaderStatus;
                        }
                        case SOME_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(16);
                            }
                            return checkHeaderStatus;
                        }
                        case NO_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(17);
                            }
                            return checkHeaderStatus;
                        }
                    }
                }
                case SOME_HEADERS: {
                    CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                    if (checkHeaderStatus == null) {
                        CheckHeaderStatus.$$$reportNull$$$0(18);
                    }
                    return checkHeaderStatus;
                }
                case NO_HEADERS: {
                    switch (other) {
                        case HEADER: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(19);
                            }
                            return checkHeaderStatus;
                        }
                        case NOT_HEADER: {
                            CheckHeaderStatus checkHeaderStatus = NO_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(20);
                            }
                            return checkHeaderStatus;
                        }
                        case ALL_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(21);
                            }
                            return checkHeaderStatus;
                        }
                        case SOME_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = SOME_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(22);
                            }
                            return checkHeaderStatus;
                        }
                        case NO_HEADERS: {
                            CheckHeaderStatus checkHeaderStatus = NO_HEADERS;
                            if (checkHeaderStatus == null) {
                                CheckHeaderStatus.$$$reportNull$$$0(23);
                            }
                            return checkHeaderStatus;
                        }
                    }
                }
            }
            CheckHeaderStatus checkHeaderStatus = IGNORE;
            if (checkHeaderStatus == null) {
                CheckHeaderStatus.$$$reportNull$$$0(24);
            }
            return checkHeaderStatus;
        }

        @NotNull
        CheckHeaderStatus singleFileToDirectory() {
            if (this == HEADER) {
                CheckHeaderStatus checkHeaderStatus = ALL_HEADERS;
                if (checkHeaderStatus == null) {
                    CheckHeaderStatus.$$$reportNull$$$0(25);
                }
                return checkHeaderStatus;
            }
            if (this == NOT_HEADER) {
                CheckHeaderStatus checkHeaderStatus = NO_HEADERS;
                if (checkHeaderStatus == null) {
                    CheckHeaderStatus.$$$reportNull$$$0(26);
                }
                return checkHeaderStatus;
            }
            CheckHeaderStatus checkHeaderStatus = this;
            if (checkHeaderStatus == null) {
                CheckHeaderStatus.$$$reportNull$$$0(27);
            }
            return checkHeaderStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter$CheckHeaderStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectStepAdapter$CheckHeaderStatus";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "singleFileToDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

