/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CMakeProjectWizard;
import com.jetbrains.cidr.cpp.cmake.projectWizard.ImportCMakeProjectStepAdapter;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportCMakeProjectWizard
extends CMakeProjectWizard {
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";
    private final ImportCMakeProjectStepAdapter myStep;
    private final VirtualFile myImportDir;

    private ImportCMakeProjectWizard(@NotNull VirtualFile importDir) {
        if (importDir == null) {
            ImportCMakeProjectWizard.$$$reportNull$$$0(0);
        }
        super("Import CMake Project", "ImportCMakeProject");
        this.myStep = new ImportCMakeProjectStepAdapter();
        this.myImportDir = importDir;
        this.initWithStep(this.myStep);
    }

    @Override
    protected boolean tryFinish() {
        try {
            this.myStep.createProject();
            return true;
        }
        catch (IOException e) {
            CPPLog.LOG.warn((Throwable)e);
            this.setErrorText("Cannot create CMake project");
            this.getNextButton().setEnabled(false);
            return false;
        }
    }

    public static void startRunWizard() {
        VirtualFile importDir = ImportCMakeProjectWizard.chooseDirectory();
        if (importDir != null) {
            CLionProjectWizardUtils.refreshProjectDir(importDir);
            VirtualFile makeFile = importDir.findChild("CMakeLists.txt");
            if (makeFile != null) {
                int button = Messages.showYesNoCancelDialog((Project)null, (String)("Directory " + importDir.getPresentableName() + " contains " + "CMakeLists.txt"), (String)"Import Project", (String)"Open Project", (String)"Overwrite CMakeLists.txt", (String)Messages.CANCEL_BUTTON, null);
                if (button != 1) {
                    if (button == 0) {
                        ProjectUtil.openOrImport((String)makeFile.getPath(), null, (boolean)false);
                    }
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            }
            new ImportCMakeProjectWizard(importDir).runWizard();
        }
    }

    @Override
    protected void beforeRunWizard() {
        this.myStep.prepareDirectories(this.myImportDir);
    }

    @Override
    protected void doRunWizard() {
        CLionProjectWizardUtils.refreshProjectDir(this.myImportDir);
        VirtualFile makeFile = this.myImportDir.findChild("CMakeLists.txt");
        CPPLog.LOG.assertTrue(makeFile != null);
        String pathToOpen = makeFile.getPath();
        Project project2 = ProjectUtil.findAndFocusExistingProjectForPath((String)pathToOpen);
        if (project2 != null) {
            CMakeWorkspace.getInstance(project2).selectProjectDir(VfsUtilCore.virtualToIoFile((VirtualFile)this.myImportDir));
        } else {
            CMakeWorkspace.forceReloadOnOpening(this.myImportDir);
            project2 = ProjectUtil.openOrImport((String)pathToOpen, null, (boolean)false);
            if (project2 == null) {
                return;
            }
        }
        CLionProjectWizardUtils.reformatProjectFiles(project2, makeFile, false, new VirtualFile[0]);
        new OpenFileDescriptor(project2, makeFile).navigate(false);
    }

    @Nullable
    private static VirtualFile chooseDirectory() {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, false){
            FileChooserDescriptor myDelegate = new OpenProjectFileChooserDescriptor(true);

            public Icon getIcon(VirtualFile file) {
                Icon icon = this.myDelegate.getIcon(file);
                return icon == null ? super.getIcon(file) : icon;
            }

            public boolean isFileSelectable(VirtualFile file) {
                return file != null && file.isDirectory() && file.getChildren().length > 0;
            }
        };
        descriptor2.setHideIgnored(true);
        descriptor2.setTitle("Select Directory to Import");
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, null);
        VirtualFile[] files = chooser.choose(null, new VirtualFile[]{toSelect});
        if (files.length == 0) {
            return null;
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, files[0].getPath());
        return files[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDir", "com/jetbrains/cidr/cpp/cmake/projectWizard/ImportCMakeProjectWizard", "<init>"));
    }
}

