/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard.generators;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.platform.GeneratorPeerImpl;
import com.intellij.platform.ProjectGeneratorPeer;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.ui.CMakeSettingsPanel;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import icons.CLionIcons;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.codec.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeProjectGenerator
extends DirectoryProjectGeneratorBase<CMakeProjectSettings> {
    public static final String SHARED_LIB_TYPE = "shared";
    public static final String STATIC_LIB_TYPE = "static";
    public static final String OTHER_PROJECT_GROUP_NAME = "Other";
    private static final CMakeProjectSettings C_MAKE_DEFAULT_PROJECT_SETTINGS = new CMakeProjectSettings(){

        @Override
        @NotNull
        public String getEnabledProjectLanguages() {
            if ("" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "";
        }

        @Override
        @NotNull
        public String getLanguageVersionLineForCMake() {
            if ("" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/CMakeProjectGenerator$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnabledProjectLanguages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageVersionLineForCMake";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    @Nullable
    protected String myLanguageVersion;
    @Nullable
    private String myLibraryType = "static";

    @Nullable
    public Icon getLogo() {
        return CLionIcons.CMake;
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)baseDirPath)) {
            ValidationResult validationResult = new ValidationResult("Enter project location");
            if (validationResult == null) {
                CMakeProjectGenerator.$$$reportNull$$$0(1);
            }
            return validationResult;
        }
        File dir = new File(baseDirPath);
        if (!dir.isAbsolute()) {
            ValidationResult validationResult = new ValidationResult("Project location path should be absolute");
            if (validationResult == null) {
                CMakeProjectGenerator.$$$reportNull$$$0(2);
            }
            return validationResult;
        }
        if (dir.exists() && !dir.canWrite()) {
            ValidationResult validationResult = new ValidationResult(String.format("Directory '%s' is not writable.\nPlease choose another directory.", baseDirPath));
            if (validationResult == null) {
                CMakeProjectGenerator.$$$reportNull$$$0(3);
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(4);
        }
        return validationResult;
    }

    public void generateProject(@NotNull Project project2, @NotNull VirtualFile baseDir, @NotNull CMakeProjectSettings settings, @NotNull Module module2) {
        CreatedFilesHolder createdFiles;
        if (project2 == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(7);
        }
        if (module2 == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(8);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.new.cmake.project");
        UsageTrigger.trigger((String)("new.cmake.project." + ConvertUsagesUtil.ensureProperKey((String)this.getName())));
        try {
            createdFiles = (CreatedFilesHolder)ApplicationManager.getApplication().runWriteAction(() -> {
                if (project2 == null) {
                    CMakeProjectGenerator.$$$reportNull$$$0(19);
                }
                if (baseDir == null) {
                    CMakeProjectGenerator.$$$reportNull$$$0(20);
                }
                return this.createProject(project2.getName(), baseDir);
            });
        }
        catch (IOException e) {
            this.handleErrorDuringGeneration(project2, e);
            return;
        }
        CLionProjectWizardUtils.reformatProjectFiles(project2, createdFiles.cMakeFile, this.formatSourceFilesAsCpp(), createdFiles.sourceFiles);
        CMakeWorkspace.getInstance(project2).selectProjectDir(VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            new OpenFileDescriptor(project2, createdFiles.cMakeFile).navigate(false);
            Arrays.asList(createdFiles.sourceFiles).forEach(vf -> {
                if (project2 == null) {
                    CMakeProjectGenerator.$$$reportNull$$$0(18);
                }
                new OpenFileDescriptor(project2, vf).navigate(true);
            });
        }
    }

    protected void handleErrorDuringGeneration(@NotNull Project project2, Exception e) {
        if (project2 == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(9);
        }
        Messages.showErrorDialog((Project)project2, (String)("Cannot create a new project: " + e.getMessage()), (String)"New Project");
        CPPLog.LOG.error((Throwable)e);
    }

    @NotNull
    public ProjectGeneratorPeer<CMakeProjectSettings> createPeer() {
        CMakeProjectSettings cMakeProjectSettings;
        JComponent panel = this.getSettingsPanel();
        if (panel == null) {
            panel = new JPanel();
        }
        if ((cMakeProjectSettings = this.getCMakeProjectSettings()) == null) {
            cMakeProjectSettings = C_MAKE_DEFAULT_PROJECT_SETTINGS;
        }
        GeneratorPeerImpl generatorPeerImpl = new GeneratorPeerImpl((Object)cMakeProjectSettings, panel);
        if (generatorPeerImpl == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(10);
        }
        return generatorPeerImpl;
    }

    @Nullable
    public CMakeProjectSettings getCMakeProjectSettings() {
        CMakeProjectSettings settings = this.createProjectSettings();
        if (settings != null) {
            if (this.myLanguageVersion != null) {
                settings.setLanguageVersion(this.myLanguageVersion);
            }
            if (this.myLibraryType != null) {
                settings.setLibraryType(this.myLibraryType);
            }
        }
        return settings;
    }

    public boolean addLibrarySettingsPanel() {
        return false;
    }

    public void setLanguageVersion(@NotNull String languageVersion) {
        if (languageVersion == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(11);
        }
        this.myLanguageVersion = languageVersion;
    }

    public void setLibraryType(@Nullable String libraryType) {
        this.myLibraryType = libraryType;
    }

    public String[] getLanguageVersions() {
        return null;
    }

    @Nullable
    public JComponent getSettingsPanel() {
        CMakeSettingsPanel panel = this.createSettingsPanel();
        if (panel != null) {
            panel.initFields(this.myLanguageVersion, this.myLibraryType);
        }
        return panel;
    }

    protected CMakeSettingsPanel createSettingsPanel() {
        return new CMakeSettingsPanel(this);
    }

    @Nullable
    public CMakeProjectSettings createProjectSettings() {
        return null;
    }

    private CreatedFilesHolder createProject(String name2, VirtualFile projectDir) throws IOException {
        String sanitizedName = FileUtil.sanitizeFileName((String)name2);
        VirtualFile cMakeFile = this.createCMakeFile(sanitizedName, projectDir);
        VirtualFile[] sourceFiles = this.createSourceFiles(sanitizedName, projectDir);
        return new CreatedFilesHolder(cMakeFile, sourceFiles);
    }

    @NotNull
    protected VirtualFile createCMakeFile(@NotNull String name2, @NotNull VirtualFile dir) throws IOException {
        if (name2 == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(12);
        }
        if (dir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = this.createProjectFileWithContent(dir, "CMakeLists.txt", this.getCMakeFileContent(name2));
        if (virtualFile == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @NotNull
    public String getGroupName() {
        if (OTHER_PROJECT_GROUP_NAME == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(15);
        }
        return OTHER_PROJECT_GROUP_NAME;
    }

    @NotNull
    protected abstract String getCMakeFileContent(@NotNull String var1);

    @NotNull
    protected abstract VirtualFile[] createSourceFiles(@NotNull String var1, @NotNull VirtualFile var2) throws IOException;

    protected boolean formatSourceFilesAsCpp() {
        return true;
    }

    @Nullable
    public String getLanguageVersion() {
        return this.myLanguageVersion;
    }

    @Nullable
    public String getLibraryType() {
        return this.myLibraryType;
    }

    @NotNull
    protected VirtualFile createProjectFileWithContent(@NotNull VirtualFile projectDir, String fileName, String fileContent) throws IOException {
        if (projectDir == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(16);
        }
        VirtualFile file = projectDir.findOrCreateChildData((Object)this, fileName);
        file.setBinaryContent(fileContent.getBytes(Charsets.UTF_8));
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            CMakeProjectGenerator.$$$reportNull$$$0(17);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/CMakeProjectGenerator";
                break;
            }
            case 5: 
            case 9: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersion";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/generators/CMakeProjectGenerator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCMakeFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectFileWithContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorDuringGeneration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCMakeFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createProjectFileWithContent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$1";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreatedFilesHolder {
        private final VirtualFile cMakeFile;
        private final VirtualFile[] sourceFiles;

        private CreatedFilesHolder(VirtualFile file, VirtualFile[] files) {
            this.cMakeFile = file;
            this.sourceFiles = files;
        }
    }
}

