/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.cpp.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cidr.cpp.cmake.editor.CMakeArgumentPresentation;
import com.jetbrains.cidr.cpp.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cidr.cpp.cmake.interpreter.CMakeScope;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgument;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeElementBase;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeLiteral;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeRoutine;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cidr.cpp.cmake.resolve.CMakeCommandReference;
import com.jetbrains.cidr.cpp.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cidr.cpp.cmake.resolve.CMakeRenameUtils;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeArgumentImplMixin
extends CMakeElementBase
implements CMakeArgument {
    public CMakeArgumentImplMixin(@NotNull ASTNode node) {
        if (node == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiElement getLiteralNotNull() {
        CMakeLiteral literal = this.getCMakeLiteral();
        assert (literal != null);
        CMakeLiteral cMakeLiteral = literal;
        if (cMakeLiteral == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(1);
        }
        return cMakeLiteral;
    }

    @Override
    public boolean isBracketArgument() {
        return this.getFirstChild().getNode().getElementType() == CMakeTokenTypes.BRACKET_ARG_START;
    }

    @Override
    public boolean isQuotedArgument() {
        return this.getFirstChild().getNode().getElementType() == CMakeTokenTypes.QUOTE;
    }

    @Override
    public void expandIntoArgumentList(@NotNull List<String> result, @NotNull CMakeScope scope) {
        if (result == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(3);
        }
        String literalText = this.getLiteralNotNull().getText();
        if (this.isBracketArgument()) {
            result.add(literalText);
        } else {
            boolean isQuoted = this.isQuotedArgument();
            String value = scope.eval(literalText);
            if (value != null) {
                if (isQuoted) {
                    result.add(value);
                } else {
                    CMakeInterpreter.expandListArgument(value, result);
                }
            }
        }
    }

    @Override
    @Nullable
    public PsiPolyVariantReference getReference() {
        if (this.isCommandDefinitionName() || this.isEndCommandDefinitionName()) {
            return new CMakeCommandReference(this, new TextRange(0, this.getTextRange().getLength()));
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        if (this.isFunctionName() || this.isEndFunctionName()) {
            return CMakeCompletionUtils.getRoutineIcon(true);
        }
        if (this.isMacroName() || this.isEndMacroName()) {
            return CMakeCompletionUtils.getRoutineIcon(false);
        }
        return super.getIcon(flags);
    }

    @NotNull
    public String getName() {
        String string = this.getValue();
        if (string == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(5);
        }
        CMakeRenameUtils.renameArgument(this.getProject(), name2, this.getNode());
        return this;
    }

    @Override
    @NotNull
    public String getValue() {
        CMakeLiteral literal = this.getCMakeLiteral();
        if (literal == null) {
            if ("" == null) {
                CMakeArgumentImplMixin.$$$reportNull$$$0(6);
            }
            return "";
        }
        String string = CMakeArgumentManipulator.getValueFromCMakeLiteralNoEval(literal.getText());
        if (string == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public TextRange getContentsRange() {
        String text;
        PsiElement literal = this.getLiteralNotNull();
        int startOffset = literal.getStartOffsetInParent();
        TextRange range = new TextRange(startOffset, startOffset + literal.getTextLength());
        if (this.isBracketArgument() && (text = literal.getText()).startsWith("\"") && text.endsWith("\"")) {
            TextRange textRange = range.shiftRight(1).grown(-2);
            if (textRange == null) {
                CMakeArgumentImplMixin.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @Override
    public boolean isFunctionName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isFunctionDeclarationParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isEndFunctionName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isEndFunctionParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isMacroName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isMacroDeclarationParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isEndMacroName() {
        CMakeCommandArguments arguments = this.getParentCommandArguments();
        return arguments.isEndMacroParameters() && arguments.getFirstArgument() == this;
    }

    @Override
    public boolean isCommandDefinitionName() {
        return this.isFunctionName() || this.isMacroName();
    }

    @Override
    public boolean isEndCommandDefinitionName() {
        return this.isEndCommandDefinitionName(null);
    }

    @Override
    public boolean isEndCommandDefinitionName(@Nullable String definitionNameCandidate) {
        if (this.isEndFunctionName() || this.isEndMacroName()) {
            CMakeRoutine routine = (CMakeRoutine)this.getParentCommandArguments().getParent().getParent();
            CMakeArgument firstArgument = routine.getFirstArgument();
            if (definitionNameCandidate != null) {
                return CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)this, firstArgument) || CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)firstArgument, definitionNameCandidate);
            }
            return CMakeCommandReferenceHelper.commandNamesEqualByText((PsiElement)this, firstArgument) || this.isCommandPartWithInvokedCompletion(firstArgument);
        }
        return false;
    }

    private boolean isCommandPartWithInvokedCompletion(@Nullable CMakeArgument firstArgument) {
        return firstArgument != null && this.getText().contains("IntellijIdeaRulezzz") && firstArgument.getText().toLowerCase(Locale.US).startsWith(this.getText().replace("IntellijIdeaRulezzz", "").toLowerCase(Locale.US));
    }

    @Override
    @Nullable
    public CMakeArgument getCommandDefinitionName() {
        CMakeRoutine cMakeCommand;
        CMakeArgument routineNameArgument;
        if (this.isCommandDefinitionName()) {
            return this;
        }
        if (this.isEndCommandDefinitionName() && this.getParentCommandArguments().isEndRoutineParameters() && (routineNameArgument = (cMakeCommand = (CMakeRoutine)this.getParentCommandArguments().getParent().getParent()).getFirstArgument()) != null) {
            return routineNameArgument;
        }
        return null;
    }

    @Override
    @Nullable
    public CMakeArgument getNextArgument() {
        return (CMakeArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @Nullable
    public CMakeArgument getPreviousArgument() {
        return (CMakeArgument)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this, CMakeArgument.class);
    }

    @Override
    @NotNull
    public CMakeCommandArguments getParentCommandArguments() {
        CMakeCommandArguments cMakeCommandArguments = (CMakeCommandArguments)PsiTreeUtil.getParentOfType((PsiElement)this, CMakeCommandArguments.class, (boolean)true);
        assert (cMakeCommandArguments != null);
        CMakeCommandArguments cMakeCommandArguments2 = cMakeCommandArguments;
        if (cMakeCommandArguments2 == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(10);
        }
        return cMakeCommandArguments2;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        CMakeArgumentPresentation cMakeArgumentPresentation = new CMakeArgumentPresentation(this);
        if (cMakeArgumentPresentation == null) {
            CMakeArgumentImplMixin.$$$reportNull$$$0(11);
        }
        return cMakeArgumentPresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/psi/CMakeArgumentImplMixin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/psi/CMakeArgumentImplMixin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralNotNull";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentsRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentCommandArguments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandIntoArgumentList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

