/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.psi.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CMakeFileLocationUtil {
    @NotNull
    public static String getLocationInFile(@NotNull PsiElement elementInCMakeFile, boolean addLineNumber) {
        if (elementInCMakeFile == null) {
            CMakeFileLocationUtil.$$$reportNull$$$0(0);
        }
        CMakeWorkspace workspace = CMakeWorkspace.getInstance(elementInCMakeFile.getProject());
        PsiFile cmdFile = elementInCMakeFile.getContainingFile();
        VirtualFile virtualFile = cmdFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = cmdFile.getOriginalFile().getVirtualFile();
        }
        String relativePathToRoot = cmdFile.getName();
        if (virtualFile != null) {
            String root = virtualFile.getPath();
            VirtualFile contentRoot = workspace.getEffectiveContentRoot();
            if (contentRoot != null) {
                String relativePath = FileUtil.getRelativePath((File)new File(FileUtil.toCanonicalPath((String)contentRoot.getPath())), (File)new File(root));
                relativePathToRoot = relativePath == null ? root : relativePath;
            }
        }
        relativePathToRoot = FileUtil.toSystemDependentName((String)relativePathToRoot);
        if (addLineNumber) {
            Document doc = PsiDocumentManager.getInstance((Project)elementInCMakeFile.getProject()).getDocument(cmdFile);
            if (doc == null) {
                doc = EditorFactory.getInstance().createDocument((CharSequence)cmdFile.getText());
            }
            int cmdLine = doc.getLineNumber(elementInCMakeFile.getTextOffset()) + 1;
            String string = relativePathToRoot + ":" + cmdLine;
            if (string == null) {
                CMakeFileLocationUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = relativePathToRoot;
        if (string == null) {
            CMakeFileLocationUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInCMakeFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/psi/util/CMakeFileLocationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/psi/util/CMakeFileLocationUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationInFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocationInFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

