/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeListsFileType;
import com.jetbrains.cidr.cpp.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgument;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeCommand;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeLiteral;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeRoutine;
import com.jetbrains.cidr.cpp.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cidr.cpp.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cidr.cpp.cmake.resolve.CMakeRenameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCommandReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference {
    private static final boolean USE_CACHE = true;

    public CMakeCommandReference(PsiElement element, TextRange textRange) {
        super(element, textRange);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.myElement.getParent() instanceof CMakeCommand) {
            CMakeRenameUtils.renameCommandCall(this.myElement.getProject(), newElementName, this.myElement.getNode());
        } else if (CMakeCommandReferenceHelper.isCommandDefinition(this.myElement) || CMakeCommandReferenceHelper.isEndCommandDefinition(this.myElement, newElementName)) {
            CMakeRenameUtils.renameArgument(this.myElement.getProject(), newElementName, this.myElement.getNode());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (CMakeCommandReferenceHelper.commandNamesEqualByText(element, this.myElement) && (CMakeCommandReferenceHelper.isCommandCall(this.myElement) || CMakeCommandReferenceHelper.isCommandDefinition(this.myElement) || CMakeCommandReferenceHelper.isEndCommandDefinition(this.myElement))) {
            CMakeArgument cMakeArgument;
            if (CMakeCommandReferenceHelper.isCommandCall(element)) {
                return true;
            }
            if (CMakeCommandReferenceHelper.isCommandDefinition(element) && (cMakeArgument = CMakeCommandReferenceHelper.getCMakeArgument(element)).isCommandDefinitionName()) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveCache cache = ResolveCache.getInstance((Project)this.getElement().getProject());
        ResolveResult[] resolveResultArray = cache.resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<CMakeCommandReference>(){

            @NotNull
            public ResolveResult[] resolve(@NotNull CMakeCommandReference reference, boolean incompleteCode) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                ResolveResult[] resolveResultArray = reference.multiResolveWithoutCaching();
                if (resolveResultArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolve";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "resolve";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, false, incompleteCode);
        if (resolveResultArray == null) {
            CMakeCommandReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    private ResolveResult[] multiResolveWithoutCaching() {
        CMakeArgument commandDefinitionName;
        if (CMakeCommandReferenceHelper.isCommandDefinition(this.myElement)) {
            return new ResolveResult[]{new PsiElementResolveResult(this.myElement)};
        }
        CMakeArgument elementArgument = null;
        if (this.myElement instanceof CMakeLiteral) {
            elementArgument = ((CMakeLiteral)this.myElement).getArgument();
        } else if (this.myElement instanceof CMakeArgument) {
            elementArgument = (CMakeArgument)this.myElement;
        }
        if (elementArgument != null && (commandDefinitionName = elementArgument.getCommandDefinitionName()) != null) {
            return new ResolveResult[]{new PsiElementResolveResult((PsiElement)commandDefinitionName)};
        }
        ArrayList<ResolveResult> commands = new ArrayList<ResolveResult>();
        this.fillCommandsFromProject(commands, true);
        return commands.toArray(ResolveResult.EMPTY_ARRAY);
    }

    private List<ResolveResult> fillCommandReferencesFromModule(@NotNull List<ResolveResult> commands, @NotNull PsiFile containingFile, @Nullable Module module2, boolean checkForTextEquality) {
        if (commands == null) {
            CMakeCommandReference.$$$reportNull$$$0(1);
        }
        if (containingFile == null) {
            CMakeCommandReference.$$$reportNull$$$0(2);
        }
        if (module2 != null) {
            List virtualFiles;
            if (checkForTextEquality) {
                virtualFiles = new ArrayList(FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)new IdIndexEntry(this.myElement.getText(), false), module2.getModuleWithLibrariesScope()));
                virtualFiles = ContainerUtil.filter(virtualFiles, file -> file.getFileType() == CMakeListsFileType.INSTANCE);
            } else {
                ArrayList finalVirtualFiles = virtualFiles = new ArrayList();
                FileTypeIndex.processFiles((FileType)CMakeListsFileType.INSTANCE, file -> {
                    finalVirtualFiles.add(file);
                    return true;
                }, (GlobalSearchScope)module2.getModuleWithLibrariesScope());
            }
            Collections.sort(virtualFiles, (o1, o2) -> o1.getPath().compareToIgnoreCase(o2.getPath()));
            for (VirtualFile virtualFile : virtualFiles) {
                PsiFile psiFile = this.myElement.getManager().findFile(virtualFile);
                if (containingFile.equals(psiFile)) continue;
                this.fillCommandsFromFile(commands, psiFile, checkForTextEquality);
            }
        }
        return commands;
    }

    private List<ResolveResult> fillCommandsFromFile(final @NotNull List<ResolveResult> commands, @Nullable PsiFile file, final boolean checkForTextEquality) {
        if (commands == null) {
            CMakeCommandReference.$$$reportNull$$$0(3);
        }
        PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                boolean isCommandDefinition;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (isCommandDefinition = element instanceof CMakeRoutine) {
                    boolean isCommandDefinitionName;
                    CMakeArgument argumentElement = ((CMakeRoutine)element).getFirstArgument();
                    boolean argumentExists = argumentElement != null;
                    boolean bl = isCommandDefinitionName = argumentExists && argumentElement.isCommandDefinitionName();
                    if (isCommandDefinitionName) {
                        if (checkForTextEquality) {
                            boolean isOurCommandName;
                            CMakeLiteral cMakeLiteral = argumentElement.getCMakeLiteral();
                            boolean bl2 = isOurCommandName = cMakeLiteral != null && cMakeLiteral.getText().equalsIgnoreCase(CMakeCommandReference.this.myElement.getText());
                            if (isOurCommandName) {
                                commands.add(new PsiElementResolveResult((PsiElement)argumentElement));
                                return true;
                            }
                        } else {
                            commands.add(new PsiElementResolveResult((PsiElement)argumentElement));
                            return true;
                        }
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference$2", "execute"));
            }
        });
        return commands;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public Object[] getVariants() {
        List<ResolveResult> commands = this.collectCommandsFromProjectOrCache();
        Object[] completionForCommandDefinition = this.getCompletionForCommandDefinition();
        if (completionForCommandDefinition != null) {
            if (completionForCommandDefinition == null) {
                CMakeCommandReference.$$$reportNull$$$0(4);
            }
            return completionForCommandDefinition;
        }
        Object[] objectArray = this.getCompletion(commands);
        if (objectArray == null) {
            CMakeCommandReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @NotNull
    private List<ResolveResult> collectCommandsFromProjectOrCache() {
        ArrayList<ResolveResult> commands = new ArrayList<ResolveResult>();
        ResolveCache cache = ResolveCache.getInstance((Project)this.getElement().getProject());
        ContainerUtil.addAll(commands, (Object[])cache.resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<CMakeCommandReference>(){

            @NotNull
            public ResolveResult[] resolve(@NotNull CMakeCommandReference reference, boolean incompleteCode) {
                if (reference == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArrayList cacheResults = new ArrayList();
                CMakeCommandReference.this.fillCommandsFromProject(cacheResults, false);
                ResolveResult[] resolveResultArray = cacheResults.toArray(ResolveResult.EMPTY_ARRAY);
                if (resolveResultArray == null) {
                    3.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolve";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "resolve";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, false, false));
        ArrayList<ResolveResult> arrayList = commands;
        if (arrayList == null) {
            CMakeCommandReference.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private Object[] getCompletionForCommandDefinition() {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        if (this.myElement instanceof CMakeArgument) {
            if (((CMakeArgument)this.myElement).isCommandDefinitionName()) {
                return LookupElement.EMPTY_ARRAY;
            }
            if (((CMakeArgument)this.myElement).isEndCommandDefinitionName()) {
                CMakeArgument commandDefinitionName = ((CMakeArgument)this.myElement).getCommandDefinitionName();
                if (commandDefinitionName != null) {
                    variants.add(CMakeCompletionUtils.createCommandItem(commandDefinitionName.getText(), this.myElement.getContainingFile().getName(), Collections.emptyList(), true, false));
                }
                return variants.toArray();
            }
        }
        return null;
    }

    @NotNull
    private Object[] getCompletion(List<ResolveResult> commands) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        for (ResolveResult command : commands) {
            PsiElement psiElement = command.getElement();
            CPPLog.LOG.assertTrue(psiElement instanceof CMakeArgument);
            CMakeArgument cMakeArgument = (CMakeArgument)psiElement;
            CMakeLiteral cMakeLiteral = cMakeArgument.getCMakeLiteral();
            CPPLog.LOG.assertTrue(cMakeLiteral != null);
            String textToComplete = CMakeCompletionUtils.convertCommandToProperCase(psiElement.getProject(), cMakeLiteral.getText());
            List<CMakeArgument> argumentList = cMakeArgument.getParentCommandArguments().getCMakeArgumentList();
            List<CMakeArgument> argumentsInCompletion = argumentList.subList(1, argumentList.size());
            String filename = CMakeFileLocationUtil.getLocationInFile(psiElement, false);
            boolean addParentheses = !(this.myElement instanceof CMakeArgument);
            variants.add(CMakeCompletionUtils.createCommandItem(textToComplete, filename, argumentsInCompletion, cMakeArgument.isFunctionName(), addParentheses));
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            CMakeCommandReference.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    private void fillCommandsFromProject(@NotNull List<ResolveResult> commands, boolean checkForTextEquality) {
        PsiFile currentFile;
        if (commands == null) {
            CMakeCommandReference.$$$reportNull$$$0(8);
        }
        if ((currentFile = this.myElement.getContainingFile()) != null) {
            this.fillCommandsFromFile(commands, currentFile, checkForTextEquality);
            VirtualFile virtualFile = currentFile.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = currentFile.getOriginalFile().getVirtualFile();
            }
            if (virtualFile != null) {
                Module module2 = ProjectRootManager.getInstance((Project)this.myElement.getProject()).getFileIndex().getModuleForFile(virtualFile);
                this.fillCommandReferencesFromModule(commands, currentFile, module2, checkForTextEquality);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PsiReferenceBase base = (PsiReferenceBase)o;
        if (this.getElement() != null ? !this.getElement().equals(base.getElement()) : base.getElement() != null) {
            return false;
        }
        return !(this.getRangeInElement() != null ? !this.getRangeInElement().equals((Object)base.getRangeInElement()) : base.getRangeInElement() != null);
    }

    public int hashCode() {
        int result = this.getElement() != null ? this.getElement().hashCode() : 0;
        result = 31 * result + (this.getRangeInElement() != null ? this.getRangeInElement().hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/resolve/CMakeCommandReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommandsFromProjectOrCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandReferencesFromModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandsFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandsFromProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

