/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.settings;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPSettingsUtil;
import com.jetbrains.cidr.cpp.DetailsEditorHelper;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsPanel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeConfigurable
implements SearchableConfigurable {
    private final Project myProject;
    private final CMakeWorkspace myWorkspace;
    private final CMakeSettings mySettings;
    private JBCheckBox myEnableCMakeAutoReload;
    private ProfileListEditor myProfileListEditor;
    private int myPreselectedProfile = -1;
    private MessageBusConnection myConnection;
    private CPPToolchainsConfigurable.Listener myToolchainsConfigurableListener;

    public CMakeConfigurable(Project project2) {
        this.myProject = project2;
        this.myWorkspace = CMakeWorkspace.getInstance(project2);
        this.mySettings = this.myWorkspace.getSettings();
    }

    @NotNull
    public String getId() {
        if ("CMakeSettings" == null) {
            CMakeConfigurable.$$$reportNull$$$0(0);
        }
        return "CMakeSettings";
    }

    @Nls
    public String getDisplayName() {
        return CPPBundle.message("cmake", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.build.cmake";
    }

    @Nullable
    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag bag = CMakeConfigurable.createBagConstraints(false);
        this.myEnableCMakeAutoReload = new JBCheckBox(CPPBundle.message("cmake.action.autoReloadCmakeProject.checkbox", new Object[0]));
        panel.add((Component)this.myEnableCMakeAutoReload, bag.nextLine().next().insets(-1, -1, 0, -1).coverLine());
        panel.add((Component)new JBLabel(CPPBundle.message("cmake.action.autoReloadCmakeProject.checkbox.hint", new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), bag.nextLine().next().insets(0, UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myEnableCMakeAutoReload), -1, -1).coverLine());
        panel.add((Component)new TitledSeparator(CPPBundle.message("cmake.settings.profilesGroup", new Object[0])), bag.nextLine().next().coverLine());
        this.myProfileListEditor = new ProfileListEditor();
        panel.add((Component)this.myProfileListEditor, bag.nextLine().next().coverLine().fillCell().weightx(1.0).weighty(1.0));
        this.mySettings.setPauseToolchainsListener(true);
        this.myToolchainsConfigurableListener = new CPPToolchainsConfigurable.Listener(){

            @Override
            public void toolchainsChanged(@NotNull List<CPPToolchains.Toolchain> newToolchains, @NotNull List<Pair<String, String>> renames) {
                if (newToolchains == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (renames == null) {
                    1.$$$reportNull$$$0(1);
                }
                CMakeConfigurable.this.myProfileListEditor.updateToolchains(newToolchains, renames);
            }

            @Override
            public void toolchainRenamed(int index, @NotNull String newName) {
                if (newName == null) {
                    1.$$$reportNull$$$0(2);
                }
                CMakeConfigurable.this.myProfileListEditor.renameToolchain(index, newName);
            }

            @Override
            public void toolchainsApplied() throws ConfigurationException {
                CMakeConfigurable.this.apply();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newToolchains";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renames";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolchainsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toolchainRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myConnection = ApplicationManager.getApplication().getMessageBus().connect();
        this.myConnection.subscribe(CPPToolchainsConfigurable.TOPIC, (Object)this.myToolchainsConfigurableListener);
        return panel;
    }

    public void setPreselectedProfile(int preselectedProfile) {
        this.myPreselectedProfile = preselectedProfile;
    }

    @NotNull
    public ProfileListEditor getProfileListEditor() {
        ProfileListEditor profileListEditor = this.myProfileListEditor;
        if (profileListEditor == null) {
            CMakeConfigurable.$$$reportNull$$$0(1);
        }
        return profileListEditor;
    }

    @NotNull
    public static GridBag createBagConstraints(boolean addLeftGap) {
        GridBag gridBag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultInsets(4, 0, 0, 10).setDefaultInsets(0, 4, addLeftGap ? 10 : 0, 0, 10).setDefaultAnchor(21).setDefaultFill(2);
        if (gridBag == null) {
            CMakeConfigurable.$$$reportNull$$$0(2);
        }
        return gridBag;
    }

    @NotNull
    private static RawCommandLineEditor createOptionsEditor(@NotNull String dialogCaption) {
        if (dialogCaption == null) {
            CMakeConfigurable.$$$reportNull$$$0(3);
        }
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption(dialogCaption);
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            CMakeConfigurable.$$$reportNull$$$0(4);
        }
        return rawCommandLineEditor;
    }

    public boolean isModified() {
        return (Boolean)ReadAction.compute(() -> {
            if (this.mySettings.isAutoReloadEnabled() != this.myEnableCMakeAutoReload.isSelected()) {
                return true;
            }
            if (this.myProfileListEditor.isModified(this.mySettings.getProfiles())) {
                return true;
            }
            return false;
        });
    }

    public void apply() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<CMakeSettings.Profile> profiles = this.myProfileListEditor.apply();
            CPPSettingsUtil.checkDuplicatingNames(ContainerUtil.map(profiles, CMakeSettings.Profile::getName), CPPBundle.message("cmake.profile", new Object[0]));
            this.mySettings.setAutoReloadEnabled(this.myEnableCMakeAutoReload.isSelected());
            this.mySettings.setProfiles(profiles);
            return null;
        });
    }

    public void reset() {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myEnableCMakeAutoReload.setSelected(this.mySettings.isAutoReloadEnabled());
            this.myProfileListEditor.reset(this.mySettings.getProfiles());
            CPPToolchainsPanel panel = this.getToolchainsPanelIfOpen();
            if (panel != null) {
                panel.deliverCurrentToolchainChanges(this.myToolchainsConfigurableListener);
            }
        });
    }

    @Nullable
    public CPPToolchainsPanel getToolchainsPanelIfOpen() {
        Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext());
        CPPToolchainsConfigurable configurable = settings != null ? (CPPToolchainsConfigurable)settings.find(CPPToolchainsConfigurable.class) : null;
        return configurable != null ? configurable.getPanelIfInitialized() : null;
    }

    @NotNull
    static String selectNextBuildType(@NotNull List<CMakeModelConfigurationData> modelConfigurationData, @NotNull List<String> alreadyAddedBuildTypes) {
        if (modelConfigurationData == null) {
            CMakeConfigurable.$$$reportNull$$$0(5);
        }
        if (alreadyAddedBuildTypes == null) {
            CMakeConfigurable.$$$reportNull$$$0(6);
        }
        LinkedHashSet<String> knownBuildTypes = new LinkedHashSet<String>();
        for (CMakeModelConfigurationData each : modelConfigurationData) {
            knownBuildTypes.addAll(each.getRegisteredBuildTypes());
        }
        if (knownBuildTypes.isEmpty()) {
            knownBuildTypes.addAll(CMakeModel.DEFAULT_BUILD_TYPES);
        }
        knownBuildTypes.removeAll(alreadyAddedBuildTypes);
        knownBuildTypes.remove("Default");
        String string = (String)ContainerUtil.getFirstItem(knownBuildTypes, (Object)"Default");
        if (string == null) {
            CMakeConfigurable.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String selectNextProfileName(@NotNull String suggestedName, @Nullable ProfileEditor excludeFromList) {
        if (suggestedName == null) {
            CMakeConfigurable.$$$reportNull$$$0(8);
        }
        String string = CPPSettingsUtil.suggestNextName(suggestedName, ContainerUtil.mapNotNull(this.myProfileListEditor.getEditors(), it -> {
            if (excludeFromList == it) {
                return null;
            }
            return it.getEffectiveProfileName();
        }));
        if (string == null) {
            CMakeConfigurable.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void disposeUIResources() {
        this.mySettings.setPauseToolchainsListener(false);
        this.myProfileListEditor.dispose();
        this.myConnection.disconnect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogCaption";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConfigurationData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyAddedBuildTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileListEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createBagConstraints";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "selectNextBuildType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "selectNextProfileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectNextBuildType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectNextProfileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ToolchainItem {
        @Nullable
        private final String name;

        public ToolchainItem(@Nullable String name2) {
            this.name = name2;
        }

        public String toString() {
            return String.valueOf(this.name);
        }
    }

    public class ProfileEditor
    extends JPanel {
        @NotNull
        private final ProfileListEditor myParentEditor;
        private JBTextField myNameField;
        private ComboBox<String> myBuildTypeComboBox;
        private ComboBox<ToolchainItem> myToolchainComboBox;
        private RawCommandLineEditor myCMakeOptions;
        private JBLabel myCMakeOptionsHint;
        private EnvironmentVariablesTextFieldWithBrowseButton myEnvironmentField;
        private TextFieldWithBrowseButton myGenerationDirField;
        private RawCommandLineEditor myBuildOptionsField;
        private boolean myUpdating;

        public ProfileEditor(ProfileListEditor parentEditor) {
            if (parentEditor == null) {
                ProfileEditor.$$$reportNull$$$0(0);
            }
            super(new GridBagLayout());
            this.myParentEditor = parentEditor;
            ProfileEditor panel = this;
            GridBag bag = CMakeConfigurable.createBagConstraints(true);
            JBInsets hintInsets = JBUI.insets((int)0, (int)-1, (int)-1, (int)-1);
            this.add((Component)new JLabel("Name:"), bag.nextLine().next());
            this.myNameField = new JBTextField(10);
            this.add((Component)this.myNameField, bag.next().coverLine());
            this.add((Component)new SeparatorWithText(), bag.nextLine().next().coverLine());
            panel.add((Component)new JBLabel(CPPBundle.message("cmake.settings.buildType", new Object[0])), bag.nextLine().next());
            this.myBuildTypeComboBox = new ComboBox();
            panel.add((Component)this.myBuildTypeComboBox, bag.next().fillCellNone().weightx(0.0));
            this.myBuildTypeComboBox.setEditable(true);
            FixedComboBoxEditor buildTypeEditor = new FixedComboBoxEditor();
            buildTypeEditor.getField().getEmptyText().setText(CMakeSettings.normalizeBuildType(null));
            this.myBuildTypeComboBox.setEditor((ComboBoxEditor)buildTypeEditor);
            panel.add((Component)new JLabel(CPPBundle.message("cpp.toolchain", new Object[0]) + ":"), bag.next());
            this.myToolchainComboBox = new ComboBox();
            panel.add((Component)this.myToolchainComboBox, bag.next().weightx(1.0));
            panel.add((Component)new JBLabel(CPPBundle.message("cmake.settings.generationOptions", new Object[0])), bag.nextLine().next());
            this.myCMakeOptions = CMakeConfigurable.createOptionsEditor(CPPBundle.message("cmake.settings.generationOptions.dialog", new Object[0]));
            panel.add((Component)this.myCMakeOptions, bag.next().coverLine());
            this.myCMakeOptionsHint = new JBLabel("", UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
            panel.add((Component)this.myCMakeOptionsHint, bag.nextLine().next().next().coverLine().insets((Insets)hintInsets));
            panel.add((Component)new JBLabel(CPPBundle.message("cmake.settings.environment", new Object[0])), bag.nextLine().next());
            this.myEnvironmentField = new EnvironmentVariablesTextFieldWithBrowseButton();
            panel.add((Component)this.myEnvironmentField, bag.next().coverLine());
            panel.add((Component)new JBLabel(CPPBundle.message("cmake.settings.generationDir", new Object[0])), bag.nextLine().next().insetTop(16));
            this.myGenerationDirField = new TextFieldWithBrowseButton();
            panel.add((Component)this.myGenerationDirField, bag.next().coverLine().insetTop(16));
            panel.add((Component)new JBLabel(CPPBundle.message("cmake.settings.generationDir.specified.hint", new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), bag.nextLine().next().next().coverLine().insets((Insets)hintInsets));
            panel.add((Component)new JBLabel(CPPBundle.message("cmake.settings.buildOptions", new Object[0])), bag.nextLine().next().insetTop(16));
            this.myBuildOptionsField = CMakeConfigurable.createOptionsEditor(CPPBundle.message("cmake.settings.buildOptions.dialog", new Object[0]));
            panel.add((Component)this.myBuildOptionsField, bag.next().coverLine().insetTop(16));
            this.add(Box.createVerticalGlue(), bag.nextLine().next().weighty(1.0).fillCell());
            this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ProfileEditor.this.profileNameChanged();
                }
            });
            class MyProfileNameUpdater
            extends DocumentAdapter
            implements ActionListener {
                @Nullable
                String myPreviousBuildType;
                @Nullable
                Ref<String> myPreviousToolchainName;

                MyProfileNameUpdater() {
                }

                protected void textChanged(DocumentEvent e) {
                    ProfileEditor.this.buildTypeOrToolchainNameChanged(this.myPreviousBuildType, (Ref<String>)this.myPreviousToolchainName);
                    this.myPreviousBuildType = ProfileEditor.this.getBuildTypeName();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileEditor.this.buildTypeOrToolchainNameChanged(this.myPreviousBuildType, (Ref<String>)this.myPreviousToolchainName);
                    this.myPreviousToolchainName = Ref.create((Object)ProfileEditor.this.getToolchainName());
                }
            }
            MyProfileNameUpdater updater = new MyProfileNameUpdater();
            ((JBTextField)this.myBuildTypeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)((Object)updater));
            this.myToolchainComboBox.addActionListener((ActionListener)updater);
            FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false);
            this.myGenerationDirField.addBrowseFolderListener(new TextBrowseFolderListener(descriptor2, CMakeConfigurable.this.myProject){

                @Nullable
                protected VirtualFile getInitialFile() {
                    File dir;
                    for (dir = ProfileEditor.this.myParentEditor.getEffectiveGenerationDir(ProfileEditor.this); dir != null && !dir.exists(); dir = dir.getParentFile()) {
                    }
                    if (dir == null) {
                        return CMakeConfigurable.this.myWorkspace.getEffectiveContentRoot();
                    }
                    return VfsUtil.findFileByIoFile((File)dir, (boolean)false);
                }

                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    String relativePath;
                    if (chosenFile == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    File chosenIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)chosenFile);
                    File contentRoot = CMakeConfigurable.this.myWorkspace.getProjectDir();
                    if (FileUtil.isAncestor((File)contentRoot, (File)chosenIoFile, (boolean)true) && (relativePath = FileUtil.getRelativePath((File)contentRoot, (File)chosenIoFile)) != null) {
                        String string = relativePath;
                        if (string == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    String string = super.chosenFileToResultingText(chosenFile);
                    if (string == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "chosenFile";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileEditor$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileEditor$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "chosenFileToResultingText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "chosenFileToResultingText";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }

        private void profileNameChanged() {
            this.myParentEditor.profileNameChanged(this);
        }

        private void buildTypeOrToolchainNameChanged(@Nullable String previousBuildType, @Nullable Ref<String> previousToolchainName) {
            String newBuildType = this.getBuildTypeName();
            String newToolchainName = this.getToolchainName();
            if (!this.myUpdating) {
                String currentProfileName = this.getSpecifiedProfileName();
                this.myNameField.setText(CMakeSettings.generateProfileName(currentProfileName, previousBuildType, previousToolchainName, newBuildType, newToolchainName, it -> CMakeConfigurable.this.selectNextProfileName(it, this)));
            }
            this.myNameField.getEmptyText().setText(CMakeSettings.getEffectiveProfileName(null, newBuildType, newToolchainName));
            this.updateCMakeOptionsHint();
        }

        public void updateToolchains() {
            this.resetToolchains(this.getToolchainName());
            this.updateCMakeOptionsHint();
        }

        private void updateCMakeOptionsHint() {
            CMakeSettings.Profile profile2 = this.create();
            CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(profile2.getToolchainName());
            String options = CMakeGenerator.getBuildTypeOption(this.getBuildTypeName()) + " " + StringUtil.join(profile2.getEffectiveGenerationOptionsList(toolchain), (String)" ");
            ((JBTextField)this.myCMakeOptions.getTextField()).getEmptyText().setText(options);
            this.myCMakeOptionsHint.setText(CPPBundle.message("cmake.settings.generationOptions.hint", new Object[0]));
            ((JBTextField)this.myBuildOptionsField.getTextField()).getEmptyText().setText(CMakeSettings.getCurrentDefaultBuildOptions(toolchain));
        }

        private void updateGenerationDirHint(@NotNull String dirName) {
            if (dirName == null) {
                ProfileEditor.$$$reportNull$$$0(1);
            }
            ((JBTextField)this.myGenerationDirField.getTextField()).getEmptyText().setText(dirName);
        }

        @Nullable
        public String getSpecifiedProfileName() {
            return CMakeSettings.normalizeProfileName(this.myNameField.getText());
        }

        @NotNull
        public String getEffectiveProfileName() {
            String string = CMakeSettings.getEffectiveProfileName(this.getSpecifiedProfileName(), this.getBuildTypeName(), this.getToolchainName());
            if (string == null) {
                ProfileEditor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getBuildTypeName() {
            String string = CMakeSettings.normalizeBuildType(String.valueOf(this.myBuildTypeComboBox.getEditor().getItem()));
            if (string == null) {
                ProfileEditor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public String getToolchainName() {
            ToolchainItem item = (ToolchainItem)this.myToolchainComboBox.getSelectedItem();
            return item == null ? null : item.name;
        }

        public void setToolchainName(@Nullable String name2) {
            this.myToolchainComboBox.setSelectedIndex(this.getToolchainsComboBoxNames().indexOf(name2));
        }

        @NotNull
        public List<String> getToolchainsComboBoxNames() {
            ArrayList<String> items = new ArrayList<String>();
            for (int i = 0; i < this.myToolchainComboBox.getItemCount(); ++i) {
                items.add(((ToolchainItem)this.myToolchainComboBox.getItemAt(i)).name);
            }
            ArrayList<String> arrayList = items;
            if (arrayList == null) {
                ProfileEditor.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        public File getGenerationDir() {
            return StringUtil.isEmptyOrSpaces((String)this.myGenerationDirField.getText()) ? null : new File(this.myGenerationDirField.getText());
        }

        public boolean isModified(@NotNull CMakeSettings.Profile profile2) {
            File file;
            if (profile2 == null) {
                ProfileEditor.$$$reportNull$$$0(5);
            }
            if (!StringUtil.equals((CharSequence)profile2.getName(), (CharSequence)this.getEffectiveProfileName())) {
                return true;
            }
            if (!StringUtil.equals((CharSequence)profile2.getBuildType(), (CharSequence)this.getBuildTypeName())) {
                return true;
            }
            if (!StringUtil.equals((CharSequence)profile2.getBuildType(), (CharSequence)this.getBuildTypeName())) {
                return true;
            }
            if (!StringUtil.equals((CharSequence)profile2.getToolchainName(), (CharSequence)this.getToolchainName())) {
                return true;
            }
            if (!StringUtil.equals((CharSequence)profile2.getGenerationOptions(), (CharSequence)CMakeSettings.normalizeOptions(this.myCMakeOptions.getText()))) {
                return true;
            }
            if (profile2.getPassSystemEnvironment() != this.myEnvironmentField.isPassParentEnvs()) {
                return true;
            }
            if (!profile2.getAdditionalEnvironment().equals(CMakeSettings.normalizeEnvironment(this.myEnvironmentField.getEnvs()))) {
                return true;
            }
            File file2 = file = StringUtil.isEmptyOrSpaces((String)this.myGenerationDirField.getText()) ? null : new File(this.myGenerationDirField.getText());
            if (!FileUtil.filesEqual((File)profile2.getGenerationDir(), (File)file)) {
                return true;
            }
            return !StringUtil.equals((CharSequence)profile2.getBuildOptions(), (CharSequence)CMakeSettings.normalizeOptions(this.myBuildOptionsField.getText()));
        }

        @NotNull
        public CMakeSettings.Profile create() {
            CMakeSettings.Profile profile2 = new CMakeSettings.Profile(this.getEffectiveProfileName(), this.getBuildTypeName(), this.getToolchainName(), this.myCMakeOptions.getText(), this.myEnvironmentField.isPassParentEnvs(), CMakeSettings.normalizeEnvironment(this.myEnvironmentField.getEnvs()), this.getGenerationDir(), CMakeSettings.normalizeOptions(this.myBuildOptionsField.getText()));
            if (profile2 == null) {
                ProfileEditor.$$$reportNull$$$0(6);
            }
            return profile2;
        }

        public void reset(@NotNull CMakeSettings.Profile profile2) {
            if (profile2 == null) {
                ProfileEditor.$$$reportNull$$$0(7);
            }
            this.myUpdating = true;
            try {
                this.myNameField.setText(profile2.getName());
                this.setComboBoxModelItems(this.myBuildTypeComboBox, profile2.getBuildType(), this.getRegisteredBuildTypesFor(profile2.getName()), Function.identity());
                this.resetToolchains(profile2.getToolchainName());
                this.myCMakeOptions.setText(profile2.getGenerationOptions());
                this.myEnvironmentField.setPassParentEnvs(profile2.getPassSystemEnvironment());
                this.myEnvironmentField.setEnvs(profile2.getAdditionalEnvironment());
                File generationDir = profile2.getGenerationDir();
                this.myGenerationDirField.setText(generationDir == null ? "" : generationDir.getPath());
                this.myBuildOptionsField.setText(profile2.getBuildOptions());
            }
            finally {
                this.myUpdating = false;
            }
            this.profileNameChanged();
            this.updateCMakeOptionsHint();
        }

        private void resetToolchains(@Nullable String currentSelectedToolchain) {
            ToolchainItem selectedItem;
            List toolchainNames = ContainerUtil.prepend((List)this.myParentEditor.myCurrentToolchainNames, (Object[])new String[]{null});
            List toolchainItems = ContainerUtil.map((Collection)toolchainNames, name2 -> new ToolchainItem((String)name2));
            int currentSelectionIndex = this.myToolchainComboBox.getSelectedIndex();
            int renamedToolchainIndex = this.myParentEditor.myRenamedToolchainIndex;
            if (renamedToolchainIndex > -1 && renamedToolchainIndex == currentSelectionIndex - 1) {
                selectedItem = (ToolchainItem)toolchainItems.get(renamedToolchainIndex + 1);
            } else {
                int index;
                String renamed;
                if (this.myParentEditor.myToolchainRenames != null && (renamed = (String)this.myParentEditor.myToolchainRenames.get(currentSelectedToolchain)) != null) {
                    currentSelectedToolchain = renamed;
                }
                if ((index = toolchainNames.indexOf(currentSelectedToolchain)) > -1) {
                    if (renamedToolchainIndex > -1 && currentSelectionIndex > -1 && currentSelectionIndex < toolchainNames.size()) {
                        index = currentSelectionIndex;
                    }
                    selectedItem = (ToolchainItem)toolchainItems.get(index);
                } else {
                    selectedItem = new ToolchainItem(currentSelectedToolchain);
                }
            }
            this.setComboBoxModelItems(this.myToolchainComboBox, selectedItem, toolchainItems, s -> new ToolchainItem((String)s));
            String defaultToolchainName = (String)ContainerUtil.getFirstItem((List)this.myParentEditor.myCurrentToolchainNames);
            final String defaultToolchainTitle = defaultToolchainName == null ? null : (defaultToolchainName.equalsIgnoreCase(CPPToolchains.Toolchain.DEFAULT) ? "Use " + defaultToolchainName : "Use default: " + defaultToolchainName);
            THashSet toolchainNamesSet = new THashSet((Collection)toolchainNames);
            this.myToolchainComboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ToolchainItem>((Set)toolchainNamesSet){
                final /* synthetic */ Set val$toolchainNamesSet;
                {
                    this.val$toolchainNamesSet = set;
                }

                protected void customizeCellRenderer(@NotNull JList<? extends ToolchainItem> list, ToolchainItem value, int index, boolean selected, boolean hasFocus) {
                    String toolchainName;
                    if (list == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((toolchainName = value.name) == null) {
                        if (defaultToolchainTitle == null) {
                            this.append(CPPBundle.message("cpp.toolchains.empty", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                        } else {
                            this.append(defaultToolchainTitle, StatusText.DEFAULT_ATTRIBUTES);
                        }
                    } else if (!this.val$toolchainNamesSet.contains(toolchainName)) {
                        this.append(toolchainName + " (not found)", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else {
                        this.append(toolchainName);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileEditor$3", "customizeCellRenderer"));
                }
            });
        }

        private <T> void setComboBoxModelItems(ComboBox<T> comboBox, T currentItem, List<T> availableItems, Function<String, T> prototypeItemFactory) {
            if (!availableItems.contains(currentItem)) {
                availableItems = ContainerUtil.append(availableItems, (Object[])new Object[]{currentItem});
            }
            comboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(availableItems));
            int maxLength = Math.min(15, availableItems.stream().map(it -> it == null ? 0 : String.valueOf(it).length()).max(Integer::compareTo).orElse(15));
            comboBox.setPrototypeDisplayValue(prototypeItemFactory.apply(StringUtil.repeat((String)"A", (int)maxLength)));
            comboBox.setSelectedItem(currentItem);
        }

        @NotNull
        private List<String> getRegisteredBuildTypesFor(@NotNull String profileName) {
            List<CMakeModelConfigurationData> all;
            CMakeModelConfigurationData data;
            if (profileName == null) {
                ProfileEditor.$$$reportNull$$$0(8);
            }
            if ((data = (CMakeModelConfigurationData)ContainerUtil.find(all = CMakeConfigurable.this.myWorkspace.getModelConfigurationData(), it -> {
                if (profileName == null) {
                    ProfileEditor.$$$reportNull$$$0(10);
                }
                return it.getConfigName().equals(profileName);
            })) == null) {
                data = (CMakeModelConfigurationData)ContainerUtil.getFirstItem(all);
            }
            List<String> list = data == null ? CMakeModel.DEFAULT_BUILD_TYPES : data.getRegisteredBuildTypes();
            if (list == null) {
                ProfileEditor.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        public String toString() {
            return this.getEffectiveProfileName();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myGenerationDirField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileEditor";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveProfileName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildTypeName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolchainsComboBoxNames";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegisteredBuildTypesFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateGenerationDirHint";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isModified";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getRegisteredBuildTypesFor";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getRegisteredBuildTypesFor$4";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class ProfileListEditor
    extends JPanel {
        @NotNull
        private final CollectionListModel<ProfileEditor> myEditors;
        private final JBList<ProfileEditor> myList;
        private final JBSplitter mySplitter;
        private final JBPanelWithEmptyText myNoEditorsPanel;
        private final DetailsEditorHelper myDetailsEditorHelper;
        boolean myUpdating;
        private Map<String, String> myToolchainRenames;
        private int myRenamedToolchainIndex;
        private List<String> myCurrentToolchainNames;

        public ProfileListEditor() {
            super(new BorderLayout());
            this.myEditors = new CollectionListModel((Object[])new ProfileEditor[0]);
            this.myToolchainRenames = null;
            this.myRenamedToolchainIndex = -1;
            this.updateToolchains(CPPToolchains.getInstance().getToolchains(), ContainerUtil.emptyList());
            this.mySplitter = new OnePixelSplitter(false, 0.2f);
            this.mySplitter.setSplitterProportionKey("CMakeConfigurable.configurations");
            this.mySplitter.setHonorComponentsMinimumSize(true);
            this.myList = new JBList(this.myEditors);
            this.myDetailsEditorHelper = new DetailsEditorHelper(this.myList, this.myEditors, CMakeConfigurable.this.myPreselectedProfile, runnable2 -> {
                this.myUpdating = true;
                try {
                    runnable2.run();
                }
                finally {
                    this.myUpdating = false;
                }
                this.updateProfileNamesAndHints();
            });
            ToolbarDecorator.ElementActionButton copyAction2 = new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), AllIcons.Actions.Copy){

                public boolean isDumbAware() {
                    return true;
                }

                public void actionPerformed(AnActionEvent e) {
                    ProfileListEditor.this.performAddOrCopy(((ProfileEditor)ProfileListEditor.this.myEditors.getElementAt(ProfileListEditor.this.myList.getSelectedIndex())).create());
                }
            };
            copyAction2.setShortcut(CommonShortcuts.getDuplicate());
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    ProfileListEditor.this.performAddOrCopy(null);
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    ProfileListEditor.this.myDetailsEditorHelper.restoreSelectionAfter(() -> ProfileListEditor.this.myEditors.remove(ProfileListEditor.this.myList.getSelectedIndex()));
                }
            }).addExtraAction((AnActionButton)copyAction2).setButtonComparator(new String[]{CommonActionsPanel.Buttons.ADD.getText(), CommonActionsPanel.Buttons.REMOVE.getText(), copyAction2.getTemplatePresentation().getText()}).setPanelBorder(IdeBorderFactory.createBorder((int)11));
            if (!SystemInfo.isMac) {
                decorator.setToolbarPosition(ActionToolbarPosition.TOP);
            }
            this.mySplitter.setFirstComponent((JComponent)decorator.createPanel());
            this.myNoEditorsPanel = new JBPanelWithEmptyText();
            ProfileEditor prototypeEditor = new ProfileEditor(this);
            prototypeEditor.reset(new CMakeSettings.Profile());
            this.myNoEditorsPanel.getEmptyText().setText(CPPBundle.message("cmake.settings.profile.empty", new Object[0]));
            this.myList.getEmptyText().setText(CPPBundle.message("cmake.settings.profile.empty", new Object[0]));
            this.myList.setSelectionMode(0);
            this.myList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ProfileListEditor.this.updateSelectedEditor();
                }
            });
            this.myEditors.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    ProfileListEditor.this.updateProfileNamesAndHints();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    ProfileListEditor.this.updateProfileNamesAndHints();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    ProfileListEditor.this.updateProfileNamesAndHints();
                }
            });
            this.updateSelectedEditor();
            this.add((Component)this.mySplitter);
        }

        public void updateSelectedEditor() {
            int index = this.myList.getSelectedIndex();
            if (index >= 0) {
                this.mySplitter.setSecondComponent((JComponent)this.myEditors.getElementAt(index));
            } else {
                this.mySplitter.setSecondComponent((JComponent)this.myNoEditorsPanel);
            }
        }

        public void updateToolchains(List<CPPToolchains.Toolchain> toolchains, List<Pair<String, String>> renames) {
            this.myToolchainRenames = ContainerUtil.map2Map(renames);
            try {
                this.doUpdateToolchains(ContainerUtil.map(toolchains, it -> it.getName()));
            }
            finally {
                this.myToolchainRenames = null;
            }
        }

        public void renameToolchain(int index, @NotNull String newName) {
            if (newName == null) {
                ProfileListEditor.$$$reportNull$$$0(0);
            }
            try {
                this.myRenamedToolchainIndex = index;
                this.myCurrentToolchainNames.set(index, newName);
                this.doUpdateToolchains(this.myCurrentToolchainNames);
            }
            finally {
                this.myRenamedToolchainIndex = -1;
            }
        }

        public void doUpdateToolchains(@NotNull List<String> toolchainNames) {
            if (toolchainNames == null) {
                ProfileListEditor.$$$reportNull$$$0(1);
            }
            this.myCurrentToolchainNames = toolchainNames;
            this.getEditors().forEach(it -> it.updateToolchains());
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.myEditors != null) {
                this.getEditors().forEach(SwingUtilities::updateComponentTreeUI);
            }
        }

        public void dispose() {
            this.getEditors().forEach(ProfileEditor::dispose);
        }

        @NotNull
        public List<ProfileEditor> getEditors() {
            List list = this.myEditors.getItems();
            if (list == null) {
                ProfileListEditor.$$$reportNull$$$0(2);
            }
            return list;
        }

        public boolean isModified(List<CMakeSettings.Profile> profiles) {
            if (this.myEditors.getSize() != profiles.size()) {
                return true;
            }
            for (int i = 0; i < profiles.size(); ++i) {
                if (!((ProfileEditor)this.myEditors.getElementAt(i)).isModified(profiles.get(i))) continue;
                return true;
            }
            return false;
        }

        public List<CMakeSettings.Profile> apply() {
            return ContainerUtil.map(this.getEditors(), it -> it.create());
        }

        public void reset(List<CMakeSettings.Profile> profiles) {
            this.myDetailsEditorHelper.restoreSelectionAfter(() -> {
                int i;
                for (i = 0; i < Math.min(profiles.size(), this.myEditors.getSize()); ++i) {
                    ((ProfileEditor)this.myEditors.getElementAt(i)).reset((CMakeSettings.Profile)profiles.get(i));
                }
                if (profiles.size() > this.myEditors.getSize()) {
                    for (i = this.myEditors.getSize(); i < profiles.size(); ++i) {
                        this.addProfileEditor((CMakeSettings.Profile)profiles.get(i));
                    }
                } else if (profiles.size() < this.myEditors.getSize()) {
                    this.myEditors.removeRange(profiles.size(), this.myEditors.getSize() - 1);
                }
            });
        }

        private void updateProfileNamesAndHints() {
            if (this.myUpdating) {
                return;
            }
            List<ProfileEditor> editors = this.getEditors();
            List<String> names = CMakeWorkspace.getProfileGenerationDirNames(ContainerUtil.map(editors, it -> it.getEffectiveProfileName()));
            ContainerUtil.zip(editors, names).forEach(it -> ((ProfileEditor)it.first).updateGenerationDirHint((String)it.second));
        }

        private void performAddOrCopy(@Nullable CMakeSettings.Profile toCopy) {
            this.myDetailsEditorHelper.restoreSelectionAfter(() -> {
                ProfileEditor editor = this.addProfileEditor(this.createNewProfile(toCopy));
                this.myList.setSelectedIndex(this.myEditors.getElementIndex((Object)editor));
            });
        }

        @NotNull
        private CMakeSettings.Profile createNewProfile(@Nullable CMakeSettings.Profile template) {
            if (template == null) {
                template = new CMakeSettings.Profile(CMakeConfigurable.selectNextBuildType(CMakeConfigurable.this.myWorkspace.getModelConfigurationData(), ContainerUtil.map(this.getEditors(), it -> it.getBuildTypeName())));
            }
            CMakeSettings.Profile profile2 = template.withName(CMakeConfigurable.this.selectNextProfileName(template.getName(), null));
            if (profile2 == null) {
                ProfileListEditor.$$$reportNull$$$0(3);
            }
            return profile2;
        }

        @NotNull
        private ProfileEditor addProfileEditor(@NotNull CMakeSettings.Profile profile2) {
            if (profile2 == null) {
                ProfileListEditor.$$$reportNull$$$0(4);
            }
            ProfileEditor editor = new ProfileEditor(this);
            editor.reset(profile2);
            this.myEditors.add((Object)editor);
            ProfileEditor profileEditor = editor;
            if (profileEditor == null) {
                ProfileListEditor.$$$reportNull$$$0(5);
            }
            return profileEditor;
        }

        public void profileNameChanged(@NotNull ProfileEditor editor) {
            int index;
            if (editor == null) {
                ProfileListEditor.$$$reportNull$$$0(6);
            }
            if ((index = this.myEditors.getElementIndex((Object)editor)) != -1) {
                this.myEditors.setElementAt((Object)editor, index);
            }
        }

        @Nullable
        public File getEffectiveGenerationDir(@NotNull ProfileEditor editor) {
            int index;
            if (editor == null) {
                ProfileListEditor.$$$reportNull$$$0(7);
            }
            if ((index = this.myEditors.getElementIndex((Object)editor)) == -1) {
                return null;
            }
            List<File> dirs = CMakeConfigurable.this.myWorkspace.getEffectiveProfileGenerationDirs(ContainerUtil.map(this.getEditors(), it -> Pair.create((Object)it.getEffectiveProfileName(), (Object)it.getGenerationDir())));
            return dirs.get(index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolchainNames";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileListEditor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/settings/CMakeConfigurable$ProfileListEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewProfile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addProfileEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "renameToolchain";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "doUpdateToolchains";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addProfileEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "profileNameChanged";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getEffectiveGenerationDir";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

