/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.cmake.actions.LoadCMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceWatcher;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeNotificationProvider
extends EditorNotifications.Provider
implements DumbAware {
    private final Project myProject;
    private final CMakeWorkspace myWorkspace;
    static final Key KEY = Key.create((String)"CMakeNotificationProvider");

    public CMakeNotificationProvider(@NotNull Project project2) {
        if (project2 == null) {
            CMakeNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myWorkspace = CMakeWorkspace.getInstance(project2);
    }

    @NotNull
    public Key getKey() {
        Key key = KEY;
        if (key == null) {
            CMakeNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            CMakeNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            CMakeNotificationProvider.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myProject);
        VirtualFile contentRoot = rootManager.getFileIndex().getContentRootForFile(file);
        if (contentRoot == null) {
            return null;
        }
        if (contentRoot.equals(file) && rootManager.getContentRoots().length == 1) {
            return null;
        }
        if (!CMakeWorkspace.getInstance(this.myProject).isInitialized()) {
            if (FileUtil.namesEqual((String)file.getName(), (String)"CMakeLists.txt")) {
                EditorNotificationPanel panel = new EditorNotificationPanel();
                panel.setText(CPPBundle.message("cmake.loadCMakeNotification.text", new Object[0]));
                panel.createActionLabel(CPPBundle.message("cmake.loadCMakeNotification.action.load", new Object[0]), "CMake.LoadCMakeProject");
                return panel;
            }
            if (file.getFileType() == OCFileType.INSTANCE && OCWorkspace.getInstance(this.myProject).getConfigurations().isEmpty()) {
                EditorNotificationPanel panel = new EditorNotificationPanel();
                panel.setText(CPPBundle.message("cmake.loadCMakeNotification.text", new Object[0]));
                panel.createActionLabel(CPPBundle.message("cmake.loadCMakeNotification.action.select", new Object[0]), () -> LoadCMakeProjectAction.selectAndLoadCMakeProject(this.myProject));
                return panel;
            }
        } else if (this.myProject.getUserData(CMakeWorkspaceWatcher.NEEDS_RELOAD) != null && this.myWorkspace.getCMakeDependencyFiles().contains(VfsUtilCore.virtualToIoFile((VirtualFile)file))) {
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(CPPBundle.message("cmake.autoReloadNotification.text", new Object[0]));
            panel.createActionLabel(CPPBundle.message("cmake.autoReloadNotification.reloadChanges", new Object[0]), "CMake.ReloadCMakeProject");
            panel.createActionLabel(CPPBundle.message("cmake.autoReloadNotification.enableAutoReload", new Object[0]), "CMake.ToggleCMakeAutoReload");
            return panel;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

