/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ContentsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.actions.EditCMakeCacheAction;
import com.jetbrains.cidr.cpp.cmake.actions.OpenCMakeSettingsAction;
import com.jetbrains.cidr.cpp.cmake.actions.ShowCMakeGeneratedDirAction;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleBuilder;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleViewImpl;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import icons.CLionIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeOutputConsole {
    private static final Key<String> CONSOLE_INDEX = Key.create((String)"CONSOLE_INDEX");
    private static final Key<String> CONSOLE_TITLE = Key.create((String)"CONSOLE_TITLE");
    private static final Key<File> CONSOLE_GENERATION_DIR = Key.create((String)"CONSOLE_GENERATION_DIR");
    private static final Key<ProcessHandler> CONSOLE_PROCESS_HANDLER = Key.create((String)"CONSOLE_PROCESS_HANDLER");
    private static final Key<List<CMakeMessage>> CONSOLE_MESSAGES = Key.create((String)"CONSOLE_MESSAGES");
    private static final Key<String> MESSAGES_COLLECTED = Key.create((String)"MESSAGES_COLLECTED");
    private static final Key<String> CURRENT_MESSAGE_TYPE = Key.create((String)"MESSAGE_TYPE");
    private static final Key<?> CONSOLE_HISTORY_KEY = Key.create((String)"CONSOLE_HISTORY_KEY");
    public static final String HELP_ID = "Cmake_Output";
    private final Project myProject;
    private MessageBusConnection myConnection;
    @Nullable
    private ContentManager myContentManager;
    private boolean isOnceActivated;
    @Nullable
    private ProgressIndicator myCurrentReloadingIndicator;

    public CMakeOutputConsole(Project project2) {
        this.myProject = project2;
    }

    void listenForChanges() {
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            @Override
            public void reloadingFinished(boolean canceled) {
                CMakeOutputConsole.this.reloadingFinished(canceled);
            }
        });
        ToolWindow tw = CMakeWorkspace.getToolWindow(this.myProject);
        this.myContentManager = tw == null ? null : tw.getContentManager();
    }

    void shutdown() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
            this.myContentManager = null;
        }
    }

    public void updateTabs(@Nullable File sourceDir, @NotNull List<CMakeProfileInfo> profileInfos) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(0);
        }
        this.updateTabs(sourceDir, profileInfos, null);
    }

    private void updateTabs(@Nullable File sourceDir, @NotNull List<CMakeProfileInfo> profileInfos, @Nullable Runnable ifCreated) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(1);
        }
        this.invokeLater(() -> {
            Content[] contents;
            if (profileInfos == null) {
                CMakeOutputConsole.$$$reportNull$$$0(38);
            }
            StopCMakeReloadAction stopAction = new StopCMakeReloadAction();
            ContentManager contentManager = this.getContentManager();
            if (contentManager == null) {
                return;
            }
            int selectedTabIndex = ArrayUtil.indexOf((Object[])contentManager.getContents(), (Object)contentManager.getSelectedContent());
            contentManager.removeAllContents(true);
            if (profileInfos.isEmpty()) {
                JComponent console = this.doCreateConsole("Output", 0, null, null, null, stopAction);
                ContentImpl content = new ContentImpl(console, "Output", false);
                content.setHelpId(HELP_ID);
                ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (boolean)true);
                this.getConsole(0).print(CPPBundle.message("cmake.console.noProfiles", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                for (int i = 0; i < profileInfos.size(); ++i) {
                    CMakeProfileInfo each = (CMakeProfileInfo)profileInfos.get(i);
                    String title = each.getProfile().getName();
                    JComponent console = this.doCreateConsole(title, i, sourceDir, each.getGenerationDir(), each.getEnvironment(), stopAction);
                    ContentImpl content = new ContentImpl(console, title, false);
                    content.setHelpId(HELP_ID);
                    ContentsUtil.addContent((ContentManager)contentManager, (Content)content, (i == selectedTabIndex ? 1 : 0) != 0);
                }
            }
            for (Content each : contents = contentManager.getContents()) {
                each.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                each.setIcon(CLionIcons.CMake);
            }
            if (ifCreated != null) {
                ifCreated.run();
            }
        });
    }

    public void restoreTabs(@Nullable File sourceDir, @NotNull List<CMakeProfileInfo> profileInfos, boolean loadPreviousOutput) {
        if (profileInfos == null) {
            CMakeOutputConsole.$$$reportNull$$$0(2);
        }
        this.updateTabs(sourceDir, profileInfos, () -> {
            if (profileInfos == null) {
                CMakeOutputConsole.$$$reportNull$$$0(37);
            }
            if (loadPreviousOutput) {
                for (int i = 0; i < profileInfos.size(); ++i) {
                    CMakeOutputConsole.doLoadLogFile(this.getConsole(i), ((CMakeProfileInfo)profileInfos.get(i)).getGenerationDir());
                }
            }
        });
    }

    @NotNull
    private JComponent doCreateConsole(@NotNull String title, int profileIndex, @Nullable File sourceDir, @Nullable File generationDir, @Nullable CidrToolEnvironment environment, @NotNull StopCMakeReloadAction stopAction) {
        if (title == null) {
            CMakeOutputConsole.$$$reportNull$$$0(3);
        }
        if (stopAction == null) {
            CMakeOutputConsole.$$$reportNull$$$0(4);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("CMake.ReloadCMakeProject"));
        group.add((AnAction)stopAction);
        group.addSeparator();
        group.add((AnAction)new EditCMakeCacheAction(generationDir));
        DefaultActionGroup extra = new DefaultActionGroup();
        extra.setPopup(true);
        extra.getTemplatePresentation().setIcon(AllIcons.General.SecondaryGroup);
        extra.add((AnAction)new OpenCMakeSettingsAction(profileIndex));
        extra.add(ActionManager.getInstance().getAction("CMake.ChangeCMakeProjectContentRoot"));
        extra.add((AnAction)new ShowCMakeGeneratedDirAction(generationDir));
        extra.addSeparator();
        extra.add(ActionManager.getInstance().getAction("CMake.ClearCacheAndReload"));
        group.add((AnAction)extra);
        CMakeConsoleBuilder consoleBuilder = new CMakeConsoleBuilder(this.myProject, environment, sourceDir);
        final CMakeConsoleViewImpl console = (CMakeConsoleViewImpl)consoleBuilder.getConsole();
        Disposer.register((Disposable)this.myProject, (Disposable)console);
        console.addMessageListener(new CMakeConsoleViewImpl.MessageListener(){

            @Override
            public void messageReported(@NotNull CMakeConsoleMessageType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                CMakeOutputConsole.this.doUpdateTabIconAndActivate((ConsoleView)console, type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$2", "messageReported"));
            }
        });
        DefaultActionGroup consoleActionGroup = new DefaultActionGroup(console.createConsoleActions());
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBorder(IdeBorderFactory.createBorder((int)4));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar leftToolbar = actionManager.createActionToolbar("CMakeOutputLeft", (ActionGroup)group, false);
        ActionToolbar centerToolbar = actionManager.createActionToolbar("CMakeOutputCenter", (ActionGroup)consoleActionGroup, false);
        toolbarPanel.add((Component)leftToolbar.getComponent(), "West");
        toolbarPanel.add((Component)centerToolbar.getComponent(), "Center");
        JComponent consoleComponent = console.getComponent();
        consoleComponent.add((Component)toolbarPanel, "West");
        consoleComponent.putClientProperty(CONSOLE_INDEX, profileIndex);
        consoleComponent.putClientProperty(CONSOLE_TITLE, title);
        consoleComponent.putClientProperty(CONSOLE_MESSAGES, new ArrayList());
        consoleComponent.putClientProperty(CONSOLE_GENERATION_DIR, generationDir);
        DataProviderPanel dataProviderPanel = new DataProviderPanel(console);
        if (dataProviderPanel == null) {
            CMakeOutputConsole.$$$reportNull$$$0(5);
        }
        return dataProviderPanel;
    }

    private static void doLoadLogFile(final ConsoleView console, @NotNull File logDir) {
        if (logDir == null) {
            CMakeOutputConsole.$$$reportNull$$$0(6);
        }
        ((CMakeConsoleViewImpl)console).dimHighlighting();
        ConsoleViewContentType outputType = ConsoleViewContentType.getConsoleViewType(CONSOLE_HISTORY_KEY);
        try {
            File logFile = CMakeOutputConsole.getOutputLogFile(logDir);
            String text = FileUtilRt.loadFile((File)logFile);
            console.print(text, outputType);
            console.print("\n" + CPPBundle.message("cmake.console.outputRestored", DateFormatUtil.formatDateTime((long)logFile.lastModified())) + "\n", outputType);
        }
        catch (IOException ignore) {
            console.print(CPPBundle.message("cmake.console.noOutput", new Object[0]) + "\n", outputType);
        }
        ((ConsoleViewImpl)console).requestScrollingToEnd();
        ((ConsoleViewImpl)console).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    ((ConsoleViewImpl)console).removeHierarchyListener((HierarchyListener)this);
                    ((ConsoleViewImpl)console).requestScrollingToEnd();
                }
            }
        });
    }

    public void reportMessage(int tabIndex, @NotNull CMakeMessage message) {
        if (message == null) {
            CMakeOutputConsole.$$$reportNull$$$0(7);
        }
        this.reportMessage(tabIndex, message, null);
    }

    public void reportMessage(int tabIndex, @NotNull CMakeMessage message, @Nullable Fix fix) {
        if (message == null) {
            CMakeOutputConsole.$$$reportNull$$$0(8);
        }
        this.doReportMessages(tabIndex, Collections.singletonList(Pair.create((Object)message, (Object)fix)));
    }

    private void doReportMessages(int tabIndex, @NotNull List<Pair<CMakeMessage, Fix>> messagesWithFixes) {
        if (messagesWithFixes == null) {
            CMakeOutputConsole.$$$reportNull$$$0(9);
        }
        this.invokeLater(() -> {
            if (messagesWithFixes == null) {
                CMakeOutputConsole.$$$reportNull$$$0(36);
            }
            for (ConsoleView each : tabIndex == -1 ? this.getConsoles() : Collections.singletonList(this.getConsole(tabIndex))) {
                for (Pair eachMessageWithFix : messagesWithFixes) {
                    CMakeMessage eachMessage = (CMakeMessage)eachMessageWithFix.first;
                    CMakeMessage.MessageLevel level = eachMessage.getLevel();
                    boolean error = level.isError();
                    boolean normalText = level.ordinal() < CMakeMessage.MessageLevel.WARNING.ordinal();
                    each.print(eachMessage.getText(), normalText ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT);
                    final Fix fix = (Fix)eachMessageWithFix.second;
                    if (fix != null) {
                        each.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
                        each.printHyperlink(fix.text, new HyperlinkInfo(){

                            public void navigate(Project project2) {
                                fix.action.run();
                            }
                        });
                    }
                    each.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    this.doUpdateTabIconAndActivate(each, error ? CMakeConsoleMessageType.ERROR : CMakeConsoleMessageType.WARNING);
                }
                CMakeOutputConsole.getConsoleMessages(each).addAll(ContainerUtil.map((Collection)messagesWithFixes, it -> (CMakeMessage)it.first));
            }
        });
    }

    public void attachConsoleToProcess(final int tabIndex, @NotNull ProcessHandler handler) {
        if (handler == null) {
            CMakeOutputConsole.$$$reportNull$$$0(10);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.invokeAndWait(() -> {
                if (handler == null) {
                    CMakeOutputConsole.$$$reportNull$$$0(35);
                }
                ConsoleView console = this.getConsole(tabIndex);
                console.attachToProcess(handler);
                CMakeOutputConsole.setConsoleProcessHandler(console, handler);
            });
        } else {
            this.invokeLater(() -> {
                if (handler == null) {
                    CMakeOutputConsole.$$$reportNull$$$0(34);
                }
                CMakeOutputConsole.setConsoleProcessHandler(this.getConsole(tabIndex), handler);
            });
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    CMakeOutputConsole.this.invokeLater(() -> {
                        if (event == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        CMakeOutputConsole.this.getConsole(tabIndex).print(event.getText(), ConsoleViewContentType.NORMAL_OUTPUT);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onTextAvailable$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public List<Pair<String, List<CMakeMessage>>> getMessages() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (ConsoleView each : this.getConsoles()) {
            List<CMakeMessage> messages = CMakeOutputConsole.getConsoleMessages(each);
            if (each.getComponent().getClientProperty(MESSAGES_COLLECTED) != Boolean.TRUE) {
                messages.addAll(((CMakeConsoleViewImpl)each).finishAndGetMessages());
                each.getComponent().putClientProperty(MESSAGES_COLLECTED, Boolean.TRUE);
            }
            result.add(Pair.create((Object)CMakeOutputConsole.getConsoleTitle(each), Collections.unmodifiableList(messages)));
        }
        return Collections.unmodifiableList(result);
    }

    @NotNull
    private static File getOutputLogFile(@NotNull File outputDir) {
        if (outputDir == null) {
            CMakeOutputConsole.$$$reportNull$$$0(11);
        }
        File file = CMakeGenerator.getCMakeFilesIDEFile(outputDir, "log.txt");
        if (file == null) {
            CMakeOutputConsole.$$$reportNull$$$0(12);
        }
        return file;
    }

    void reloadingStarted(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeOutputConsole.$$$reportNull$$$0(13);
        }
        this.invokeLater(() -> {
            if (indicator == null) {
                CMakeOutputConsole.$$$reportNull$$$0(33);
            }
            this.isOnceActivated = false;
            this.myCurrentReloadingIndicator = indicator;
        });
    }

    void reloadingFinished(final boolean canceled) {
        this.invokeLater(() -> {
            if (this.myCurrentReloadingIndicator == null) {
                return;
            }
            this.myCurrentReloadingIndicator = null;
            final List<ConsoleView> consoles = this.getConsoles();
            final Runnable consoleFinished = new Runnable(){
                int finishedConsoles = 0;

                @Override
                public void run() {
                    if (++this.finishedConsoles < consoles.size()) {
                        return;
                    }
                    boolean hasErrors = ContainerUtil.exists((Iterable)consoles, each -> CMakeOutputConsole.getConsoleMessageType(each) == CMakeConsoleMessageType.ERROR);
                    for (ConsoleView each2 : consoles) {
                        File generationDir = CMakeOutputConsole.getConsoleGenerationDir(each2);
                        if (generationDir == null) continue;
                        if (canceled) {
                            each2.print("\n" + CPPBundle.message("cmake.console.reloadingCanceled", new Object[0]) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                            continue;
                        }
                        File logFile = CMakeOutputConsole.getOutputLogFile(generationDir);
                        try {
                            FileUtil.writeToFile((File)logFile, (String)CMakeOutputConsole.getFlushedConsoleText(each2));
                        }
                        catch (IOException e) {
                            CPPLog.LOG.warn("Can't write CMake log: " + e);
                        }
                        each2.print("\n" + CPPBundle.message(hasErrors ? "cmake.console.reloadingFinishedWithErrors" : "cmake.console.reloadingFinished", new Object[0]) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                }
            };
            for (ConsoleView each : consoles) {
                final Runnable finishOnce = new Runnable(){
                    boolean finished = false;

                    @Override
                    public void run() {
                        if (!this.finished) {
                            this.finished = true;
                            consoleFinished.run();
                        }
                    }
                };
                ProcessHandler handler = CMakeOutputConsole.getConsoleProcessHandler(each);
                if (handler != null) {
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                8.$$$reportNull$$$0(0);
                            }
                            CMakeOutputConsole.this.invokeLater(finishOnce);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$8", "processTerminated"));
                        }
                    });
                }
                if (handler != null && !handler.isProcessTerminated()) continue;
                finishOnce.run();
            }
        });
    }

    private void doUpdateTabIconAndActivate(@NotNull ConsoleView console, @NotNull CMakeConsoleMessageType type) {
        ContentManager manager;
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(14);
        }
        if (type == null) {
            CMakeOutputConsole.$$$reportNull$$$0(15);
        }
        if ((manager = this.getContentManager()) == null) {
            return;
        }
        Content content = manager.getContent(CMakeOutputConsole.getConsoleIndex(console));
        assert (content != null);
        CMakeConsoleMessageType currentType = CMakeOutputConsole.getConsoleMessageType(console);
        if (currentType == null || currentType.getLevel() < type.getLevel()) {
            CMakeOutputConsole.setConsoleMessageType(console, type);
            Icon icon = type == CMakeConsoleMessageType.ERROR ? AllIcons.General.BalloonError : AllIcons.General.BalloonWarning;
            content.setIcon(icon);
        }
        if (!this.isOnceActivated) {
            this.isOnceActivated = true;
            manager.setSelectedContent(content, false);
            ToolWindow tw = CMakeWorkspace.getToolWindow(this.myProject);
            if (tw != null) {
                tw.activate(null, false, false);
            }
        }
    }

    @Nullable
    private ContentManager getContentManager() {
        return this.myContentManager;
    }

    @NotNull
    private ConsoleView getConsole(int index) {
        List<ConsoleView> consoles = this.getConsoles();
        if (index >= consoles.size()) {
            throw new AssertionError((Object)("Console " + index + " not available among " + ContainerUtil.map(consoles, each -> CMakeOutputConsole.getConsoleTitle(each))));
        }
        ConsoleView consoleView = consoles.get(index);
        if (consoleView == null) {
            CMakeOutputConsole.$$$reportNull$$$0(16);
        }
        return consoleView;
    }

    @NotNull
    public List<ConsoleView> getConsoles() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            List<ConsoleView> list = Collections.emptyList();
            if (list == null) {
                CMakeOutputConsole.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])contentManager.getContents(), it -> ((DataProviderPanel)it.getComponent()).getConsole());
        if (list == null) {
            CMakeOutputConsole.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static int getConsoleIndex(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(19);
        }
        return (Integer)each.getComponent().getClientProperty(CONSOLE_INDEX);
    }

    @NotNull
    public static String getConsoleTitle(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(20);
        }
        String string = (String)each.getComponent().getClientProperty(CONSOLE_TITLE);
        if (string == null) {
            CMakeOutputConsole.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public static File getConsoleGenerationDir(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(22);
        }
        return (File)each.getComponent().getClientProperty(CONSOLE_GENERATION_DIR);
    }

    @Nullable
    private static ProcessHandler getConsoleProcessHandler(@NotNull ConsoleView each) {
        if (each == null) {
            CMakeOutputConsole.$$$reportNull$$$0(23);
        }
        return (ProcessHandler)each.getComponent().getClientProperty(CONSOLE_PROCESS_HANDLER);
    }

    private static void setConsoleProcessHandler(@NotNull ConsoleView consle, @NotNull ProcessHandler handler) {
        if (consle == null) {
            CMakeOutputConsole.$$$reportNull$$$0(24);
        }
        if (handler == null) {
            CMakeOutputConsole.$$$reportNull$$$0(25);
        }
        consle.getComponent().putClientProperty(CONSOLE_PROCESS_HANDLER, handler);
    }

    @NotNull
    public static String getFlushedConsoleText(@NotNull ConsoleView console) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(26);
        }
        ConsoleViewImpl impl = (ConsoleViewImpl)console;
        impl.flushDeferredText();
        String string = impl.getText();
        if (string == null) {
            CMakeOutputConsole.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static List<CMakeMessage> getConsoleMessages(@NotNull ConsoleView console) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(28);
        }
        List list = (List)console.getComponent().getClientProperty(CONSOLE_MESSAGES);
        if (list == null) {
            CMakeOutputConsole.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Nullable
    private static CMakeConsoleMessageType getConsoleMessageType(@NotNull ConsoleView console) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(30);
        }
        return (CMakeConsoleMessageType)((Object)console.getComponent().getClientProperty(CURRENT_MESSAGE_TYPE));
    }

    private static void setConsoleMessageType(@NotNull ConsoleView console, @NotNull CMakeConsoleMessageType type) {
        if (console == null) {
            CMakeOutputConsole.$$$reportNull$$$0(31);
        }
        if (type == null) {
            CMakeOutputConsole.$$$reportNull$$$0(32);
        }
        console.getComponent().putClientProperty(CURRENT_MESSAGE_TYPE, (Object)type);
    }

    private void invokeAndWait(Runnable runnable2) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            runnable2.run();
        }, ModalityState.any());
    }

    private void invokeLater(Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            runnable2.run();
        }, ModalityState.any());
    }

    static {
        ConsoleViewContentType.registerNewConsoleViewType(CONSOLE_HISTORY_KEY, (TextAttributesKey)ConsoleViewContentType.LOG_EXPIRED_ENTRY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAction";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDir";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesWithFixes";
                break;
            }
            case 10: 
            case 25: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsole";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputLogFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleTitle";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlushedConsoleText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateTabs";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreTabs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsole";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLogFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doReportMessages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "attachConsoleToProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOutputLogFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reloadingStarted";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateTabIconAndActivate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleTitle";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleGenerationDir";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleProcessHandler";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleProcessHandler";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFlushedConsoleText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleMessages";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleMessageType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleMessageType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reloadingStarted$6";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$attachConsoleToProcess$5";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$attachConsoleToProcess$4";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doReportMessages$3";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restoreTabs$1";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateTabs$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StopCMakeReloadAction
    extends DumbAwareAction {
        public StopCMakeReloadAction() {
            super(CPPBundle.message("cmake.action.stopReload", new Object[0]), null, AllIcons.Actions.Suspend);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(CMakeOutputConsole.this.myCurrentReloadingIndicator != null && CMakeOutputConsole.this.myCurrentReloadingIndicator.isRunning());
        }

        public void actionPerformed(AnActionEvent e) {
            if (CMakeOutputConsole.this.myCurrentReloadingIndicator != null) {
                CMakeOutputConsole.this.myCurrentReloadingIndicator.cancel();
            }
        }
    }

    private static class DataProviderPanel
    extends JPanel
    implements DataProvider {
        private final CMakeConsoleViewImpl myConsole;

        private DataProviderPanel(CMakeConsoleViewImpl c) {
            super(new BorderLayout());
            this.myConsole = c;
            this.add((Component)((Object)c), "Center");
        }

        @NotNull
        public CMakeConsoleViewImpl getConsole() {
            CMakeConsoleViewImpl cMakeConsoleViewImpl = this.myConsole;
            if (cMakeConsoleViewImpl == null) {
                DataProviderPanel.$$$reportNull$$$0(0);
            }
            return cMakeConsoleViewImpl;
        }

        @Nullable
        public Object getData(String dataId) {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return CMakeOutputConsole.HELP_ID;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$DataProviderPanel", "getConsole"));
        }
    }

    public static class Fix {
        @NotNull
        private final String text;
        @NotNull
        private final Runnable action;

        public Fix(@NotNull String text, @NotNull Runnable action) {
            if (text == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (action == null) {
                Fix.$$$reportNull$$$0(1);
            }
            this.text = text;
            this.action = action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeOutputConsole$Fix";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

