/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.CPPModuleType;
import com.jetbrains.cidr.cpp.CPPSettingsUtil;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectOpenProcessor;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.CMakeSettingsListener;
import com.jetbrains.cidr.cpp.cmake.actions.ChangeCMakeProjectContentRootAction;
import com.jetbrains.cidr.cpp.cmake.actions.LoadCMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.actions.OpenCMakeSettingsAction;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeFile;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeOutputConsole;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceWatcher;
import com.jetbrains.cidr.cpp.cmake.workspace.FileStamp;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsListener;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.project.CidrNotInProjectNotification;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.project.CidrRootConfigurationListener;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import icons.CLionIcons;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.zip.CRC32;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.jvm.functions.Function4;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CMakeWorkspace")
public final class CMakeWorkspace
implements PersistentStateComponent<Element>,
ProjectComponent {
    private static final Key<Boolean> FORCE_RELOAD_ON_OPENING = Key.create((String)"FORCE_RELOAD_ON_OPENING");
    private static final int SERIALIZATION_VERSION = 108002;
    public static final String TOOLWINDOW_ID = "CMake";
    @Nullable
    private static Boolean ourSkipReloadOnProjectOpenInTests;
    @Nullable
    private static Boolean ourForceUseStandardDirForGenerationInTests;
    @Nullable
    private static BalloonNotifier ourBalloonNotifier;
    @Nullable
    private static Function4<Project, CMakeSettings.Profile, EnvironmentProblems, Boolean, CMakeEnvironment> ourEnvironmentFactory;
    @Nullable
    private static Consumer<CMakeSettings> ourSettingsConfigurator;
    @Nullable
    private static Function<CMakeGenerator.Parameters, CMakeGenerator.Parameters> ourGenerationParametersConfigurator;
    @Nullable
    private static Pair<Integer, Integer> ourPauseOnReloadInTests;
    private static final AtomicInteger ourReloadsCounter;
    private static final Ref<Boolean> ourCheckCachesValidity;
    @NotNull
    private final Project myProject;
    private final Disposable myBusConnectionDisposable;
    private volatile boolean myStateWasLoaded;
    private final AtomicBoolean myInitialized;
    @Nullable
    private volatile File myProjectDir;
    @NotNull
    private volatile State myState;
    private volatile boolean myClearGeneratedFilesBeforeReload;
    @Nullable
    private volatile File myContentRoot;
    private volatile boolean myReportFilesOutsideRoots;
    private volatile boolean myIgnoreFilesOutsideOfProjectRoot;
    @NotNull
    private final CMakeSettings mySettings;
    @NotNull
    private final MyRootsSynchronizer myRootsSynchronizer;
    @NotNull
    private final CMakeWorkspaceWatcher myWorkspaceWatcher;
    private volatile CMakeOutputConsole myOutputConsole;
    boolean myUpdateContentRootsRecursionProtection;

    public static void setSkipReloadOnProjectOpenInTests(@Nullable Boolean value) {
        ourSkipReloadOnProjectOpenInTests = value;
    }

    public static void setForceUseStandardDirForGenerationInTests(@Nullable Boolean value) {
        ourForceUseStandardDirForGenerationInTests = value;
    }

    public static void setBalloonNotifierInTests(@Nullable BalloonNotifier notifier) {
        ourBalloonNotifier = notifier;
    }

    public static void setEnvironmentFactoryInTests(@Nullable Function4<Project, CMakeSettings.Profile, EnvironmentProblems, Boolean, CMakeEnvironment> factory2) {
        ourEnvironmentFactory = factory2;
    }

    public static void setSettingsConfiguratorInTests(@Nullable Consumer<CMakeSettings> configurator) {
        ourSettingsConfigurator = configurator;
    }

    @Nullable
    public static Consumer<CMakeSettings> getSettingsConfiguratorInTests() {
        return ourSettingsConfigurator;
    }

    public static void setGenerationParametersConfigurator(@Nullable Function<CMakeGenerator.Parameters, CMakeGenerator.Parameters> configurator) {
        ourGenerationParametersConfigurator = configurator;
    }

    public static void setPauseOnReloadInTests(@Nullable Pair<Integer, Integer> value) {
        ourPauseOnReloadInTests = value;
    }

    public static int getReloadsCounter() {
        return ourReloadsCounter.get();
    }

    public static void clearTestSettings() {
        ourSkipReloadOnProjectOpenInTests = null;
        ourForceUseStandardDirForGenerationInTests = null;
        ourBalloonNotifier = null;
        ourEnvironmentFactory = null;
        ourSettingsConfigurator = null;
        ourGenerationParametersConfigurator = null;
        ourPauseOnReloadInTests = null;
    }

    @NotNull
    public static CMakeWorkspace getInstance(@NotNull Project project2) {
        if (project2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(0);
        }
        CMakeWorkspace cMakeWorkspace = (CMakeWorkspace)project2.getComponent(CMakeWorkspace.class);
        if (cMakeWorkspace == null) {
            CMakeWorkspace.$$$reportNull$$$0(1);
        }
        return cMakeWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMakeWorkspace(@NotNull Project project2) {
        if (project2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(2);
        }
        this.myBusConnectionDisposable = Disposer.newDisposable();
        this.myStateWasLoaded = false;
        this.myInitialized = new AtomicBoolean(false);
        this.myState = this.createInitialState(null);
        this.myClearGeneratedFilesBeforeReload = false;
        this.myProject = project2;
        this.mySettings = CMakeSettings.getInstance(project2);
        if (!CMakeWorkspace.shouldLoadForProject(project2)) {
            this.myRootsSynchronizer = null;
            this.myWorkspaceWatcher = null;
            return;
        }
        Ref<Boolean> ref = ourCheckCachesValidity;
        synchronized (ref) {
            if (((Boolean)ourCheckCachesValidity.get()).booleanValue()) {
                ourCheckCachesValidity.set((Object)false);
                if (CMakeWorkspace.getBrokenMarkerFile().exists() && !FileUtil.delete((File)CMakeWorkspace.getBaseCacheDir().toFile())) {
                    CPPLog.LOG.warn("Cannot delete invalidated CMake generation dir");
                }
            }
        }
        this.myRootsSynchronizer = new MyRootsSynchronizer(project2);
        this.myWorkspaceWatcher = new CMakeWorkspaceWatcher(project2, this);
    }

    @NotNull
    private static ModuleType getModuleType() {
        ModuleType moduleType = CPPModuleType.getInstance();
        if (moduleType == null) {
            CMakeWorkspace.$$$reportNull$$$0(3);
        }
        return moduleType;
    }

    static boolean shouldLoadForProject(Project project2) {
        return !project2.isDefault() && !ProjectManagerImpl.isLight((Project)project2);
    }

    public static void invalidateCaches() {
        FileUtil.createIfDoesntExist((File)CMakeWorkspace.getBrokenMarkerFile());
    }

    @NotNull
    private static File getBrokenMarkerFile() {
        File file = CMakeWorkspace.getBaseCacheDir().resolve(".broken").toFile();
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(4);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCheckCachesValidity(boolean value) {
        Ref<Boolean> ref = ourCheckCachesValidity;
        synchronized (ref) {
            ourCheckCachesValidity.set((Object)value);
        }
    }

    public static void forceReloadOnOpening(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(5);
        }
        baseDir.putUserData(FORCE_RELOAD_ON_OPENING, (Object)true);
    }

    public void projectOpened() {
        CMakeProjectOpenProcessor.OpenProjectSpec openSpec;
        if (!CMakeWorkspace.shouldLoadForProject(this.myProject)) {
            return;
        }
        if (this.myRootsSynchronizer.getModule() == null) {
            return;
        }
        if (ourSettingsConfigurator != null) {
            ourSettingsConfigurator.consume((Object)this.getSettings());
            ourSettingsConfigurator = null;
        }
        ReloadFlag reloadFlag = ReloadFlag.RELOAD_ONLY_WHEN_CHANGED_PLUS_FULL_CHECK_ENVIRONMENT;
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            if (baseDir.getUserData(FORCE_RELOAD_ON_OPENING) == Boolean.TRUE) {
                reloadFlag = ReloadFlag.FORCE_RELOAD;
            }
            baseDir.putUserData(FORCE_RELOAD_ON_OPENING, null);
        }
        if ((openSpec = CMakeWorkspace.getAndClearSourceAndGenerationDirToOpen(this.myProject)) != null) {
            this.myProjectDir = openSpec.sourceDir;
            this.myState = this.createInitialState(this.myProjectDir);
            reloadFlag = ReloadFlag.FORCE_RELOAD;
            this.updateSettingsFromOpenSpec(openSpec);
        }
        if (ourSkipReloadOnProjectOpenInTests == Boolean.TRUE) {
            reloadFlag = null;
        }
        if (this.myProjectDir != null) {
            this.initialize(reloadFlag, true);
        }
    }

    private void initialize(@Nullable ReloadFlag reloadFlagOrNullForNoReload, boolean projectOpening) {
        if (this.myInitialized.getAndSet(true)) {
            return;
        }
        if (projectOpening) {
            ApplicationManager.getApplication().runWriteAction(this::updateContentRoots);
        }
        this.initToolWindow(this.myStateWasLoaded && reloadFlagOrNullForNoReload != ReloadFlag.FORCE_RELOAD);
        this.myStateWasLoaded = false;
        this.listenForChanges();
        if (reloadFlagOrNullForNoReload != null) {
            this.scheduleReload(reloadFlagOrNullForNoReload);
        }
    }

    public void projectClosed() {
        if (!CMakeWorkspace.shouldLoadForProject(this.myProject)) {
            return;
        }
        this.shutdown(true);
    }

    public boolean isInitialized() {
        return this.myInitialized.get();
    }

    private void updateSettingsFromOpenSpec(@NotNull CMakeProjectOpenProcessor.OpenProjectSpec openSpec) {
        if (openSpec == null) {
            CMakeWorkspace.$$$reportNull$$$0(6);
        }
        if (openSpec.generationDir != null) {
            File normalizedGenerationDir = openSpec.isInSourceGeneration() ? new File(".") : openSpec.generationDir;
            this.getSettings().setProfiles(Collections.singletonList(new CMakeSettings.Profile(openSpec.buildType).withGenerationDir(normalizedGenerationDir)));
        }
    }

    @Nullable
    private static CMakeProjectOpenProcessor.OpenProjectSpec getAndClearSourceAndGenerationDirToOpen(@NotNull Project project2) {
        if (project2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(7);
        }
        return CMakeProjectOpenProcessor.getHelper().getAndClearFileToOpenData(project2);
    }

    private void listenForChanges() {
        Disposer.register((Disposable)this.myProject, (Disposable)this.myBusConnectionDisposable);
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect(this.myBusConnectionDisposable);
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this.myBusConnectionDisposable);
        appConnection.subscribe(CPPToolchainsListener.TOPIC, (Object)new CPPToolchainsListener(){

            @Override
            public void toolchainCMakeEnvironmentChanged(@NotNull List<CPPToolchains.Toolchain> toolchain) {
                if (toolchain == null) {
                    1.$$$reportNull$$$0(0);
                }
                CMakeWorkspace.this.scheduleReload(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolchain", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$1", "toolchainCMakeEnvironmentChanged"));
            }
        });
        connection.subscribe(CMakeSettingsListener.Companion.getTOPIC(), (Object)new CMakeSettingsListener(){

            @Override
            public void autoReloadChanged() {
                CMakeWorkspace.this.myWorkspaceWatcher.schedulePendingAutoReloads();
            }

            @Override
            public void profilesChanged() {
                ApplicationManager.getApplication().runWriteAction(() -> CMakeWorkspace.this.updateContentRoots(true));
                CMakeWorkspace.this.scheduleReload(false);
            }
        });
        connection.subscribe(CidrRootConfigurationListener.TOPIC, (Object)new CidrRootConfigurationListener(){

            @Override
            public void configurationChanged() {
                CMakeWorkspace.this.updateContentRoots();
            }
        });
        this.myWorkspaceWatcher.listenForChanges();
        this.myOutputConsole.listenForChanges();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    private void shutdown(boolean projectClosing) {
        if (!this.myInitialized.getAndSet(false)) {
            return;
        }
        this.cancelActiveReload();
        this.myWorkspaceWatcher.shutdown();
        this.myOutputConsole.shutdown();
        Disposer.dispose((Disposable)this.myBusConnectionDisposable);
        if (!projectClosing) {
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(TOOLWINDOW_ID);
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }
    }

    private void initToolWindow(boolean loadPreviousModelOutput) {
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow tw = manager.registerToolWindow(TOOLWINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        tw.setIcon(CLionIcons.CMakeToolWindow);
        final ContentManager cm = tw.getContentManager();
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                cm.removeAllContents(true);
            }
        });
        this.myOutputConsole = new CMakeOutputConsole(this.myProject);
        if (this.myState.model == null) {
            loadPreviousModelOutput = false;
        }
        List<CMakeProfileInfo> infos = this.collectProfilesInfos(this.getSettings().getProfiles(), false);
        this.myOutputConsole.restoreTabs(this.myProjectDir, infos, loadPreviousModelOutput);
    }

    private void reportFilesOutsideContentRoot() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myReportFilesOutsideRoots && !this.myIgnoreFilesOutsideOfProjectRoot) {
            String changeLink = "change";
            String ignoreLink = "ignore";
            HyperlinkAdapter listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if ("change".equals(e.getDescription())) {
                        ChangeCMakeProjectContentRootAction.perform(CMakeWorkspace.this.myProject, CMakeWorkspace.this);
                    } else if ("ignore".equals(e.getDescription())) {
                        CMakeWorkspace.this.myIgnoreFilesOutsideOfProjectRoot = true;
                    }
                }
            };
            this.showBalloonNotification(MessageType.WARNING, CPPBundle.message("cmake.filesOutsideOfProject", "change", "ignore"), (HyperlinkListener)listener2);
        }
    }

    @Nullable
    public static ToolWindow getToolWindow(@NotNull Project project2) {
        if (project2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(8);
        }
        return ToolWindowManager.getInstance((Project)project2).getToolWindow(TOOLWINDOW_ID);
    }

    private void showBalloonNotification(@NotNull MessageType type, @NotNull String message, @NotNull HyperlinkListener listener2) {
        if (type == null) {
            CMakeWorkspace.$$$reportNull$$$0(9);
        }
        if (message == null) {
            CMakeWorkspace.$$$reportNull$$$0(10);
        }
        if (listener2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(11);
        }
        if (ourBalloonNotifier != null) {
            ourBalloonNotifier.notify(type, message, listener2);
        } else {
            ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon(TOOLWINDOW_ID, type, message, null, listener2);
        }
    }

    @NotNull
    public CMakeOutputConsole getConsole() {
        CMakeOutputConsole cMakeOutputConsole = this.myOutputConsole;
        if (cMakeOutputConsole == null) {
            CMakeWorkspace.$$$reportNull$$$0(12);
        }
        return cMakeOutputConsole;
    }

    @NotNull
    public CMakeSettings getSettings() {
        CMakeSettings cMakeSettings = this.mySettings;
        if (cMakeSettings == null) {
            CMakeWorkspace.$$$reportNull$$$0(13);
        }
        return cMakeSettings;
    }

    @NotNull
    public static Path getBaseCacheDir() {
        Path path = Paths.get(FileUtil.toCanonicalPath((String)PathManager.getSystemPath()), "cmake");
        if (path == null) {
            CMakeWorkspace.$$$reportNull$$$0(14);
        }
        return path;
    }

    @NotNull
    public Path getProjectCacheDir() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Path path = ProjectUtil.getProjectCachePath((Project)this.myProject, (Path)CMakeWorkspace.getBaseCacheDir(), (boolean)false, (String)"-");
        if (path == null) {
            CMakeWorkspace.$$$reportNull$$$0(15);
        }
        return path;
    }

    @NotNull
    private File getProjectCacheModelFile() {
        File file = this.getProjectCacheDir().resolve("CMakeModel").toFile();
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public List<File> getEffectiveProfileGenerationDirs(@NotNull List<Pair<String, File>> profileNamesWithSpecifiedDirs) {
        if (profileNamesWithSpecifiedDirs == null) {
            CMakeWorkspace.$$$reportNull$$$0(17);
        }
        List<String> dirNames = CMakeWorkspace.getProfileGenerationDirNames(ContainerUtil.map(profileNamesWithSpecifiedDirs, it -> (String)it.getFirst()));
        if (ApplicationManager.getApplication().isUnitTestMode() && ourForceUseStandardDirForGenerationInTests != Boolean.TRUE) {
            List list = ContainerUtil.map(dirNames, it -> this.getProjectCacheDir().resolve((String)it).toFile());
            if (list == null) {
                CMakeWorkspace.$$$reportNull$$$0(18);
            }
            return list;
        }
        List list = ContainerUtil.map((Iterable)ContainerUtil.zip(profileNamesWithSpecifiedDirs, dirNames), it -> {
            String configDirName = (String)it.second;
            File specifiedDir = (File)((Pair)it.first).second;
            return this.getProjectSubDir(specifiedDir != null ? specifiedDir : new File(configDirName));
        });
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static List<String> getProfileGenerationDirNames(@NotNull List<String> profileNames) {
        if (profileNames == null) {
            CMakeWorkspace.$$$reportNull$$$0(20);
        }
        profileNames = ContainerUtil.map(profileNames, it -> StringUtil.toLowerCase((String)FileUtil.sanitizeFileName((String)it, (boolean)false, (String)"").replaceAll("\\s", "-")));
        profileNames = CPPSettingsUtil.deduplicateNames(profileNames, "name-number");
        List list = ContainerUtil.map(profileNames, it -> "cmake-build-" + it);
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(21);
        }
        return list;
    }

    void clearGeneratedFiles() {
        ArrayList<File> toClear = new ArrayList<File>();
        toClear.addAll(this.myState.getAllGenerationDirs());
        toClear.addAll(this.collectProfilesGenerationDirs(this.getSettings().getProfiles()));
        ContainerUtil.removeDuplicates(toClear);
        for (File eachDir : toClear) {
            CMakeGenerator.cleanGeneratedCMakeFiles(eachDir);
        }
        CMakeWorkspace.refreshGeneratedDirs(toClear, null);
    }

    private static void refreshGeneratedDirs(List<File> toRefresh, @Nullable Runnable onFinish) {
        if (!toRefresh.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(toRefresh, true, true, onFinish);
        } else if (onFinish != null) {
            onFinish.run();
        }
    }

    @NotNull
    public File getProjectSubDir(@NotNull File subdir) {
        if (subdir == null) {
            CMakeWorkspace.$$$reportNull$$$0(22);
        }
        if (subdir.isAbsolute()) {
            File file = subdir;
            if (file == null) {
                CMakeWorkspace.$$$reportNull$$$0(23);
            }
            return file;
        }
        File file = new File(this.getProjectDir(), subdir.getPath()).getAbsoluteFile();
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(24);
        }
        return file;
    }

    @NotNull
    public File getProjectDir() {
        File projectDir = this.myProjectDir;
        if (projectDir == null) {
            String basePath = this.myProject.getBasePath();
            if (basePath == null) {
                throw new NullPointerException("Project base path is null. default = " + this.myProject.isDefault());
            }
            projectDir = new File(basePath);
        }
        File file = projectDir.getAbsoluteFile();
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(25);
        }
        return file;
    }

    @NotNull
    public List<CMakeModelConfigurationData> getModelConfigurationData() {
        State state = this.myState;
        List<CMakeModelConfigurationData> list = state.model == null ? Collections.emptyList() : state.model.getConfigurationData();
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(26);
        }
        return list;
    }

    public <T> Future<T> lockModelDuring(Callable<T> callable) {
        return this.myWorkspaceWatcher.lockModelDuring(callable);
    }

    public void setReloadInBackgroundInTests(boolean value, Disposable disposable) {
        this.myWorkspaceWatcher.setReloadInBackgroundInTests(value, disposable);
    }

    public void waitForReloadsToFinish() throws TimeoutException {
        this.myWorkspaceWatcher.waitForReloadsToFinish();
    }

    public void cancelActiveReload() {
        ProgressIndicator indicator = this.myWorkspaceWatcher.getRunningReloadTaskIndicator();
        if (indicator != null) {
            indicator.cancel();
        }
    }

    public void stopReloadsOnDocumentChange() {
        this.myWorkspaceWatcher.stopReloadsOnDocumentChange();
    }

    public void resumeReloadsOnDocumentChange() {
        this.myWorkspaceWatcher.resumeReloadsOnDocumentChange();
    }

    public void scheduleReload(boolean force) {
        this.scheduleReload(force ? ReloadFlag.FORCE_RELOAD : ReloadFlag.RELOAD_ONLY_WHEN_CHANGED);
    }

    void scheduleReload(@NotNull ReloadFlag flag) {
        if (flag == null) {
            CMakeWorkspace.$$$reportNull$$$0(27);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myWorkspaceWatcher.scheduleReload(indicator -> this.doReload((ProgressIndicator)indicator), flag);
    }

    public void selectProjectDir(@Nullable File newProjectDir) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myProjectDir = newProjectDir;
        if (!this.isInitialized()) {
            if (this.myProjectDir != null) {
                Module module2 = this.myRootsSynchronizer.getModule();
                if (module2 != null) {
                    VirtualFile contentRoot = (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots());
                    this.myContentRoot = contentRoot == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
                }
                this.initialize(ReloadFlag.FORCE_RELOAD, false);
            }
        } else {
            this.scheduleReload(ReloadFlag.FORCE_RELOAD);
        }
    }

    public void scheduleClearGeneratedFilesAndReload() {
        this.myClearGeneratedFilesBeforeReload = true;
        this.scheduleReload(true);
    }

    private <T> T runReadActionCanceling(Computable<T> computable) {
        return (T)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            ProgressManager.checkCanceled();
            return computable.compute();
        });
    }

    private void runReadActionCanceling(Runnable runnable2) {
        this.runReadActionCanceling(() -> {
            runnable2.run();
            return null;
        });
    }

    private void doReload(@NotNull ProgressIndicator indicator) {
        boolean finalCanceled;
        if (indicator == null) {
            CMakeWorkspace.$$$reportNull$$$0(28);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"CMake reloading should not be initiated from writeAction. Will cause a deadlock.");
        }
        if (this.myClearGeneratedFilesBeforeReload) {
            this.myClearGeneratedFilesBeforeReload = false;
            this.clearGeneratedFiles();
        }
        ourReloadsCounter.incrementAndGet();
        CMakeWorkspaceListener publisher = (CMakeWorkspaceListener)this.runReadActionCanceling(() -> {
            CMakeWorkspaceListener result = (CMakeWorkspaceListener)this.myProject.getMessageBus().syncPublisher(CMakeWorkspaceListener.TOPIC);
            result.reloadingStarted();
            return result;
        });
        if (ourPauseOnReloadInTests != null && CMakeWorkspace.ourPauseOnReloadInTests.first != null) {
            try {
                Thread.sleep(((Integer)CMakeWorkspace.ourPauseOnReloadInTests.first).intValue());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean canceled = false;
        try {
            Pair<State, OCWorkspaceImpl.ModifiableModel> newStateAndWorkspaceModel;
            ProgressManager.checkCanceled();
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            });
            ProgressManager.checkCanceled();
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            Ref toRefresh = new Ref();
            Ref modelFile = new Ref();
            Runnable fireGenerationStartedCanceling = () -> this.runReadActionCanceling(() -> publisher.generationStarted());
            Runnable fireGenerationFinishedNonCanceling = () -> ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                publisher.generationFinished();
            });
            Runnable fireFileRefreshedNonCanceling = () -> ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                publisher.filesRefreshedAfterGeneration();
            });
            State previousState = this.myState;
            try {
                newStateAndWorkspaceModel = this.doGenerateProject(this.myProjectDir, previousState, indicator, fireGenerationStartedCanceling, fireGenerationFinishedNonCanceling);
                this.runReadActionCanceling(() -> {
                    toRefresh.set((Object)((State)newStateAndWorkspaceModel.first).getAllGenerationDirs());
                    modelFile.set((Object)this.getProjectCacheModelFile());
                });
            }
            catch (Throwable e) {
                try {
                    fireFileRefreshedNonCanceling.run();
                }
                catch (Throwable suppressed) {
                    e.addSuppressed(suppressed);
                }
                ExceptionUtil.rethrow((Throwable)e);
                throw new RuntimeException(e);
            }
            CMakeWorkspace.refreshGeneratedDirs((List)toRefresh.get(), fireFileRefreshedNonCanceling);
            CMakeWorkspace.saveState((State)newStateAndWorkspaceModel.first, (File)modelFile.get());
            TransactionGuard.getInstance().submitTransactionAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                publisher.beforeApplying();
                State oldState = this.myState;
                this.myState = (State)newStateAndWorkspaceModel.first;
                ((OCWorkspaceImpl.ModifiableModel)newStateAndWorkspaceModel.second).commit(108002);
                this.updateProjectName(oldState.model, this.myState.model);
                this.updateContentRoots();
                this.reportFilesOutsideContentRoot();
                OCWorkspaceModificationTrackers trackers = OCWorkspaceModificationTrackers.getInstance(this.myProject);
                trackers.getProjectsListTracker().incModificationCount();
                trackers.getSourceFilesListTracker().incModificationCount();
                trackers.getBuildSettingsChangesTracker().incModificationCount();
            }));
            finalCanceled = canceled;
        }
        catch (ProcessCanceledException e) {
            try {
                canceled = true;
                throw e;
            }
            catch (Throwable throwable) {
                boolean finalCanceled2 = canceled;
                new WriteAction(publisher, finalCanceled2){
                    final /* synthetic */ CMakeWorkspaceListener val$publisher;
                    final /* synthetic */ boolean val$finalCanceled;
                    {
                        this.val$publisher = cMakeWorkspaceListener;
                        this.val$finalCanceled = bl;
                    }

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (!CMakeWorkspace.this.myProject.isDisposed()) {
                            this.val$publisher.reloadingFinished(this.val$finalCanceled);
                        }
                        if (((CMakeWorkspace)CMakeWorkspace.this).myState.projectDir == null) {
                            CMakeWorkspace.this.shutdown();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$6", "run"));
                    }
                }.execute();
                if (ourPauseOnReloadInTests != null && CMakeWorkspace.ourPauseOnReloadInTests.second != null) {
                    try {
                        Thread.sleep(((Integer)CMakeWorkspace.ourPauseOnReloadInTests.second).intValue());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        new /* invalid duplicate definition of identical inner class */.execute();
        if (ourPauseOnReloadInTests != null && CMakeWorkspace.ourPauseOnReloadInTests.second != null) {
            try {
                Thread.sleep(((Integer)CMakeWorkspace.ourPauseOnReloadInTests.second).intValue());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Pair<State, OCWorkspaceImpl.ModifiableModel> doGenerateProject(@Nullable File projectDir, @NotNull State currentState, @NotNull ProgressIndicator indicator, @NotNull Runnable beforeGeneration, @NotNull Runnable afterGeneration) {
        File cmakeLists;
        if (currentState == null) {
            CMakeWorkspace.$$$reportNull$$$0(29);
        }
        if (indicator == null) {
            CMakeWorkspace.$$$reportNull$$$0(30);
        }
        if (beforeGeneration == null) {
            CMakeWorkspace.$$$reportNull$$$0(31);
        }
        if (afterGeneration == null) {
            CMakeWorkspace.$$$reportNull$$$0(32);
        }
        List profiles = (List)this.runReadActionCanceling(() -> this.mySettings.getProfiles());
        List profileInfos = (List)this.runReadActionCanceling(() -> this.collectProfilesInfos(profiles, true));
        ProfilesAndEnvHash profilesAndEnvHash = CMakeWorkspace.calcProfilesAndEnvHash(profileInfos, true);
        this.myOutputConsole.updateTabs(projectDir, profileInfos);
        this.myOutputConsole.reloadingStarted(indicator);
        boolean hasCMakeLists = false;
        if (projectDir != null && !(hasCMakeLists = (cmakeLists = new File(projectDir, "CMakeLists.txt")).exists())) {
            CMakeOutputConsole.Fix fix = new CMakeOutputConsole.Fix(CPPBundle.message("cmake.loadCMakeNotification.action.select", new Object[0]), () -> LoadCMakeProjectAction.selectAndLoadCMakeProject(this.myProject));
            String text = "CMakeLists.txt not found in " + projectDir;
            this.myOutputConsole.reportMessage(-1, CMakeMessage.fatalError(text, cmakeLists), fix);
        }
        if (projectDir == null || !hasCMakeLists || !FileUtil.filesEqual((File)projectDir, (File)currentState.projectDir)) {
            currentState = this.createInitialState(projectDir);
        }
        NullableFunction<File, VirtualFile> fileMapper = OCWorkspaceImpl.createFileMapper();
        boolean hasEnvironmentProblems = false;
        for (int i = 0; i < profileInfos.size(); ++i) {
            EnvironmentProblems problems = ((CMakeProfileInfo)profileInfos.get(i)).getEnvironmentProblems();
            if (!problems.hasProblems()) continue;
            for (EnvironmentProblems.Problem eachProblem : problems.getProblems()) {
                CMakeMessage message2 = new CMakeMessage(CMakeMessage.MessageLevel.FATAL_ERROR, null, null, eachProblem.getMessage());
                EnvironmentProblems.Fix fix = eachProblem.getFix();
                this.myOutputConsole.reportMessage(i, message2, fix == null ? null : new CMakeOutputConsole.Fix(fix.getText(), () -> fix.run()));
            }
            hasEnvironmentProblems = true;
        }
        if (hasCMakeLists && !hasEnvironmentProblems) {
            CMakeModel model2;
            Charset defaultCharset = (Charset)this.runReadActionCanceling(() -> EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
            int[] index = new int[]{0};
            THashMap indexedProfileInfos = new THashMap();
            List parameters = ContainerUtil.mapNotNull((Collection)profiles, arg_0 -> this.lambda$doGenerateProject$24(index, profileInfos, (Map)indexedProfileInfos, arg_0));
            beforeGeneration.run();
            try {
                model2 = new CMakeGenerator(this.myProject, projectDir, parameters, this.determineEncoding(projectDir, defaultCharset), defaultCharset).generate(currentState.model, indicator);
            }
            finally {
                afterGeneration.run();
            }
            currentState = this.createStateWithModel(profilesAndEnvHash, projectDir, model2, (Map<Integer, CMakeProfileInfo>)indexedProfileInfos, currentState, fileMapper);
        }
        OCWorkspaceImpl.ModifiableModel modifiableModel = this.updateOCWorkspace(currentState.model, currentState.profileInfos, fileMapper, (tabIndex, message) -> this.myOutputConsole.reportMessage((int)tabIndex, (CMakeMessage)message));
        Pair pair2 = Pair.create((Object)currentState, (Object)modifiableModel);
        if (pair2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(33);
        }
        return pair2;
    }

    @NotNull
    private List<File> collectProfilesGenerationDirs(@NotNull List<CMakeSettings.Profile> profiles) {
        if (profiles == null) {
            CMakeWorkspace.$$$reportNull$$$0(34);
        }
        List<File> list = this.getEffectiveProfileGenerationDirs(ContainerUtil.map(profiles, it -> Pair.create((Object)it.getName(), (Object)it.getGenerationDir())));
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    private List<CMakeProfileInfo> collectProfilesInfos(@NotNull List<CMakeSettings.Profile> profiles, boolean checkIfEnvironmentFunctional) {
        if (profiles == null) {
            CMakeWorkspace.$$$reportNull$$$0(36);
        }
        List<File> generationDirs = this.collectProfilesGenerationDirs(profiles);
        int[] counter = new int[]{0};
        List list = ContainerUtil.map((Iterable)ContainerUtil.zip(profiles, generationDirs), it -> {
            int n = counter[0];
            counter[0] = n + 1;
            int profileIndex = n;
            ProgressManager.checkCanceled();
            EnvironmentProblems problems = new EnvironmentProblems();
            CMakeEnvironment environment = ourEnvironmentFactory == null ? CPPToolchains.createCMakeEnvironment(this.myProject, ((CMakeSettings.Profile)it.first).getToolchainName(), problems, checkIfEnvironmentFunctional, () -> OpenCMakeSettingsAction.openProfile(this.myProject, profileIndex)) : (CMakeEnvironment)ourEnvironmentFactory.invoke((Object)this.myProject, it.first, (Object)problems, (Object)checkIfEnvironmentFunctional);
            return new CMakeProfileInfo((CMakeSettings.Profile)it.first, (File)it.second, environment, problems);
        });
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    private static ProfilesAndEnvHash calcProfilesAndEnvHash(List<CMakeProfileInfo> profileInfos, boolean calcEnvHash) {
        long profilesHash = CMakeSettings.calcProfilesHash(ContainerUtil.map(profileInfos, info -> {
            CMakeEnvironment environment = info.getEnvironment();
            return new kotlin.Pair((Object)info.getProfile(), (Object)(environment == null ? null : environment.getToolchain()));
        }));
        long envHash = 0L;
        if (calcEnvHash) {
            CRC32 crc = new CRC32();
            profileInfos.forEach(info -> {
                CMakeEnvironment env = info.getEnvironment();
                crc.update(env == null ? 0 : 1);
                if (env != null) {
                    crc.update(env.calcToolchainHash().getBytes());
                    crc.update(env.calcCMakeHash().getBytes());
                }
            });
            envHash = crc.getValue();
        }
        ProfilesAndEnvHash profilesAndEnvHash = new ProfilesAndEnvHash(profilesHash, envHash);
        if (profilesAndEnvHash == null) {
            CMakeWorkspace.$$$reportNull$$$0(38);
        }
        return profilesAndEnvHash;
    }

    @Nullable
    private String determineEncoding(@NotNull File projectDir, @NotNull Charset defaultCharset) {
        if (projectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(39);
        }
        if (defaultCharset == null) {
            CMakeWorkspace.$$$reportNull$$$0(40);
        }
        Charset[] charset = new Charset[]{null};
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (projectDir == null) {
                CMakeWorkspace.$$$reportNull$$$0(92);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            VirtualFile file = VfsUtil.findFileByIoFile((File)new File(projectDir, "CMakeLists.txt"), (boolean)true);
            charset[0] = file == null ? null : file.getCharset();
        });
        if (charset[0] == null || defaultCharset.equals(charset[0])) {
            return null;
        }
        return charset[0].name();
    }

    @NotNull
    private State createInitialState(@Nullable File projectDir) {
        Set cmakeFiles = ContainerUtil.createMaybeSingletonSet((Object)(projectDir == null ? null : new File(projectDir, "CMakeLists.txt")));
        Map<File, FileStamp> cmakeFilesWithStamps = cmakeFiles.isEmpty() ? Collections.emptyMap() : this.calculateFileStamps(cmakeFiles, Collections.emptyMap(), (NullableFunction<File, VirtualFile>)((NullableFunction)file -> VfsUtil.findFileByIoFile((File)file, (boolean)false)));
        State state = new State(projectDir, cmakeFilesWithStamps);
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(41);
        }
        return state;
    }

    @NotNull
    private State createStateWithModel(@NotNull ProfilesAndEnvHash profilesAndEnvHash, @NotNull File projectDir, @NotNull CMakeModel model2, @NotNull Map<Integer, CMakeProfileInfo> profileInfos, @NotNull State previousState, @NotNull NullableFunction<File, VirtualFile> fileMapper) {
        if (profilesAndEnvHash == null) {
            CMakeWorkspace.$$$reportNull$$$0(42);
        }
        if (projectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(43);
        }
        if (model2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(44);
        }
        if (profileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(45);
        }
        if (previousState == null) {
            CMakeWorkspace.$$$reportNull$$$0(46);
        }
        if (fileMapper == null) {
            CMakeWorkspace.$$$reportNull$$$0(47);
        }
        THashSet dependencyFiles = new THashSet(model2.getCMakeDependencyFiles(), FileUtil.FILE_HASHING_STRATEGY);
        dependencyFiles.add(new File(projectDir, "CMakeLists.txt"));
        THashMap<File, FileStamp> dependencyFilesWithStamps = this.calculateFileStamps((Set<File>)dependencyFiles, previousState.cmakeDependencyFilesWithStamps, fileMapper);
        State state = new State(projectDir, profilesAndEnvHash, model2, profileInfos, (Map)dependencyFilesWithStamps);
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(48);
        }
        return state;
    }

    @NotNull
    private OCWorkspaceImpl.ModifiableModel updateOCWorkspace(@Nullable CMakeModel model2, @NotNull Map<Integer, CMakeProfileInfo> profileInfos, @NotNull NullableFunction<File, VirtualFile> fileMapper, @NotNull BiConsumer<Integer, CMakeMessage> messagesCollector) {
        if (profileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(49);
        }
        if (fileMapper == null) {
            CMakeWorkspace.$$$reportNull$$$0(50);
        }
        if (messagesCollector == null) {
            CMakeWorkspace.$$$reportNull$$$0(51);
        }
        OCWorkspaceImpl.ModifiableModel workspaceModel = OCWorkspaceImpl.getInstanceImpl(this.myProject).getModifiableModel();
        THashMap configToProfileIds = new THashMap();
        if (model2 != null) {
            for (CMakeTarget eachTarget : model2.getTargets()) {
                for (CMakeConfiguration cmakeConfig : eachTarget.getBuildConfigurations()) {
                    CMakeEnvironment environment = profileInfos.get(cmakeConfig.getProfileId()).getEnvironment();
                    assert (environment != null) : "environment should have been checked already";
                    THashMap configLanguages = new THashMap(cmakeConfig.getSupportedLanguages().size());
                    for (OCLanguageKind oCLanguageKind : cmakeConfig.getSupportedLanguages()) {
                        CMakeConfigurationSettings settings = cmakeConfig.getSettings(oCLanguageKind);
                        List<String> flags = cmakeConfig.getCombinedCompilerFlags(oCLanguageKind, null);
                        configLanguages.put(oCLanguageKind, Trinity.create((Object)((Object)(settings == null ? null : settings.getCompiler().getCompilerKind())), (Object)(settings == null ? null : settings.getCompilerExecutable()), (Object)new CidrSwitchBuilder().addAllRaw(flags).build()));
                    }
                    THashMap configSourceFiles = new THashMap();
                    for (File ioSource : cmakeConfig.getSources()) {
                        CMakeFileSettings settings;
                        VirtualFile vfSource = (VirtualFile)fileMapper.fun((Object)ioSource);
                        if (vfSource == null || (settings = cmakeConfig.getFileSettings(ioSource)) == null) continue;
                        CidrCompilerSwitches switches2 = null;
                        if (settings.hasCustomSettings()) {
                            List<String> flags = cmakeConfig.getCombinedCompilerFlags(settings.getLanguageKind(), ioSource);
                            switches2 = new CidrSwitchBuilder().addAllRaw(flags).build();
                        }
                        configSourceFiles.put(vfSource, Pair.create((Object)settings.getLanguageKind(), switches2));
                    }
                    String string = CMakeWorkspace.getCMakeConfigurationId(cmakeConfig);
                    configToProfileIds.put(string, cmakeConfig.getProfileId());
                    String displayName = OCWorkspaceUtil.getConfigurationDisplayName(eachTarget.getName(), cmakeConfig.getName(), false);
                    String shortDisplayName = OCWorkspaceUtil.getConfigurationDisplayName(eachTarget.getName(), cmakeConfig.getName(), true);
                    workspaceModel.addConfiguration(string, displayName, shortDisplayName, cmakeConfig.getBuildWorkingDir(), (Map<OCLanguageKind, ? extends Trinity<OCCompilerKind, File, CidrCompilerSwitches>>)configLanguages, (Map<VirtualFile, ? extends Pair<OCLanguageKind, CidrCompilerSwitches>>)configSourceFiles, environment, fileMapper);
                }
            }
        }
        MultiValuesMap messages = new MultiValuesMap(true);
        workspaceModel.getMessages().forEach(arg_0 -> CMakeWorkspace.lambda$updateOCWorkspace$33(messages, (Map)configToProfileIds, arg_0));
        CMakeWorkspace.flushConsoleMessages("Cannot get compiler information", OCWorkspaceImpl.ModifiableModel.MessageType.ERROR, CMakeMessage.MessageLevel.ERROR, (MultiValuesMap<Integer, OCWorkspaceImpl.ModifiableModel.Message>)messages, messagesCollector);
        CMakeWorkspace.flushConsoleMessages("Problems were encountered while collecting compiler information", OCWorkspaceImpl.ModifiableModel.MessageType.WARNING, CMakeMessage.MessageLevel.WARNING, (MultiValuesMap<Integer, OCWorkspaceImpl.ModifiableModel.Message>)messages, messagesCollector);
        OCWorkspaceImpl.ModifiableModel modifiableModel = workspaceModel;
        if (modifiableModel == null) {
            CMakeWorkspace.$$$reportNull$$$0(52);
        }
        return modifiableModel;
    }

    @NotNull
    private THashMap<File, FileStamp> calculateFileStamps(@NotNull Set<File> files, final @NotNull Map<File, FileStamp> alreadyCalculatedStamps, final @NotNull NullableFunction<File, VirtualFile> getVirtualFile) {
        if (files == null) {
            CMakeWorkspace.$$$reportNull$$$0(53);
        }
        if (alreadyCalculatedStamps == null) {
            CMakeWorkspace.$$$reportNull$$$0(54);
        }
        if (getVirtualFile == null) {
            CMakeWorkspace.$$$reportNull$$$0(55);
        }
        THashMap result = new THashMap(files.size(), FileUtil.FILE_HASHING_STRATEGY);
        for (final File each : files) {
            FileStamp.FileStampFunction function = new FileStamp.FileStampFunction(){

                @Override
                public FileStamp getAlreadyCalculatedStamp() {
                    return (FileStamp)alreadyCalculatedStamps.get(each);
                }

                @Override
                @Nullable
                public CMakeFile getCMakeFile(@NotNull Project project2) {
                    VirtualFile file;
                    if (project2 == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return (file = (VirtualFile)getVirtualFile.fun((Object)each)) == null ? null : FileStamp.createOrGetCMakeFile(project2, file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$8", "getCMakeFile"));
                }
            };
            result.put((Object)each, this.runReadActionCanceling(() -> FileStamp.calcFileStamp(this.myProject, each, function)));
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            CMakeWorkspace.$$$reportNull$$$0(56);
        }
        return tHashMap;
    }

    private static void flushConsoleMessages(@NotNull String prefix, @NotNull OCWorkspaceImpl.ModifiableModel.MessageType flushMessagesType, @NotNull CMakeMessage.MessageLevel level, @NotNull MultiValuesMap<Integer, OCWorkspaceImpl.ModifiableModel.Message> messages, @NotNull BiConsumer<Integer, CMakeMessage> messagesCollector) {
        if (prefix == null) {
            CMakeWorkspace.$$$reportNull$$$0(57);
        }
        if (flushMessagesType == null) {
            CMakeWorkspace.$$$reportNull$$$0(58);
        }
        if (level == null) {
            CMakeWorkspace.$$$reportNull$$$0(59);
        }
        if (messages == null) {
            CMakeWorkspace.$$$reportNull$$$0(60);
        }
        if (messagesCollector == null) {
            CMakeWorkspace.$$$reportNull$$$0(61);
        }
        for (Map.Entry entry : ContainerUtil.sorted((Collection)messages.entrySet(), Comparator.comparingInt(Map.Entry::getKey))) {
            List filtered = ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), it -> {
                if (flushMessagesType == null) {
                    CMakeWorkspace.$$$reportNull$$$0(91);
                }
                return it.getType() == flushMessagesType ? it.getText() : null;
            });
            if (filtered.isEmpty()) continue;
            String text = "\n" + prefix + ":\n\t" + StringUtil.replace((String)String.join((CharSequence)"\n", filtered), (String)"\n", (String)"\n\t");
            messagesCollector.accept((Integer)entry.getKey(), new CMakeMessage(level, null, null, text));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveState(@NotNull State state, @NotNull File file) {
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(62);
        }
        if (file == null) {
            CMakeWorkspace.$$$reportNull$$$0(63);
        }
        try {
            if (!FileUtil.createParentDirs((File)file)) {
                throw new IOException("Cannot create directory: " + file.getParent());
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                out.writeInt(108002);
                out.writeBoolean(state.projectDir != null);
                if (state.projectDir != null) {
                    out.writeObject(state.projectDir.getPath());
                }
                out.writeBoolean(state.myProfilesAndEnvHash != null);
                if (state.myProfilesAndEnvHash != null) {
                    out.writeLong(state.myProfilesAndEnvHash.profilesHash);
                    out.writeLong(state.myProfilesAndEnvHash.envHash);
                }
                out.writeBoolean(state.model != null);
                if (state.model != null) {
                    state.model.save(out);
                    out.writeInt(state.profileInfos.size());
                    for (Map.Entry<Integer, CMakeProfileInfo> entry : state.profileInfos.entrySet()) {
                        out.writeInt(entry.getKey());
                        CMakeEnvironment environment = entry.getValue().getEnvironment();
                        out.writeBoolean(environment != null);
                        if (environment == null) continue;
                        out.writeObject(environment.calcToolchainHash());
                    }
                    out.writeInt(state.cmakeDependencyFilesWithStamps.size());
                    for (Map.Entry<Comparable<Integer>, Object> entry : state.cmakeDependencyFilesWithStamps.entrySet()) {
                        out.writeObject(((File)entry.getKey()).getPath());
                        FileStamp stamp = (FileStamp)entry.getValue();
                        out.writeLong(stamp.timestamp);
                        out.writeLong(stamp.size);
                        out.writeLong(stamp.contentCrc);
                    }
                }
            }
        }
        catch (IOException e) {
            CPPLog.LOG.warn("Cannot save CMake model file: " + file, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static State loadStateIfActual(@NotNull File currentProjectDir, @NotNull File modelFile, @NotNull List<CMakeProfileInfo> actualProfileInfos) {
        if (currentProjectDir == null) {
            CMakeWorkspace.$$$reportNull$$$0(64);
        }
        if (modelFile == null) {
            CMakeWorkspace.$$$reportNull$$$0(65);
        }
        if (actualProfileInfos == null) {
            CMakeWorkspace.$$$reportNull$$$0(66);
        }
        if (!modelFile.exists()) {
            return null;
        }
        try {
            File savedProjectDir;
            String string;
            ObjectInputStream in;
            block22: {
                block21: {
                    in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(modelFile)));
                    try {
                        int stateVersion = in.readInt();
                        if (stateVersion != 108002) {
                            State state = null;
                            return state;
                        }
                        if (in.readBoolean()) {
                        }
                        break block21;
                    }
                    catch (IOException ignore) {
                        State state = null;
                        return state;
                    }
                    string = (String)in.readObject();
                    break block22;
                }
                string = null;
            }
            String projectDirPath = string;
            File file = savedProjectDir = projectDirPath != null ? new File(projectDirPath) : null;
            if (!FileUtil.filesEqual((File)savedProjectDir, (File)currentProjectDir)) {
                return null;
            }
            ProfilesAndEnvHash profilesAndEnvHash = null;
            if (in.readBoolean()) {
                profilesAndEnvHash = new ProfilesAndEnvHash(in.readLong(), in.readLong());
            }
            State result = null;
            if (savedProjectDir == null) return result;
            CMakeModel model2 = in.readBoolean() ? CMakeModel.load(in) : null;
            if (model2 == null) return result;
            int count = in.readInt();
            THashMap restoredProfileInfos = new THashMap(count);
            while (count-- > 0) {
                int profileIndex = in.readInt();
                String toolchainHash = in.readBoolean() ? (String)in.readObject() : null;
                if (profileIndex >= actualProfileInfos.size()) return null;
                CMakeProfileInfo cMakeProfileInfo = actualProfileInfos.get(profileIndex);
                CMakeProfileInfo info = cMakeProfileInfo;
                if (info == null) return null;
                if (info.getEnvironment() == null) return null;
                if (!Objects.equals(toolchainHash, info.getEnvironment().calcToolchainHash())) {
                    return null;
                }
                restoredProfileInfos.put(profileIndex, info);
            }
            int count2 = in.readInt();
            THashMap cmakeFilesWithStamps = new THashMap(count2, FileUtil.FILE_HASHING_STRATEGY);
            while (count2-- > 0) {
                cmakeFilesWithStamps.put(new File((String)in.readObject()), new FileStamp(in.readLong(), in.readLong(), in.readLong()));
            }
            result = new State(savedProjectDir, profilesAndEnvHash, model2, (Map)restoredProfileInfos, (Map)cmakeFilesWithStamps);
            return result;
            finally {
                in.close();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            CPPLog.LOG.warn("Cannot load CMake model file: " + modelFile, (Throwable)e);
            return null;
        }
    }

    private void updateProjectName(@Nullable CMakeModel oldModel, @Nullable CMakeModel newModel) {
        ProjectImpl projectImpl = (ProjectImpl)this.myProject;
        String currentProjectName = projectImpl.getName();
        String defaultProjectName = PathUtil.getFileName((String)ProjectKt.getStateStore((Project)projectImpl).getProjectBasePath());
        if (!(defaultProjectName.equals(currentProjectName) || oldModel != null && oldModel.getProjectName().equals(currentProjectName))) {
            return;
        }
        String newProjectName = null;
        if (newModel != null && (newProjectName = newModel.getProjectName()).equals("Project")) {
            newProjectName = null;
        }
        projectImpl.setProjectName(StringUtil.notNullize((String)newProjectName, (String)defaultProjectName));
    }

    private void updateContentRoots() {
        this.updateContentRoots(false);
    }

    private void updateContentRoots(boolean forceRootChangesEvents) {
        this.updateContentRoots(this.myState, this.myContentRoot, forceRootChangesEvents);
    }

    private void updateContentRoots(@NotNull State state, @Nullable File contentRoot) {
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(67);
        }
        this.updateContentRoots(state, contentRoot, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateContentRoots(@NotNull State state, @Nullable File contentRoot, boolean forceRootChangesEvents) {
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(68);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myUpdateContentRootsRecursionProtection) {
            return;
        }
        this.myUpdateContentRootsRecursionProtection = true;
        try {
            boolean cmakeIsEnabled = state.projectDir != null;
            CidrRootConfiguration.setEnabledFor(this.myRootsSynchronizer.getModule(), cmakeIsEnabled);
            this.myRootsSynchronizer.installClasspathStorage(cmakeIsEnabled ? TOOLWINDOW_ID : "default");
            if (cmakeIsEnabled) {
                if (FileUtil.filesEqual((File)state.projectDir, (File)contentRoot)) {
                    contentRoot = null;
                }
                this.myContentRoot = contentRoot;
            } else {
                contentRoot = this.getProjectDir();
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            this.collectExcludeRoots(state, contentRoot).forEach(it -> {
                changeListManager.addDirectoryToIgnoreImplicitly(FileUtil.toCanonicalPath((String)it.getPath()));
                while ((it = it.getParentFile()) != null) {
                    changeListManager.removeImplicitlyIgnoredDirectory(FileUtil.toCanonicalPath((String)it.getPath()));
                }
            });
            UpdateRoots updateRoots = this.collectUpdateRoots(this.myRootsSynchronizer.getModule(), state, contentRoot);
            boolean reportOutsideFiles = false;
            for (File eachSource : updateRoots.sourceFiles) {
                if (OCRootsSynchronizer.isUnder(updateRoots.roots, eachSource)) continue;
                reportOutsideFiles = true;
                break;
            }
            if (!reportOutsideFiles) {
                this.myIgnoreFilesOutsideOfProjectRoot = false;
            }
            this.myReportFilesOutsideRoots = reportOutsideFiles;
            this.myRootsSynchronizer.updateRoots(updateRoots.rootsInfo, forceRootChangesEvents);
            CidrNotInProjectNotification.setEnabled(this.myProject, state.model != null);
        }
        finally {
            this.myUpdateContentRootsRecursionProtection = false;
        }
    }

    @NotNull
    List<VirtualFile> getExcludeRoots() {
        List list = ContainerUtil.mapNotNull(this.collectExcludeRoots(this.myState, this.myContentRoot), it -> VfsUtil.findFileByIoFile((File)it, (boolean)false));
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(69);
        }
        return list;
    }

    void updateContentRoots(@NotNull ModifiableRootModel model2) {
        if (model2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(70);
        }
        this.myRootsSynchronizer.updateModuleRoots(model2, this.collectUpdateRoots((Module)model2.getModule(), (State)this.myState, (File)this.myContentRoot).rootsInfo);
    }

    @NotNull
    private UpdateRoots collectUpdateRoots(@NotNull Module module2, @NotNull State state, @Nullable File contentRoot) {
        if (module2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(71);
        }
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(72);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<File> sourceFiles = new ArrayList<File>(state.getAllSourceFiles());
        List<File> roots = CMakeWorkspace.getRoots(state, contentRoot, sourceFiles);
        block0: for (File eachResourceFiles : state.getAllResourceFiles()) {
            for (File eachRoot : roots) {
                if (!VfsUtilCore.isAncestor((File)eachRoot, (File)eachResourceFiles, (boolean)true)) continue;
                sourceFiles.add(eachResourceFiles);
                continue block0;
            }
        }
        OCRootsSynchronizer.RootsInfo info = new OCRootsSynchronizer.RootsInfo();
        info.registerSystemHeaderRootUnderContentRootAsLibraries = false;
        info.contentRoots.addAll(roots);
        info.sourceFiles.addAll(sourceFiles);
        CidrRootConfiguration rootsConfiguration = CidrRootConfiguration.getInstance(this.myProject);
        if (CidrRootConfiguration.isEnabledFor(module2)) {
            info.explicitSourceFolders.addAll(rootsConfiguration.getSourceRoots());
            info.explicitLibraryRoots.addAll(rootsConfiguration.getLibraryRoots());
            info.explicitExcludeFolders.addAll(rootsConfiguration.getExcludeRoots());
        }
        OCWorkspaceImpl workspace = OCWorkspaceImpl.getInstanceImpl(this.myProject);
        info.headerSearchRoots.systemHeaderRoots.addAll(workspace.getSystemHeaderRoots());
        info.headerSearchRoots.userHeaderRoots.addAll(workspace.getUserHeaderRoots());
        info.headerSearchRoots.excludeRoots.addAll(workspace.getHeaderExcludeRoots());
        UpdateRoots updateRoots = new UpdateRoots(roots, sourceFiles, info);
        if (updateRoots == null) {
            CMakeWorkspace.$$$reportNull$$$0(73);
        }
        return updateRoots;
    }

    @NotNull
    private List<File> collectExcludeRoots(State state, File contentRoot) {
        boolean cmakeIsEnabled;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl = cmakeIsEnabled = state.projectDir != null;
        if (!cmakeIsEnabled) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                CMakeWorkspace.$$$reportNull$$$0(74);
            }
            return list;
        }
        List<File> roots = CMakeWorkspace.getRoots(state, contentRoot, null);
        ArrayList<File> result = new ArrayList<File>();
        this.collectProfilesGenerationDirs(this.getSettings().getProfiles()).forEach(eachGenerationDir -> {
            File toExclude = eachGenerationDir;
            if (roots.stream().anyMatch(eachRoot -> FileUtil.isAncestor((File)eachGenerationDir, (File)eachRoot, (boolean)false))) {
                toExclude = new File((File)eachGenerationDir, "CMakeFiles");
            }
            result.add(toExclude);
        });
        for (File eachCMakeRoot : roots) {
            File inSourceCMakeFiles = new File(eachCMakeRoot, "CMakeFiles");
            if (!inSourceCMakeFiles.exists()) continue;
            result.add(inSourceCMakeFiles);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            CMakeWorkspace.$$$reportNull$$$0(75);
        }
        return arrayList;
    }

    @NotNull
    private static List<File> getRoots(@NotNull State state, @Nullable File contentRoot, @Nullable List<File> rootCMakeFiles) {
        if (state == null) {
            CMakeWorkspace.$$$reportNull$$$0(76);
        }
        ArrayList<File> result = new ArrayList<File>();
        ContainerUtil.addIfNotNull(result, (Object)contentRoot);
        ContainerUtil.addIfNotNull(result, (Object)state.projectDir);
        for (File eachDependencyFile : state.cmakeDependencyFilesWithStamps.keySet()) {
            if (!"CMakeLists.txt".equalsIgnoreCase(eachDependencyFile.getName())) continue;
            ContainerUtil.addIfNotNull(result, (Object)eachDependencyFile.getParentFile());
            if (rootCMakeFiles == null) continue;
            rootCMakeFiles.add(eachDependencyFile);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            CMakeWorkspace.$$$reportNull$$$0(77);
        }
        return arrayList;
    }

    public void changeContentRoot(@Nullable VirtualFile contentRoot) {
        this.myIgnoreFilesOutsideOfProjectRoot = false;
        this.updateContentRoots(this.myState, contentRoot == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot));
    }

    @Nullable
    public VirtualFile getEffectiveContentRoot() {
        VirtualFile result;
        File root = this.myContentRoot;
        VirtualFile virtualFile = result = root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
        if (result != null) {
            return result;
        }
        root = this.myState.projectDir;
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    @Nullable
    File getCurrentContentRootIOFile() {
        return this.myContentRoot;
    }

    @Nullable
    public Element getState() {
        return CMakeWorkspace.createStateElement(this.myProjectDir, this.myContentRoot, this.myIgnoreFilesOutsideOfProjectRoot);
    }

    static Element createStateElement(@Nullable File projectDir) {
        return CMakeWorkspace.createStateElement(projectDir, null);
    }

    static Element createStateElement(@Nullable File projectDir, @Nullable File contentRoot) {
        return CMakeWorkspace.createStateElement(projectDir, contentRoot, false);
    }

    static Element createStateElement(@Nullable File projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
        Element element = new Element("state");
        if (ignoreFilesOutsideOfProjectRoot) {
            element.setAttribute("IGNORE_OUTSIDE_FILES", "true");
        }
        if (projectDir != null) {
            element.setAttribute("PROJECT_DIR", FileUtil.toSystemIndependentName((String)projectDir.getPath()));
        }
        if (contentRoot != null) {
            Element contentRootElement = new Element("contentRoot");
            contentRootElement.setAttribute("DIR", FileUtil.toSystemIndependentName((String)contentRoot.getPath()));
            element.addContent(contentRootElement);
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        boolean ignoreOutsideFiles;
        File contentRootDir;
        boolean openingExisting;
        String projectDirString;
        if (element == null) {
            CMakeWorkspace.$$$reportNull$$$0(78);
        }
        File projectDir = (projectDirString = element.getAttributeValue("PROJECT_DIR")) == null ? null : new File(projectDirString);
        CMakeProjectOpenProcessor.OpenProjectSpec openSpec = CMakeWorkspace.getAndClearSourceAndGenerationDirToOpen(this.myProject);
        boolean bl = openingExisting = openSpec == null || openSpec.generationDir == null && FileUtil.filesEqual((File)projectDir, (File)openSpec.sourceDir);
        if (openingExisting) {
            Element contentRootElement = element.getChild("contentRoot");
            String contentRootDirString = contentRootElement == null ? null : contentRootElement.getAttributeValue("DIR");
            contentRootDir = contentRootDirString == null ? null : new File(contentRootDirString);
            ignoreOutsideFiles = Boolean.parseBoolean(element.getAttributeValue("IGNORE_OUTSIDE_FILES"));
        } else {
            projectDir = openSpec.sourceDir;
            this.updateSettingsFromOpenSpec(openSpec);
            contentRootDir = null;
            ignoreOutsideFiles = false;
        }
        this.myProjectDir = projectDir;
        this.myContentRoot = contentRootDir;
        this.myIgnoreFilesOutsideOfProjectRoot = ignoreOutsideFiles;
        if (!this.myInitialized.get()) {
            if (projectDir != null) {
                State loadedState = null;
                if (openingExisting) {
                    File modelFile = (File)this.runReadActionCanceling(() -> this.getProjectCacheModelFile());
                    List profileInfos = (List)this.runReadActionCanceling(() -> this.collectProfilesInfos(this.getSettings().getProfiles(), false));
                    loadedState = CMakeWorkspace.loadStateIfActual(projectDir, modelFile, profileInfos);
                }
                if (loadedState != null && OCWorkspaceImpl.getInstanceImpl(this.myProject).getVersion() == 108002) {
                    this.myState = loadedState;
                    this.myStateWasLoaded = true;
                } else {
                    this.myState = this.createInitialState(projectDir);
                }
                if (this.myProject.isInitialized()) {
                    this.initialize(ReloadFlag.FORCE_RELOAD, false);
                }
            }
        } else if (!FileUtil.filesEqual((File)this.myState.projectDir, (File)projectDir)) {
            this.selectProjectDir(projectDir);
        } else {
            ApplicationManager.getApplication().runWriteAction(this::updateContentRoots);
        }
    }

    @Nullable
    public File getModelProjectDir() {
        return this.myState.projectDir;
    }

    @Nullable
    public CMakeModel getModel() {
        return this.myState.model;
    }

    boolean isModelSettingsHashChanged(boolean alsoCheckEnvironment) {
        State state = this.myState;
        if (state.myProfilesAndEnvHash == null) {
            return true;
        }
        ProfilesAndEnvHash hash = CMakeWorkspace.calcProfilesAndEnvHash(this.collectProfilesInfos(this.getSettings().getProfiles(), false), alsoCheckEnvironment);
        if (state.myProfilesAndEnvHash.profilesHash != hash.profilesHash) {
            return true;
        }
        return alsoCheckEnvironment && state.myProfilesAndEnvHash.envHash != hash.envHash;
    }

    @NotNull
    public List<CMakeTarget> getModelTargets() {
        CMakeModel model2 = this.myState.model;
        List<Object> list = model2 == null ? Collections.emptyList() : model2.getTargets();
        if (list == null) {
            CMakeWorkspace.$$$reportNull$$$0(79);
        }
        return list;
    }

    @NotNull
    public Set<File> getCMakeDependencyFiles() {
        Set<File> set = this.myState.cmakeDependencyFilesWithStamps.keySet();
        if (set == null) {
            CMakeWorkspace.$$$reportNull$$$0(80);
        }
        return set;
    }

    @NotNull
    Map<File, FileStamp> getCMakeDependencyFilesWithStamps() {
        Map<File, FileStamp> map2 = this.myState.cmakeDependencyFilesWithStamps;
        if (map2 == null) {
            CMakeWorkspace.$$$reportNull$$$0(81);
        }
        return map2;
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        Set<File> set = this.myState.getAllSourceFiles();
        if (set == null) {
            CMakeWorkspace.$$$reportNull$$$0(82);
        }
        return set;
    }

    @NotNull
    public Collection<VirtualFile> getSourceVirtualFiles() {
        Collection<VirtualFile> collection = OCWorkspaceImpl.getInstanceImpl(this.myProject).getSources();
        if (collection == null) {
            CMakeWorkspace.$$$reportNull$$$0(83);
        }
        return collection;
    }

    @NotNull
    public Collection<File> getProjectResourceFiles() {
        Set<File> set = this.myState.getAllResourceFiles();
        if (set == null) {
            CMakeWorkspace.$$$reportNull$$$0(84);
        }
        return set;
    }

    @NotNull
    public Collection<File> getSystemLibraryRoots() {
        Collection<File> collection = OCWorkspaceImpl.getInstanceImpl(this.myProject).getSystemHeaderRoots();
        if (collection == null) {
            CMakeWorkspace.$$$reportNull$$$0(85);
        }
        return collection;
    }

    @NotNull
    public Collection<File> getUserLibraryRoots() {
        Collection<File> collection = OCWorkspaceImpl.getInstanceImpl(this.myProject).getUserHeaderRoots();
        if (collection == null) {
            CMakeWorkspace.$$$reportNull$$$0(86);
        }
        return collection;
    }

    @Nullable
    public OCResolveConfiguration getResolveConfigurationFor(@Nullable CMakeConfiguration configuration) {
        return configuration == null ? null : OCWorkspaceImpl.getInstanceImpl(this.myProject).getConfigurationById(CMakeWorkspace.getCMakeConfigurationId(configuration));
    }

    @Nullable
    public CMakeConfiguration getCMakeConfigurationFor(@Nullable OCResolveConfiguration configuration) {
        return configuration == null ? null : this.myState.cmakeConfigurationsIds.get(configuration.getUniqueId());
    }

    @NotNull
    private static String getCMakeConfigurationId(@NotNull CMakeConfiguration config) {
        if (config == null) {
            CMakeWorkspace.$$$reportNull$$$0(87);
        }
        String string = config.getProfileId() + "-" + config.getTarget().getName();
        if (string == null) {
            CMakeWorkspace.$$$reportNull$$$0(88);
        }
        return string;
    }

    @NotNull
    public CMakeProfileInfo getProfileInfoFor(@NotNull CMakeConfiguration configuration) throws ExecutionException {
        CMakeProfileInfo result;
        if (configuration == null) {
            CMakeWorkspace.$$$reportNull$$$0(89);
        }
        if ((result = this.myState.profileInfos.get(configuration.getProfileId())) == null) {
            throw new ExecutionException("Profile '" + configuration.getProfileName() + "' has been deleted");
        }
        CMakeProfileInfo cMakeProfileInfo = result;
        if (cMakeProfileInfo == null) {
            CMakeWorkspace.$$$reportNull$$$0(90);
        }
        return cMakeProfileInfo;
    }

    private static /* synthetic */ void lambda$updateOCWorkspace$33(MultiValuesMap messages, Map configToProfileIds, OCWorkspaceImpl.ModifiableModel.Message each) {
        messages.put(configToProfileIds.get(each.getConfigId()), (Object)each);
    }

    private /* synthetic */ CMakeGenerator.Parameters lambda$doGenerateProject$24(int[] index, List profileInfos, Map indexedProfileInfos, CMakeSettings.Profile it) {
        int n = index[0];
        index[0] = n + 1;
        final int profileId = n;
        String profileName = it.getName();
        String buildType = it.getBuildType();
        CMakeProfileInfo profileInfo = (CMakeProfileInfo)profileInfos.get(profileId);
        File effectiveGenerationDir = profileInfo.getGenerationDir();
        CMakeEnvironment environment = profileInfo.getEnvironment();
        assert (environment != null);
        indexedProfileInfos.put(profileId, profileInfo);
        CMakeListener listener2 = new CMakeListener(){

            @Override
            public void message(@NotNull CMakeMessage message) {
                if (message == null) {
                    7.$$$reportNull$$$0(0);
                }
                CMakeWorkspace.this.myOutputConsole.reportMessage(profileId, message);
            }

            @Override
            public void attachTo(@NotNull ProcessHandler handler) {
                if (handler == null) {
                    7.$$$reportNull$$$0(1);
                }
                CMakeWorkspace.this.myOutputConsole.attachConsoleToProcess(profileId, handler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attachTo";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CMakeGenerator.Parameters p = new CMakeGenerator.Parameters(profileId, profileName, buildType, effectiveGenerationDir, it.getEffectiveGenerationOptionsList(environment.getToolchain()), it.getPassSystemEnvironment(), it.getAdditionalEnvironment(), listener2, environment);
        return ourGenerationParametersConfigurator == null ? p : (CMakeGenerator.Parameters)ourGenerationParametersConfigurator.fun((Object)p);
    }

    static {
        ourReloadsCounter = new AtomicInteger(0);
        ourCheckCachesValidity = Ref.create((Object)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openSpec";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileNamesWithSpecifiedDirs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileNames";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdir";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeGeneration";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterGeneration";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 39: 
            case 43: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesAndEnvHash";
                break;
            }
            case 44: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileInfos";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousState";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMapper";
                break;
            }
            case 51: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesCollector";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyCalculatedStamps";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getVirtualFile";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 58: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flushMessagesType";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 62: 
            case 67: 
            case 68: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProjectDir";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFile";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualProfileInfos";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenMarkerFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseCacheDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCacheDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCacheModelFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveProfileGenerationDirs";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileGenerationDirNames";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubDir";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelConfigurationData";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateProject";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProfilesGenerationDirs";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProfilesInfos";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calcProfilesAndEnvHash";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialState";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createStateWithModel";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "updateOCWorkspace";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateFileStamps";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRoots";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUpdateRoots";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExcludeRoots";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelTargets";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDependencyFiles";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDependencyFilesWithStamps";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceVirtualFiles";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectResourceFiles";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemLibraryRoots";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserLibraryRoots";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeConfigurationId";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileInfoFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceReloadOnOpening";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSettingsFromOpenSpec";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearSourceAndGenerationDirToOpen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showBalloonNotification";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveProfileGenerationDirs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProfileGenerationDirNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSubDir";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReload";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doReload";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateProject";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectProfilesGenerationDirs";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectProfilesInfos";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "determineEncoding";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createStateWithModel";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "updateOCWorkspace";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "calculateFileStamps";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "flushConsoleMessages";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "loadStateIfActual";
                break;
            }
            case 67: 
            case 68: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "updateContentRoots";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "collectUpdateRoots";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeConfigurationId";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getProfileInfoFor";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flushConsoleMessages$35";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$determineEncoding$31";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface BalloonNotifier {
        public void notify(@NotNull MessageType var1, @NotNull String var2, @NotNull HyperlinkListener var3);
    }

    private static class MyRootsSynchronizer
    extends OCRootsSynchronizer {
        public MyRootsSynchronizer(@NotNull Project project2) {
            if (project2 == null) {
                MyRootsSynchronizer.$$$reportNull$$$0(0);
            }
            super(project2, CMakeWorkspace.getModuleType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$MyRootsSynchronizer", "<init>"));
        }
    }

    private static class State {
        @Nullable
        final File projectDir;
        @Nullable
        final ProfilesAndEnvHash myProfilesAndEnvHash;
        @Nullable
        final CMakeModel model;
        @NotNull
        final Map<Integer, CMakeProfileInfo> profileInfos;
        @NotNull
        final Map<File, FileStamp> cmakeDependencyFilesWithStamps;
        @NotNull
        final Map<String, CMakeConfiguration> cmakeConfigurationsIds;

        public State(@Nullable File projectDir, @NotNull Map<File, FileStamp> cmakeDependencyFilesWithStamps) {
            if (cmakeDependencyFilesWithStamps == null) {
                State.$$$reportNull$$$0(0);
            }
            this(projectDir, null, null, Collections.emptyMap(), cmakeDependencyFilesWithStamps);
        }

        private State(@Nullable File projectDir, @Nullable ProfilesAndEnvHash profilesAndEnvHash, @Nullable CMakeModel model2, @NotNull Map<Integer, CMakeProfileInfo> profileInfos, @NotNull Map<File, FileStamp> cmakeDependencyFilesWithStamps) {
            if (profileInfos == null) {
                State.$$$reportNull$$$0(1);
            }
            if (cmakeDependencyFilesWithStamps == null) {
                State.$$$reportNull$$$0(2);
            }
            this.projectDir = projectDir;
            this.myProfilesAndEnvHash = profilesAndEnvHash;
            this.model = model2;
            this.profileInfos = ContainerUtil.unmodifiableOrEmptyMap(profileInfos);
            CPPLog.LOG.assertTrue(projectDir == null || cmakeDependencyFilesWithStamps.containsKey(new File(projectDir, "CMakeLists.txt")));
            this.cmakeDependencyFilesWithStamps = ContainerUtil.unmodifiableOrEmptyMap(cmakeDependencyFilesWithStamps);
            if (model2 != null) {
                THashMap configIds = new THashMap();
                for (CMakeTarget eachTarget : model2.getTargets()) {
                    for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                        configIds.put(CMakeWorkspace.getCMakeConfigurationId(eachConfig), eachConfig);
                    }
                }
                this.cmakeConfigurationsIds = Collections.unmodifiableMap(configIds);
            } else {
                this.cmakeConfigurationsIds = Collections.emptyMap();
            }
        }

        @NotNull
        Set<File> getAllSourceFiles() {
            if (this.model == null) {
                Set<File> set = Collections.emptySet();
                if (set == null) {
                    State.$$$reportNull$$$0(3);
                }
                return set;
            }
            THashSet result = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (CMakeTarget eachTarget : this.model.getTargets()) {
                for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                    result.addAll(eachConfig.getSources());
                }
            }
            Set<File> set = Collections.unmodifiableSet(result);
            if (set == null) {
                State.$$$reportNull$$$0(4);
            }
            return set;
        }

        @NotNull
        Set<File> getAllResourceFiles() {
            if (this.model == null) {
                Set<File> set = Collections.emptySet();
                if (set == null) {
                    State.$$$reportNull$$$0(5);
                }
                return set;
            }
            THashSet result = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            result.addAll(this.model.getCMakeDependencyFiles());
            result.addAll(this.model.getHeaderAndResourceFiles());
            Set<File> set = Collections.unmodifiableSet(result);
            if (set == null) {
                State.$$$reportNull$$$0(6);
            }
            return set;
        }

        @NotNull
        private List<File> getAllGenerationDirs() {
            if (this.model == null) {
                List<File> list = Collections.emptyList();
                if (list == null) {
                    State.$$$reportNull$$$0(7);
                }
                return list;
            }
            List list = ContainerUtil.map(this.model.getConfigurationData(), data -> data.getGenerationDir());
            if (list == null) {
                State.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmakeDependencyFilesWithStamps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profileInfos";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$State";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceFiles";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllResourceFiles";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllGenerationDirs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProfilesAndEnvHash {
        final long profilesHash;
        final long envHash;

        public ProfilesAndEnvHash(long profilesHash, long envHash) {
            this.profilesHash = profilesHash;
            this.envHash = envHash;
        }
    }

    private static class UpdateRoots {
        @NotNull
        List<File> roots;
        @NotNull
        List<File> sourceFiles;
        @NotNull
        OCRootsSynchronizer.RootsInfo rootsInfo;

        public UpdateRoots(@NotNull List<File> roots, @NotNull List<File> sourceFiles, @NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
            if (roots == null) {
                UpdateRoots.$$$reportNull$$$0(0);
            }
            if (sourceFiles == null) {
                UpdateRoots.$$$reportNull$$$0(1);
            }
            if (rootsInfo == null) {
                UpdateRoots.$$$reportNull$$$0(2);
            }
            this.roots = roots;
            this.sourceFiles = sourceFiles;
            this.rootsInfo = rootsInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootsInfo";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace$UpdateRoots";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum ReloadFlag {
        FORCE_RELOAD,
        RELOAD_ONLY_WHEN_CHANGED,
        RELOAD_ONLY_WHEN_CHANGED_PLUS_FULL_CHECK_ENVIRONMENT;

    }
}

