/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.FilesModificationsListener;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeFile;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.FileStamp;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeWorkspaceWatcher {
    public static final Key<Boolean> NEEDS_RELOAD = Key.create((String)"NEEDS_RELOAD");
    public static final Key<Boolean> SHOULD_CHECK_DOCUMENT_TEXT = Key.create((String)"SHOULD_CHECK_DOCUMENT_TEXT");
    private static final String READING_CMAKE_PROJECT = CPPBundle.message("cmake.loadingProgress", new Object[0]);
    private static final int DOCUMENT_CHECK_DELAY = 1000;
    @NotNull
    private AtomicBoolean myInitialized;
    @NotNull
    private final Disposable myShutdownDisposable;
    @NotNull
    private final Project myProject;
    @NotNull
    private final CMakeWorkspace myWorkspace;
    @NotNull
    private final BackgroundTaskQueue myReloadsQueue;
    @NotNull
    private final MergingUpdateQueue myChangedDocumentsQueue;
    @NotNull
    private final QueueProcessor<Runnable> mySchedulingQueueProcessor;
    @NotNull
    private final ReadWriteLock myReloadsLock;
    @NotNull
    private final AtomicInteger myWaitingReloadsCount;
    @Nullable
    private volatile ProgressIndicator myRunningReloadTaskIndicator;
    private volatile boolean myReloadInBackgroundInTestsMode;

    public CMakeWorkspaceWatcher(@NotNull Project project2, @NotNull CMakeWorkspace workspace) {
        if (project2 == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(0);
        }
        if (workspace == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(1);
        }
        this.myInitialized = new AtomicBoolean(false);
        this.myShutdownDisposable = Disposer.newDisposable();
        this.mySchedulingQueueProcessor = QueueProcessor.createRunnableQueueProcessor();
        this.myReloadsLock = new ReentrantReadWriteLock(true);
        this.myWaitingReloadsCount = new AtomicInteger();
        this.myProject = project2;
        this.myWorkspace = workspace;
        this.myReloadsQueue = new BackgroundTaskQueue(project2, READING_CMAKE_PROJECT);
        this.myChangedDocumentsQueue = new MergingUpdateQueue(this.getClass() + ": Document changes queue", 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject, null, false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myChangedDocumentsQueue.setPassThrough(true);
        }
    }

    public void listenForChanges() {
        if (this.myInitialized.getAndSet(true)) {
            return;
        }
        Disposer.register((Disposable)this.myProject, (Disposable)this.myShutdownDisposable);
        final AtomicBoolean isGenerationRunning = new AtomicBoolean(false);
        final AtomicInteger isGenerationRefreshRunning = new AtomicInteger(0);
        final AtomicLong lastGenerationTimestamp = new AtomicLong(0L);
        this.myProject.getMessageBus().connect(this.myShutdownDisposable).subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            @Override
            public void generationStarted() {
                isGenerationRunning.set(true);
                isGenerationRefreshRunning.incrementAndGet();
                lastGenerationTimestamp.set(System.currentTimeMillis());
            }

            @Override
            public void generationFinished() {
                isGenerationRunning.set(false);
                lastGenerationTimestamp.set(System.currentTimeMillis());
            }

            @Override
            public void filesRefreshedAfterGeneration() {
                isGenerationRefreshRunning.decrementAndGet();
            }
        });
        final Function getWatchedFileForDocument = doc -> {
            VirtualFile vFile = FileDocumentManager.getInstance().getFile(doc);
            if (vFile == null) {
                return null;
            }
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
            if (!this.myWorkspace.getCMakeDependencyFiles().contains(ioFile)) {
                return null;
            }
            return Pair.create((Object)ioFile, (Object)vFile);
        };
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                if (getWatchedFileForDocument.fun((Object)e.getEditor().getDocument()) != null) {
                    CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.restartTimer();
                }
            }
        }, this.myShutdownDisposable);
        multicaster.addDocumentListener(new DocumentListener(){
            @NotNull
            final Map<File, Document> myChangedDocuments = new THashMap(FileUtil.FILE_HASHING_STRATEGY);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                Document doc = event.getDocument();
                Pair files = (Pair)getWatchedFileForDocument.fun((Object)doc);
                if (files == null) {
                    return;
                }
                if (((VirtualFile)files.second).getModificationStamp() >= doc.getModificationStamp()) {
                    return;
                }
                doc.putUserData(SHOULD_CHECK_DOCUMENT_TEXT, (Object)true);
                Map<File, Document> map2 = this.myChangedDocuments;
                synchronized (map2) {
                    this.myChangedDocuments.put((File)files.first, doc);
                }
                CMakeWorkspaceWatcher.this.runWhenReady(this::scheduleDocsUpdate);
            }

            private void scheduleDocsUpdate() {
                CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.restartTimer();
                CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.queue(new Update(CMakeWorkspaceWatcher.this){

                    public void run() {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            boolean changed;
                            THashMap fileStampFunctionMap;
                            if (CMakeWorkspaceWatcher.this.myProject.isDisposed()) {
                                return;
                            }
                            LookupEx lookup = LookupManager.getInstance((Project)CMakeWorkspaceWatcher.this.myProject).getActiveLookup();
                            if (lookup != null && (lookup.getComponent().isShowing() || ApplicationManager.getApplication().isUnitTestMode())) {
                                this.rescheduleWithDelay();
                                return;
                            }
                            Map<File, Document> map2 = myChangedDocuments;
                            synchronized (map2) {
                                fileStampFunctionMap = new THashMap(myChangedDocuments.size(), FileUtil.FILE_HASHING_STRATEGY);
                                for (final Map.Entry<File, Document> eachEntry : myChangedDocuments.entrySet()) {
                                    fileStampFunctionMap.put(eachEntry.getKey(), new FileStampFunctionAdapter(false){
                                        CMakeFile myCachedPsiFile;

                                        @Override
                                        @Nullable
                                        public CMakeFile getCMakeFile(@NotNull Project project2) {
                                            if (project2 == null) {
                                                1.$$$reportNull$$$0(0);
                                            }
                                            if (this.myCachedPsiFile != null) {
                                                return this.myCachedPsiFile;
                                            }
                                            this.myCachedPsiFile = FileStamp.createOrGetCMakeFile(project2, (Document)eachEntry.getValue());
                                            return this.myCachedPsiFile;
                                        }

                                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$3$1$1", "getCMakeFile"));
                                        }
                                    });
                                }
                                myChangedDocuments.clear();
                            }
                            boolean bl = changed = CMakeWorkspaceWatcher.this.cmakeFilesHaveChanges(fileStampFunctionMap.keySet(), (NotNullFunction<File, FileStampFunctionAdapter>)arg_0 -> 1.lambda$null$0((Map)fileStampFunctionMap, arg_0)) && this.haveValidSyntax(fileStampFunctionMap.keySet(), (NotNullFunction<File, FileStampFunctionAdapter>)((NotNullFunction)arg_0 -> 1.lambda$null$1((Map)fileStampFunctionMap, arg_0)));
                            if (changed) {
                                if (CPPLog.LOG.isDebugEnabled()) {
                                    CPPLog.LOG.debug("CMake needs to be reloaded because documents changed:\n" + StringUtil.join(Collections.singletonList(fileStampFunctionMap.keySet()), (String)"\n"));
                                }
                                if (CMakeWorkspaceWatcher.this.isAutoReloadEnabled()) {
                                    CMakeWorkspaceWatcher.this.myWorkspace.scheduleReload(false);
                                } else {
                                    CMakeWorkspaceWatcher.this.setNeedsReload(true);
                                }
                            }
                        });
                    }

                    private void rescheduleWithDelay() {
                        ((CMakeWorkspaceListener)CMakeWorkspaceWatcher.this.myProject.getMessageBus().syncPublisher(CMakeWorkspaceListener.TOPIC)).reloadingRescheduled();
                        CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.restartTimer();
                        CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.queue((Update)this);
                    }

                    private boolean haveValidSyntax(@NotNull Collection<File> changedDocuments, @NotNull NotNullFunction<File, FileStampFunctionAdapter> getFileDocumentStampFunction) {
                        if (changedDocuments == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (getFileDocumentStampFunction == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return !ContainerUtil.exists(changedDocuments, each -> {
                            CMakeFile cmake;
                            if (getFileDocumentStampFunction == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return (cmake = ((FileStampFunctionAdapter)getFileDocumentStampFunction.fun(each)).getCMakeFile(CMakeWorkspaceWatcher.this.myProject)) != null && PsiTreeUtil.hasErrorElements((PsiElement)cmake);
                        });
                    }

                    public boolean canEat(Update update) {
                        return true;
                    }

                    private static /* synthetic */ FileStampFunctionAdapter lambda$null$1(Map fileStampFunctionMap, File file) {
                        return (FileStampFunctionAdapter)fileStampFunctionMap.get(file);
                    }

                    private static /* synthetic */ FileStampFunctionAdapter lambda$null$0(Map fileStampFunctionMap, File file) {
                        return (FileStampFunctionAdapter)fileStampFunctionMap.get(file);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "changedDocuments";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "getFileDocumentStampFunction";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "haveValidSyntax";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$haveValidSyntax$3";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }, this.myShutdownDisposable);
        new FilesModificationsListener(){

            @Override
            @NotNull
            protected Set<File> getWatchedFiles() {
                Set<File> set = CMakeWorkspaceWatcher.this.myWorkspace.getCMakeDependencyFiles();
                if (set == null) {
                    4.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            protected void watchedFilesChanged(@NotNull Set<File> structurallyChangedFiles, @NotNull Set<VirtualFile> filesWithContentChanges, boolean externalChange, boolean fromSave) {
                if (structurallyChangedFiles == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (filesWithContentChanges == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (externalChange) {
                    if (isGenerationRunning.get()) {
                        return;
                    }
                    if (isGenerationRefreshRunning.get() > 0 && !ContainerUtil.exists(structurallyChangedFiles, file -> file.lastModified() > lastGenerationTimestamp.get())) {
                        return;
                    }
                }
                if (!structurallyChangedFiles.isEmpty()) {
                    if (CPPLog.LOG.isDebugEnabled()) {
                        CPPLog.LOG.debug("CMake needs to be reloaded because files changed structurally" + (externalChange ? "(external)" : "") + ":\n" + StringUtil.join(structurallyChangedFiles, (String)"\n"));
                    }
                } else {
                    if (fromSave) {
                        return;
                    }
                    final Map map2 = ContainerUtil.map2MapNotNull(filesWithContentChanges, file -> Pair.create((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file), (Object)file));
                    boolean filesHaveChanged = CMakeWorkspaceWatcher.this.cmakeFilesHaveChanges(map2.keySet(), (NotNullFunction<File, FileStampFunctionAdapter>)file -> new FileStampFunctionAdapter(true, (File)file){
                        final /* synthetic */ File val$file;
                        {
                            this.val$file = file;
                            super(useAlreadyCalculatedStamp);
                        }

                        @Override
                        @Nullable
                        public CMakeFile getCMakeFile(@NotNull Project project2) {
                            if (project2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return FileStamp.createOrGetCMakeFile(project2, (VirtualFile)map2.get(this.val$file));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$4$1", "getCMakeFile"));
                        }
                    });
                    if (!filesHaveChanged) {
                        return;
                    }
                    if (CPPLog.LOG.isDebugEnabled()) {
                        CPPLog.LOG.debug("CMake needs to be reloaded because file contents changed" + (externalChange ? "(external)" : "") + ":\n" + StringUtil.join(filesWithContentChanges, (String)"\n"));
                    }
                }
                CMakeWorkspaceWatcher.this.myWorkspace.scheduleReload(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "structurallyChangedFiles";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filesWithContentChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWatchedFiles";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "watchedFilesChanged";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.install(this.myProject, this.myShutdownDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.myInitialized.getAndSet(false)) {
            return;
        }
        Disposer.dispose((Disposable)this.myShutdownDisposable);
        this.myChangedDocumentsQueue.cancelAllUpdates();
        this.myReloadsQueue.clear();
        this.mySchedulingQueueProcessor.clear();
        this.myWaitingReloadsCount.set(0);
        AtomicInteger atomicInteger = this.myWaitingReloadsCount;
        synchronized (atomicInteger) {
            this.myWaitingReloadsCount.notifyAll();
        }
        ProgressIndicator currentIndicator = this.myRunningReloadTaskIndicator;
        if (currentIndicator != null) {
            currentIndicator.cancel();
        }
    }

    private void runWhenReady(@NotNull DumbAwareRunnable runnable2) {
        if (runnable2 == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(2);
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            if (runnable2 == null) {
                CMakeWorkspaceWatcher.$$$reportNull$$$0(16);
            }
            if (!this.myInitialized.get()) {
                return;
            }
            runnable2.run();
        }));
    }

    public <T> Future<T> lockModelDuring(Callable<T> callable) {
        FutureResult result = new FutureResult();
        this.runWhenReady(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Lock lock = this.myReloadsLock.readLock();
            lock.lock();
            try {
                result.set(callable.call());
            }
            catch (Throwable e) {
                result.setException(e);
            }
            finally {
                lock.unlock();
            }
        }));
        return result;
    }

    public void setReloadInBackgroundInTests(final boolean value, final Disposable disposable) {
        new WriteAction<Object>(){

            protected void run(@NotNull Result<Object> result) {
                if (result == null) {
                    5.$$$reportNull$$$0(0);
                }
                CMakeWorkspaceWatcher.this.myReloadInBackgroundInTestsMode = value;
                CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.setPassThrough(!value);
                CMakeWorkspaceWatcher.this.myReloadsQueue.setForceAsyncInTests(value, disposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$5", "run"));
            }
        }.execute();
    }

    public void stopReloadsOnDocumentChange() {
        this.myChangedDocumentsQueue.suspend();
    }

    public void resumeReloadsOnDocumentChange() {
        this.myChangedDocumentsQueue.resume();
    }

    public void waitForReloadsToFinish() throws TimeoutException {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new AssertionError((Object)"Must not wait for CMake reload on AWT, a deadlock will happen.\nRewrite the test with runInDispatchThread=false");
        }
        AtomicBoolean finished = new AtomicBoolean();
        Thread thread = new Thread(() -> {
            this.myChangedDocumentsQueue.flush();
            while (this.myChangedDocumentsQueue.isFlushing()) {
                TimeoutUtil.sleep((long)100L);
            }
            AtomicInteger atomicInteger = this.myWaitingReloadsCount;
            synchronized (atomicInteger) {
                while (this.myWaitingReloadsCount.get() > 0) {
                    try {
                        this.myWaitingReloadsCount.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.mySchedulingQueueProcessor.waitFor();
            this.myReloadsQueue.waitForTasksToFinish();
            this.myReloadsLock.writeLock().lock();
            this.myReloadsLock.writeLock().unlock();
            RefreshQueue.getInstance().refresh(false, false, null, Collections.emptyList());
            finished.set(true);
        }, "wait for reload");
        thread.start();
        try {
            thread.join(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished.get()) {
            throw new TimeoutException();
        }
    }

    void scheduleReload(@NotNull Consumer<ProgressIndicator> reloadRunnable, @NotNull CMakeWorkspace.ReloadFlag flag) {
        if (reloadRunnable == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(3);
        }
        if (flag == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(4);
        }
        this.setNeedsReload(false);
        this.myChangedDocumentsQueue.cancelAllUpdates();
        this.myWaitingReloadsCount.incrementAndGet();
        Throwable originalStackTrace = new Throwable().fillInStackTrace();
        this.runWhenReady(() -> {
            if (reloadRunnable == null) {
                CMakeWorkspaceWatcher.$$$reportNull$$$0(14);
            }
            if (flag == null) {
                CMakeWorkspaceWatcher.$$$reportNull$$$0(15);
            }
            this.doScheduleReload(reloadRunnable, flag, originalStackTrace);
        });
    }

    private void doScheduleReload(final @NotNull Consumer<ProgressIndicator> reloadRunnable, final @NotNull CMakeWorkspace.ReloadFlag flag, final @NotNull Throwable originalStackTrace) {
        ProgressIndicator indicator;
        if (reloadRunnable == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(5);
        }
        if (flag == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(6);
        }
        if (originalStackTrace == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(7);
        }
        if ((indicator = this.myRunningReloadTaskIndicator) != null) {
            indicator.cancel();
        }
        final Throwable localOriginalStackTrace = new Throwable().fillInStackTrace();
        Runnable action = () -> {
            block10: {
                if (flag == null) {
                    CMakeWorkspaceWatcher.$$$reportNull$$$0(11);
                }
                if (reloadRunnable == null) {
                    CMakeWorkspaceWatcher.$$$reportNull$$$0(12);
                }
                if (originalStackTrace == null) {
                    CMakeWorkspaceWatcher.$$$reportNull$$$0(13);
                }
                if (!this.myInitialized.get()) {
                    return;
                }
                Lock writeLock = this.myReloadsLock.writeLock();
                writeLock.lock();
                try {
                    if (this.myWaitingReloadsCount.decrementAndGet() != 0) break block10;
                    AtomicInteger atomicInteger = this.myWaitingReloadsCount;
                    synchronized (atomicInteger) {
                        this.myWaitingReloadsCount.notifyAll();
                    }
                    this.myReloadsQueue.run(new Task.Backgroundable(this.myProject, READING_CMAKE_PROJECT, true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                6.$$$reportNull$$$0(0);
                            }
                            if (!CMakeWorkspaceWatcher.this.myInitialized.get()) {
                                return;
                            }
                            CMakeWorkspaceWatcher.this.myRunningReloadTaskIndicator = indicator;
                            try {
                                if (flag == CMakeWorkspace.ReloadFlag.FORCE_RELOAD || CMakeWorkspaceWatcher.this.cmakeFilesOrDocumentsHaveChangesOrSettingsChanged(indicator, flag == CMakeWorkspace.ReloadFlag.RELOAD_ONLY_WHEN_CHANGED_PLUS_FULL_CHECK_ENVIRONMENT)) {
                                    reloadRunnable.accept(indicator);
                                }
                            }
                            catch (RuntimeException e) {
                                localOriginalStackTrace.addSuppressed(originalStackTrace);
                                e.addSuppressed(localOriginalStackTrace);
                                ExceptionUtil.rethrow((Throwable)e);
                            }
                            finally {
                                CMakeWorkspaceWatcher.this.myRunningReloadTaskIndicator = null;
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$6", "run"));
                        }
                    });
                    this.myReloadsQueue.waitForTasksToFinish();
                }
                finally {
                    writeLock.unlock();
                }
            }
        };
        if (this.shouldReloadInBackground()) {
            this.mySchedulingQueueProcessor.add((Object)action);
        } else {
            action.run();
        }
    }

    @Nullable
    ProgressIndicator getRunningReloadTaskIndicator() {
        return this.myRunningReloadTaskIndicator;
    }

    private boolean shouldReloadInBackground() {
        return !ApplicationManager.getApplication().isUnitTestMode() || this.myReloadInBackgroundInTestsMode;
    }

    private boolean isAutoReloadEnabled() {
        return this.myWorkspace.getSettings().isAutoReloadEnabled();
    }

    public void schedulePendingAutoReloads() {
        if (this.myProject.getUserData(NEEDS_RELOAD) != null && this.isAutoReloadEnabled()) {
            this.myWorkspace.scheduleReload(false);
        }
    }

    private void setNeedsReload(boolean value) {
        this.myProject.putUserData(NEEDS_RELOAD, (Object)(value ? Boolean.valueOf(true) : null));
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    private boolean cmakeFilesOrDocumentsHaveChangesOrSettingsChanged(final @NotNull ProgressIndicator indicator, boolean alsoCheckEnvironment) {
        if (indicator == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(8);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (indicator == null) {
                CMakeWorkspaceWatcher.$$$reportNull$$$0(10);
            }
            indicator.checkCanceled();
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.myWorkspace.isModelSettingsHashChanged(alsoCheckEnvironment)) {
                return true;
            }
            NotNullFunction<File, FileStampFunctionAdapter> getFileStampFunction = new NotNullFunction<File, FileStampFunctionAdapter>(){
                FileDocumentManager myDocumentManager;

                @NotNull
                public FileStampFunctionAdapter fun(File file) {
                    Document document;
                    boolean checkDocumentText;
                    indicator.checkCanceled();
                    final VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                    if (vFile == null) {
                        FileStampFunctionAdapter fileStampFunctionAdapter = new FileStampFunctionAdapter(true){

                            @Override
                            @Nullable
                            public CMakeFile getCMakeFile(@NotNull Project project2) {
                                if (project2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return null;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$7$1", "getCMakeFile"));
                            }
                        };
                        if (fileStampFunctionAdapter == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        return fileStampFunctionAdapter;
                    }
                    if (this.myDocumentManager == null) {
                        this.myDocumentManager = FileDocumentManager.getInstance();
                    }
                    boolean bl = checkDocumentText = (document = this.myDocumentManager.getCachedDocument(vFile)) != null && document.getUserData(SHOULD_CHECK_DOCUMENT_TEXT) == Boolean.TRUE;
                    if (document != null) {
                        document.putUserData(SHOULD_CHECK_DOCUMENT_TEXT, null);
                    }
                    FileStampFunctionAdapter fileStampFunctionAdapter = new FileStampFunctionAdapter(!checkDocumentText){

                        @Override
                        @Nullable
                        public CMakeFile getCMakeFile(@NotNull Project project2) {
                            if (project2 == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (checkDocumentText) {
                                return FileStamp.createOrGetCMakeFile(project2, document);
                            }
                            return FileStamp.createOrGetCMakeFile(project2, vFile);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$7$2", "getCMakeFile"));
                        }
                    };
                    if (fileStampFunctionAdapter == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    return fileStampFunctionAdapter;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$7", "fun"));
                }
            };
            return this.cmakeFilesHaveChanges(null, getFileStampFunction);
        });
    }

    private boolean cmakeFilesHaveChanges(@Nullable Collection<File> toCheckOrNullForAll, final @NotNull NotNullFunction<File, FileStampFunctionAdapter> getFileDocumentStampFunction) {
        Map oldStamps;
        if (getFileDocumentStampFunction == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(9);
        }
        if ((oldStamps = (Map)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return null;
            }
            return this.myWorkspace.getCMakeDependencyFilesWithStamps();
        })) == null) {
            return false;
        }
        Collection<File> newFiles = toCheckOrNullForAll != null ? toCheckOrNullForAll : oldStamps.keySet();
        for (final File newFile : newFiles) {
            FileStamp oldStamp;
            FileStamp.FileStampFunction fileStampFunction;
            FileStamp newStamp = (FileStamp)ReadAction.compute(() -> this.lambda$cmakeFilesHaveChanges$9(newFile, fileStampFunction = new FileStamp.FileStampFunction(oldStamp = (FileStamp)oldStamps.get(newFile)){
                FileStampFunctionAdapter delegate;
                final /* synthetic */ FileStamp val$oldStamp;
                {
                    this.val$oldStamp = fileStamp;
                    this.delegate = (FileStampFunctionAdapter)getFileDocumentStampFunction.fun((Object)newFile);
                }

                @Override
                public FileStamp getAlreadyCalculatedStamp() {
                    return this.delegate.useAlreadyCalculatedStamp ? this.val$oldStamp : null;
                }

                @Override
                @Nullable
                public CMakeFile getCMakeFile(@NotNull Project project2) {
                    if (project2 == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return this.delegate.getCMakeFile(project2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$8", "getCMakeFile"));
                }
            }));
            if (newStamp == null) {
                return false;
            }
            if (oldStamp == null || oldStamp.timestamp != newStamp.timestamp && (oldStamp.timestamp == 0L || newStamp.timestamp == 0L)) {
                return true;
            }
            if (oldStamp.contentCrc != newStamp.contentCrc) {
                return true;
            }
            if (oldStamp.contentCrc != -1L || oldStamp.timestamp == newStamp.timestamp && oldStamp.size == newStamp.size) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ FileStamp lambda$cmakeFilesHaveChanges$9(File newFile, FileStamp.FileStampFunction fileStampFunction) throws RuntimeException {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return FileStamp.calcFileStamp(this.myProject, newFile, fileStampFunction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadRunnable";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStackTrace";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getFileDocumentStampFunction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenReady";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleReload";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doScheduleReload";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "cmakeFilesOrDocumentsHaveChangesOrSettingsChanged";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "cmakeFilesHaveChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$cmakeFilesOrDocumentsHaveChangesOrSettingsChanged$7";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doScheduleReload$6";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$scheduleReload$5";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runWhenReady$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class FileStampFunctionAdapter {
        final boolean useAlreadyCalculatedStamp;

        public FileStampFunctionAdapter(boolean useAlreadyCalculatedStamp) {
            this.useAlreadyCalculatedStamp = useAlreadyCalculatedStamp;
        }

        @Nullable
        public abstract CMakeFile getCMakeFile(@NotNull Project var1);
    }
}

