/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeArgument;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeCommandName;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeElementFactory;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeFile;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeLiteral;
import com.jetbrains.cidr.cpp.cmake.psi.CMakeTokenTypes;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileStamp {
    public static final int UNKNOWN = -1;
    public final long timestamp;
    public final long size;
    public final long contentCrc;

    public FileStamp(long timestamp, long size, long contentCrc) {
        this.timestamp = timestamp;
        this.size = size;
        this.contentCrc = contentCrc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStamp stamp = (FileStamp)o;
        if (this.timestamp != stamp.timestamp) {
            return false;
        }
        if (this.size != stamp.size) {
            return false;
        }
        return this.contentCrc == stamp.contentCrc;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.contentCrc ^ this.contentCrc >>> 32);
        return result;
    }

    public String toString() {
        return "Stamp{timestamp=" + this.timestamp + ", size=" + this.size + ", contentCrc=" + this.contentCrc + '}';
    }

    @Nullable
    public static CMakeFile createOrGetCMakeFile(@NotNull Project project2, @NotNull VirtualFile file) {
        Document cachedDoc;
        if (project2 == null) {
            FileStamp.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileStamp.$$$reportNull$$$0(1);
        }
        if ((cachedDoc = FileDocumentManager.getInstance().getCachedDocument(file)) != null && cachedDoc.getModificationStamp() == file.getModificationStamp()) {
            return FileStamp.createOrGetCMakeFile(project2, cachedDoc);
        }
        try {
            return CMakeElementFactory.createFile(project2, VfsUtilCore.loadText((VirtualFile)file));
        }
        catch (IOException ignore) {
            return null;
        }
    }

    @NotNull
    public static CMakeFile createOrGetCMakeFile(@NotNull Project project2, @NotNull Document document) {
        PsiDocumentManager manager;
        PsiFile cachedPsi;
        if (project2 == null) {
            FileStamp.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FileStamp.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = cachedPsi = (manager = PsiDocumentManager.getInstance((Project)project2)).isCommitted(document) ? manager.getCachedPsiFile(document) : null;
        if (cachedPsi instanceof CMakeFile) {
            CMakeFile cMakeFile = (CMakeFile)cachedPsi;
            if (cMakeFile == null) {
                FileStamp.$$$reportNull$$$0(4);
            }
            return cMakeFile;
        }
        CMakeFile cMakeFile = CMakeElementFactory.createFile(project2, document.getText());
        if (cMakeFile == null) {
            FileStamp.$$$reportNull$$$0(5);
        }
        return cMakeFile;
    }

    @NotNull
    public static FileStamp calcFileStamp(@NotNull Project project2, @NotNull File file, @NotNull FileStampFunction fileFunction) {
        CMakeFile cmakeFile;
        if (project2 == null) {
            FileStamp.$$$reportNull$$$0(6);
        }
        if (file == null) {
            FileStamp.$$$reportNull$$$0(7);
        }
        if (fileFunction == null) {
            FileStamp.$$$reportNull$$$0(8);
        }
        long fileLastModified = file.lastModified();
        long fileLength = file.length();
        FileStamp alreadyCalculated = fileFunction.getAlreadyCalculatedStamp();
        if (alreadyCalculated != null && fileLastModified == alreadyCalculated.timestamp && fileLength == alreadyCalculated.size) {
            FileStamp fileStamp = alreadyCalculated;
            if (fileStamp == null) {
                FileStamp.$$$reportNull$$$0(9);
            }
            return fileStamp;
        }
        long crc = -1L;
        String name2 = file.getName();
        if (fileLength <= (long)PersistentFSConstants.getMaxIntellisenseFileSize() && (name2.equalsIgnoreCase("CMakeLists.txt") || StringUtil.endsWithIgnoreCase((String)name2, (String)".cmake")) && (cmakeFile = fileFunction.getCMakeFile(project2)) != null) {
            crc = FileStamp.calcFileHashCode(cmakeFile);
        }
        FileStamp fileStamp = new FileStamp(fileLastModified, fileLength, crc);
        if (fileStamp == null) {
            FileStamp.$$$reportNull$$$0(10);
        }
        return fileStamp;
    }

    public static long calcFileHashCode(@NotNull CMakeFile psiFile) {
        if (psiFile == null) {
            FileStamp.$$$reportNull$$$0(11);
        }
        CRC32 crc32 = new CRC32();
        boolean hadEOL = false;
        PsiElement element = PsiTreeUtil.firstChild((PsiElement)psiFile);
        while (element != null) {
            boolean significantLeaf;
            PsiElement parent = element.getParent();
            boolean bl = significantLeaf = element instanceof LeafPsiElement && !(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace) && !"\"".equals(element.getText()) && (!";".equals(element.getText()) || !(parent instanceof CMakeCommandArguments));
            if (significantLeaf) {
                boolean isEOL = ((TreeElement)element).getElementType().equals(CMakeTokenTypes.EOL);
                if (!isEOL) {
                    if (hadEOL) {
                        crc32.update(10);
                        hadEOL = false;
                    }
                    crc32.update(-1);
                    String text = element.getText();
                    if (parent instanceof CMakeCommandName) {
                        text = text.toLowerCase(Locale.ENGLISH);
                        crc32.update(-2);
                    } else if (parent instanceof CMakeArgument) {
                        text = ((CMakeArgument)parent).getValue();
                        crc32.update(-3);
                    } else if (parent instanceof CMakeLiteral) {
                        text = ((CMakeArgument)parent.getParent()).getValue();
                        crc32.update(-4);
                    }
                    crc32.update(text.getBytes());
                }
                hadEOL = hadEOL || isEOL && !(parent instanceof CMakeFile);
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return crc32.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/FileStamp";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFunction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/FileStamp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetCMakeFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFileStamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOrGetCMakeFile";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcFileStamp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcFileHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface FileStampFunction {
        @Nullable
        public FileStamp getAlreadyCalculatedStamp();

        @Nullable
        public CMakeFile getCMakeFile(@NotNull Project var1);
    }
}

