/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.CMakeLauncher;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeAppRunConfiguration
extends CidrRunConfiguration<CMakeConfiguration, CMakeTarget>
implements CidrExecutableDataHolder {
    @Nullable
    private ExecutableData myExecutableData;
    @Nullable
    private String myExplicitBuildTargetName;
    public static final String ALL_TARGET = "all";
    public static final String INSTALL_TARGET = "install";
    public static final String CLEAN_TARGET = "clean";

    protected CMakeAppRunConfiguration(Project project2, ConfigurationFactory factory2, String name2) {
        super(project2, factory2, name2);
    }

    @NotNull
    public CMakeRunConfigurationType getType() {
        CMakeRunConfigurationType cMakeRunConfigurationType = (CMakeRunConfigurationType)super.getType();
        if (cMakeRunConfigurationType == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(0);
        }
        return cMakeRunConfigurationType;
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(1);
        }
        return target instanceof CMakeBuildProfileExecutionTarget;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getResolveConfiguration(@NotNull ExecutionTarget target) {
        BuildAndRunConfigurations configurations;
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(2);
        }
        return (configurations = this.getBuildAndRunConfigurations(target)) == null ? null : CMakeWorkspace.getInstance(this.getProject()).getResolveConfigurationFor(configurations.buildConfiguration);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.doCheckConfiguration(this.getBuildProfileIfActive(), false);
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
        super.checkSettingsBeforeRun();
        this.doCheckConfiguration(this.getBuildProfileIfActive(), true);
    }

    @Nullable
    private String getBuildProfileIfActive() {
        return this.isSelectedConfiguration() ? CMakeBuildProfileExecutionTarget.getProfileName(ExecutionTargetManager.getInstance((Project)this.getProject()).getActiveTarget()) : null;
    }

    boolean isSelectedConfiguration() {
        RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)this.getProject()).getSelectedConfiguration();
        return selected != null && Objects.equals(selected.getUniqueID(), RunnerAndConfigurationSettingsImpl.getUniqueIdFor((RunConfiguration)this));
    }

    private void doCheckConfiguration(@Nullable String buildProfile, boolean checkExecutableSpecified) throws RuntimeConfigurationError {
        BuildConfigurationProblems problems = new BuildConfigurationProblems();
        this.getBuildAndRunConfigurations(buildProfile, problems, checkExecutableSpecified);
        if (problems.hasProblems()) {
            throw new RuntimeConfigurationError(problems.getHtmlProblems());
        }
    }

    @Nullable
    public CMakeTarget getCMakeTarget() {
        CMakeBuildConfigurationHelper helper = this.getHelper();
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        return this.isBuildAllTargets() ? helper.createBuildAllVirtualTarget() : (CMakeTarget)helper.findTarget(data == null ? null : data.target);
    }

    @NotNull
    public List<String> getBuildProfiles() {
        List list = ContainerUtil.map(this.getHelper().getConfigurations(this.getCMakeTarget()), it -> it.getProfileName());
        if (list == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull ExecutionTarget target) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(4);
        }
        return this.getBuildAndRunConfigurations(target, null, false);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull ExecutionTarget target, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        if (target == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(5);
        }
        return this.getBuildAndRunConfigurations(CMakeBuildProfileExecutionTarget.getProfileName(target), problems, checkExecutableSpecified);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull String buildProfileName) {
        if (buildProfileName == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(6);
        }
        return this.getBuildAndRunConfigurations(buildProfileName, null, false);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@Nullable String buildProfileName, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        return (BuildAndRunConfigurations)((Object)ReadAction.compute(() -> {
            CMakeConfiguration buildConfig;
            CMakeBuildConfigurationHelper helper;
            if (this.getProject().isDisposed()) {
                return null;
            }
            BuildTargetAndConfigurationData buildData = this.getTargetAndConfigurationData();
            if (buildData != null) {
                buildData = new BuildTargetAndConfigurationData(buildData.target, buildProfileName);
            }
            if (!BuildTargetAndConfigurationData.checkData(helper = CMakeRunConfigurationType.getHelper(this.getProject()), buildData, problems, this.myExplicitBuildTargetName != null, true)) {
                return null;
            }
            assert (buildData != null);
            File runExecutable = null;
            CMakeConfiguration runConfig = null;
            ExecutableData runData = this.getExecutableData();
            if (runData == null && checkExecutableSpecified) {
                if (problems != null) {
                    problems.problems.add(CidrBundle.message("build.configuration.parameterNotSelected", CidrBundle.message("build.configuration.executable", new Object[0])));
                }
                return null;
            }
            boolean runTargetIsValid = true;
            if (runData != null) {
                if (runData.target != null) {
                    if (!runData.target.equals(buildData.target)) {
                        runConfig = CMakeAppRunConfiguration.checkAndGetConfiguration(helper, problems, runData.target, buildData.configurationName, true, true);
                        runTargetIsValid = runConfig != null;
                    }
                } else {
                    CPPLog.LOG.assertTrue(runData.path != null);
                    runExecutable = new File(runData.path);
                }
            }
            if (this.myExplicitBuildTargetName != null) {
                buildConfig = null;
                if (buildData.configurationName != null) {
                    CMakeTarget each;
                    Iterator<CMakeTarget> iterator = helper.getTargets().iterator();
                    while (iterator.hasNext() && (buildConfig = helper.findConfiguration(each = iterator.next(), buildData.configurationName)) == null) {
                    }
                    if (buildConfig == null && problems != null) {
                        problems.problems.add(CidrBundle.message("build.configuration.parameterNotFound", helper.getConfigurationTitle(), buildData.configurationName));
                    }
                }
            } else {
                CPPLog.LOG.assertTrue(buildData.target != null);
                buildConfig = CMakeAppRunConfiguration.checkAndGetConfiguration(helper, problems, buildData.target, buildData.configurationName, false, runConfig == null && runExecutable == null);
            }
            if (buildConfig == null || !runTargetIsValid) {
                return null;
            }
            return new BuildAndRunConfigurations(buildConfig, runConfig, runExecutable, this.myExplicitBuildTargetName);
        }));
    }

    @Nullable
    private static CMakeConfiguration checkAndGetConfiguration(@NotNull CMakeBuildConfigurationHelper helper, @Nullable BuildConfigurationProblems problems, @NotNull BuildTargetData dataTarget, @Nullable String configurationName, boolean checkTargetType, boolean checkProduct) {
        CMakeTarget target;
        if (helper == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(7);
        }
        if (dataTarget == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(8);
        }
        if ((target = (CMakeTarget)helper.findTarget(dataTarget)) == null || checkTargetType && !target.isExecutable()) {
            if (problems != null) {
                problems.problems.add(CidrBundle.message("build.configuration.parameterNotFound", helper.getTargetTitle(), dataTarget.getDisplayString()));
            }
            return null;
        }
        if (configurationName == null) {
            return null;
        }
        CMakeConfiguration config = helper.findConfiguration(target, configurationName);
        if (config == null) {
            if (problems != null) {
                problems.problems.add(CidrBundle.message("build.configuration.parameterNotFoundForTarget", helper.getConfigurationTitle(), configurationName, StringUtil.toLowerCase((String)helper.getTargetTitle()), dataTarget.getDisplayString()));
            }
            return null;
        }
        if (checkProduct && config.getProductFile() == null) {
            if (problems != null) {
                problems.problems.add(CidrBundle.message("build.configuration.productNotFound", StringUtil.toLowerCase((String)helper.getTargetTitle()), dataTarget.getDisplayString(), configurationName));
            }
            return null;
        }
        return config;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor<? extends CMakeAppRunConfiguration> settingsEditor = this.getType().createEditor(this.getProject());
        if (settingsEditor == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(9);
        }
        return settingsEditor;
    }

    @Override
    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(10);
        }
        if (env == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(11);
        }
        return new CidrCommandLineState(env, new CMakeLauncher(env, this));
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(12);
        }
        super.writeExternal(element);
        if (this.myExecutableData != null) {
            this.myExecutableData.writeExternal(element);
        }
        if (this.myExplicitBuildTargetName != null) {
            element.setAttribute("EXPLICIT_BUILD_TARGET_NAME", this.myExplicitBuildTargetName);
            element.removeAttribute("PROJECT_NAME");
            element.removeAttribute("TARGET_NAME");
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(13);
        }
        super.readExternal(element);
        this.myExecutableData = ExecutableData.loadExternal(element);
        this.myExplicitBuildTargetName = element.getAttributeValue("EXPLICIT_BUILD_TARGET_NAME");
    }

    @Override
    @Nullable
    public ExecutableData getExecutableData() {
        return this.myExecutableData;
    }

    @Override
    public void setExecutableData(@Nullable ExecutableData executableData) {
        this.myExecutableData = executableData;
    }

    public boolean isBuildAllTargets() {
        return ALL_TARGET.equals(this.myExplicitBuildTargetName);
    }

    public void setExplicitBuildTargetName(@Nullable String explicitBuildTargetName) {
        this.myExplicitBuildTargetName = explicitBuildTargetName;
    }

    @Override
    public RunConfiguration clone() {
        CMakeAppRunConfiguration result = (CMakeAppRunConfiguration)super.clone();
        result.myExecutableData = this.myExecutableData;
        result.myExplicitBuildTargetName = this.myExplicitBuildTargetName;
        return result;
    }

    @Override
    public void setupDefaultTargetAndExecutable() {
        super.setupDefaultTargetAndExecutable();
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        if (data != null && data.target != null && this.getHelper().findRunTarget(data.target) != null) {
            this.setExecutableData(new ExecutableData(data.target));
        }
    }

    @NotNull
    public CMakeBuildConfigurationHelper getHelper() {
        CMakeBuildConfigurationHelper cMakeBuildConfigurationHelper = CMakeRunConfigurationType.getHelper(this.getProject());
        if (cMakeBuildConfigurationHelper == null) {
            CMakeAppRunConfiguration.$$$reportNull$$$0(14);
        }
        return cMakeBuildConfigurationHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProfileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataTarget";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProfiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolveConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuildAndRunConfigurations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BuildAndRunConfigurations
    extends UserDataHolderBase {
        @NotNull
        public final CMakeConfiguration buildConfiguration;
        @Nullable
        public final CMakeConfiguration runConfiguration;
        @Nullable
        public final File runExecutable;
        @Nullable
        public final String explicitBuildTargetName;

        public BuildAndRunConfigurations(@NotNull CMakeConfiguration buildConfiguration, @Nullable CMakeConfiguration runConfiguration, @Nullable File runExecutable, @Nullable String explicitBuildTargetName) {
            if (buildConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(0);
            }
            this.buildConfiguration = buildConfiguration;
            this.runConfiguration = runConfiguration;
            this.runExecutable = runExecutable;
            this.explicitBuildTargetName = explicitBuildTargetName;
        }

        public BuildAndRunConfigurations(@NotNull CMakeConfiguration buildConfiguration) {
            if (buildConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(1);
            }
            this(buildConfiguration, null, null, null);
        }

        @NotNull
        public CMakeConfiguration getRunConfiguration() {
            CMakeConfiguration cMakeConfiguration = this.runConfiguration != null ? this.runConfiguration : this.buildConfiguration;
            if (cMakeConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(2);
            }
            return cMakeConfiguration;
        }

        @Nullable
        public File getRunFile() {
            if (this.runExecutable != null) {
                return this.runExecutable;
            }
            return this.getRunConfiguration().getProductFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration$BuildAndRunConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration$BuildAndRunConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

