/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.testing.boost.CMakeBoostTestRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.testing.google.CMakeGoogleTestRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.testing.tcatch.CMakeCatchTestRunConfigurationType;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Triple;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeBuildConfigurationHelper
extends CidrBuildConfigurationHelper<CMakeConfiguration, CMakeTarget> {
    @NotNull
    private final Project myProject;
    private static final String[] GOOGLE_TEST_STANDARD_LIBS = new String[]{"gtest", "gtest_main", "gmock", "gmock_main"};

    @Override
    @NotNull
    public String getConfigurationTitle() {
        String string = CPPBundle.message("cmake.profile", new Object[0]);
        if (string == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean allowEditBuildConfiguration() {
        return false;
    }

    public CMakeBuildConfigurationHelper(@NotNull Project project2) {
        if (project2 == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
    }

    @NotNull
    public String getProjectName() {
        CMakeModel model2 = CMakeWorkspace.getInstance(this.myProject).getModel();
        String string = model2 == null ? "Project" : model2.getProjectName();
        if (string == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public CMakeTarget createBuildAllVirtualTarget() {
        THashSet added = new THashSet();
        ArrayList<CMakeConfiguration> allConfigurations = new ArrayList<CMakeConfiguration>();
        for (CMakeTarget target : this.getTargets()) {
            for (CMakeConfiguration config : target.getBuildConfigurations()) {
                if (!added.add(config.getName())) continue;
                allConfigurations.add(config);
            }
        }
        allConfigurations.sort((o1, o2) -> Comparing.compare((int)o1.getProfileId(), (int)o2.getProfileId()));
        CMakeTarget cMakeTarget = new CMakeTarget(this.getProjectName(), "All targets", allConfigurations){

            @Override
            public boolean isExecutable() {
                return false;
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return CMakeTarget.META_TARGET_ICON;
            }
        };
        if (cMakeTarget == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(3);
        }
        return cMakeTarget;
    }

    @Override
    @NotNull
    public List<CMakeTarget> getTargets() {
        List<CMakeTarget> list = CMakeWorkspace.getInstance(this.myProject).getModelTargets();
        if (list == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public CMakeConfiguration getDefaultConfiguration(@Nullable CMakeTarget target) {
        return (CMakeConfiguration)ContainerUtil.getFirstItem(this.getConfigurations(target));
    }

    @Override
    @Contract(value="null, _ -> null")
    public <T extends CMakeTarget> T findTarget(@Nullable BuildTargetData targetData, @NotNull List<T> targets) {
        if (targets == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(5);
        }
        if (targetData == null) {
            return null;
        }
        for (CMakeTarget each : targets) {
            if (!each.projectNameEquals(targetData.projectName) || !each.getName().equals(targetData.targetName)) continue;
            return (T)each;
        }
        return null;
    }

    @Override
    @NotNull
    public List<CMakeTarget> getRunTargets() {
        List list = ContainerUtil.filter(this.getTargets(), target -> target.isExecutable());
        if (list == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @Nullable
    public CMakeTarget findRunTarget(@Nullable BuildTargetData data) {
        return this.findTarget(data, this.getRunTargets());
    }

    @Override
    @Nullable
    public CMakeConfiguration findConfiguration(@Nullable CMakeTarget target, @Nullable String name2) {
        if (name2 == null) {
            return null;
        }
        for (CMakeConfiguration each : this.getConfigurations(target)) {
            if (!each.getName().equals(name2)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public CMakeRunConfigurationType getDefaultTargetType(@NotNull CMakeTarget target) {
        if (target == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(7);
        }
        if (this.isGoogleTestTarget(target)) {
            CMakeGoogleTestRunConfigurationType cMakeGoogleTestRunConfigurationType = CMakeGoogleTestRunConfigurationType.getInstance();
            if (cMakeGoogleTestRunConfigurationType == null) {
                CMakeBuildConfigurationHelper.$$$reportNull$$$0(8);
            }
            return cMakeGoogleTestRunConfigurationType;
        }
        if (CidrBuildConfigurationHelper.isTargetDetectionEnabled()) {
            ArrayList<Triple<String, Set<String>, CMakeRunConfigurationType>> fwDetectionList = new ArrayList<Triple<String, Set<String>, CMakeRunConfigurationType>>();
            fwDetectionList.add(new Triple((Object)"catch.hpp", CidrCatchTestFramework.CATCH_TEST_MACRO_NAMES, (Object)CMakeCatchTestRunConfigurationType.getInstance()));
            fwDetectionList.add(new Triple((Object)"unit_test.hpp", CidrBoostTestFramework.BOOST_TEST_MACRO_NAMES, (Object)CMakeBoostTestRunConfigurationType.getInstance()));
            CMakeRunConfigurationType testType = this.getTestTargetFromContextOfFiles(target, fwDetectionList);
            if (testType != null) {
                CMakeRunConfigurationType cMakeRunConfigurationType = testType;
                if (cMakeRunConfigurationType == null) {
                    CMakeBuildConfigurationHelper.$$$reportNull$$$0(9);
                }
                return cMakeRunConfigurationType;
            }
        }
        CMakeAppRunConfigurationType cMakeAppRunConfigurationType = CMakeAppRunConfigurationType.getInstance();
        if (cMakeAppRunConfigurationType == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(10);
        }
        return cMakeAppRunConfigurationType;
    }

    private boolean isGoogleTestTarget(@NotNull CMakeTarget target) {
        CMakeConfiguration config;
        if (target == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(11);
        }
        if (target.isExecutable() && (config = this.getDefaultConfiguration(target)) != null) {
            HashSet gtLibNames = new HashSet();
            Arrays.asList(GOOGLE_TEST_STANDARD_LIBS).forEach(libTargetName -> {
                gtLibNames.add("lib" + libTargetName + ".a");
                gtLibNames.add(libTargetName + ".lib");
            });
            return null != ContainerUtil.find(config.getLinkerFlags(), it -> gtLibNames.contains(PathUtil.getFileName((String)it).toLowerCase(Locale.ENGLISH)));
        }
        return false;
    }

    @Nullable
    private CMakeRunConfigurationType getTestTargetFromContextOfFiles(@NotNull CMakeTarget target, @NotNull Collection<Triple<String, Set<String>, CMakeRunConfigurationType>> fwDetection) {
        CMakeConfiguration config;
        if (target == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(12);
        }
        if (fwDetection == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(13);
        }
        if (target.isExecutable() && (config = this.getDefaultConfiguration(target)) != null) {
            Collection<File> sources = config.getSources();
            LocalFileSystem fs = LocalFileSystem.getInstance();
            int maxFilesInTargetToCheck = 10;
            for (File file : sources) {
                if (--maxFilesInTargetToCheck < 0) break;
                VirtualFile vf = fs.findFileByIoFile(file);
                if (vf == null) continue;
                try {
                    String fullContext = VfsUtilCore.loadText((VirtualFile)vf);
                    String content = fullContext.substring(0, Math.min(fullContext.length(), 1024));
                    for (Triple<String, Set<String>, CMakeRunConfigurationType> fwd : fwDetection) {
                        if (!content.contains((String)fwd.getFirst() + "\"") && !content.contains((String)fwd.getFirst() + ">")) continue;
                        for (String catchMacroName : (Set)fwd.getSecond()) {
                            if (!content.contains(catchMacroName)) continue;
                            return (CMakeRunConfigurationType)((Object)fwd.getThird());
                        }
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable CMakeTarget selectedTarget, @Nullable CMakeConfiguration selectedConfiguration, @NotNull List<CMakeTarget> targetsWithContext) {
        if (targetsWithContext == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(14);
        }
        return targetsWithContext.contains(selectedTarget) ? new BuildTargetAndConfigurationData((CidrBuildTarget)selectedTarget, (String)null) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeBuildConfigurationHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fwDetection";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetsWithContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTitle";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeBuildConfigurationHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildAllVirtualTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunTargets";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGoogleTestTarget";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTestTargetFromContextOfFiles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSimilarValidInTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

