/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CLionCustomDebuggerProvider;
import com.jetbrains.cidr.cpp.execution.CLionRunConfigurationExtensionsManager;
import com.jetbrains.cidr.cpp.execution.CLionRunParameters;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.debugger.backend.GDBDriverConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.CidrCommandLineConfigurator;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.CidrDebugConsoleFilterProvider;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrLocalDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeLauncher
extends CidrLauncher {
    private static final String WIN_PTY_COLS = "win.pty.cols";
    private static final int WIN_PTY_CONSOLE_WIDTH = 120;
    @NotNull
    protected final CMakeAppRunConfiguration myConfiguration;
    @NotNull
    protected final ExecutionEnvironment myEnvironment;
    @NotNull
    private final CLionRunConfigurationExtensionsManager myExtensionsManager;

    public CMakeLauncher(@NotNull ExecutionEnvironment environment, @NotNull CMakeAppRunConfiguration configuration) {
        if (environment == null) {
            CMakeLauncher.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            CMakeLauncher.$$$reportNull$$$0(1);
        }
        this.myConfiguration = configuration;
        this.myEnvironment = environment;
        this.myExtensionsManager = CLionRunConfigurationExtensionsManager.getInstance();
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project2 = this.myConfiguration.getProject();
        if (project2 == null) {
            CMakeLauncher.$$$reportNull$$$0(2);
        }
        return project2;
    }

    @Nullable
    private File getProjectBaseDir() {
        return CMakeWorkspace.getInstance(this.getProject()).getModelProjectDir();
    }

    @Override
    public ProcessHandler createProcess(@NotNull CommandLineState state) throws ExecutionException {
        if (state == null) {
            CMakeLauncher.$$$reportNull$$$0(3);
        }
        boolean usePty = this.usePty();
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = this.getBuildAndRunConfigurations();
        CMakeEnvironment environment = this.getRunEnvironment(buildAndRunConfigurations);
        GeneralCommandLine cl = this.createCommandLine(state, buildAndRunConfigurations, environment, usePty);
        RunnerSettings runnerSettings = this.myEnvironment.getRunnerSettings();
        String runnerId = this.myEnvironment.getRunner().getRunnerId();
        this.myExtensionsManager.patchCommandLine(this.myConfiguration, runnerSettings, environment, cl, runnerId);
        state.setConsoleBuilder(this.createConsoleBuilder(state, environment, this.getProjectBaseDir()));
        this.myExtensionsManager.patchCommandLineState(this.myConfiguration, runnerSettings, environment, this.getProjectBaseDir(), state, runnerId);
        return this.createProcessHandler(environment, cl, usePty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull CMakeEnvironment environment, @NotNull GeneralCommandLine cl, boolean usePty) throws ExecutionException {
        BaseProcessHandler processHandler;
        if (environment == null) {
            CMakeLauncher.$$$reportNull$$$0(4);
        }
        if (cl == null) {
            CMakeLauncher.$$$reportNull$$$0(5);
        }
        boolean overrideWinPtyWidth = SystemInfo.isWindows && usePty && environment.useWindowsConsole();
        String oldCols = null;
        if (overrideWinPtyWidth) {
            oldCols = System.getProperty(WIN_PTY_COLS);
            System.setProperty(WIN_PTY_COLS, String.valueOf(120));
        }
        try {
            processHandler = environment.createProcess(cl, true, usePty);
        }
        finally {
            if (overrideWinPtyWidth) {
                if (oldCols != null) {
                    System.setProperty(WIN_PTY_COLS, oldCols);
                } else {
                    System.clearProperty(WIN_PTY_COLS);
                }
            }
        }
        BaseProcessHandler baseProcessHandler = processHandler;
        if (baseProcessHandler == null) {
            CMakeLauncher.$$$reportNull$$$0(6);
        }
        return baseProcessHandler;
    }

    @NotNull
    protected TextConsoleBuilder createConsoleBuilder(@NotNull CommandLineState state, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir) {
        if (state == null) {
            CMakeLauncher.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            CMakeLauncher.$$$reportNull$$$0(8);
        }
        CidrConsoleBuilder cidrConsoleBuilder = new CidrConsoleBuilder(this.myConfiguration.getProject(), environment, projectBaseDir);
        if (cidrConsoleBuilder == null) {
            CMakeLauncher.$$$reportNull$$$0(9);
        }
        return cidrConsoleBuilder;
    }

    public boolean usePty() {
        Application application = ApplicationManager.getApplication();
        return PtyCommandLine.isEnabled() || application.isInternal() || application.isUnitTestMode();
    }

    @Override
    @NotNull
    public CidrDebugProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        if (state == null) {
            CMakeLauncher.$$$reportNull$$$0(10);
        }
        if (session == null) {
            CMakeLauncher.$$$reportNull$$$0(11);
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = this.getBuildAndRunConfigurations();
        CMakeEnvironment environment = this.getRunEnvironment(buildAndRunConfigurations);
        GeneralCommandLine cl = this.createCommandLine(state, buildAndRunConfigurations, environment, false);
        environment.convertPathVariableToEnv(cl);
        File projectBaseDir = this.getProjectBaseDir();
        state.setConsoleBuilder(this.createConsoleBuilder(state, environment, projectBaseDir));
        CidrDebugConsoleFilterProvider backendFilterProvider = new CidrDebugConsoleFilterProvider(environment, projectBaseDir);
        RunParameters parameters = this.getDebugParameters(environment, cl);
        CidrLocalDebugProcess cidrLocalDebugProcess = new CidrLocalDebugProcess(parameters, session, state.getConsoleBuilder(), backendFilterProvider);
        if (cidrLocalDebugProcess == null) {
            CMakeLauncher.$$$reportNull$$$0(12);
        }
        return cidrLocalDebugProcess;
    }

    @NotNull
    private RunParameters getDebugParameters(@NotNull CMakeEnvironment environment, @NotNull GeneralCommandLine cl) throws ExecutionException {
        String debugSupportDisabled;
        if (environment == null) {
            CMakeLauncher.$$$reportNull$$$0(13);
        }
        if (cl == null) {
            CMakeLauncher.$$$reportNull$$$0(14);
        }
        TrivialInstaller installer = new TrivialInstaller(cl);
        for (CLionCustomDebuggerProvider each : (CLionCustomDebuggerProvider[])Extensions.getExtensions(CLionCustomDebuggerProvider.EP_NAME)) {
            DebuggerDriverConfiguration config = (DebuggerDriverConfiguration)((Object)ContainerUtil.getFirstItem(each.getDebuggerConfigurations()));
            if (config == null) continue;
            CLionRunParameters cLionRunParameters = new CLionRunParameters(config, installer);
            if (cLionRunParameters == null) {
                CMakeLauncher.$$$reportNull$$$0(15);
            }
            return cLionRunParameters;
        }
        CPPToolSet toolset = environment.getToolSet();
        String string = debugSupportDisabled = toolset == null ? null : toolset.isDebugSupportDisabled();
        if (debugSupportDisabled != null) {
            throw new ExecutionException(debugSupportDisabled);
        }
        CPPToolchains.Toolchain toolchain = environment.getToolchain();
        if (toolchain.isUseLLDB()) {
            CLionRunParameters cLionRunParameters = new CLionRunParameters(CMakeLauncher.createLLDBDriverConfiguration(this.getProject(), toolchain), installer);
            if (cLionRunParameters == null) {
                CMakeLauncher.$$$reportNull$$$0(16);
            }
            return cLionRunParameters;
        }
        CLionRunParameters cLionRunParameters = new CLionRunParameters(CMakeLauncher.createGDBDriverConfiguration(this.getProject(), toolchain), installer);
        if (cLionRunParameters == null) {
            CMakeLauncher.$$$reportNull$$$0(17);
        }
        return cLionRunParameters;
    }

    @NotNull
    public static LLDBDriverConfiguration createLLDBDriverConfiguration(@NotNull Project project2, @NotNull CPPToolchains.Toolchain toolchain) {
        if (project2 == null) {
            CMakeLauncher.$$$reportNull$$$0(18);
        }
        if (toolchain == null) {
            CMakeLauncher.$$$reportNull$$$0(19);
        }
        LLDBDriverConfiguration lLDBDriverConfiguration = new LLDBDriverConfiguration();
        if (lLDBDriverConfiguration == null) {
            CMakeLauncher.$$$reportNull$$$0(20);
        }
        return lLDBDriverConfiguration;
    }

    @NotNull
    public static DebuggerDriverConfiguration createGDBDriverConfiguration(@NotNull Project project2, @NotNull CPPToolchains.Toolchain toolchain) {
        if (project2 == null) {
            CMakeLauncher.$$$reportNull$$$0(21);
        }
        if (toolchain == null) {
            CMakeLauncher.$$$reportNull$$$0(22);
        }
        GDBDriverConfiguration gDBDriverConfiguration = new GDBDriverConfiguration(project2, toolchain);
        if (gDBDriverConfiguration == null) {
            CMakeLauncher.$$$reportNull$$$0(23);
        }
        return gDBDriverConfiguration;
    }

    @Override
    protected void configProcessHandler(@NotNull CommandLineState state, @NotNull ProcessHandler handler, boolean detachSupported, boolean reportExitCode) throws ExecutionException {
        if (state == null) {
            CMakeLauncher.$$$reportNull$$$0(24);
        }
        if (handler == null) {
            CMakeLauncher.$$$reportNull$$$0(25);
        }
        super.configProcessHandler(state, handler, detachSupported, reportExitCode);
        CMakeEnvironment environment = this.getRunEnvironment(this.getBuildAndRunConfigurations());
        this.myExtensionsManager.attachExtensionsToProcess(this.myConfiguration, handler, environment, this.myEnvironment.getRunnerSettings());
    }

    @NotNull
    protected GeneralCommandLine createCommandLine(@NotNull CommandLineState state, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations, final @NotNull CMakeEnvironment environment, final boolean usePty) throws ExecutionException {
        File runFile;
        if (state == null) {
            CMakeLauncher.$$$reportNull$$$0(26);
        }
        if (buildAndRunConfigurations == null) {
            CMakeLauncher.$$$reportNull$$$0(27);
        }
        if (environment == null) {
            CMakeLauncher.$$$reportNull$$$0(28);
        }
        CPPLog.LOG.assertTrue((runFile = buildAndRunConfigurations.getRunFile()) != null);
        if (!runFile.exists()) {
            throw new ExecutionException(CidrBundle.message("run.fileNotFound", runFile));
        }
        GeneralCommandLine generalCommandLine = (GeneralCommandLine)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<GeneralCommandLine, ExecutionException>(){

            public GeneralCommandLine compute() throws ExecutionException {
                PtyCommandLine cl;
                if (usePty) {
                    cl = new PtyCommandLine();
                    cl.setUseCygwinLaunch(environment.isCygwin());
                } else {
                    cl = new GeneralCommandLine();
                }
                cl.setExePath(runFile.getPath());
                CidrCommandLineConfigurator configurator = new CidrCommandLineConfigurator(CMakeLauncher.this.myConfiguration.getProject(), CMakeLauncher.this.getParameters(runFile.getParent()));
                configurator.configureCommandLine((GeneralCommandLine)cl);
                environment.prepare((GeneralCommandLine)cl, CidrToolEnvironment.PrepareFor.RUN);
                return cl;
            }
        });
        if (generalCommandLine == null) {
            CMakeLauncher.$$$reportNull$$$0(29);
        }
        return generalCommandLine;
    }

    @NotNull
    private CMakeEnvironment getRunEnvironment(@NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations) throws ExecutionException {
        if (buildAndRunConfigurations == null) {
            CMakeLauncher.$$$reportNull$$$0(30);
        }
        CMakeConfiguration runConfiguration = buildAndRunConfigurations.getRunConfiguration();
        CMakeEnvironment cMakeEnvironment = CMakeWorkspace.getInstance(this.getProject()).getProfileInfoFor(runConfiguration).getEnvironmentSafe();
        if (cMakeEnvironment == null) {
            CMakeLauncher.$$$reportNull$$$0(31);
        }
        return cMakeEnvironment;
    }

    @NotNull
    private CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations() throws ExecutionException {
        ExecutionTarget target = this.myEnvironment.getExecutionTarget();
        if (!(target instanceof CMakeBuildProfileExecutionTarget)) {
            throw new ExecutionException(ProgramRunnerUtil.getCannotRunOnErrorMessage((RunProfile)this.myConfiguration, (ExecutionTarget)target));
        }
        BuildConfigurationProblems buildConfigurationProblems = new BuildConfigurationProblems();
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = this.myConfiguration.getBuildAndRunConfigurations(target, buildConfigurationProblems, true);
        if (buildAndRunConfigurations == null) {
            throw new ExecutionException(buildConfigurationProblems.getText());
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations2 = buildAndRunConfigurations;
        if (buildAndRunConfigurations2 == null) {
            CMakeLauncher.$$$reportNull$$$0(32);
        }
        return buildAndRunConfigurations2;
    }

    @NotNull
    private SimpleProgramParameters getParameters(final @NotNull String defaultWorkingDir) {
        if (defaultWorkingDir == null) {
            CMakeLauncher.$$$reportNull$$$0(33);
        }
        SimpleProgramParameters params = new SimpleProgramParameters();
        ProgramParametersConfigurator configurator = new ProgramParametersConfigurator(){

            @NotNull
            protected String getDefaultWorkingDir(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = defaultWorkingDir;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeLauncher$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeLauncher$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultWorkingDir";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDefaultWorkingDir";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        configurator.configureConfiguration(params, (CommonProgramRunConfigurationParameters)this.myConfiguration);
        SimpleProgramParameters simpleProgramParameters = params;
        if (simpleProgramParameters == null) {
            CMakeLauncher.$$$reportNull$$$0(34);
        }
        return simpleProgramParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeLauncher";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildAndRunConfigurations";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeLauncher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleBuilder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugParameters";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLDBDriverConfiguration";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createGDBDriverConfiguration";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunEnvironment";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildAndRunConfigurations";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleBuilder";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDebugParameters";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLLDBDriverConfiguration";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createGDBDriverConfiguration";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "configProcessHandler";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRunEnvironment";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

