/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrOrderMerger;
import com.jetbrains.cidr.execution.ExecutableData;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CMakeRunConfigurationManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class CMakeRunConfigurationManager
extends AbstractProjectComponent
implements PersistentStateComponent<Element> {
    private static volatile boolean ourEnableInTests = false;
    private volatile boolean myShouldGenerateConfigs = true;
    private volatile boolean myShouldDeleteObsoleteConfigs = true;
    private volatile boolean myBuildAllGenerated = false;
    @NotNull
    private volatile Set<BuildTargetData> myGeneratedConfigs = Collections.emptySet();

    public static void setEnableInTests(boolean enableInTests) {
        ourEnableInTests = enableInTests;
    }

    @NotNull
    public static CMakeRunConfigurationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(0);
        }
        CMakeRunConfigurationManager cMakeRunConfigurationManager = (CMakeRunConfigurationManager)((Object)project2.getComponent(CMakeRunConfigurationManager.class));
        if (cMakeRunConfigurationManager == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(1);
        }
        return cMakeRunConfigurationManager;
    }

    protected CMakeRunConfigurationManager(Project project2) {
        super(project2);
    }

    public void initComponent() {
        super.initComponent();
        if (!ourEnableInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            @Override
            public void reloadingFinished(boolean canceled) {
                if (canceled) {
                    return;
                }
                if (CMakeRunConfigurationManager.this.myShouldGenerateConfigs) {
                    CMakeRunConfigurationManager.this.updateRunConfigurations();
                }
            }
        });
    }

    private void updateRunConfigurations() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myGeneratedConfigs = Collections.unmodifiableSet(this.doUpdateRunConfigurations(this.myGeneratedConfigs, false));
    }

    public void recreateRunConfigurations() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myGeneratedConfigs = Collections.unmodifiableSet(this.doUpdateRunConfigurations(Collections.emptySet(), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<BuildTargetData> doUpdateRunConfigurations(Set<BuildTargetData> previouslyGenerated, boolean shouldRegenerateBuildAll) {
        RunManagerImpl runManager = (RunManagerImpl)RunManagerEx.getInstanceEx((Project)this.myProject);
        runManager.fireBeginUpdate();
        boolean needToRestoreSelection = runManager.getSelectedConfiguration() != null || CMakeRunConfigurationManager.forEachCMakeConfiguration(runManager.getAllSettings(), (Processor<CMakeAppRunConfiguration>)((Processor)it -> false));
        Set<BuildTargetData> result = this.doUpdateRunConfigurations(runManager, previouslyGenerated, shouldRegenerateBuildAll);
        if (needToRestoreSelection && runManager.getSelectedConfiguration() == null) {
            CMakeRunConfigurationManager.selectCMakeConfiguration(runManager);
        }
        Set<BuildTargetData> set = result;
        Set<BuildTargetData> set2 = set;
        if (set2 == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(2);
        }
        return set2;
        finally {
            runManager.fireEndUpdate();
        }
    }

    @NotNull
    private Set<BuildTargetData> doUpdateRunConfigurations(RunManagerImpl runManager, Set<BuildTargetData> previouslyGenerated, boolean shouldRegenerateBuildAll) {
        List originalOrder = runManager.getAllSettings();
        CMakeBuildConfigurationHelper helper = CMakeRunConfigurationType.getHelper(this.myProject);
        if (!(!shouldRegenerateBuildAll && this.myBuildAllGenerated || helper.getTargets().isEmpty())) {
            CMakeRunConfigurationManager.addBuildAllRunConfiguration(runManager);
            this.myBuildAllGenerated = true;
        }
        List allFactories2 = ContainerUtil.flatten((Iterable)ContainerUtil.map((Collection)runManager.getConfigurationFactoriesWithoutUnknown(), it -> Arrays.asList(it.getConfigurationFactories())));
        List templatesAndConfigurations = ContainerUtil.concat((List)ContainerUtil.map((Collection)allFactories2, it -> runManager.getConfigurationTemplate(it)), (List)runManager.getAllSettings());
        CMakeRunConfigurationManager.forEachCMakeSettingsAndConfiguration(templatesAndConfigurations, (Processor<Pair<RunnerAndConfigurationSettings, CMakeAppRunConfiguration>>)((Processor)it -> {
            CMakeRunConfigurationManager.updateProjectName(runManager, helper, (RunnerAndConfigurationSettings)it.first, (CMakeAppRunConfiguration)it.second);
            CMakeRunConfigurationManager.updateBuildConfiguration(runManager, helper, (RunnerAndConfigurationSettings)it.first, (CMakeAppRunConfiguration)it.second);
            return true;
        }));
        previouslyGenerated = CMakeRunConfigurationManager.updateProjectName(helper, previouslyGenerated);
        HashSet<BuildTargetData> generated = new HashSet<BuildTargetData>();
        HashSet targetsWithRunConfiguration = new HashSet(ContainerUtil.map(previouslyGenerated, data -> {
            generated.add((BuildTargetData)data);
            return data.targetName;
        }));
        MultiMap deletedTargetsWithConfigurations = new MultiMap();
        THashSet existingCMakeRunConfigurationNames = new THashSet();
        CMakeRunConfigurationManager.forEachCMakeSettingsAndConfiguration(runManager.getAllSettings(), (Processor<Pair<RunnerAndConfigurationSettings, CMakeAppRunConfiguration>>)((Processor)arg_0 -> CMakeRunConfigurationManager.lambda$doUpdateRunConfigurations$5((Set)existingCMakeRunConfigurationNames, generated, targetsWithRunConfiguration, deletedTargetsWithConfigurations, arg_0)));
        for (CMakeTarget cmakeTarget : helper.getTargets()) {
            BuildTargetData buildTarget = new BuildTargetData(cmakeTarget);
            deletedTargetsWithConfigurations.remove((Object)buildTarget);
            String name2 = cmakeTarget.getName();
            if (targetsWithRunConfiguration.contains(name2) || !existingCMakeRunConfigurationNames.add(name2)) continue;
            CMakeConfiguration buildConfiguration = helper.getDefaultConfiguration(cmakeTarget);
            RunnerAndConfigurationSettings newConfig = CMakeRunConfigurationManager.createRunConfiguration((RunManagerEx)runManager, helper.getDefaultTargetType(cmakeTarget).getFactory(), name2, new BuildTargetAndConfigurationData(buildTarget, buildConfiguration == null ? null : buildConfiguration.getName()), cmakeTarget.isExecutable() ? Ref.create((Object)new ExecutableData(buildTarget)) : null);
            runManager.addConfiguration(newConfig, false);
            ContainerUtil.addIfNotNull(generated, (Object)buildTarget);
        }
        if (this.myShouldDeleteObsoleteConfigs) {
            CMakeRunConfigurationManager.removeConfigurationsForDeletedTargets((RunManagerEx)runManager, previouslyGenerated, (MultiMap<BuildTargetData, RunnerAndConfigurationSettings>)deletedTargetsWithConfigurations, generated);
        }
        List cmakeConfigsNamesOrder = ContainerUtil.mapNotNull((Collection)originalOrder, each -> each.getConfiguration() instanceof CMakeAppRunConfiguration ? each.getName() : null);
        List<String> order = CidrOrderMerger.mergeWithOriginalOrderPrecedence(cmakeConfigsNamesOrder, ContainerUtil.map(helper.getTargets(), CMakeTarget::getName), false);
        TObjectIntHashMap orderIndices = new TObjectIntHashMap();
        int i = 0;
        for (String each2 : order) {
            orderIndices.put((Object)each2, i++);
        }
        runManager.setOrder((o1, o2) -> {
            boolean o2cmake;
            boolean o1cmake = o1.getConfiguration() instanceof CMakeAppRunConfiguration;
            if (o1cmake != (o2cmake = o2.getConfiguration() instanceof CMakeAppRunConfiguration)) {
                return Comparing.compare((boolean)o1cmake, (boolean)o2cmake);
            }
            if (!o1cmake) {
                return 0;
            }
            return Comparing.compare((int)orderIndices.get((Object)o1.getName()), (int)orderIndices.get((Object)o2.getName()));
        });
        HashSet<BuildTargetData> hashSet = generated;
        if (hashSet == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void updateBuildConfiguration(@NotNull RunManagerImpl runManager, @NotNull CMakeBuildConfigurationHelper helper, @NotNull RunnerAndConfigurationSettings settings, @NotNull CMakeAppRunConfiguration config) {
        CMakeTarget cmakeTarget;
        BuildTargetAndConfigurationData data;
        if (runManager == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(6);
        }
        if (config == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(7);
        }
        if ((data = config.getTargetAndConfigurationData()) == null) {
            return;
        }
        boolean isBuildAll = config.isBuildAllTargets();
        CMakeTarget cMakeTarget = cmakeTarget = isBuildAll ? (CMakeTarget)ContainerUtil.getFirstItem(helper.getTargets()) : (CMakeTarget)helper.findTarget(data.target);
        if (cmakeTarget != null && helper.findConfiguration(cmakeTarget, data.configurationName) == null) {
            config.setTargetAndConfigurationData(new BuildTargetAndConfigurationData((CidrBuildTarget)(isBuildAll ? null : cmakeTarget), helper.getDefaultConfiguration(cmakeTarget)));
            runManager.fireRunConfigurationChanged(settings);
        }
    }

    private static Set<BuildTargetData> updateProjectName(@NotNull CMakeBuildConfigurationHelper helper, @NotNull Set<BuildTargetData> original) {
        if (helper == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(8);
        }
        if (original == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(9);
        }
        String projectName = helper.getProjectName();
        return ContainerUtil.map2Set(original, it -> new BuildTargetData(projectName, it.targetName));
    }

    private static void updateProjectName(@NotNull RunManagerImpl runManager, @NotNull CMakeBuildConfigurationHelper helper, @NotNull RunnerAndConfigurationSettings settings, @NotNull CMakeAppRunConfiguration config) {
        ExecutableData executableData;
        if (runManager == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(10);
        }
        if (helper == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(12);
        }
        if (config == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(13);
        }
        boolean changed = false;
        String projectName = helper.getProjectName();
        BuildTargetAndConfigurationData data = config.getTargetAndConfigurationData();
        if (data != null && data.target != null && !Objects.equals(data.target.projectName, projectName)) {
            config.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(projectName, data.target.targetName, data.configurationName));
            changed = true;
        }
        if ((executableData = config.getExecutableData()) != null && executableData.target != null && !Objects.equals(executableData.target.projectName, projectName)) {
            config.setExecutableData(new ExecutableData(new BuildTargetData(projectName, executableData.target.targetName)));
            changed = true;
        }
        if (changed) {
            runManager.fireRunConfigurationChanged(settings);
        }
    }

    private static void removeConfigurationsForDeletedTargets(@NotNull RunManagerEx runManager, @NotNull Set<BuildTargetData> previouslyGenerated, @NotNull MultiMap<BuildTargetData, RunnerAndConfigurationSettings> deletedTargets, @NotNull Set<BuildTargetData> generated) {
        if (runManager == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(14);
        }
        if (previouslyGenerated == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(15);
        }
        if (deletedTargets == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(16);
        }
        if (generated == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(17);
        }
        for (Map.Entry each : deletedTargets.entrySet()) {
            BuildTargetData buildTarget = (BuildTargetData)each.getKey();
            generated.remove(buildTarget);
            if (!previouslyGenerated.contains(buildTarget)) continue;
            for (RunnerAndConfigurationSettings eachSettings : (Collection)each.getValue()) {
                if (!StringUtil.equals((CharSequence)eachSettings.getName(), (CharSequence)buildTarget.targetName)) continue;
                CMakeAppRunConfiguration eachConfig = (CMakeAppRunConfiguration)eachSettings.getConfiguration();
                BuildTargetAndConfigurationData configData = eachConfig.getTargetAndConfigurationData();
                RunnerAndConfigurationSettings template = CMakeRunConfigurationManager.createRunConfiguration(runManager, eachConfig.getFactory(), buildTarget.targetName, new BuildTargetAndConfigurationData(buildTarget, configData == null ? null : configData.configurationName), (Ref<ExecutableData>)Ref.create((Object)eachConfig.getExecutableData()));
                RunConfiguration templateConfig = template.getConfiguration();
                Element eachConfigState = new Element("state");
                eachConfig.writeExternal(eachConfigState);
                Element templateState = new Element("state");
                templateConfig.writeExternal(templateState);
                if (!JDOMUtil.writeElement((Element)eachConfigState).equals(JDOMUtil.writeElement((Element)templateState))) continue;
                runManager.removeConfiguration(eachSettings);
            }
        }
    }

    @NotNull
    static RunnerAndConfigurationSettings createRunConfiguration(@NotNull RunManagerEx runManager, @NotNull ConfigurationFactory factory2, @NotNull String name2, @NotNull BuildTargetAndConfigurationData data, @Nullable Ref<ExecutableData> executableData) {
        if (runManager == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(18);
        }
        if (factory2 == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(19);
        }
        if (name2 == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(20);
        }
        if (data == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(21);
        }
        RunnerAndConfigurationSettings result = runManager.createRunConfiguration(name2, factory2);
        CMakeAppRunConfiguration runConfig = (CMakeAppRunConfiguration)result.getConfiguration();
        runConfig.setTargetAndConfigurationData(data);
        if (executableData != null) {
            runConfig.setExecutableData((ExecutableData)executableData.get());
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result;
        if (runnerAndConfigurationSettings == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(22);
        }
        return runnerAndConfigurationSettings;
    }

    private static void addBuildAllRunConfiguration(RunManagerImpl runManager) {
        if (!CMakeRunConfigurationManager.forEachCMakeConfiguration(runManager.getAllSettings(), (Processor<CMakeAppRunConfiguration>)((Processor)it -> !it.isBuildAllTargets()))) {
            return;
        }
        ConfigurationFactory factory2 = CMakeAppRunConfigurationType.getInstance().getFactory();
        RunnerAndConfigurationSettings configuration = runManager.createRunConfiguration("Build All", factory2);
        CMakeAppRunConfiguration cmakeRunConf = (CMakeAppRunConfiguration)configuration.getConfiguration();
        cmakeRunConf.setExplicitBuildTargetName("all");
        BuildTargetAndConfigurationData data = cmakeRunConf.getTargetAndConfigurationData();
        cmakeRunConf.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(null, null, data != null ? data.configurationName : null));
        cmakeRunConf.setExecutableData(null);
        runManager.addConfiguration(configuration, false);
        TObjectIntHashMap indices = new TObjectIntHashMap();
        int i = 0;
        for (RunnerAndConfigurationSettings each : runManager.getAllSettings()) {
            indices.put((Object)each, i++);
        }
        runManager.setOrder((o1, o2) -> {
            if (o1 == configuration) {
                return -1;
            }
            if (o2 == configuration) {
                return 1;
            }
            return indices.get(o1) - indices.get(o2);
        });
    }

    private static void selectCMakeConfiguration(@NotNull RunManagerImpl runManager) {
        if (runManager == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(23);
        }
        ArrayList configurations = new ArrayList();
        List configs2 = ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])runManager.getConfigurationFactories(), it -> {
            if (runManager == null) {
                CMakeRunConfigurationManager.$$$reportNull$$$0(26);
            }
            return runManager.getConfigurationSettingsList(it);
        }));
        CMakeRunConfigurationManager.forEachCMakeSettingsAndConfiguration(configs2, (Processor<Pair<RunnerAndConfigurationSettings, CMakeAppRunConfiguration>>)((Processor)it -> {
            configurations.add(it);
            return true;
        }));
        configurations.sort((c1, c2) -> {
            int r = -Comparing.compare((((CMakeAppRunConfiguration)c1.second).getExecutableData() != null ? 1 : 0) != 0, (((CMakeAppRunConfiguration)c2.second).getExecutableData() != null ? 1 : 0) != 0);
            if (r != 0) {
                return r;
            }
            return Comparing.compare((boolean)((CMakeAppRunConfiguration)c1.second).isBuildAllTargets(), (boolean)((CMakeAppRunConfiguration)c2.second).isBuildAllTargets());
        });
        if (!configurations.isEmpty()) {
            runManager.setSelectedConfiguration((RunnerAndConfigurationSettings)((Pair)configurations.get((int)0)).first);
        }
    }

    private static boolean forEachCMakeConfiguration(Iterable<RunnerAndConfigurationSettings> configurations, Processor<CMakeAppRunConfiguration> processor2) {
        return CMakeRunConfigurationManager.forEachCMakeSettingsAndConfiguration(configurations, (Processor<Pair<RunnerAndConfigurationSettings, CMakeAppRunConfiguration>>)((Processor)it -> processor2.process(it.second)));
    }

    private static boolean forEachCMakeSettingsAndConfiguration(Iterable<RunnerAndConfigurationSettings> configurations, Processor<Pair<RunnerAndConfigurationSettings, CMakeAppRunConfiguration>> processor2) {
        for (RunnerAndConfigurationSettings each : configurations) {
            RunConfiguration runConfig = each.getConfiguration();
            if (!(runConfig instanceof CMakeAppRunConfiguration) || processor2.process((Object)Pair.create((Object)each, (Object)((CMakeAppRunConfiguration)runConfig)))) continue;
            return false;
        }
        return true;
    }

    public boolean shouldGenerateConfigurations() {
        return this.myShouldGenerateConfigs;
    }

    public void setShouldGenerateConfigurations(boolean shouldGenerateConfigs) {
        this.myShouldGenerateConfigs = shouldGenerateConfigs;
    }

    public boolean shouldDeleteObsoleteConfigurations() {
        return this.myShouldDeleteObsoleteConfigs;
    }

    public void setShouldDeleteObsoleteConfigurations(boolean shouldDeleteObsoleteConfigs) {
        this.myShouldDeleteObsoleteConfigs = shouldDeleteObsoleteConfigs;
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        element.setAttribute("shouldGenerate", Boolean.toString(this.myShouldGenerateConfigs));
        element.setAttribute("shouldDeleteObsolete", Boolean.toString(this.myShouldDeleteObsoleteConfigs));
        element.setAttribute("buildAllGenerated", Boolean.toString(this.myBuildAllGenerated));
        Element generatedElement = new Element("generated");
        element.addContent(generatedElement);
        for (BuildTargetData each : this.myGeneratedConfigs) {
            Element eachElement = new Element("config");
            generatedElement.addContent(eachElement);
            eachElement.setAttribute("projectName", each.projectName);
            eachElement.setAttribute("targetName", each.targetName);
        }
        Element element2 = element;
        if (element2 == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(24);
        }
        return element2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            CMakeRunConfigurationManager.$$$reportNull$$$0(25);
        }
        this.myShouldGenerateConfigs = this.getBoolean(state.getAttributeValue("shouldGenerate"), true);
        this.myShouldDeleteObsoleteConfigs = this.getBoolean(state.getAttributeValue("shouldDeleteObsolete"), true);
        this.myBuildAllGenerated = this.getBoolean(state.getAttributeValue("buildAllGenerated"), false);
        THashSet loaded = new THashSet();
        Element generatedElement = state.getChild("generated");
        if (generatedElement != null) {
            for (Element eachElement : generatedElement.getChildren("config")) {
                String projectName = eachElement.getAttributeValue("projectName");
                String targetName = eachElement.getAttributeValue("targetName");
                if (projectName == null || targetName == null) continue;
                loaded.add(new BuildTargetData(projectName, targetName));
            }
        }
        this.myGeneratedConfigs = Collections.unmodifiableSet(loaded);
    }

    public boolean getBoolean(@Nullable String attributeValue, boolean def) {
        return attributeValue == null ? def : Boolean.parseBoolean(attributeValue);
    }

    private static /* synthetic */ boolean lambda$doUpdateRunConfigurations$5(Set existingCMakeRunConfigurationNames, Set generated, Set targetsWithRunConfiguration, MultiMap deletedTargetsWithConfigurations, Pair it) {
        existingCMakeRunConfigurationNames.add(((RunnerAndConfigurationSettings)it.first).getName());
        BuildTargetAndConfigurationData data = ((CMakeAppRunConfiguration)it.second).getTargetAndConfigurationData();
        if (data != null && data.target != null) {
            generated.add(data.target);
            targetsWithRunConfiguration.add(data.target.targetName);
            deletedTargetsWithConfigurations.putValue((Object)data.target, it.first);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeRunConfigurationManager";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 18: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previouslyGenerated";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedTargets";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeRunConfigurationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdateRunConfigurations";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunConfiguration";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: 
            case 24: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateBuildConfiguration";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeConfigurationsForDeletedTargets";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectCMakeConfiguration";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectCMakeConfiguration$11";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

