/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleBuilder;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleViewImpl;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBeforeRunTaskProviderMixin;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuildListener;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.BuildListener;
import com.jetbrains.cidr.execution.build.CidrBuild;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeBuild {
    private static final NotificationGroup LOG_NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"CMake Build Log");

    public static ExecutionResult<Boolean> build(@NotNull Project project2, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(0);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(1);
        }
        return CMakeBuild.build(project2, configurations, null);
    }

    public static ExecutionResult<Boolean> build(@NotNull Project project2, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener2) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(2);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(3);
        }
        return CMakeBuild.execute(project2, CidrBundle.message("build", new Object[0]), CidrBundle.message("build.progress", new Object[0]), configurations, listener2, (ThrowableConvertor<Boolean, Boolean, ExecutionException>)((ThrowableConvertor)success -> {
            if (configurations == null) {
                CMakeBuild.$$$reportNull$$$0(36);
            }
            if (project2 == null) {
                CMakeBuild.$$$reportNull$$$0(37);
            }
            CPPLog.LOG.assertTrue(configurations.runConfiguration != null);
            return success != false && CMakeBuild.execute(project2, CidrBundle.message("build", new Object[0]), CidrBundle.message("build.progress", new Object[0]), configurations.runConfiguration, null, listener2, false, CMakeBuild.getRunTaskConfiguration(configurations)).get() != false;
        }));
    }

    public static ExecutionResult<Boolean> clean(@NotNull Project project2, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations buildConfiguration) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(4);
        }
        if (buildConfiguration == null) {
            CMakeBuild.$$$reportNull$$$0(5);
        }
        return CMakeBuild.clean(project2, buildConfiguration, null);
    }

    public static ExecutionResult<Boolean> clean(@NotNull Project project2, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener2) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(6);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(7);
        }
        return CMakeBuild.execute(project2, CidrBundle.message("build.clean", new Object[0]), CidrBundle.message("build.clean.progress", new Object[0]), configurations.buildConfiguration, "clean", listener2, true, CMakeBuild.getRunTaskConfiguration(configurations));
    }

    public static ExecutionResult<Boolean> install(@NotNull Project project2, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(8);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(9);
        }
        return CMakeBuild.install(project2, configurations, null);
    }

    public static ExecutionResult<Boolean> install(@NotNull Project project2, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener2) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(10);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(11);
        }
        return CMakeBuild.execute(project2, CPPBundle.message("cmake.install.name", new Object[0]), CPPBundle.message("cmake.install.progress", new Object[0]), configurations.buildConfiguration, "install", listener2, true, CMakeBuild.getRunTaskConfiguration(configurations));
    }

    private static ExecutionResult<Boolean> execute(@NotNull Project project2, @NotNull String taskName, @NotNull String progressTitle, @NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations, @Nullable ProcessListener listener2, @Nullable ThrowableConvertor<Boolean, Boolean, ExecutionException> additionalBuildRunner) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(12);
        }
        if (taskName == null) {
            CMakeBuild.$$$reportNull$$$0(13);
        }
        if (progressTitle == null) {
            CMakeBuild.$$$reportNull$$$0(14);
        }
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(15);
        }
        ExecutionResult<Boolean> executionResult = CMakeBuild.execute(project2, taskName, progressTitle, configurations.buildConfiguration, configurations.explicitBuildTargetName, listener2, true, CMakeBuild.getRunTaskConfiguration(configurations));
        if (configurations.runConfiguration == null || configurations.explicitBuildTargetName != null || additionalBuildRunner == null) {
            return executionResult;
        }
        ExecutionResult<Boolean> resultWrapper = new ExecutionResult<Boolean>();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                resultWrapper.set((Boolean)additionalBuildRunner.convert(executionResult.get()));
            }
            catch (ExecutionException e) {
                resultWrapper.setException(e);
            }
        });
        return resultWrapper;
    }

    @Nullable
    private static RunnerAndConfigurationSettings getRunTaskConfiguration(@NotNull CMakeAppRunConfiguration.BuildAndRunConfigurations configurations) {
        if (configurations == null) {
            CMakeBuild.$$$reportNull$$$0(16);
        }
        return (RunnerAndConfigurationSettings)configurations.getUserData(CMakeBeforeRunTaskProviderMixin.BEFORE_RUN_TASK_CONFIGURATION);
    }

    public static ExecutionResult<Boolean> execute(@NotNull Project project2, @NotNull String taskName, @NotNull String progressTitle, @NotNull CMakeConfiguration buildConfiguration, @Nullable String explicitTargetName, @Nullable ProcessListener additionalProcessListener, boolean resetConsoleContent, @Nullable RunnerAndConfigurationSettings runTaskConfiguration) {
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(17);
        }
        if (taskName == null) {
            CMakeBuild.$$$reportNull$$$0(18);
        }
        if (progressTitle == null) {
            CMakeBuild.$$$reportNull$$$0(19);
        }
        if (buildConfiguration == null) {
            CMakeBuild.$$$reportNull$$$0(20);
        }
        CidrBuild.BuildContext context = new CidrBuild.BuildContext(project2);
        return CidrBuild.execute(project2, context, taskName, progressTitle, () -> {
            if (project2 == null) {
                CMakeBuild.$$$reportNull$$$0(29);
            }
            if (buildConfiguration == null) {
                CMakeBuild.$$$reportNull$$$0(30);
            }
            if (taskName == null) {
                CMakeBuild.$$$reportNull$$$0(31);
            }
            CMakeWorkspace workspace = CMakeWorkspace.getInstance(project2);
            workspace.lockModelDuring(() -> {
                if (buildConfiguration == null) {
                    CMakeBuild.$$$reportNull$$$0(32);
                }
                if (project2 == null) {
                    CMakeBuild.$$$reportNull$$$0(33);
                }
                if (taskName == null) {
                    CMakeBuild.$$$reportNull$$$0(34);
                }
                try {
                    CMakeProfileInfo profileInfo = workspace.getProfileInfoFor(buildConfiguration);
                    CMakeEnvironment environment = profileInfo.getEnvironmentSafe();
                    File generatedDir = buildConfiguration.getConfigurationGenerationDir();
                    File cmakeSourceDir = workspace.getModelProjectDir();
                    SmartList toRefresh = new SmartList();
                    toRefresh.add((Object)generatedDir);
                    for (CMakeTarget eachTarget : workspace.getModelTargets()) {
                        for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                            ContainerUtil.addIfNotNull((Collection)toRefresh, (Object)eachConfig.getProductFile());
                        }
                    }
                    for (String eachUrl : ProjectRootManager.getInstance((Project)project2).getContentRootUrls()) {
                        ContainerUtil.addIfNotNull((Collection)toRefresh, (Object)new File(VfsUtilCore.urlToPath((String)eachUrl)));
                    }
                    try {
                        String makeTarget = explicitTargetName != null ? explicitTargetName : buildConfiguration.getTarget().getName();
                        CMakeSettings.Profile profile2 = profileInfo.getProfile();
                        context.processHandler = CMakeBuild.createBuildProcess(environment, profile2.getEffectiveBuildOptionsList(environment.getToolchain()), profile2.getPassSystemEnvironment(), profile2.getAdditionalEnvironment(), generatedDir, makeTarget);
                    }
                    catch (Throwable e) {
                        throw e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(e);
                    }
                    if (additionalProcessListener != null) {
                        context.processHandler.addProcessListener(additionalProcessListener);
                    }
                    BuildListener buildListener = (BuildListener)UIUtil.invokeAndWaitIfNeeded(() -> {
                        if (project2 == null) {
                            CMakeBuild.$$$reportNull$$$0(35);
                        }
                        return CMakeBuild.createBuildListenerAndConsole(project2, environment, cmakeSourceDir, context, resetConsoleContent, runTaskConfiguration);
                    });
                    CidrBuild.startProcess(project2, LOG_NOTIFICATION_GROUP, taskName, context, buildListener, (List<File>)toRefresh);
                    context.processHandler.waitFor();
                }
                catch (ExecutionException e) {
                    context.error(e);
                    ExecutionUtil.handleExecutionError((Project)project2, (String)ToolWindowId.MESSAGES_WINDOW, (String)taskName, (Throwable)e);
                }
                catch (Throwable e) {
                    context.error(e);
                }
                return null;
            });
        });
    }

    public static BuildListener createBuildListenerAndConsole(final @NotNull Project project2, @NotNull CPPEnvironment environment, @Nullable File cmakeSourceDir, final @NotNull CidrBuild.BuildContext context, boolean resetContent, final @Nullable RunnerAndConfigurationSettings runTaskConfiguration) {
        CMakeConsoleViewImpl consoleView;
        if (project2 == null) {
            CMakeBuild.$$$reportNull$$$0(21);
        }
        if (environment == null) {
            CMakeBuild.$$$reportNull$$$0(22);
        }
        if (context == null) {
            CMakeBuild.$$$reportNull$$$0(23);
        }
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        final ContentManager contentManager = toolWindow.getContentManager();
        Content usedContent = (Content)ContainerUtil.find((Object[])contentManager.getContents(), content -> content.getDisplayName().equals(CidrBundle.message("build.logToolWindowName", new Object[0])));
        class ToolWindowActivator {
            boolean wasActivated = false;
            List<RunContentDescriptor> runTaskContentsAfterBuildFinished = null;

            ToolWindowActivator() {
            }

            public void buildFinished() {
                this.runTaskContentsAfterBuildFinished = this.getRunTaskContents();
            }

            public void activateIfNeeded() {
                if (this.wasActivated) {
                    return;
                }
                this.wasActivated = true;
                if (this.runTaskContentsAfterBuildFinished != null) {
                    List<RunContentDescriptor> newRunTaskContents = this.getRunTaskContents();
                    newRunTaskContents.removeAll(this.runTaskContentsAfterBuildFinished);
                    if (!newRunTaskContents.isEmpty()) {
                        return;
                    }
                }
                toolWindow.activate(null, false);
            }

            List<RunContentDescriptor> getRunTaskContents() {
                if (runTaskConfiguration == null) {
                    return Collections.emptyList();
                }
                return ExecutionManagerImpl.getInstance((Project)project2).getDescriptors(it -> it == runTaskConfiguration);
            }
        }
        final ToolWindowActivator toolWindowActivator = new ToolWindowActivator();
        class Property {
            final String key;
            final boolean defaultValue;

            public Property(String key, boolean defaultValue) {
                this.key = key;
                this.defaultValue = defaultValue;
            }

            boolean get() {
                return PropertiesComponent.getInstance().getBoolean(this.key, this.defaultValue);
            }

            void set(boolean value) {
                PropertiesComponent.getInstance().setValue(this.key, value, this.defaultValue);
            }
        }
        final Property isShowAlways = new Property("cmake.build.toolwindow.showAlways", true);
        final Property isShowOnlyOnWarning = new Property("cmake.build.toolwindow.showOnlyOnWarning", false);
        if (resetContent || usedContent == null || !(usedContent.getComponent() instanceof CMakeConsoleViewImpl)) {
            CMakeConsoleBuilder consoleBuilder = new CMakeConsoleBuilder(project2, environment, cmakeSourceDir){

                @Override
                protected void addToolbarActions(final @NotNull ConsoleView consoleView, @NotNull DefaultActionGroup toolbarActions) {
                    if (consoleView == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (toolbarActions == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    toolbarActions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend){

                        public void actionPerformed(AnActionEvent e) {
                            CidrBuild.BuildContext context = this.getConsoleBuildContext();
                            if (context != null) {
                                context.stop();
                            }
                        }

                        public void update(AnActionEvent event) {
                            CidrBuild.BuildContext context = this.getConsoleBuildContext();
                            event.getPresentation().setEnabled(context != null && context.isRunning());
                        }

                        @Nullable
                        public CidrBuild.BuildContext getConsoleBuildContext() {
                            return (CidrBuild.BuildContext)((CMakeConsoleViewImpl)consoleView).getClientProperty(CidrBuild.BuildContext.class);
                        }
                    });
                    toolbarActions.addSeparator();
                    super.addToolbarActions(consoleView, toolbarActions);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "consoleView";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "toolbarActions";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/cpp/execution/build/CMakeBuild$1";
                    objectArray[2] = "addToolbarActions";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            consoleView = (CMakeConsoleViewImpl)consoleBuilder.getConsole();
            consoleView.addMessageListener(new CMakeConsoleViewImpl.MessageListener(){
                {
                }

                @Override
                public void messageReported(@NotNull CMakeConsoleMessageType type) {
                    if (type == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    toolWindowActivator.activateIfNeeded();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/cpp/execution/build/CMakeBuild$2", "messageReported"));
                }
            });
            final Content content2 = ContentFactory.SERVICE.getInstance().createContent(consoleView.getComponent(), CidrBundle.message("build.logToolWindowName", new Object[0]), true);
            ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content2, (boolean)true);
            Disposer.register((Disposable)content2, (Disposable)consoleView);
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)new DefaultActionGroup(){
                {
                    this.add((AnAction)new DumbAwareToggleAction("Always Show on Build", "Always show this tool window when build starts", null){

                        public boolean isSelected(AnActionEvent e) {
                            return isShowAlways.get();
                        }

                        public void setSelected(AnActionEvent e, boolean state) {
                            isShowAlways.set(state);
                        }
                    });
                    this.add((AnAction)new DumbAwareToggleAction("Auto-Hide and Show on Warning/Error", "Hide this tool window when build starts and show it when warning or error is reported", null){

                        public void update(@NotNull AnActionEvent e) {
                            if (e == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            super.update(e);
                            e.getPresentation().setEnabled(!isShowAlways.get());
                        }

                        public boolean isSelected(AnActionEvent e) {
                            return isShowOnlyOnWarning.get();
                        }

                        public void setSelected(AnActionEvent e, boolean state) {
                            isShowOnlyOnWarning.set(state);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/build/CMakeBuild$3$2", "update"));
                        }
                    });
                }
            });
            contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void contentRemoved(ContentManagerEvent event) {
                    if (event.getContent() != content2) {
                        return;
                    }
                    contentManager.removeContentManagerListener((ContentManagerListener)this);
                }

                public void contentRemoveQuery(ContentManagerEvent event) {
                    if (event.getContent() != content2) {
                        return;
                    }
                    if (context.isRunning()) {
                        int result = Messages.showYesNoDialog((Project)project2, (String)CidrBundle.message("build.inProgress.cancelQuestion", new Object[0]), (String)CidrBundle.message("build.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                        if (result == 0) {
                            context.stop();
                        } else {
                            event.consume();
                        }
                    }
                }
            });
        } else {
            consoleView = (CMakeConsoleViewImpl)((Object)usedContent.getComponent());
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        context.processHandler.addProcessListener((ProcessListener)new CMakeBuildListener(context.indicator));
        consoleView.putClientProperty(CidrBuild.BuildContext.class, context);
        consoleView.attachToProcess(context.processHandler);
        if (isShowAlways.get()) {
            toolWindow.activate(null, false);
        } else if (isShowOnlyOnWarning.get()) {
            toolWindow.hide(null);
        }
        return new BuildListener(){
            {
            }

            @Override
            public void finished(@NotNull MessageType messageType, @NotNull String message) {
                if (messageType == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (messageType != MessageType.INFO) {
                    toolWindowActivator.activateIfNeeded();
                }
                toolWindowActivator.buildFinished();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "messageType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/cpp/execution/build/CMakeBuild$5";
                objectArray[2] = "finished";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static ProcessHandler createBuildProcess(@NotNull CMakeEnvironment environment, @NotNull List<String> buildOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment, @NotNull File generatedDir, @NotNull String target) throws CMakeException, ExecutionException {
        if (environment == null) {
            CMakeBuild.$$$reportNull$$$0(24);
        }
        if (buildOptions == null) {
            CMakeBuild.$$$reportNull$$$0(25);
        }
        if (additionalEnvironment == null) {
            CMakeBuild.$$$reportNull$$$0(26);
        }
        if (generatedDir == null) {
            CMakeBuild.$$$reportNull$$$0(27);
        }
        if (target == null) {
            CMakeBuild.$$$reportNull$$$0(28);
        }
        CPPToolSet toolSet = environment.getToolSet();
        boolean usePty = (!SystemInfo.isWindows || toolSet != null && toolSet.isCygwin()) && (PtyCommandLine.isEnabled() || ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isUnitTestMode());
        String generatedDirPath = environment.toEnvPath(generatedDir.getPath());
        GeneralCommandLine cmd = CMakeRunner.buildCommandLine(environment, generatedDir, Arrays.asList("--build", generatedDirPath, "--target", target), passSystemEnvironment, additionalEnvironment, usePty);
        cmd.addParameter("--");
        cmd.addParameters(buildOptions);
        CPPLog.LOG.info("Building: " + cmd.getCommandLineString());
        cmd.getEnvironment().put("TERM", "xterm");
        cmd.getEnvironment().put("GCC_COLORS", "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01");
        return environment.createProcess(cmd, true, usePty);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 5: 
            case 20: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildConfiguration";
                break;
            }
            case 13: 
            case 18: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildOptions";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedDir";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/build/CMakeBuild";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "clean";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunTaskConfiguration";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuildListenerAndConsole";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuildProcess";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$4";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$3";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$build$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

