/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.jetbrains.cidr.cpp.execution.CLionCustomDebuggerProvider;
import com.jetbrains.cidr.cpp.execution.CMakeLauncher;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionLocalAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final Key<List<XLocalAttachDebugger>> DEBUGGERS_KEY = Key.create((String)"CLionLocalAttachDebuggerProvider.DEBUGGERS");
    private final boolean myFilterUnsupported;

    public CLionLocalAttachDebuggerProvider() {
        this(true);
    }

    public CLionLocalAttachDebuggerProvider(boolean filterUnsupported) {
        this.myFilterUnsupported = filterUnsupported;
    }

    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project2, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        List<XLocalAttachDebugger> result;
        if (project2 == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        if (processInfo == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        if (contextHolder == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if ((result = (List<XLocalAttachDebugger>)contextHolder.getUserData(DEBUGGERS_KEY)) != null) {
            List<XLocalAttachDebugger> list = result;
            if (list == null) {
                CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<CidrLocalAttachDebugger> debuggers = new ArrayList<CidrLocalAttachDebugger>();
        CPPToolchains.Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            if (!toolchain.isUseLLDB()) {
                debuggers.add(CLionLocalAttachDebuggerProvider.createGDBDebugger(project2, toolchain));
            }
            if (toolchain.isUseLLDB() || toolchain.isLLDBAvailable()) {
                debuggers.add(CLionLocalAttachDebuggerProvider.createLLDBDebugger(project2, toolchain));
            }
        }
        for (CLionCustomDebuggerProvider eachProvider : (CLionCustomDebuggerProvider[])Extensions.getExtensions(CLionCustomDebuggerProvider.EP_NAME)) {
            for (DebuggerDriverConfiguration eachConfig : eachProvider.getDebuggerConfigurations()) {
                debuggers.add(new CidrLocalAttachDebugger(eachConfig));
            }
        }
        if (this.myFilterUnsupported) {
            debuggers = ContainerUtil.filter(debuggers, debugger -> debugger.getConfiguration().isAttachSupported());
        }
        result = Collections.unmodifiableList(debuggers);
        contextHolder.putUserData(DEBUGGERS_KEY, result);
        List<XLocalAttachDebugger> list = result;
        if (list == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    protected CPPToolchains.Toolchain getToolchain() {
        return CPPToolchains.getInstance().getDefaultToolchain();
    }

    @NotNull
    public static CidrLocalAttachDebugger createLLDBDebugger(@NotNull Project project2, @NotNull CPPToolchains.Toolchain toolchain) {
        if (project2 == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        if (toolchain == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(6);
        }
        CidrLocalAttachDebugger cidrLocalAttachDebugger = new CidrLocalAttachDebugger(CMakeLauncher.createLLDBDriverConfiguration(project2, toolchain));
        if (cidrLocalAttachDebugger == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(7);
        }
        return cidrLocalAttachDebugger;
    }

    @NotNull
    public static CidrLocalAttachDebugger createGDBDebugger(@NotNull Project project2, @NotNull CPPToolchains.Toolchain toolchain) {
        if (project2 == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(8);
        }
        if (toolchain == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(9);
        }
        CidrLocalAttachDebugger cidrLocalAttachDebugger = new CidrLocalAttachDebugger(CMakeLauncher.createGDBDriverConfiguration(project2, toolchain));
        if (cidrLocalAttachDebugger == null) {
            CLionLocalAttachDebuggerProvider.$$$reportNull$$$0(10);
        }
        return cidrLocalAttachDebugger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CLionLocalAttachDebuggerProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CLionLocalAttachDebuggerProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLDBDebugger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGDBDebugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLLDBDebugger";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGDBDebugger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

