/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDBEnvironment;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import com.jetbrains.cidr.toolchains.OSType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBDriverConfiguration
extends DebuggerDriverConfiguration {
    @Nullable
    private final GDBEnvironment myGDBEnvironment;
    @NotNull
    private final EnvironmentProblems myGDBEnvProblems;

    public GDBDriverConfiguration(@NotNull Project project2, @Nullable CPPToolchains.Toolchain toolchain) {
        if (project2 == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        this(project2, toolchain, true);
    }

    public GDBDriverConfiguration(@NotNull Project project2, @Nullable CPPToolchains.Toolchain toolchain, boolean requireToolSetOnWindows) {
        if (project2 == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        this.myGDBEnvProblems = new EnvironmentProblems();
        this.myGDBEnvironment = CPPToolchains.createGDBEnvironment(project2, toolchain, this.myGDBEnvProblems, requireToolSetOnWindows);
    }

    @Override
    @NotNull
    public String getDriverName() {
        if ("GDB" == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        return "GDB";
    }

    @Override
    public boolean isAttachSupported() {
        return !SystemInfo.isMac;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler) throws ExecutionException {
        if (handler == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        this.myGDBEnvProblems.throwAsExecutionException();
        GDBDriver gDBDriver = new GDBDriver(handler, this);
        if (gDBDriver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        return gDBDriver;
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (driver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        this.myGDBEnvProblems.throwAsExecutionException();
        GeneralCommandLine result = new GeneralCommandLine();
        assert (this.myGDBEnvironment != null);
        this.myGDBEnvironment.prepare(result, CidrToolEnvironment.PrepareFor.RUN);
        GDBDriverConfiguration.setupCommonParameters(result);
        result.addParameters(new String[]{"-interpreter=mi2"});
        result.putUserData(GDBDriver.PRETTY_PRINTERS_PATH, (Object)FileUtil.toSystemIndependentName((String)CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().getAbsolutePath()));
        result.putUserData(GDBDriver.ENABLE_STL_PRETTY_PRINTERS, (Object)CidrDebuggerSettings.getInstance().STL_RENDERERS_ENABLED);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    @Override
    public String convertToLocalPath(@Nullable String absolutePath) {
        assert (this.myGDBEnvironment != null);
        return this.myGDBEnvironment.toLocalPath(absolutePath);
    }

    @Override
    public String convertToEnvPath(@Nullable String localPath) {
        assert (this.myGDBEnvironment != null);
        return this.myGDBEnvironment.toEnvPath(localPath);
    }

    @Override
    @NotNull
    public BaseProcessHandler createDebugProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        this.myGDBEnvProblems.throwAsExecutionException();
        assert (this.myGDBEnvironment != null);
        if (this.isRemoteEnv()) {
            BaseProcessHandler baseProcessHandler = this.myGDBEnvironment.createProcess(commandLine, false, false);
            if (baseProcessHandler == null) {
                GDBDriverConfiguration.$$$reportNull$$$0(8);
            }
            return baseProcessHandler;
        }
        BaseProcessHandler baseProcessHandler = super.createDebugProcessHandler(commandLine);
        if (baseProcessHandler == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(9);
        }
        return baseProcessHandler;
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull CidrStackFrame frame) {
        if (driver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(10);
        }
        if (frame == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(11);
        }
        EvaluationContext evaluationContext = new EvaluationContext(driver, expirable, frame){

            @Override
            @NotNull
            public String convertToRValue(@NotNull LLValueData rValue, @NotNull Pair<LLValue, String> valuePair) throws DebuggerCommandException {
                if (rValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (valuePair == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = 1.cast((String)valuePair.getSecond(), ((LLValue)((Object)valuePair.getFirst())).getType());
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valuePair";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/backend/GDBDriverConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/backend/GDBDriverConfiguration$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToRValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToRValue";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (evaluationContext == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(12);
        }
        return evaluationContext;
    }

    @Override
    public boolean isRemoteEnv() {
        assert (this.myGDBEnvironment != null);
        return this.myGDBEnvironment.isRemote();
    }

    @Override
    @NotNull
    public OSType getEnvOSType() {
        assert (this.myGDBEnvironment != null);
        OSType oSType = this.myGDBEnvironment.getEnvOSType();
        if (oSType == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(13);
        }
        return oSType;
    }

    @Override
    public void sendSignalToRemoteProcess(int pid, int signal) throws ExecutionException {
        assert (this.myGDBEnvironment != null);
        if (CidrDebuggerLog.LOG.assertTrue(this.isRemoteEnv())) {
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"kill", "-" + signal, Integer.toString(pid)});
            this.myGDBEnvironment.runProcess(cmd, null, 0);
        }
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        assert (this.myGDBEnvironment != null);
        NamedPipe namedPipe = this.myGDBEnvironment.openNamedPipe();
        if (namedPipe == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(14);
        }
        return namedPipe;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/backend/GDBDriverConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/backend/GDBDriverConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluationContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvOSType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "openNamedPipe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

