/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.CPPPathManager;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMake
extends CidrExecutableTool {
    public static final String EXECUTABLE_NAME = SystemInfo.isWindows ? "cmake.exe" : "cmake";
    public static final Version MIN_VERSION = new Version(2, 8, 11);
    public static final Version MAX_VERSION = new Version(3, 11, -1);
    @Nullable
    private final CPPToolSet myToolSet;
    @NotNull
    private final CidrToolEnvironment myEnvironment;

    public CMake(@NotNull File executable, @NotNull CMakeEnvironment env) {
        if (executable == null) {
            CMake.$$$reportNull$$$0(0);
        }
        if (env == null) {
            CMake.$$$reportNull$$$0(1);
        }
        super(executable);
        this.myToolSet = env.getToolSet();
        this.myEnvironment = env;
    }

    @NotNull
    public static CMake getBundledCMake(@NotNull CMakeEnvironment env) {
        CPPToolSet toolSet;
        if (env == null) {
            CMake.$$$reportNull$$$0(2);
        }
        CMake cMake = new CMake(CPPPathManager.getBundledCMakeBinary((toolSet = env.getToolSet()) != null && toolSet.isCygwin()), env);
        if (cMake == null) {
            CMake.$$$reportNull$$$0(3);
        }
        return cMake;
    }

    @Override
    @NotNull
    public File getExecutable() {
        File file = this.myExecutable;
        if (file == null) {
            CMake.$$$reportNull$$$0(4);
        }
        return file;
    }

    @Override
    @Nullable
    public String readVersion() {
        String result;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (this.myToolSet != null) {
            try {
                this.myToolSet.prepareEnvironment(commandLine, CidrToolEnvironment.PrepareFor.BUILD, Collections.emptyList());
            }
            catch (ExecutionException e) {
                return null;
            }
        }
        commandLine.setExePath(this.myExecutable.getPath());
        commandLine.addParameter("-version");
        try {
            ProcessOutput output = this.myEnvironment.runProcess(commandLine, CidrToolsUtil.getProgressIndicator(), 10000);
            result = (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
            result = StringUtil.nullize((String)result, (boolean)true);
        }
        catch (ExecutionException ignored) {
            result = null;
        }
        if (CPPLog.LOG.isDebugEnabled()) {
            CPPLog.logReadVersion("CMake", this.myExecutable, result);
        }
        return result == null ? null : StringUtil.trimStart(result, (String)"cmake version ");
    }

    @Nullable
    public static String readBundledVersion(@NotNull CMakeEnvironment env) {
        if (env == null) {
            CMake.$$$reportNull$$$0(5);
        }
        return CMake.getBundledCMake(env).readVersion();
    }

    @Nullable
    public static String checkVersion(@NotNull String version) {
        if (version == null) {
            CMake.$$$reportNull$$$0(6);
        }
        return CPPToolchains.checkVersion(MIN_VERSION, MAX_VERSION, ToolVersion.parse(version, CPPEnvironment.VERSION_PATTERN));
    }

    @NotNull
    public static CMake createCMake(@NotNull CMakeEnvironment env, @Nullable String customCMakePath) {
        if (env == null) {
            CMake.$$$reportNull$$$0(7);
        }
        CMake cMake = customCMakePath == null ? CMake.getBundledCMake(env) : new CMake(new File(customCMakePath), env);
        if (cMake == null) {
            CMake.$$$reportNull$$$0(8);
        }
        return cMake;
    }

    @Nullable
    public static String readCMakeVersion(@Nullable CPPToolchains.Toolchain toolchain) {
        return toolchain == null ? null : new CMakeEnvironment(toolchain).getCMake().readVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CMake";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CMake";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledCMake";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCMake";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBundledCMake";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readBundledVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCMake";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

