/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.RemoteUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPEnvironment
extends CidrToolEnvironment {
    static final Pattern VERSION_PATTERN = Pattern.compile("^[a-zA-Z() \\d]*([\\d]+\\.[\\d]+\\.?[\\d]*).*", 8);
    @NotNull
    protected final CPPToolchains.Toolchain myToolchain;
    @Nullable
    protected final CPPToolSet myToolSet;
    @NotNull
    protected final List<CPPToolSet.Option> myToolSetOptions;
    @Nullable
    private static Consumer<GeneralCommandLine> myAdditionalPreparationInTest;

    public CPPEnvironment(@NotNull CPPToolchains.Toolchain toolchain) {
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(0);
        }
        this.myToolchain = toolchain;
        this.myToolSet = toolchain.getToolSet();
        this.myToolSetOptions = toolchain.getToolSetOptions();
    }

    @NotNull
    public CPPToolchains.Toolchain getToolchain() {
        CPPToolchains.Toolchain toolchain = this.myToolchain;
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(1);
        }
        return toolchain;
    }

    @Nullable
    public CPPToolSet getToolSet() {
        return this.myToolSet;
    }

    public boolean isMSVC() {
        return this.myToolSet != null && this.myToolSet.isMSVC();
    }

    public boolean isCygwin() {
        return this.myToolSet != null && this.myToolSet.isCygwin();
    }

    public boolean isMinGW() {
        return this.myToolSet != null && this.myToolSet.isMinGW();
    }

    @NotNull
    public static Charset getCharset() {
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        Charset charset = toolchain != null && toolchain.getCygwin() == null ? Charset.defaultCharset() : CharsetToolkit.UTF8_CHARSET;
        if (charset == null) {
            CPPEnvironment.$$$reportNull$$$0(2);
        }
        return charset;
    }

    public boolean useWindowsConsole() {
        return this.isMinGW() || this.isMSVC();
    }

    @Override
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        Cygwin cygwin = this.getCygwinOrNull();
        if (cygwin != null) {
            return Cygwin.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath, cygwin);
        }
        WSL wsl = this.getWslOrNull();
        if (wsl != null) {
            return wsl.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
        }
        return super.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
    }

    @Override
    public String toEnvPath(@Nullable String localPath) {
        Cygwin cygwin = this.getCygwinOrNull();
        if (cygwin != null) {
            return Cygwin.toCygwinPath(localPath, cygwin);
        }
        WSL wsl = this.getWslOrNull();
        if (wsl != null) {
            return wsl.toEnvPath(localPath);
        }
        return super.toEnvPath(localPath);
    }

    @Override
    @NotNull
    public char[] getSupportedFileSeparators() {
        char[] cArray = this.myToolSet != null ? this.myToolSet.getSupportedFileSeparators() : super.getSupportedFileSeparators();
        if (cArray == null) {
            CPPEnvironment.$$$reportNull$$$0(3);
        }
        return cArray;
    }

    @Override
    public boolean isRemote() {
        return this.myToolSet != null && this.myToolSet.isWSL();
    }

    @Override
    @NotNull
    public OSType getEnvOSType() {
        if (this.myToolSet != null && this.myToolSet.isWSL()) {
            OSType oSType = OSType.LINUX;
            if (oSType == null) {
                CPPEnvironment.$$$reportNull$$$0(4);
            }
            return oSType;
        }
        OSType oSType = super.getEnvOSType();
        if (oSType == null) {
            CPPEnvironment.$$$reportNull$$$0(5);
        }
        return oSType;
    }

    @NotNull
    private RemoteCredentials getRemoteCredentialsInRemoteMode() throws ExecutionException {
        RemoteCredentials credentials = this.myToolchain.getRemoteCredentials();
        if (credentials == null) {
            throw new ExecutionException("Empty credentials in remote mode");
        }
        RemoteCredentials remoteCredentials = credentials;
        if (remoteCredentials == null) {
            CPPEnvironment.$$$reportNull$$$0(6);
        }
        return remoteCredentials;
    }

    @Override
    protected boolean isEnvAbsolute(@NotNull String absoluteOrRelativeEnvPath) {
        Cygwin cygwin;
        if (absoluteOrRelativeEnvPath == null) {
            CPPEnvironment.$$$reportNull$$$0(7);
        }
        if ((cygwin = this.getCygwinOrNull()) != null) {
            return Cygwin.isAbsolutePath(absoluteOrRelativeEnvPath);
        }
        WSL wsl = this.getWslOrNull();
        if (wsl != null) {
            return wsl.isAbsolutePath(absoluteOrRelativeEnvPath);
        }
        return super.isEnvAbsolute(absoluteOrRelativeEnvPath);
    }

    @NotNull
    public ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable File workingDir, @Nullable String absoluteOrRelativeEnvPath) throws ExecutionException {
        ExecutablePathResult executablePathResult = this.resolveEnvPathToLocalExecutable(workingDir, absoluteOrRelativeEnvPath, true);
        if (executablePathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(8);
        }
        return executablePathResult;
    }

    @NotNull
    ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable File workingDir, @Nullable String absoluteOrRelativeEnvPath, boolean checkIfExecutable) throws ExecutionException {
        boolean isPosix;
        if (absoluteOrRelativeEnvPath == null) {
            ExecutablePathResult executablePathResult = new ExecutablePathResult(null, false);
            if (executablePathResult == null) {
                CPPEnvironment.$$$reportNull$$$0(9);
            }
            return executablePathResult;
        }
        if (this.isRemote()) {
            boolean resolved = this.isEnvAbsolute(absoluteOrRelativeEnvPath);
            ExecutablePathResult executablePathResult = new ExecutablePathResult(absoluteOrRelativeEnvPath, resolved);
            if (executablePathResult == null) {
                CPPEnvironment.$$$reportNull$$$0(10);
            }
            return executablePathResult;
        }
        Predicate<File> isExecutable = file -> file != null && (checkIfExecutable ? file.isFile() && file.canExecute() : file.exists());
        Cygwin cygwin = this.getCygwinOrNull();
        boolean bl = isPosix = !this.isWindows || cygwin != null;
        if (this.isEnvAbsolute(absoluteOrRelativeEnvPath)) {
            File result = new File(this.toLocalPath(absoluteOrRelativeEnvPath));
            ExecutablePathResult executablePathResult = new ExecutablePathResult(result.getPath(), isExecutable.test(result));
            if (executablePathResult == null) {
                CPPEnvironment.$$$reportNull$$$0(11);
            }
            return executablePathResult;
        }
        if (isPosix && absoluteOrRelativeEnvPath.startsWith("~/")) {
            File result = new File(FileUtil.expandUserHome((String)absoluteOrRelativeEnvPath));
            ExecutablePathResult executablePathResult = new ExecutablePathResult(result.getPath(), isExecutable.test(result));
            if (executablePathResult == null) {
                CPPEnvironment.$$$reportNull$$$0(12);
            }
            return executablePathResult;
        }
        String platformSeparator = isPosix ? "/" : "\\";
        boolean isNameOnly = StringsKt.indexOfAny((CharSequence)absoluteOrRelativeEnvPath, (char[])(isPosix ? UNIX_FILE_SEPARATORS : WINDOWS_UNIX_FILE_SEPARATORS), (int)0, (boolean)false) == -1;
        boolean isExplicitlyRelativePath = absoluteOrRelativeEnvPath.startsWith("." + platformSeparator) || absoluteOrRelativeEnvPath.startsWith(".." + platformSeparator);
        boolean isNameOnlyOrExplicitlyRelativePath = isNameOnly || isExplicitlyRelativePath;
        List<String> lookupNames = this.isWindows && isNameOnlyOrExplicitlyRelativePath ? Arrays.asList(absoluteOrRelativeEnvPath, absoluteOrRelativeEnvPath + ".exe") : Collections.singletonList(absoluteOrRelativeEnvPath);
        for (String eachLookupName : lookupNames) {
            File result;
            if (workingDir != null && (isPosix ? isExplicitlyRelativePath : isNameOnlyOrExplicitlyRelativePath) && isExecutable.test(result = new File(this.toLocalPath(workingDir, eachLookupName)))) {
                ExecutablePathResult executablePathResult = new ExecutablePathResult(result.getPath(), true);
                if (executablePathResult == null) {
                    CPPEnvironment.$$$reportNull$$$0(13);
                }
                return executablePathResult;
            }
            if (!isNameOnly) continue;
            GeneralCommandLine cl = new GeneralCommandLine();
            this.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            String pathVariable = (String)cl.getEffectiveEnvironment().get("PATH");
            File result2 = PathEnvironmentVariableUtil.findInPath((String)eachLookupName, (String)pathVariable, null);
            if (result2 == null || !isExecutable.test(result2)) continue;
            ExecutablePathResult executablePathResult = new ExecutablePathResult(result2.getPath(), true);
            if (executablePathResult == null) {
                CPPEnvironment.$$$reportNull$$$0(14);
            }
            return executablePathResult;
        }
        ExecutablePathResult executablePathResult = new ExecutablePathResult(absoluteOrRelativeEnvPath, false);
        if (executablePathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(15);
        }
        return executablePathResult;
    }

    @Override
    public void prepare(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor) throws ExecutionException {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(16);
        }
        if (prepareFor == null) {
            CPPEnvironment.$$$reportNull$$$0(17);
        }
        super.prepare(cl, prepareFor);
        if (this.myToolSet != null) {
            this.myToolSet.prepareEnvironment(cl, prepareFor, this.myToolSetOptions);
        }
        if (myAdditionalPreparationInTest != null) {
            myAdditionalPreparationInTest.consume((Object)cl);
        }
    }

    public void convertPathVariableToEnv(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(18);
        }
        Cygwin.convertPathVariableToCygwin(cl, this.getCygwinOrNull());
    }

    @Override
    @NotNull
    public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(19);
        }
        if (this.isRemote()) {
            RemoteCredentials credentials = this.getRemoteCredentialsInRemoteMode();
            ProcessOutput processOutput = RemoteUtil.runRemoteProcess(this, cl, credentials, indicator, timeout);
            if (processOutput == null) {
                CPPEnvironment.$$$reportNull$$$0(20);
            }
            return processOutput;
        }
        ProcessOutput processOutput = super.runProcess(cl, indicator, timeout);
        if (processOutput == null) {
            CPPEnvironment.$$$reportNull$$$0(21);
        }
        return processOutput;
    }

    @Override
    @NotNull
    public BaseProcessHandler createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty) throws ExecutionException {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(22);
        }
        if (this.isRemote()) {
            RemoteCredentials credentials = this.getRemoteCredentialsInRemoteMode();
            CapturingSshProcessHandler capturingSshProcessHandler = RemoteUtil.createRemoteProcess(this, cl, credentials, usePty);
            if (capturingSshProcessHandler == null) {
                CPPEnvironment.$$$reportNull$$$0(23);
            }
            return capturingSshProcessHandler;
        }
        BaseProcessHandler baseProcessHandler = super.createProcess(cl, colored, usePty);
        if (baseProcessHandler == null) {
            CPPEnvironment.$$$reportNull$$$0(24);
        }
        return baseProcessHandler;
    }

    @Override
    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            CPPEnvironment.$$$reportNull$$$0(25);
        }
        if (this.isRemote()) {
            RemoteUtil.killProcessTree(handler);
        } else {
            super.killProcessTree(handler);
        }
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        if (this.isRemote()) {
            RemoteCredentials credentials = this.getRemoteCredentialsInRemoteMode();
            NamedPipe namedPipe = RemoteUtil.openPipe(credentials, this.getEnvOSType());
            if (namedPipe == null) {
                CPPEnvironment.$$$reportNull$$$0(26);
            }
            return namedPipe;
        }
        NamedPipe namedPipe = super.openNamedPipe();
        if (namedPipe == null) {
            CPPEnvironment.$$$reportNull$$$0(27);
        }
        return namedPipe;
    }

    @Override
    public boolean isFileExist(@NotNull String path) throws ExecutionException {
        if (path == null) {
            CPPEnvironment.$$$reportNull$$$0(28);
        }
        if (this.isRemote()) {
            RemoteCredentials credentials = this.getRemoteCredentialsInRemoteMode();
            return RemoteUtil.isFileExist(credentials, path);
        }
        return super.isFileExist(path);
    }

    @Nullable
    private Cygwin getCygwinOrNull() {
        return this.myToolSet instanceof Cygwin ? (Cygwin)this.myToolSet : null;
    }

    private WSL getWslOrNull() {
        return this.myToolSet instanceof WSL ? (WSL)this.myToolSet : null;
    }

    public static void setAdditionalPreparationInTest(@Nullable Consumer<GeneralCommandLine> additionalPreparationInTest) {
        myAdditionalPreparationInTest = additionalPreparationInTest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchain";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvOSType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteCredentialsInRemoteMode";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveEnvPathToLocalExecutable";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "openNamedPipe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnvAbsolute";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "convertPathVariableToEnv";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isFileExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExecutablePathResult {
        @Nullable
        public final String path;
        public final boolean isResolvedToExecutable;

        public ExecutablePathResult(@Nullable String path, boolean isResolvedToExecutable) {
            this.path = path;
            this.isResolvedToExecutable = isResolvedToExecutable;
        }

        public String toString() {
            return "{path='" + this.path + '\'' + ", resolved=" + this.isResolvedToExecutable + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutablePathResult result = (ExecutablePathResult)o;
            if (this.isResolvedToExecutable != result.isResolvedToExecutable) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(result.path) : result.path != null);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.isResolvedToExecutable ? 1 : 0);
            return result;
        }
    }
}

