/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.OSType;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CPPToolSet {
    @NotNull
    protected final Kind myKind;
    @NotNull
    protected final File myHome;

    public CPPToolSet(@NotNull Kind kind, @NotNull File home) {
        if (kind == null) {
            CPPToolSet.$$$reportNull$$$0(0);
        }
        if (home == null) {
            CPPToolSet.$$$reportNull$$$0(1);
        }
        this.myKind = kind;
        this.myHome = home;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.myKind;
        if (kind == null) {
            CPPToolSet.$$$reportNull$$$0(2);
        }
        return kind;
    }

    @NotNull
    public String getName() {
        String string = this.myKind.getDisplayName();
        if (string == null) {
            CPPToolSet.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public abstract String readVersion();

    public abstract String checkVersion(@NotNull String var1);

    public boolean isMSVC() {
        return this.myKind == Kind.MSVC;
    }

    public boolean isCygwin() {
        return this.myKind == Kind.CYGWIN;
    }

    public boolean isMinGW() {
        return this.myKind == Kind.MINGW;
    }

    public boolean isWSL() {
        return this.myKind == Kind.WSL;
    }

    @NotNull
    public File getHome() {
        File file = this.myHome;
        if (file == null) {
            CPPToolSet.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myHome.getPath();
        if (string == null) {
            CPPToolSet.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Contract(value="null -> null")
    public File getSubFile(@Nullable String relativePath) {
        return relativePath == null ? null : new File(this.myHome, relativePath);
    }

    @Contract(value="null -> null")
    public String getSubFilePath(@Nullable String relativePath) {
        File result = this.getSubFile(relativePath);
        return result == null ? null : result.getPath();
    }

    @NotNull
    public abstract char[] getSupportedFileSeparators();

    @NotNull
    public abstract File getGDBPath();

    public abstract boolean isBundledGdbCompatible();

    @Nullable
    public String isDebugSupportDisabled() {
        return null;
    }

    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<Option> options) throws ExecutionException {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(6);
        }
        if (prepareFor == null) {
            CPPToolSet.$$$reportNull$$$0(7);
        }
        if (options == null) {
            CPPToolSet.$$$reportNull$$$0(8);
        }
    }

    protected static void prependPathVariable(@NotNull GeneralCommandLine cl, String ... paths) {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(9);
        }
        if (paths == null) {
            CPPToolSet.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        for (String each : paths) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append(FileUtil.toSystemDependentName((String)each));
        }
        THashMap system = new THashMap(cl.getEffectiveEnvironment(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (system.containsKey("PATH")) {
            if (result.length() != 0) {
                result.append(";");
            }
            result.append((String)system.get("PATH"));
        }
        cl.getEnvironment().put("PATH", result.toString());
    }

    public String toString() {
        return this.getName() + "@" + this.getHome();
    }

    @NotNull
    protected static List<Trinity<String, File, Boolean>> createSortedVersionsList() {
        SortedList sortedList = new SortedList((o1, o2) -> {
            int result = Boolean.compare((Boolean)o2.third, (Boolean)o1.third);
            if (result != 0) {
                return result;
            }
            result = StringUtil.compareVersionNumbers((String)((String)o2.first), (String)((String)o1.first));
            if (result != 0) {
                return result;
            }
            return FileUtil.compareFiles((File)((File)o1.second), (File)((File)o2.second));
        });
        if (sortedList == null) {
            CPPToolSet.$$$reportNull$$$0(11);
        }
        return sortedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSortedVersionsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prependPathVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface InstallationProcessor {
        public boolean process(@NotNull File var1, boolean var2);
    }

    public static interface Option {
        @NotNull
        public String getValue();

        public void write(@NotNull Element var1);

        @NotNull
        public String getUniqueID();
    }

    public static enum Kind {
        MINGW(CPPBundle.message("mingw", new Object[0]), "http://mingw-w64.org/doku.php/download/mingw-builds"),
        CYGWIN(CPPBundle.message("cygwin", new Object[0]), "https://cygwin.com/install.html"),
        MSVC(CPPBundle.message("msvc", new Object[0]), "https://www.visualstudio.com/downloads/"),
        WSL(CPPBundle.message("wsl", new Object[0]), "https://www.microsoft.com/store/productId/9NBLGGH4MSV6");

        @NotNull
        private String myDisplayName;
        @Nullable
        private String myDownloadPage;

        private Kind(String displayName, String downloadPage) {
            if (displayName == null) {
                Kind.$$$reportNull$$$0(0);
            }
            this.myDisplayName = displayName;
            this.myDownloadPage = downloadPage;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                Kind.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getDownloadPage() {
            return this.myDownloadPage;
        }

        public boolean isSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(2);
            }
            if (!(this != WSL || SystemInfo.isWin10OrNewer && ApplicationManager.getApplication() != null)) {
                return false;
            }
            return os == OSType.WIN;
        }

        @NotNull
        public static List<Kind> getSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(3);
            }
            List list = ContainerUtil.filter((Object[])Kind.values(), it -> {
                if (os == null) {
                    Kind.$$$reportNull$$$0(10);
                }
                return it.isSupportedOn(os);
            });
            if (list == null) {
                Kind.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public CPPToolSet create(@NotNull File home) {
            if (home == null) {
                Kind.$$$reportNull$$$0(5);
            }
            switch (this) {
                case MSVC: {
                    MSVC mSVC = new MSVC(home);
                    if (mSVC == null) {
                        Kind.$$$reportNull$$$0(6);
                    }
                    return mSVC;
                }
                case MINGW: {
                    MinGW minGW = new MinGW(home);
                    if (minGW == null) {
                        Kind.$$$reportNull$$$0(7);
                    }
                    return minGW;
                }
                case CYGWIN: {
                    Cygwin cygwin = new Cygwin(home);
                    if (cygwin == null) {
                        Kind.$$$reportNull$$$0(8);
                    }
                    return cygwin;
                }
                case WSL: {
                    WSL wSL = new WSL(home);
                    if (wSL == null) {
                        Kind.$$$reportNull$$$0(9);
                    }
                    return wSL;
                }
            }
            throw new RuntimeException("Add creation support for " + (Object)((Object)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind";
                    break;
                }
                case 2: 
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "home";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedOn";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupportedOn";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSupportedOn";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getSupportedOn$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

