/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CMake;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPToolchainUsageCollector
extends UsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        HashSet<UsageDescriptor> result = new HashSet<UsageDescriptor>();
        List<CPPToolchains.Toolchain> toolchains = CPPToolchains.getInstance().getToolchains();
        result.add(new UsageDescriptor("Toolchains number", toolchains.size()));
        for (CPPToolchains.Toolchain toolchain : toolchains) {
            CPPToolSet toolset = toolchain.getToolSet();
            if (toolset != null) {
                result.add(new UsageDescriptor(toolset.getName() + " " + CPPToolchainUsageCollector.anonymizeVersion(toolset.readVersion())));
            }
            if (toolchain.getCustomCMakePath() == null) {
                result.add(new UsageDescriptor("CMake bundled"));
            } else {
                result.add(new UsageDescriptor("CMake specified " + CPPToolchainUsageCollector.anonymizeVersion(CMake.readCMakeVersion(toolchain))));
            }
            result.add(new UsageDescriptor("Make " + (toolchain.getCustomMakeToolPath() == null ? "default" : "custom")));
            result.add(new UsageDescriptor("C Compiler " + (toolchain.getCustomCCompilerPath() == null ? "default" : "custom")));
            result.add(new UsageDescriptor("CXX Compiler " + (toolchain.getCustomCXXCompilerPath() == null ? "default" : "custom")));
            switch (toolchain.getDebuggerKind()) {
                case BUNDLED_LLDB: {
                    result.add(new UsageDescriptor("LLDB bundled"));
                    break;
                }
                case BUNDLED_GDB: {
                    result.add(new UsageDescriptor("GDB bundled"));
                    break;
                }
                case CUSTOM_GDB: {
                    GDB gdb2 = GDB.createBundledOrCustomGDB(toolchain);
                    if (gdb2 == null) break;
                    result.add(new UsageDescriptor("GDB specified " + CPPToolchainUsageCollector.anonymizeVersion(gdb2.readVersion())));
                }
            }
        }
        HashSet<UsageDescriptor> hashSet = result;
        if (hashSet == null) {
            CPPToolchainUsageCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private static String anonymizeVersion(@Nullable String version) {
        String string = ToolVersion.parse(StringUtil.notNullize((String)version), CPPEnvironment.VERSION_PATTERN).toCompactString();
        if (string == null) {
            CPPToolchainUsageCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Toolchains_2");
        if (groupDescriptor == null) {
            CPPToolchainUsageCollector.$$$reportNull$$$0(2);
        }
        return groupDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "anonymizeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

