/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.CMake;
import com.jetbrains.cidr.cpp.toolchains.CMakeEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsListener;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.GDBEnvironment;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import com.jetbrains.cidr.toolchains.OSType;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function3;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CPPToolchains", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public class CPPToolchains
implements PersistentStateComponent<Element> {
    public static volatile List<Toolchain> InitialToolchains;
    @NotNull
    private final OSType myCurrentOSType;
    private volatile boolean myToolchainsDetected;
    private volatile int myToolchainsDetectedVersion;
    @NotNull
    private final List<Toolchain> myToolchains_DoNotAccess;
    private static volatile boolean ourEmulateCMakeEnvironmentError;
    private volatile LinkedHashSet<Toolchain> myUpdates;
    private volatile Map<String, String> myRenames;

    @NotNull
    public static CPPToolchains getInstance() {
        CPPToolchains cPPToolchains = (CPPToolchains)ServiceManager.getService(CPPToolchains.class);
        if (cPPToolchains == null) {
            CPPToolchains.$$$reportNull$$$0(0);
        }
        return cPPToolchains;
    }

    public CPPToolchains() {
        this(OSType.getCurrent());
    }

    CPPToolchains(@NotNull OSType osType) {
        if (osType == null) {
            CPPToolchains.$$$reportNull$$$0(1);
        }
        this.myToolchains_DoNotAccess = new ArrayList<Toolchain>();
        this.myCurrentOSType = osType;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myCurrentOSType;
        if (oSType == null) {
            CPPToolchains.$$$reportNull$$$0(2);
        }
        return oSType;
    }

    @Nullable
    private static String getTestToolParameter(@NotNull CPPToolSet.Kind environment) {
        if (environment == null) {
            CPPToolchains.$$$reportNull$$$0(3);
        }
        THashMap keys = new THashMap();
        keys.put(CPPToolSet.Kind.MSVC, "cpp.test.msvc.home");
        keys.put(CPPToolSet.Kind.MINGW, "cpp.test.mingw.home");
        keys.put(CPPToolSet.Kind.CYGWIN, "cpp.test.cygwin.home");
        keys.put(CPPToolSet.Kind.WSL, "cpp.test.wsl.credentials");
        String requestedKey = (String)keys.get((Object)environment);
        if (requestedKey == null) {
            throw new RuntimeException("Please add testing support for " + (Object)((Object)environment));
        }
        String param = StringUtil.nullize((String)System.getProperty(requestedKey));
        if (param == null) {
            return null;
        }
        for (String otherKey : keys.values()) {
            if (otherKey.equals(requestedKey) || System.getProperty(otherKey) == null) continue;
            throw new RuntimeException("Only one testing environment should be specified. Got " + requestedKey + " and " + otherKey);
        }
        CPPLog.LOG.assertTrue(environment == CPPToolSet.Kind.WSL || new File(param).exists(), (Object)((Object)((Object)environment) + " not found at: " + param));
        return param;
    }

    public static void setEmulateCMakeEnvironmentErrorInTests(boolean emulate) {
        ourEmulateCMakeEnvironmentError = emulate;
    }

    @Nullable
    public static CMakeEnvironment createCMakeEnvironment(@NotNull Project project2, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(5);
        }
        Toolchain toolchain = CPPToolchains.validateToolchain(project2, toolchainNameOrNullForDefault, problems, checkIfFunctional, onMissingToolchain);
        if (problems.hasProblems()) {
            return null;
        }
        assert (toolchain != null);
        if (ourEmulateCMakeEnvironmentError) {
            problems.addProblem("Emulated CMake environment problem", null);
        }
        CMakeEnvironment environment = new CMakeEnvironment(toolchain);
        CMake cmake = environment.getCMake();
        if (checkIfFunctional) {
            CPPToolchains.checkTool(project2, toolchain, cmake, CPPBundle.message("cmake", new Object[0]), problems);
        }
        if (problems.hasProblems()) {
            return null;
        }
        return environment;
    }

    @Nullable
    public static GDBEnvironment createGDBEnvironment(@NotNull Project project2, @Nullable Toolchain toolchain, @NotNull EnvironmentProblems problems, boolean requireToolSetOnWindows) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(6);
        }
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(7);
        }
        CPPToolchains.validateToolchain(project2, toolchain, null, problems, true, requireToolSetOnWindows, null);
        if (problems.hasProblems()) {
            return null;
        }
        assert (toolchain != null);
        GDBEnvironment gdbEnvironment = new GDBEnvironment(toolchain);
        CPPToolchains.checkTool(project2, toolchain, gdbEnvironment.getGdb(), CPPBundle.message("cpp.toolchains.debugger", new Object[0]), problems);
        return problems.hasProblems() ? null : gdbEnvironment;
    }

    @Nullable
    private static Toolchain validateToolchain(@NotNull Project project2, @Nullable String toolchainName, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(8);
        }
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(9);
        }
        Toolchain toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainName);
        return CPPToolchains.validateToolchain(project2, toolchain, toolchainName, problems, checkIfFunctional, true, onMissingToolchain);
    }

    private static Toolchain validateToolchain(@NotNull Project project2, @Nullable Toolchain toolchain, @Nullable String requestedToolchainName, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, boolean requireToolSetOnWindows, @Nullable Runnable onMissingToolchain) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(10);
        }
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(11);
        }
        if (toolchain == null) {
            if (requestedToolchainName == null) {
                problems.addProblem(CPPBundle.message("cpp.toolchains.error.toolchainNotConfigured", new Object[0]), CPPToolchains.getGenericToolchainsFix(project2, null));
            } else {
                problems.addProblem(CPPBundle.message("cpp.toolchains.error.toolchainNotFound", requestedToolchainName), CPPToolchains.getMissingToolchainsFix(project2, onMissingToolchain));
            }
            return null;
        }
        OSType currentOS = OSType.getCurrent();
        if (currentOS == OSType.WIN) {
            CPPToolSet toolSet = toolchain.getToolSet();
            if (requireToolSetOnWindows && toolSet == null) {
                String allToolSets = StringUtil.join((Collection)ContainerUtil.mapNotNull(CPPToolSet.Kind.getSupportedOn(currentOS), it -> it.getDisplayName()), (String)"/");
                problems.addProblem(CPPBundle.message("cpp.toolchains.error.environmentNotSelected", allToolSets), CPPToolchains.getGenericToolchainsFix(project2, toolchain));
            }
            if (toolSet != null && checkIfFunctional && toolSet.readVersion() == null) {
                problems.addProblem(toolSet.getName() + " not found at: " + toolSet.getHome(), CPPToolchains.getGenericToolchainsFix(project2, toolchain));
            }
        }
        return toolchain;
    }

    private static void checkTool(@NotNull Project project2, @NotNull Toolchain toolchain, @Nullable CidrExecutableTool tool, @NotNull String toolName2, @NotNull EnvironmentProblems problems) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(12);
        }
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(13);
        }
        if (toolName2 == null) {
            CPPToolchains.$$$reportNull$$$0(14);
        }
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(15);
        }
        EnvironmentProblems.Fix fix = CPPToolchains.getGenericToolchainsFix(project2, toolchain);
        if (tool == null) {
            problems.addProblem(toolName2 + " executable not specified", fix);
        } else if (!FileUtil.exists((String)new CPPEnvironment(toolchain).toLocalPath(tool.getExecutablePath()))) {
            problems.addProblem(toolName2 + " executable not found", fix);
        } else if (tool.readVersion() == null) {
            problems.addProblem(toolName2 + " executable is incorrect", fix);
        }
    }

    @NotNull
    private static EnvironmentProblems.Fix getGenericToolchainsFix(@NotNull Project project2, @Nullable Toolchain toolchainToSelect) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(16);
        }
        EnvironmentProblems.Fix fix = new EnvironmentProblems.Fix(CPPBundle.message("cpp.toolchains.error.fix", new Object[0]), () -> {
            if (project2 == null) {
                CPPToolchains.$$$reportNull$$$0(52);
            }
            ShowSettingsUtil.getInstance().showSettingsDialog(project2.isDisposed() ? null : project2, CPPToolchainsConfigurable.class, configurable -> configurable.setPreselectedToolchain(CPPToolchains.getInstance().getToolchainsInternal().indexOf(toolchainToSelect)));
        });
        if (fix == null) {
            CPPToolchains.$$$reportNull$$$0(17);
        }
        return fix;
    }

    @NotNull
    private static EnvironmentProblems.Fix getMissingToolchainsFix(@NotNull Project project2, @Nullable Runnable action) {
        if (project2 == null) {
            CPPToolchains.$$$reportNull$$$0(18);
        }
        if (action == null) {
            EnvironmentProblems.Fix fix = CPPToolchains.getGenericToolchainsFix(project2, null);
            if (fix == null) {
                CPPToolchains.$$$reportNull$$$0(19);
            }
            return fix;
        }
        EnvironmentProblems.Fix fix = new EnvironmentProblems.Fix(CPPBundle.message("cpp.toolchains.error.fix", new Object[0]), action);
        if (fix == null) {
            CPPToolchains.$$$reportNull$$$0(20);
        }
        return fix;
    }

    int getDetectedVersion() {
        return this.myToolchainsDetectedVersion;
    }

    void setDetectedVersion(int version) {
        this.myToolchainsDetectedVersion = version;
    }

    @Nullable
    public Toolchain getDefaultToolchain() {
        return CPPToolchains.getDefaultToolchain(this.getToolchainsInternal());
    }

    @Nullable
    public static Toolchain getDefaultToolchain(@NotNull List<Toolchain> toolchains) {
        if (toolchains == null) {
            CPPToolchains.$$$reportNull$$$0(21);
        }
        return (Toolchain)ContainerUtil.getFirstItem(toolchains);
    }

    @Nullable
    public Toolchain getToolchainByNameOrDefault(@Nullable String name2) {
        for (Toolchain each : this.getToolchainsInternal()) {
            if (!each.getName().equals(name2)) continue;
            return each;
        }
        return name2 != null ? null : this.getDefaultToolchain();
    }

    @NotNull
    public List<Toolchain> getToolchains() {
        List<Toolchain> list = Collections.unmodifiableList(new ArrayList<Toolchain>(this.getToolchainsInternal()));
        if (list == null) {
            CPPToolchains.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private List<Toolchain> getToolchainsInternal() {
        this.detectOnFirstAccess();
        List<Toolchain> list = this.myToolchains_DoNotAccess;
        if (list == null) {
            CPPToolchains.$$$reportNull$$$0(23);
        }
        return list;
    }

    public void addToolchain(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(24);
        }
        assert (toolchain.getOwner() == null) : "Toolchain already has an owner";
        this.assertCanUpdate();
        this.doAddToolChainUnsafe(toolchain);
        this.scheduleCMakeEnvUpdatedNotification(toolchain);
    }

    private void doAddToolChainUnsafe(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(25);
        }
        toolchain.setOwner(this);
        this.getToolchainsInternal().add(toolchain);
    }

    public void removeToolchain(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(26);
        }
        this.assertCanUpdate();
        if (this.getToolchainsInternal().remove(toolchain)) {
            toolchain.setOwner(null);
            this.scheduleCMakeEnvUpdatedNotification(toolchain);
        }
    }

    void toolchainsRenamed(@NotNull List<Pair<String, String>> renamed) {
        if (renamed == null) {
            CPPToolchains.$$$reportNull$$$0(27);
        }
        assert (this.myRenames != null) : "changes should be done inside beforeUpdate/endUpdate";
        renamed.forEach(it -> this.myRenames.put((String)it.first, (String)it.second));
    }

    public void beginUpdate() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertWriteAccessAllowed();
        }
        assert (this.myUpdates == null) : "beginUpdate was already called";
        this.myUpdates = new LinkedHashSet();
        this.myRenames = new LinkedHashMap<String, String>();
    }

    public void endUpdate() {
        this.assertCanUpdate();
        CPPToolchains.fireUpdateEvents(new ArrayList<Toolchain>(this.myUpdates), this.myRenames);
        this.myUpdates = null;
        this.myRenames = null;
    }

    private void assertCanUpdate() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertWriteAccessAllowed();
        }
        assert (this.myUpdates != null) : "beginUpdate was not called";
    }

    private void scheduleCMakeEnvUpdatedNotification(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(28);
        }
        assert (this.myUpdates != null) : "changes should be done inside beforeUpdate/endUpdate";
        this.myUpdates.add(toolchain);
    }

    public static void fireUpdateEvents(@NotNull List<Toolchain> changes, @NotNull Map<String, String> renames) {
        Application application;
        if (changes == null) {
            CPPToolchains.$$$reportNull$$$0(29);
        }
        if (renames == null) {
            CPPToolchains.$$$reportNull$$$0(30);
        }
        if ((application = ApplicationManager.getApplication()) == null) {
            return;
        }
        if (!changes.isEmpty()) {
            ((CPPToolchainsListener)application.getMessageBus().syncPublisher(CPPToolchainsListener.TOPIC)).toolchainCMakeEnvironmentChanged(changes);
        }
        if (!renames.isEmpty()) {
            ((CPPToolchainsListener)application.getMessageBus().syncPublisher(CPPToolchainsListener.TOPIC)).toolchainsRenamed(renames);
        }
    }

    private void detectOnFirstAccess() {
        this.detectOnFirstAccess(true, msvcProcessor -> MSVC.processVisualStudioInstallations(msvcProcessor), mingwProcessor -> MinGW.processMinGWInstallations(mingwProcessor), cygwinProcessor -> Cygwin.processCygwinInstallations(cygwinProcessor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detectOnFirstAccess(boolean skipDetectionInTests, @NotNull Consumer<CPPToolSet.InstallationProcessor> msvcInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> mingwInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> cygwinInstallations) {
        if (msvcInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(31);
        }
        if (mingwInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(32);
        }
        if (cygwinInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(33);
        }
        if (!this.myToolchainsDetected) {
            List<Toolchain> list = this.myToolchains_DoNotAccess;
            synchronized (list) {
                if (!this.myToolchainsDetected) {
                    try {
                        List<Toolchain> detected;
                        List<Toolchain> initialToolchains = InitialToolchains;
                        InitialToolchains = null;
                        Application application = ApplicationManager.getApplication();
                        if (initialToolchains != null) {
                            initialToolchains.forEach(it -> ((Toolchain)it).setOwner(null));
                            detected = initialToolchains;
                        } else if (skipDetectionInTests && application != null && application.isUnitTestMode()) {
                            Toolchain testToolchain = new Toolchain(this.myCurrentOSType);
                            testToolchain.setName("Test Toolchain");
                            if (SystemInfo.isWindows) {
                                CPPToolchains.prepareTestToolchain(testToolchain);
                            }
                            detected = Collections.singletonList(testToolchain);
                        } else {
                            detected = CPPToolchains.doDetectToolSets(this.myToolchainsDetectedVersion, this.myCurrentOSType, msvcInstallations, mingwInstallations, cygwinInstallations);
                            if (this.myCurrentOSType != OSType.WIN && detected.isEmpty()) {
                                Toolchain defaultToolchain = new Toolchain(this.myCurrentOSType);
                                defaultToolchain.setName(Toolchain.DEFAULT);
                                detected.add(defaultToolchain);
                            }
                        }
                        detected.forEach(it -> {
                            ((Toolchain)it).setOwner(this);
                            this.myToolchains_DoNotAccess.add((Toolchain)it);
                        });
                    }
                    finally {
                        this.myToolchainsDetectedVersion = 5;
                        this.myToolchainsDetected = true;
                    }
                }
            }
        }
    }

    private static void prepareTestToolchain(@NotNull Toolchain testToolchain) {
        if (testToolchain == null) {
            CPPToolchains.$$$reportNull$$$0(34);
        }
        CPPToolSet.Kind kind = null;
        String param = null;
        for (CPPToolSet.Kind each : CPPToolSet.Kind.values()) {
            param = CPPToolchains.getTestToolParameter(each);
            if (param == null) continue;
            kind = each;
            break;
        }
        if (kind == null) {
            throw new RuntimeException("Environment is not specified.\nFor MSVC, MinGW or Cygwin use -Dcpp.test.<msvc/mingw/cygwin>.home to set test environment on Windows.\nFor WSL use -Dcpp.test.wsl.user=username:password to specify credentials, also you can specify\n   port and custom CMake path using -Dcpp.test.wsl.<port/cmake>");
        }
        if (kind == CPPToolSet.Kind.WSL) {
            Pattern credentialsPattern = Pattern.compile("(.+):(.+)");
            Matcher matcher = credentialsPattern.matcher(param);
            if (!matcher.matches()) {
                throw new RuntimeException("WSL credential parameters are incorrect, please use the follow format -Dcpp.test.wsl.param=username:password");
            }
            WSL.initWSLToolchain(testToolchain, matcher.group(1), matcher.group(2));
        } else {
            testToolchain.setToolSetKind(kind);
            testToolchain.setToolSetPath(FileUtil.toCanonicalPath((String)param));
        }
        if (testToolchain.getDebuggerKind() == CPPDebugger.Kind.BUNDLED_GDB) {
            testToolchain.setBundledOrToolSetGdb();
        }
    }

    private static List<Toolchain> doDetectToolSets(int previousVersion, @NotNull OSType osType, @NotNull Consumer<CPPToolSet.InstallationProcessor> msvcInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> mingwInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> cygwinInstallations) {
        if (osType == null) {
            CPPToolchains.$$$reportNull$$$0(35);
        }
        if (msvcInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(36);
        }
        if (mingwInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(37);
        }
        if (cygwinInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(38);
        }
        THashMap activeProcessors = new THashMap();
        if (osType == OSType.WIN) {
            if (previousVersion < 3) {
                activeProcessors.put(CPPToolSet.Kind.MINGW, mingwInstallations);
                activeProcessors.put(CPPToolSet.Kind.CYGWIN, cygwinInstallations);
            }
            if (previousVersion < 5) {
                activeProcessors.put(CPPToolSet.Kind.MSVC, msvcInstallations);
            }
        }
        ArrayList<Toolchain> result = new ArrayList<Toolchain>();
        for (CPPToolSet.Kind kind : CPPToolSet.Kind.getSupportedOn(osType)) {
            Consumer processor2 = (Consumer)activeProcessors.get((Object)kind);
            if (processor2 == null) continue;
            CPPLog.LOG.info("Looking for " + (Object)((Object)kind) + "...");
            File[] found = new File[1];
            processor2.accept((dir, fullySupported) -> {
                if (found[0] == null || fullySupported) {
                    found[0] = dir;
                }
                return !fullySupported;
            });
            if (found[0] == null) continue;
            CPPLog.LOG.info((Object)((Object)kind) + " found at " + found[0]);
            Toolchain toolchain = new Toolchain(osType);
            toolchain.setName(Toolchain.generateToolchainName(kind));
            toolchain.setToolSetKind(kind);
            toolchain.setToolSetPath(found[0].getPath());
            toolchain.setBundledOrToolSetGdb();
            result.add(toolchain);
        }
        return result;
    }

    @NotNull
    public Element getState() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertReadAccessAllowed();
        }
        Element stateElement = new Element("state");
        stateElement.setAttribute("version", "2");
        Element toolchainsElement = new Element("toolchains");
        toolchainsElement.setAttribute("detectedVersion", Integer.toString(this.myToolchainsDetectedVersion));
        stateElement.addContent(toolchainsElement);
        Function3 setAttributeIfNotNull = (el, name2, value) -> {
            if (value != null) {
                el.setAttribute(name2, value);
            }
            return null;
        };
        for (Toolchain toolchain : this.getToolchainsInternal()) {
            Element element = new Element("toolchain");
            toolchainsElement.addContent(element);
            element.setAttribute("name", toolchain.getName());
            CPPToolSet.Kind kind = toolchain.getToolSetKind();
            if (kind != null) {
                element.setAttribute("toolSetKind", kind.name());
            }
            setAttributeIfNotNull.invoke((Object)element, (Object)"toolSetPath", (Object)toolchain.getToolSetPath());
            for (CPPToolSet.Option option : toolchain.getToolSetOptions()) {
                Element optionEl = new Element("toolSetOption");
                element.addContent(optionEl);
                option.write(optionEl);
            }
            setAttributeIfNotNull.invoke((Object)element, (Object)"customCMakePath", (Object)toolchain.getCustomCMakePath());
            setAttributeIfNotNull.invoke((Object)element, (Object)"customMakePath", (Object)toolchain.getCustomMakeToolPath());
            setAttributeIfNotNull.invoke((Object)element, (Object)"customCCompilerPath", (Object)toolchain.getCustomCCompilerPath());
            setAttributeIfNotNull.invoke((Object)element, (Object)"customCXXCompilerPath", (Object)toolchain.getCustomCXXCompilerPath());
            CPPToolchains.saveCredentials(element, toolchain.myCredentials);
            element.setAttribute("debuggerKind", toolchain.getDebuggerKind().name());
            setAttributeIfNotNull.invoke((Object)element, (Object)"customGDBPath", (Object)toolchain.getCustomGDBExecutablePath());
        }
        Element element = stateElement;
        if (element == null) {
            CPPToolchains.$$$reportNull$$$0(39);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            CPPToolchains.$$$reportNull$$$0(40);
        }
        ArrayList<Toolchain> toolchains = new ArrayList<Toolchain>();
        Element toolchainsElement = state.getChild("toolchains");
        if (toolchainsElement != null) {
            for (Element eachElement : toolchainsElement.getChildren("toolchain")) {
                Toolchain toolchain = new Toolchain(this.myCurrentOSType);
                toolchain.setName(eachElement.getAttributeValue("name"));
                try {
                    String kind = eachElement.getAttributeValue("toolSetKind");
                    toolchain.setToolSetKind(kind == null ? null : CPPToolSet.Kind.valueOf(kind));
                }
                catch (IllegalArgumentException kind) {
                    // empty catch block
                }
                toolchain.setToolSetPath(eachElement.getAttributeValue("toolSetPath"));
                ArrayList<CPPToolSet.Option> toolSetOptions = new ArrayList<CPPToolSet.Option>();
                for (Element eachOptionElement : eachElement.getChildren("toolSetOption")) {
                    ContainerUtil.addIfNotNull(toolSetOptions, (Object)MSVC.loadOption(eachOptionElement));
                }
                toolchain.setToolSetOptions(toolSetOptions);
                String legacyIsUseCustomCMake = eachElement.getAttributeValue("useCustomCMake");
                if (legacyIsUseCustomCMake == null || Boolean.valueOf(legacyIsUseCustomCMake).booleanValue()) {
                    toolchain.setCustomCMakePath(eachElement.getAttributeValue("customCMakePath"));
                }
                toolchain.setCustomMakeToolPath(eachElement.getAttributeValue("customMakePath"));
                toolchain.setCustomCCompilerPath(eachElement.getAttributeValue("customCCompilerPath"));
                toolchain.setCustomCXXCompilerPath(eachElement.getAttributeValue("customCXXCompilerPath"));
                toolchain.setRemoteCredentials(CPPToolchains.loadCredentials(eachElement));
                CPPDebugger.Kind debuggerKind = CPPDebugger.Kind.BUNDLED_GDB;
                try {
                    String kindString = eachElement.getAttributeValue("debuggerKind");
                    if (kindString != null) {
                        debuggerKind = CPPDebugger.Kind.valueOf(kindString);
                    }
                }
                catch (IllegalArgumentException kindString) {
                    // empty catch block
                }
                String customGDBPath = eachElement.getAttributeValue("customGDBPath");
                if (debuggerKind == CPPDebugger.Kind.BUNDLED_GDB) {
                    toolchain.setBundledOrToolSetGdb();
                } else {
                    toolchain.setDebugger(CPPDebugger.create(debuggerKind, customGDBPath));
                }
                toolchain.setOwner(this);
                toolchains.add(toolchain);
            }
        }
        List<Toolchain> list = this.myToolchains_DoNotAccess;
        synchronized (list) {
            this.myToolchainsDetected = true;
            this.myToolchainsDetectedVersion = toolchainsElement == null ? 0 : StringUtil.parseInt((String)toolchainsElement.getAttributeValue("detectedVersion"), (int)0);
            this.myToolchains_DoNotAccess.clear();
            this.myToolchains_DoNotAccess.addAll(toolchains);
        }
    }

    private static void saveCredentials(@NotNull Element root, @Nullable RemoteCredentialsHolder credentials) {
        if (root == null) {
            CPPToolchains.$$$reportNull$$$0(41);
        }
        if (credentials == null) {
            return;
        }
        Element element = new Element("remoteCredentials");
        root.addContent(element);
        credentials.save(element);
    }

    @Nullable
    private static RemoteCredentials loadCredentials(@NotNull Element root) {
        Element element;
        if (root == null) {
            CPPToolchains.$$$reportNull$$$0(42);
        }
        if ((element = root.getChild("remoteCredentials")) != null) {
            RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
            credentials.load(element);
            return credentials;
        }
        return null;
    }

    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @NotNull ToolVersion toolVersion) {
        if (min == null) {
            CPPToolchains.$$$reportNull$$$0(43);
        }
        if (max == null) {
            CPPToolchains.$$$reportNull$$$0(44);
        }
        if (toolVersion == null) {
            CPPToolchains.$$$reportNull$$$0(45);
        }
        return CPPToolchains.checkVersion(min, max, toolVersion.versionNumber);
    }

    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @Nullable Version version) {
        if (min == null) {
            CPPToolchains.$$$reportNull$$$0(46);
        }
        if (max == null) {
            CPPToolchains.$$$reportNull$$$0(47);
        }
        if (version == null || CPPToolchains.compareVersions(min, version) < 0 || CPPToolchains.compareVersions(max, version) > 0) {
            return min.equals((Object)max) ? CPPBundle.message("settings.select.UnsupportedVersion", version, CPPToolchains.toWildcardString(min), CPPToolchains.toWildcardString(max)) : CPPBundle.message("settings.select.UnsupportedVersion.range", version, CPPToolchains.toWildcardString(min), CPPToolchains.toWildcardString(max));
        }
        return null;
    }

    @NotNull
    public static String toWildcardString(@NotNull Version version) {
        if (version == null) {
            CPPToolchains.$$$reportNull$$$0(48);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(version.major);
        if (version.minor != -1) {
            builder.append(".").append(version.minor);
            if (version.bugfix != -1) {
                builder.append(".").append(version.bugfix);
            } else {
                builder.append(".x");
            }
        } else {
            builder.append(".x");
        }
        String string = builder.toString();
        if (string == null) {
            CPPToolchains.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static int compareVersions(@NotNull Version baseline, @NotNull Version version) {
        if (baseline == null) {
            CPPToolchains.$$$reportNull$$$0(50);
        }
        if (version == null) {
            CPPToolchains.$$$reportNull$$$0(51);
        }
        return version.compareTo(baseline.major == -1 ? null : Integer.valueOf(baseline.major), baseline.minor == -1 ? null : Integer.valueOf(baseline.minor), baseline.bugfix == -1 ? null : Integer.valueOf(baseline.bugfix));
    }

    @Nullable
    public static String preparePath(@Nullable String path) {
        return StringUtil.nullize((String)StringUtil.trim((String)path), (boolean)true);
    }

    static {
        ourEmulateCMakeEnvironmentError = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains";
                break;
            }
            case 1: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchains";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renamed";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msvcInstallations";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mingwInstallations";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cygwinInstallations";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testToolchain";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "min";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "max";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolVersion";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericToolchainsFix";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingToolchainsFix";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchains";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchainsInternal";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toWildcardString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestToolParameter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCMakeEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGDBEnvironment";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateToolchain";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkTool";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGenericToolchainsFix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMissingToolchainsFix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultToolchain";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addToolchain";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doAddToolChainUnsafe";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeToolchain";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toolchainsRenamed";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCMakeEnvUpdatedNotification";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fireUpdateEvents";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "detectOnFirstAccess";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestToolchain";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doDetectToolSets";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "saveCredentials";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadCredentials";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "toWildcardString";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGenericToolchainsFix$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Toolchain {
        public static final String DEFAULT = CPPBundle.message("cpp.toolchains.default.name", new Object[0]);
        public static final String UNNAMED = "Unnamed";
        @NotNull
        private final OSType myCurrentOSType;
        @Nullable
        private volatile CPPToolchains myOwner;
        @NotNull
        private volatile String myName;
        @Nullable
        private volatile CPPToolSet.Kind myToolSetKind;
        @Nullable
        private volatile String myToolSetPath;
        @NotNull
        private volatile List<CPPToolSet.Option> myToolSetOptions;
        @Nullable
        private volatile String myCustomCMakePath;
        @Nullable
        private volatile String myCustomMakeToolPath;
        @Nullable
        private volatile String myCustomCCompilerPath;
        @Nullable
        private volatile String myCustomCXXCompilerPath;
        @Nullable
        private volatile RemoteCredentialsHolder myCredentials;
        @NotNull
        private volatile CPPDebugger myDebugger;

        public Toolchain(@NotNull OSType osType) {
            if (osType == null) {
                Toolchain.$$$reportNull$$$0(0);
            }
            this.myName = Toolchain.normalizeToolchainNameOrUnnamed(null);
            this.myToolSetOptions = Collections.emptyList();
            this.myCurrentOSType = osType;
            this.myDebugger = osType == OSType.MAC ? CPPDebugger.bundledLldb() : CPPDebugger.bundledGdb();
        }

        @NotNull
        public OSType getOSType() {
            OSType oSType = this.myCurrentOSType;
            if (oSType == null) {
                Toolchain.$$$reportNull$$$0(1);
            }
            return oSType;
        }

        @Nullable
        private CPPToolchains getOwner() {
            return this.myOwner;
        }

        private void setOwner(@Nullable CPPToolchains owner2) {
            this.myOwner = owner2;
        }

        @NotNull
        public Toolchain copy() {
            Toolchain copy = new Toolchain(this.myCurrentOSType);
            copy.myName = this.myName;
            copy.myToolSetKind = this.myToolSetKind;
            copy.myToolSetPath = this.myToolSetPath;
            copy.myToolSetOptions = this.myToolSetOptions;
            copy.myCustomCMakePath = this.myCustomCMakePath;
            copy.myCustomMakeToolPath = this.myCustomMakeToolPath;
            copy.myCustomCCompilerPath = this.myCustomCCompilerPath;
            copy.myCustomCXXCompilerPath = this.myCustomCXXCompilerPath;
            if (this.myCredentials != null) {
                RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
                RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)this.myCredentials, (MutableRemoteCredentials)holder);
                copy.myCredentials = holder;
            }
            copy.myDebugger = this.myDebugger;
            Toolchain toolchain = copy;
            if (toolchain == null) {
                Toolchain.$$$reportNull$$$0(2);
            }
            return toolchain;
        }

        private void checkForUpdate() {
            CPPToolchains owner2 = this.myOwner;
            if (owner2 != null) {
                owner2.assertCanUpdate();
            }
        }

        private void notifyCMakeChange() {
            CPPToolchains owner2 = this.myOwner;
            if (owner2 != null) {
                owner2.scheduleCMakeEnvUpdatedNotification(this);
            }
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Toolchain.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void setName(String name2) {
            this.checkForUpdate();
            name2 = Toolchain.normalizeToolchainNameOrUnnamed(name2);
            if (!Objects.equals(this.myName, name2)) {
                this.myName = name2;
                this.notifyCMakeChange();
            }
        }

        @NotNull
        public static String normalizeToolchainNameOrUnnamed(@Nullable String name2) {
            String string = (name2 = Toolchain.normalizeToolchainName(name2)) == null ? UNNAMED : name2;
            if (string == null) {
                Toolchain.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public static String normalizeToolchainName(@Nullable String name2) {
            return StringUtil.nullize((String)StringUtil.trim((String)name2));
        }

        @NotNull
        public static String generateToolchainName(@Nullable CPPToolSet.Kind kind) {
            String string = kind == null ? UNNAMED : kind.getDisplayName();
            if (string == null) {
                Toolchain.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public CPPToolSet.Kind getToolSetKind() {
            return this.myToolSetKind;
        }

        public void setToolSetKind(@Nullable CPPToolSet.Kind kind) {
            this.checkForUpdate();
            if (kind != null && !kind.isSupportedOn(this.myCurrentOSType)) {
                return;
            }
            if (this.myToolSetKind != kind) {
                this.myToolSetKind = kind;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public String getToolSetPath() {
            return this.myToolSetPath;
        }

        public void setToolSetPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchains.preparePath(path);
            if (!Objects.equals(this.myToolSetPath, path)) {
                this.myToolSetPath = path;
                this.notifyCMakeChange();
            }
        }

        @NotNull
        public List<CPPToolSet.Option> getToolSetOptions() {
            List<CPPToolSet.Option> list = this.myToolSetOptions;
            if (list == null) {
                Toolchain.$$$reportNull$$$0(6);
            }
            return list;
        }

        public void setToolSetOptions(@NotNull List<CPPToolSet.Option> toolSetOptions) {
            if (toolSetOptions == null) {
                Toolchain.$$$reportNull$$$0(7);
            }
            this.checkForUpdate();
            if (!Objects.equals(this.myToolSetOptions, toolSetOptions)) {
                this.notifyCMakeChange();
                this.myToolSetOptions = Collections.unmodifiableList(toolSetOptions);
            }
        }

        @Nullable
        public String getCustomCMakePath() {
            return this.myCustomCMakePath;
        }

        public void setCustomCMakePath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchains.preparePath(path);
            if (!Objects.equals(this.myCustomCMakePath, path)) {
                this.myCustomCMakePath = path;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public String getCustomMakeToolPath() {
            return this.myCustomMakeToolPath;
        }

        public void setCustomMakeToolPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchains.preparePath(path);
            if (!Objects.equals(this.myCustomMakeToolPath, path)) {
                this.myCustomMakeToolPath = path;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public String getCustomCCompilerPath() {
            return this.myCustomCCompilerPath;
        }

        public void setCustomCCompilerPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchains.preparePath(path);
            if (!Objects.equals(this.myCustomCCompilerPath, path)) {
                this.myCustomCCompilerPath = path;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public String getCustomCXXCompilerPath() {
            return this.myCustomCXXCompilerPath;
        }

        public void setCustomCXXCompilerPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchains.preparePath(path);
            if (!Objects.equals(this.myCustomCXXCompilerPath, path)) {
                this.myCustomCXXCompilerPath = path;
                this.notifyCMakeChange();
            }
        }

        public void setRemoteCredentials(@Nullable RemoteCredentials remoteCredentials) {
            RemoteCredentialsHolder credentials;
            this.checkForUpdate();
            if (remoteCredentials == null) {
                credentials = null;
            } else {
                credentials = new RemoteCredentialsHolder();
                credentials.copyFrom(remoteCredentials);
            }
            if (!Objects.equals(this.myCredentials, credentials)) {
                this.myCredentials = credentials;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public RemoteCredentials getRemoteCredentials() {
            return this.myCredentials;
        }

        @NotNull
        public CPPDebugger getDebugger() {
            CPPDebugger cPPDebugger = this.myDebugger;
            if (cPPDebugger == null) {
                Toolchain.$$$reportNull$$$0(8);
            }
            return cPPDebugger;
        }

        public void setDebugger(@NotNull CPPDebugger debugger) {
            if (debugger == null) {
                Toolchain.$$$reportNull$$$0(9);
            }
            this.checkForUpdate();
            this.myDebugger = debugger;
        }

        public void setBundledOrToolSetGdb() {
            CPPToolSet toolSet = this.getToolSet();
            if (toolSet != null && !toolSet.isBundledGdbCompatible()) {
                this.setDebugger(CPPDebugger.customGdb(toolSet.getGDBPath()));
            } else {
                this.setDebugger(CPPDebugger.bundledGdb());
            }
        }

        @NotNull
        public CPPDebugger.Kind getDebuggerKind() {
            CPPDebugger.Kind kind = this.myDebugger.getKind();
            if (kind == null) {
                Toolchain.$$$reportNull$$$0(10);
            }
            return kind;
        }

        public boolean isUseLLDB() {
            return this.myDebugger.isLldb();
        }

        public boolean isLLDBAvailable() {
            return this.myCurrentOSType != OSType.WIN;
        }

        @Nullable
        public String getCustomGDBExecutablePath() {
            return this.myDebugger.getGdbExecutablePath();
        }

        @Nullable
        public MSVC getMSVC() {
            return (MSVC)this.getToolSetIf(CPPToolSet.Kind.MSVC);
        }

        @Nullable
        public MinGW getMinGW() {
            return (MinGW)this.getToolSetIf(CPPToolSet.Kind.MINGW);
        }

        @Nullable
        public Cygwin getCygwin() {
            return (Cygwin)this.getToolSetIf(CPPToolSet.Kind.CYGWIN);
        }

        @Nullable
        public WSL getWSL() {
            return (WSL)this.getToolSetIf(CPPToolSet.Kind.WSL);
        }

        @Nullable
        public CPPToolSet getToolSet() {
            CPPToolSet.Kind kind = this.myToolSetKind;
            String path = this.myToolSetPath;
            return kind == null || path == null ? null : kind.create(new File(path));
        }

        @Nullable
        public <T extends CPPToolSet> T getToolSetIf(@Nullable CPPToolSet.Kind requiredKind) {
            CPPToolSet.Kind kind = this.myToolSetKind;
            String path = this.myToolSetPath;
            return (T)(kind == null || requiredKind != null && kind != requiredKind || path == null ? null : kind.create(new File(path)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "osType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolSetOptions";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizeToolchainNameOrUnnamed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateToolchainName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolSetOptions";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugger";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setToolSetOptions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setDebugger";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

