/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cygwin
extends CPPToolSet {
    private static final SLRUMap<CacheKey, String> ourLocalToCygwinCache = new SLRUMap(10000, 10000);
    private static final SLRUMap<CacheKey, String> ourCygwinToLocalCache = new SLRUMap(10000, 10000);
    public static final Version MIN_VERSION = new Version(2, 8, 0);
    public static final Version MAX_VERSION = new Version(2, -1, -1);
    private final String myNormalizedHomePath;

    public Cygwin(@NotNull File home) {
        if (home == null) {
            Cygwin.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.CYGWIN, home);
        this.myNormalizedHomePath = FileUtil.normalize((String)home.getPath());
    }

    public boolean isCygwin64() {
        return Cygwin.isCygwin64(this.myHome);
    }

    private static boolean isCygwin64(@NotNull File home) {
        String result;
        File uname;
        if (home == null) {
            Cygwin.$$$reportNull$$$0(1);
        }
        if ((uname = new File(home, "/bin/uname.exe")).isFile() && uname.canExecute() && (result = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{uname.getAbsolutePath(), "-m"}))) != null) {
            return result.trim().equalsIgnoreCase("x86_64");
        }
        return false;
    }

    @Override
    public boolean isBundledGdbCompatible() {
        return false;
    }

    @Override
    @NotNull
    public File getGDBPath() {
        File file = this.getSubFile("bin/gdb.exe");
        if (file == null) {
            Cygwin.$$$reportNull$$$0(2);
        }
        return file;
    }

    @Contract(value="null -> null")
    public static File getCMakePath(@Nullable File home) {
        return home == null ? null : new File(home, "bin/cmake.exe");
    }

    @Contract(value="null -> null")
    public static File getGDBPath(@Nullable File home) {
        return home == null ? null : new File(home, "bin/gdb.exe");
    }

    @Override
    @Nullable
    public String readVersion() {
        return Cygwin.readVersion(this.myHome);
    }

    @Override
    public String checkVersion(@NotNull String version) {
        if (version == null) {
            Cygwin.$$$reportNull$$$0(3);
        }
        return Cygwin.checkVersion(version, this.isCygwin64());
    }

    @Nullable
    public static String checkVersion(@NotNull String version, boolean isX64) {
        if (version == null) {
            Cygwin.$$$reportNull$$$0(4);
        }
        if (isX64) {
            return CPPToolchains.checkVersion(MIN_VERSION, MAX_VERSION, ToolVersion.parse(version, CPPEnvironment.VERSION_PATTERN));
        }
        return "32-bit Cygwin is not supported, please install 64-bit version";
    }

    @Nullable
    public static String readVersion(@Nullable File home) {
        if (home == null) {
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.logReadVersion("Cygwin", null);
            }
            return null;
        }
        File exec = new File(home, "/bin/cygcheck.exe");
        if (!exec.isFile() || !exec.canExecute()) {
            if (CPPLog.LOG.isDebugEnabled()) {
                CPPLog.logReadVersion("Cygwin", exec);
            }
            return null;
        }
        String result = CidrToolsUtil.readOneLineWithProgress(new GeneralCommandLine(new String[]{exec.getAbsolutePath(), "-V"}), 10000);
        if (CPPLog.LOG.isDebugEnabled()) {
            CPPLog.logReadVersion("Cygwin", exec, result);
        }
        return result == null ? null : StringUtil.trimStart((String)result, (String)"cygcheck (cygwin) ");
    }

    @Contract(value="null, _ -> null")
    public static String toLocalPath(@Nullable String cygwinPath, @Nullable Cygwin cygwin) {
        return Cygwin.toLocalPath(null, cygwinPath, cygwin);
    }

    @Contract(value="_, null, _ -> null")
    public static String toLocalPath(@Nullable File localBaseDir, @Nullable String cygwinPath, @Nullable Cygwin cygwin) {
        if (cygwinPath == null) {
            return null;
        }
        if (FileUtil.isWindowsAbsolutePath((String)cygwinPath)) {
            return cygwinPath;
        }
        if (!FileUtil.isUnixAbsolutePath((String)cygwinPath) && localBaseDir != null) {
            String baseDirPath = Cygwin.toCygwinPath(localBaseDir.getPath(), cygwin);
            baseDirPath = StringUtil.trimEnd((String)baseDirPath, (String)"/");
            cygwinPath = FileUtil.toCanonicalPath((String)(baseDirPath + "/" + cygwinPath));
        }
        return Cygwin.doConvert(true, cygwinPath, cygwin, ourCygwinToLocalCache);
    }

    public static boolean isAbsolutePath(@NotNull String cygwinOrWindowsPath) {
        if (cygwinOrWindowsPath == null) {
            Cygwin.$$$reportNull$$$0(5);
        }
        return FileUtil.isAbsolutePlatformIndependent((String)cygwinOrWindowsPath);
    }

    @Contract(value="null, _ -> null")
    public static String toCygwinPath(@Nullable String localPath, @Nullable Cygwin cygwin) {
        return Cygwin.doConvert(false, localPath, cygwin, ourLocalToCygwinCache);
    }

    @Override
    @NotNull
    public char[] getSupportedFileSeparators() {
        if (CidrToolEnvironment.WINDOWS_UNIX_FILE_SEPARATORS == null) {
            Cygwin.$$$reportNull$$$0(6);
        }
        return CidrToolEnvironment.WINDOWS_UNIX_FILE_SEPARATORS;
    }

    public static void convertPathVariableToCygwin(@NotNull GeneralCommandLine cl, @Nullable Cygwin cygwin) {
        String path;
        if (cl == null) {
            Cygwin.$$$reportNull$$$0(7);
        }
        if (cygwin != null && (path = (String)cl.getEnvironment().get("PATH")) != null) {
            List paths = ContainerUtil.map((Object[])path.split(";"), s -> Cygwin.toCygwinPath(s, cygwin));
            cl.getEnvironment().put("PATH", StringUtil.join((Collection)paths, (String)":"));
        }
    }

    @Override
    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<CPPToolSet.Option> options) {
        Application application;
        if (cl == null) {
            Cygwin.$$$reportNull$$$0(8);
        }
        if (prepareFor == null) {
            Cygwin.$$$reportNull$$$0(9);
        }
        if (options == null) {
            Cygwin.$$$reportNull$$$0(10);
        }
        Cygwin.prependPathVariable(cl, this.getSubFilePath("bin"), this.getSubFilePath("usr\\local\\bin"));
        Map env = cl.getEnvironment();
        if (cl.isPassParentEnvironment()) {
            Map system = cl.getParentEnvironment();
            if (system.containsKey("TEMP")) {
                env.put("TEMP", "/tmp");
            }
            if (system.containsKey("TMP")) {
                env.put("TMP", "/tmp");
            }
            if (system.containsKey("USERNAME")) {
                env.put("USER", system.get("USERNAME"));
            }
            if (system.containsKey("COMPUTERNAME")) {
                env.put("HOSTNAME", system.get("COMPUTERNAME"));
            }
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode()) {
            env.put("CMAKE_LEGACY_CYGWIN_WIN32", "0");
        }
    }

    public static boolean processCygwinInstallations(CPPToolSet.InstallationProcessor processor2) {
        List<Trinity<String, File, Boolean>> found = Cygwin.createSortedVersionsList();
        THashSet processed = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        Processor foundProcessor = arg_0 -> Cygwin.lambda$processCygwinInstallations$1((Set)processed, found, arg_0);
        String location = "HKEY_CURRENT_USER\\SOFTWARE\\Cygwin\\Installations";
        for (String eachValue : WindowsRegistryUtil.readRegistryBranchValues((String)location)) {
            String string;
            File file;
            String string2 = WindowsRegistryUtil.readRegistryValue((String)location, (String)eachValue);
            if (string2 == null || foundProcessor.process((Object)(file = new File(string = StringUtil.trimStart((String)string2, (String)"\\??\\"))))) continue;
            return false;
        }
        Object[] rootDirs = new File("C:\\").listFiles();
        if (rootDirs != null) {
            Arrays.sort(rootDirs);
            for (Object each : rootDirs) {
                if (!((File)each).isDirectory() || !StringUtil.containsIgnoreCase((String)((File)each).getName(), (String)"cygwin") || foundProcessor.process(each)) continue;
                return false;
            }
        }
        for (Trinity trinity : found) {
            if (processor2.process((File)trinity.second, (Boolean)trinity.third)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, null, _, _ -> null")
    private static String doConvert(boolean toWindows, @Nullable String path, @Nullable Cygwin cygwin, SLRUMap<CacheKey, String> cache) {
        if (path == null) {
            return null;
        }
        if (cygwin == null) {
            return path;
        }
        if (!SystemInfo.isWindows) {
            return path;
        }
        CacheKey key = new CacheKey(path, cygwin.myNormalizedHomePath);
        SLRUMap<CacheKey, String> sLRUMap = cache;
        synchronized (sLRUMap) {
            String cached = (String)cache.get((Object)key);
            if (cached != null) {
                return cached;
            }
        }
        String result = Cygwin.runCygpath(toWindows, path, cygwin);
        if (result == null) {
            return path;
        }
        SLRUMap<CacheKey, String> sLRUMap2 = cache;
        synchronized (sLRUMap2) {
            cache.put((Object)key, (Object)result);
        }
        return result;
    }

    @Nullable
    private static String runCygpath(boolean toWindows, @NotNull String path, @NotNull Cygwin cygwin) {
        File cygpath;
        if (path == null) {
            Cygwin.$$$reportNull$$$0(11);
        }
        if (cygwin == null) {
            Cygwin.$$$reportNull$$$0(12);
        }
        if (!(cygpath = new File(cygwin.myHome, "\\bin\\cygpath.exe")).canExecute()) {
            return null;
        }
        String result = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{cygpath.getPath(), toWindows ? "-w" : "-u", path}).withCharset(CharsetToolkit.UTF8_CHARSET));
        if (result == null) {
            return null;
        }
        if (toWindows && result.startsWith("\\\\?\\")) {
            result = result.replace("\\\\?\\", "");
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$processCygwinInstallations$1(Set processed, List found, File file) {
        if (!processed.add(file)) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        String version = Cygwin.readVersion(file);
        if (version == null) {
            return true;
        }
        boolean is64 = Cygwin.isCygwin64(file);
        found.add(Trinity.create((Object)version, (Object)file, (Object)is64));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/Cygwin";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cygwinOrWindowsPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cygwin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/Cygwin";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGDBPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCygwin64";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertPathVariableToCygwin";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runCygpath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CacheKey {
        @NotNull
        private final String path;
        @NotNull
        private final String cygwinHome;
        private final int hashCode;

        public CacheKey(@NotNull String path, @NotNull String cygwinHome) {
            if (path == null) {
                CacheKey.$$$reportNull$$$0(0);
            }
            if (cygwinHome == null) {
                CacheKey.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.cygwinHome = cygwinHome;
            this.hashCode = this.calculateHashCode();
        }

        public int calculateHashCode() {
            return 31 * this.path.hashCode() + this.cygwinHome.hashCode();
        }

        public String toString() {
            return this.path + '@' + this.cygwinHome;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (!this.path.equals(other.path)) {
                return false;
            }
            return this.cygwinHome.equals(other.cygwinHome);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cygwinHome";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/toolchains/Cygwin$CacheKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

