/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Triple;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MSVC
extends CPPToolSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.cpp.toolchains.MSVC");
    public static final String VS_VERSION_ENV = "VisualStudioVersion";
    public static final com.intellij.openapi.util.Version MIN_VERSION = new com.intellij.openapi.util.Version(12, -1, -1);
    public static final com.intellij.openapi.util.Version MAX_VERSION = new com.intellij.openapi.util.Version(15, -1, -1);

    public MSVC(@NotNull File home) {
        if (home == null) {
            MSVC.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.MSVC, home);
    }

    @Override
    public String checkVersion(@NotNull String version) {
        String result;
        if (version == null) {
            MSVC.$$$reportNull$$$0(1);
        }
        return (result = CPPToolchains.checkVersion(MIN_VERSION, MAX_VERSION, ToolVersion.parse(version, Pattern.compile("(\\d+\\.\\d+).*")))) != null ? result : "Visual C++ support is experimental";
    }

    @Override
    @Nullable
    public String readVersion() {
        try {
            GeneralCommandLine cl = new GeneralCommandLine(new String[]{""});
            this.prepareEnvironment(cl, CidrToolEnvironment.PrepareFor.BUILD, Collections.emptyList());
            cl.setExePath(MSVC.getCommandExe());
            cl.withParameters(new String[]{"/C", "echo", "VisualStudioVersion=%VisualStudioVersion%"});
            ProcessOutput output = CidrToolsUtil.runWithProgress((BaseProcessHandler)new CapturingProcessHandler(cl), 10000);
            if (output.getExitCode() != 0 || output.isTimeout()) {
                throw new ExecutionException("Exit code: " + output.getExitCode() + "\n" + output.getStdout() + "\n" + output.getStderr());
            }
            Matcher matcher = Pattern.compile("VisualStudioVersion=(\\d.+)").matcher(output.getStdout());
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new ExecutionException("Cannot detect MSVC version:\n" + output.getStdout() + "\n" + output.getStderr());
        }
        catch (ExecutionException e) {
            LOG.info("Cannot read MSVC version: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String readVersion(@NotNull File home) {
        if (home == null) {
            MSVC.$$$reportNull$$$0(2);
        }
        return new MSVC(home).readVersion();
    }

    @Override
    public boolean isBundledGdbCompatible() {
        return false;
    }

    @Override
    @Nullable
    public String isDebugSupportDisabled() {
        return CPPBundle.message("msvc.debug.notSupported", new Object[0]);
    }

    @Override
    @NotNull
    public File getGDBPath() {
        File file = this.getSubFile("VC\\bin\\gdb.exe");
        if (file == null) {
            MSVC.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Override
    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<CPPToolSet.Option> options) throws ExecutionException {
        if (cl == null) {
            MSVC.$$$reportNull$$$0(4);
        }
        if (prepareFor == null) {
            MSVC.$$$reportNull$$$0(5);
        }
        if (options == null) {
            MSVC.$$$reportNull$$$0(6);
        }
        if (prepareFor == CidrToolEnvironment.PrepareFor.BUILD) {
            Triple<Arch, Platform, Version> apv = MSVC.getOptions(options);
            ArrayList<String> args = new ArrayList<String>();
            args.add(apv.component1() != null ? ((Arch)apv.component1()).getValue() : "x86");
            ContainerUtil.addIfNotNull(args, apv.component2() != null ? ((Platform)apv.component2()).getValue() : null);
            ContainerUtil.addIfNotNull(args, apv.component3() != null ? ((Version)apv.component3()).getValue() : null);
            THashMap msvcEnvironment = new THashMap(EnvCache.getEnvironment(this.getVarsAllScript(), args), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            String msvcPath = (String)msvcEnvironment.get("PATH");
            if (msvcPath != null) {
                MSVC.prependPathVariable(cl, msvcPath);
            }
            THashMap userEnvironment = new THashMap(cl.getEnvironment(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            cl.withEnvironment((Map)msvcEnvironment).getEnvironment().putAll(userEnvironment);
        }
    }

    @NotNull
    private String getVarsAllScript() throws ExecutionException {
        String name2 = "vcvarsall.bat";
        String homePath = this.getHomePath();
        File path = new File(homePath, "VC\\" + name2);
        if (path.exists()) {
            String string = path.getAbsolutePath();
            if (string == null) {
                MSVC.$$$reportNull$$$0(7);
            }
            return string;
        }
        path = new File(homePath, "VC\\Auxiliary\\Build\\" + name2);
        if (path.exists()) {
            String string = path.getAbsolutePath();
            if (string == null) {
                MSVC.$$$reportNull$$$0(8);
            }
            return string;
        }
        throw new ExecutionException("Cannot locate vcvarsall.bat in " + homePath + "\nPlease check if Visual C++ support is installed");
    }

    @NotNull
    private static String getCommandExe() throws ExecutionException {
        String cmdPath = System.getenv("ComSpec");
        if (StringUtil.isEmptyOrSpaces((String)cmdPath)) {
            throw new ExecutionException("Windows 'cmd' not found in 'ComSpec' environment variable.");
        }
        String string = cmdPath;
        if (string == null) {
            MSVC.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static OptionsConfigurable createOptionsConfigurable() {
        final List<String> archs = Arrays.asList("x86", "amd64", "arm", "x86_amd64", "x86_arm", "amd64_x86", "amd64_arm");
        OptionsConfigurable optionsConfigurable = new OptionsConfigurable(){
            private ComboBox<String> myArchComboBox;
            private ComboBox<String> myPlatformField;
            private ComboBox<String> myVersionField;

            @Override
            public JPanel createPanel(@NotNull Runnable onChange) {
                if (onChange == null) {
                    1.$$$reportNull$$$0(0);
                }
                JPanel panel = new JPanel(new GridBagLayout());
                GridBag bag = new GridBag().setDefaultInsets(0, 0, 4, 10).setDefaultAnchor(17);
                bag.nextLine();
                panel.add((Component)new JLabel(CPPBundle.message("msvc.option.arch", new Object[0])), bag.next());
                panel.add((Component)new JLabel(CPPBundle.message("msvc.option.platform", new Object[0])), bag.next());
                panel.add((Component)new JLabel(CPPBundle.message("msvc.option.version", new Object[0])), bag.next());
                bag.nextLine();
                this.myArchComboBox = this.createComboWithElementsAndHint(onChange, archs, "x86");
                panel.add((Component)this.myArchComboBox, bag.next());
                this.myPlatformField = this.createComboWithElementsAndHint(onChange, Arrays.asList("store", "uwp", "onecore"), "");
                panel.add((Component)this.myPlatformField, bag.next());
                String versionHint = "8.1 or Windows 10 SDK version";
                this.myVersionField = this.createComboWithElementsAndHint(onChange, Collections.singletonList("8.1"), versionHint);
                this.myVersionField.setToolTipText(versionHint);
                panel.add((Component)this.myVersionField, bag.next().fillCell().coverLine().weightx(1.0).insetRight(0));
                return panel;
            }

            private ComboBox<String> createComboWithElementsAndHint(final Runnable onChange, List<String> values, String hint) {
                ComboBox result = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(values));
                FixedComboBoxEditor editor = new FixedComboBoxEditor();
                result.setEditor((ComboBoxEditor)editor);
                editor.getField().getEmptyText().setText(hint);
                result.setEditable(true);
                ((JTextField)editor.getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        onChange.run();
                    }
                });
                return result;
            }

            @Override
            public boolean isModified(@NotNull List<CPPToolSet.Option> currentOptions) {
                if (currentOptions == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !Comparing.equal((Object)MSVC.getOptions(currentOptions), this.getFieldValues());
            }

            @NotNull
            public Triple<Arch, Platform, Version> getFieldValues() {
                String a = this.getComboBoxValue(this.myArchComboBox);
                String p = this.getComboBoxValue(this.myPlatformField);
                String v = this.getComboBoxValue(this.myVersionField);
                Triple triple = new Triple((Object)(a == null ? null : new Arch(a)), (Object)(p == null ? null : new Platform(p)), (Object)(v == null ? null : new Version(v)));
                if (triple == null) {
                    1.$$$reportNull$$$0(2);
                }
                return triple;
            }

            @Nullable
            public String getComboBoxValue(ComboBox<String> comboBox) {
                return StringUtil.trim((String)StringUtil.nullize((String)((String)comboBox.getEditor().getItem()), (boolean)true));
            }

            @Override
            @NotNull
            public List<CPPToolSet.Option> apply() {
                Triple<Arch, Platform, Version> values = this.getFieldValues();
                ArrayList<CPPToolSet.Option> result = new ArrayList<CPPToolSet.Option>(3);
                ContainerUtil.addIfNotNull(result, (Object)values.component1());
                ContainerUtil.addIfNotNull(result, (Object)values.component2());
                ContainerUtil.addIfNotNull(result, (Object)values.component3());
                ArrayList<CPPToolSet.Option> arrayList = result;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            @Override
            public void reset(@NotNull List<CPPToolSet.Option> currentOptions) {
                Triple apv;
                if (currentOptions == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.myArchComboBox.setSelectedItem((apv = MSVC.getOptions(currentOptions)).component1() == null ? null : ((Arch)apv.component1()).getValue());
                this.myPlatformField.setSelectedItem(apv.component2() == null ? null : ((Platform)apv.component2()).getValue());
                this.myVersionField.setSelectedItem(apv.component3() == null ? null : ((Version)apv.component3()).getValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onChange";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentOptions";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFieldValues";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "apply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPanel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isModified";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "reset";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (optionsConfigurable == null) {
            MSVC.$$$reportNull$$$0(10);
        }
        return optionsConfigurable;
    }

    @NotNull
    private static Triple<Arch, Platform, Version> getOptions(@NotNull List<CPPToolSet.Option> options) {
        if (options == null) {
            MSVC.$$$reportNull$$$0(11);
        }
        Arch a = null;
        Platform p = null;
        Version v = null;
        for (CPPToolSet.Option each : options) {
            if (each instanceof Arch) {
                a = (Arch)each;
            }
            if (each instanceof Platform) {
                p = (Platform)each;
            }
            if (!(each instanceof Version)) continue;
            v = (Version)each;
        }
        Triple triple = new Triple(a, p, v);
        if (triple == null) {
            MSVC.$$$reportNull$$$0(12);
        }
        return triple;
    }

    @Nullable
    public static CPPToolSet.Option loadOption(@NotNull Element element) {
        if (element == null) {
            MSVC.$$$reportNull$$$0(13);
        }
        String type = element.getAttributeValue("type");
        String value = element.getAttributeValue("value");
        if (type == null || value == null) {
            return null;
        }
        switch (type) {
            case "msvc.arch": {
                return new Arch(value);
            }
            case "msvc.platform": {
                return new Platform(value);
            }
            case "version": {
                return new Version(value);
            }
        }
        return null;
    }

    public static boolean processVisualStudioInstallations(CPPToolSet.InstallationProcessor processor2) {
        Processor wrappedProcessor = file -> {
            if (!file.isDirectory()) {
                return true;
            }
            boolean vcInstalled = new File((File)file, "VC").exists();
            return processor2.process((File)file, vcInstalled);
        };
        for (File eachVersionDir : MSVC.sortedSubdirs(new File("C:\\Program Files (x86)\\Microsoft Visual Studio"), (f1, f2) -> -StringUtil.compareVersionNumbers((String)f1, (String)f2))) {
            if (!eachVersionDir.getName().matches("\\d+")) continue;
            for (File eachEditionDir : MSVC.sortedSubdirs(eachVersionDir, (f1, f2) -> f1.compareToIgnoreCase((String)f2))) {
                if (wrappedProcessor.process((Object)eachEditionDir)) continue;
                return false;
            }
        }
        String installDir = WindowsRegistryUtil.readRegistryValue((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\14.0", (String)"InstallDir");
        if (installDir != null && !wrappedProcessor.process((Object)new File(installDir = StringUtil.trimEnd((String)StringUtil.trimEnd((String)installDir, (String)"\\"), (String)"Common7\\IDE")))) {
            return false;
        }
        installDir = WindowsRegistryUtil.readRegistryValue((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\12.0\\Setup\\VS", (String)"ProductDir");
        return installDir == null || wrappedProcessor.process((Object)new File(StringUtil.trimEnd((String)installDir, (String)"\\")));
    }

    @NotNull
    private static List<File> sortedSubdirs(@NotNull File dir, Comparator<String> comparator) {
        File[] subdirs;
        if (dir == null) {
            MSVC.$$$reportNull$$$0(14);
        }
        if ((subdirs = dir.listFiles()) != null) {
            ArrayList<File> list = new ArrayList<File>(Arrays.asList(subdirs));
            list.sort((f1, f2) -> comparator.compare(f1.getName(), f2.getName()));
            ArrayList<File> arrayList = list;
            if (arrayList == null) {
                MSVC.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        List<File> list = Collections.emptyList();
        if (list == null) {
            MSVC.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @NotNull
    public char[] getSupportedFileSeparators() {
        if (CidrToolEnvironment.WINDOWS_UNIX_FILE_SEPARATORS == null) {
            MSVC.$$$reportNull$$$0(17);
        }
        return CidrToolEnvironment.WINDOWS_UNIX_FILE_SEPARATORS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGDBPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarsAllScript";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandExe";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsConfigurable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedSubdirs";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadOption";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortedSubdirs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnvCache {
        private static final Map<List<String>, Map<String, String>> myCache = new ConcurrentHashMap<List<String>, Map<String, String>>();
        private static final AtomicBoolean myListenerAdded = new AtomicBoolean(false);

        private EnvCache() {
        }

        public static Map<String, String> getEnvironment(String script, List<String> args) throws ExecutionException {
            List key;
            Map cached;
            Application application = ApplicationManager.getApplication();
            if (application != null && !myListenerAdded.getAndSet(true)) {
                application.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                    public void applicationDeactivated(IdeFrame ideFrame) {
                        myCache.clear();
                    }
                });
            }
            if ((cached = myCache.get(key = ContainerUtil.concat(Collections.singletonList(script), args))) == null) {
                try {
                    Pair<String, Map<String, String>> outputAndEnv = new EnvironmentUtil.ShellEnvReader(){

                        @NotNull
                        public Pair<String, Map<String, String>> readBatOutputAndEnv(@NotNull File batchFile, List<String> args) throws Exception {
                            if (batchFile == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            Pair pair2 = super.readBatOutputAndEnv(batchFile, args);
                            if (pair2 == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            return pair2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "batchFile";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$EnvCache$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$EnvCache$2";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "readBatOutputAndEnv";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "readBatOutputAndEnv";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    }.readBatOutputAndEnv(new File(script), args);
                    String output = (String)outputAndEnv.first;
                    if (output.contains("Error in script usage") || output.contains("Invalid argument")) {
                        throw new Exception(output);
                    }
                    LOG.info(script + " " + StringUtil.join(args, (String)" ") + ":\n" + output);
                    cached = (Map)outputAndEnv.second;
                    if (application != null) {
                        myCache.put(key, cached);
                    }
                }
                catch (Exception e) {
                    throw new ExecutionException("Cannot load Visual C++ environment from " + script + ":\n" + e.getMessage(), (Throwable)e);
                }
            }
            return cached;
        }
    }

    public static class Version
    extends BasicOption {
        public static final String TYPE = "version";

        public Version(@NotNull String value) {
            if (value == null) {
                Version.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        protected String getType() {
            if (TYPE == null) {
                Version.$$$reportNull$$$0(1);
            }
            return TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$Version";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$Version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Platform
    extends BasicOption {
        public static final String TYPE = "msvc.platform";

        public Platform(@NotNull String value) {
            if (value == null) {
                Platform.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        protected String getType() {
            if (TYPE == null) {
                Platform.$$$reportNull$$$0(1);
            }
            return TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$Platform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$Platform";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Arch
    extends MSVCOption {
        public static final String TYPE = "msvc.arch";
        public static final String DEFAULT = "x86";

        public Arch(@NotNull String value) {
            if (value == null) {
                Arch.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        protected String getType() {
            if (TYPE == null) {
                Arch.$$$reportNull$$$0(1);
            }
            return TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$Arch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$Arch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class MSVCOption
    extends BasicOption {
        public MSVCOption(@NotNull String value) {
            if (value == null) {
                MSVCOption.$$$reportNull$$$0(0);
            }
            super(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/cpp/toolchains/MSVC$MSVCOption", "<init>"));
        }
    }

    protected static abstract class BasicOption
    implements CPPToolSet.Option {
        public static final String TYPE_ATTR = "type";
        public static final String VALUE_ATTR = "value";
        @NotNull
        private final String myValue;

        public BasicOption(@NotNull String value) {
            if (value == null) {
                BasicOption.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                BasicOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void write(@NotNull Element element) {
            if (element == null) {
                BasicOption.$$$reportNull$$$0(2);
            }
            element.setAttribute(TYPE_ATTR, this.getType());
            element.setAttribute(VALUE_ATTR, this.myValue);
        }

        @Override
        @NotNull
        public String getUniqueID() {
            String string = this.getType() + "=" + this.myValue;
            if (string == null) {
                BasicOption.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        protected abstract String getType();

        public String toString() {
            return this.getType() + "=" + this.myValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicOption arch = (BasicOption)o;
            return this.myValue.equals(arch.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = VALUE_ATTR;
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$BasicOption";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$BasicOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUniqueID";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface OptionsConfigurable {
        public JPanel createPanel(@NotNull Runnable var1);

        public boolean isModified(@NotNull List<CPPToolSet.Option> var1);

        @NotNull
        public List<CPPToolSet.Option> apply();

        public void reset(@NotNull List<CPPToolSet.Option> var1);

        default public void disposeUIResources() {
        }
    }
}

