/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.cpp.RemoteUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSL
extends CPPToolSet {
    private static final String MIN_VERSION = "16299.15";
    private static final SLRUMap<String, String> ourSymlinkCache = new SLRUMap(10000, 10000);
    public static final String DEFAULT_CMAKE_PATH = "/usr/bin/cmake";
    public static final String DEFAULT_GDB_PATH = "/usr/bin/gdb";
    public static final Logger LOG = Logger.getInstance(WSL.class);
    @Nullable
    private final WSLDistribution myWslDistribution;
    private static final int RESOLVE_SYMLINK_TIMEOUT = 5000;
    private static final int WSL_START_TIMEOUT = 10000;

    public WSL(@NotNull File file) {
        if (file == null) {
            WSL.$$$reportNull$$$0(0);
        }
        super(CPPToolSet.Kind.WSL, file);
        this.myWslDistribution = WSLCidrUtil.getDistributionByExecutionPath(file.getPath());
    }

    @Override
    @Nullable
    public String readVersion() {
        return this.myWslDistribution != null ? this.myWslDistribution.readReleaseInfo() : null;
    }

    @Override
    public String checkVersion(@NotNull String version) {
        if (version == null) {
            WSL.$$$reportNull$$$0(1);
        }
        if (MIN_VERSION.compareToIgnoreCase(version) > 0) {
            return "Minimum required version (windows build) is 16299.15";
        }
        return null;
    }

    public static List<File> getDistributionFiles() {
        List result = ContainerUtil.map(WSLCidrUtil.getAvailableDistributions(), dist -> dist.getExecutablePath().toFile());
        return Collections.unmodifiableList(result);
    }

    @Override
    @NotNull
    public char[] getSupportedFileSeparators() {
        if (CidrToolEnvironment.UNIX_FILE_SEPARATORS == null) {
            WSL.$$$reportNull$$$0(2);
        }
        return CidrToolEnvironment.UNIX_FILE_SEPARATORS;
    }

    @Override
    @NotNull
    public File getGDBPath() {
        File file = new File(DEFAULT_GDB_PATH);
        if (file == null) {
            WSL.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Override
    public boolean isBundledGdbCompatible() {
        return false;
    }

    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        String localPath = absoluteOrRelativeEnvPath;
        if (!FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath) && localBaseDir != null) {
            localPath = localBaseDir.getPath() + "/" + absoluteOrRelativeEnvPath;
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)localPath);
        if (this.myWslDistribution == null) {
            return canonicalPath;
        }
        if (FileUtil.isUnixAbsolutePath((String)canonicalPath)) {
            String winPath;
            String resolvedPath = canonicalPath;
            if (!canonicalPath.startsWith("/mnt/")) {
                resolvedPath = WSL.resolveSymlink(canonicalPath, this.myWslDistribution, ourSymlinkCache);
            }
            if ((winPath = this.myWslDistribution.getWindowsPath(resolvedPath)) != null) {
                localPath = winPath;
            }
        }
        return localPath;
    }

    public String toEnvPath(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        String path = this.myWslDistribution != null ? this.myWslDistribution.getWslPath(localPath) : null;
        return FileUtil.toSystemIndependentName((String)(path != null ? path : localPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String resolveSymlink(@NotNull String path, @NotNull WSLDistribution distribution, @NotNull SLRUMap<String, String> cache) {
        if (path == null) {
            WSL.$$$reportNull$$$0(4);
        }
        if (distribution == null) {
            WSL.$$$reportNull$$$0(5);
        }
        if (cache == null) {
            WSL.$$$reportNull$$$0(6);
        }
        SLRUMap<String, String> sLRUMap = cache;
        synchronized (sLRUMap) {
            String result = (String)cache.get((Object)path);
            if (result != null) {
                String string = result;
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                if (string == null) {
                    WSL.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String result = distribution.resolveSymlink(path, 5000);
        SLRUMap<String, String> sLRUMap2 = cache;
        synchronized (sLRUMap2) {
            cache.put((Object)path, (Object)result);
        }
        String string = result;
        if (string == null) {
            WSL.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAbsolutePath(@NotNull String wslOrWindowsPath) {
        if (wslOrWindowsPath == null) {
            WSL.$$$reportNull$$$0(9);
        }
        return FileUtil.isAbsolutePlatformIndependent((String)wslOrWindowsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Pair<Boolean, String> verifyConnectionAndSelectedDistribution(@Nullable String toolSetPath, @Nullable RemoteCredentials credentials) {
        block14: {
            Pair pair2;
            boolean connected;
            if (toolSetPath == null) {
                Pair pair3 = Pair.create((Object)false, (Object)"There is no available WSL distribution");
                if (pair3 == null) {
                    WSL.$$$reportNull$$$0(10);
                }
                return pair3;
            }
            WSLDistribution distribution = WSLCidrUtil.getDistributionByExecutionPath(toolSetPath);
            if (distribution == null) {
                Pair pair4 = Pair.create((Object)false, (Object)"There is no available WSL distribution");
                if (pair4 == null) {
                    WSL.$$$reportNull$$$0(11);
                }
                return pair4;
            }
            boolean bl = connected = credentials != null && RemoteUtil.checkConnection(credentials);
            if (!connected) {
                Pair pair5 = Pair.create((Object)false, (Object)"Cannot establish connection");
                if (pair5 == null) {
                    WSL.$$$reportNull$$$0(12);
                }
                return pair5;
            }
            String winFilePath = null;
            try {
                String wslFilePath = RemoteUtil.mktemp(credentials, OSType.LINUX);
                winFilePath = distribution.getWindowsPath(wslFilePath);
                LOG.debug("wsl2win: " + wslFilePath + " -> " + winFilePath);
                if (FileUtil.exists((String)winFilePath)) break block14;
                Pair pair6 = Pair.create((Object)false, (Object)("Credentials are not valid for this WSL distribution (" + distribution.getPresentableName() + ")."));
                pair2 = pair6;
            }
            catch (ExecutionException e) {
                LOG.error("Cannot create temp file", (Throwable)e);
                Pair.create((Object)false, (Object)"WSL: environment execution error");
                break block14;
            }
            finally {
                if (winFilePath != null) {
                    FileUtil.delete((File)new File(winFilePath));
                }
            }
            if (pair2 == null) {
                WSL.$$$reportNull$$$0(13);
            }
            return pair2;
        }
        Pair pair7 = Pair.create((Object)true, (Object)"Connected");
        if (pair7 == null) {
            WSL.$$$reportNull$$$0(14);
        }
        return pair7;
    }

    public static void initWSLToolchain(@NotNull CPPToolchains.Toolchain testToolchain, @NotNull String username, @NotNull String password) {
        if (testToolchain == null) {
            WSL.$$$reportNull$$$0(15);
        }
        if (username == null) {
            WSL.$$$reportNull$$$0(16);
        }
        if (password == null) {
            WSL.$$$reportNull$$$0(17);
        }
        if (LOG.assertTrue(WSLCidrUtil.hasAvailableDistributions())) {
            int attempts;
            WSLDistribution wslDistribution = WSLCidrUtil.getAvailableDistributions().get(0);
            String execPath = wslDistribution.getExecutablePath().toString();
            Stream<ProcessInfo> processStream = Stream.of(ProcessListUtil.getProcessList());
            Optional<ProcessInfo> wslProcess = processStream.filter(p -> p.getCommandLine().equals(execPath)).findFirst();
            if (!wslProcess.isPresent()) {
                try {
                    GeneralCommandLine cl = new GeneralCommandLine(new String[]{"cmd", "/c", "start", execPath});
                    CapturingProcessHandler handler = new CapturingProcessHandler(cl);
                    ProcessOutput output = handler.runProcess(10000);
                    if (output.isTimeout()) {
                        throw new ExecutionException("timeout");
                    }
                    if (output.getExitCode() < 0) {
                        throw new ExecutionException("exit code: " + output.getExitCode() + "\n" + output.getStderr());
                    }
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
            credentials.setUserName(username);
            credentials.setPassword(password);
            credentials.setHost("localhost");
            credentials.setLiteralPort(System.getProperty("cpp.test.wsl.port", "22"));
            for (attempts = 3; !RemoteUtil.checkConnection((RemoteCredentials)credentials) && attempts > 0; --attempts) {
            }
            if (attempts <= 0) {
                StringBuilder message = new StringBuilder();
                message.append("WSL: cannot establish connection to ").append(wslDistribution.getPresentableName());
                message.append("\n\thost = ").append(credentials.getHost());
                message.append("\n\tport = ").append(credentials.getPort());
                message.append("\n\tusername = ").append(credentials.getUserName());
                message.append("\n\tpassword = ").append(credentials.getPassword());
                message.append("\n\texecPath = ").append(execPath);
                message.append("\n\tWSL process is ").append(wslProcess.isPresent() ? "available" : "created");
                message.append(", pid = ");
                if (wslProcess.isPresent()) {
                    message.append(wslProcess.get().getPid());
                } else {
                    Optional<ProcessInfo> newProcess = Stream.of(ProcessListUtil.getProcessList()).filter(p -> p.getCommandLine().equals(execPath)).findFirst();
                    message.append(newProcess.map(ProcessInfo::getPid).orElse(-1));
                }
                throw new RuntimeException(message.toString());
            }
            testToolchain.setToolSetKind(CPPToolSet.Kind.WSL);
            testToolchain.setToolSetPath(execPath);
            testToolchain.setCustomCMakePath(System.getProperty("cpp.test.wsl.cmake", DEFAULT_CMAKE_PATH));
            testToolchain.setRemoteCredentials((RemoteCredentials)credentials);
        }
    }

    static {
        if (SystemInfo.isWindows) {
            LOG.debug("Windows build: " + WSLCidrUtil.getWindowsBuildAndVersion());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSL";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslOrWindowsPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testToolchain";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSL";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGDBPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyConnectionAndSelectedDistribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "initWSLToolchain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

