/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLCidrUtil {
    private static final AtomicNotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = AtomicNotNullLazyValue.createValue(() -> {
        HashMap result = ContainerUtil.newHashMap();
        String lxss = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
        List distributions = WindowsRegistryUtil.readRegistryBranch((String)"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
        WSL.LOG.debug("Processing Lxss registry: " + distributions.size());
        for (String distribution : distributions) {
            String name2 = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"DistributionName");
            String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution), (String)"BasePath");
            WSL.LOG.debug(name2 + ": " + path);
            if (path == null) continue;
            result.put(name2, path + "\\rootfs");
        }
        return Collections.unmodifiableMap(result);
    });
    private static final AtomicNullableLazyValue<String> WINDOWS_BUILD_AND_VERSION = AtomicNullableLazyValue.createValue(() -> {
        if (!SystemInfo.isWindows) {
            return null;
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{ExecUtil.getWindowsShellName(), "/c", "ver"});
        try {
            ProcessOutput result = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)3000);
            if (result.isTimeout() || result.getExitCode() != 0) {
                WSL.LOG.warn("Error while executing `ver` command: " + result.getExitCode());
                return null;
            }
            return result.getStdout().trim();
        }
        catch (ExecutionException e) {
            WSL.LOG.warn("Error while executing `ver` command", (Throwable)e);
            return null;
        }
    });

    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        List distributions = WSLUtil.getAvailableDistributions();
        ArrayList<CidrWSLDistribution> result = new ArrayList<CidrWSLDistribution>(distributions.size());
        for (WSLDistribution distribution : distributions) {
            if (distribution.getId().equals(WSLDistributionLegacy.LEGACY_WSL.getId())) continue;
            result.add(new CidrWSLDistribution(distribution));
        }
        List<WSLDistribution> list = Collections.unmodifiableList(result);
        if (list == null) {
            WSLCidrUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static boolean hasAvailableDistributions() {
        return WSLCidrUtil.getAvailableDistributions().size() > 0;
    }

    @Nullable
    public static WSLDistribution getDistributionByExecutionPath(@NotNull String exePath) {
        if (exePath == null) {
            WSLCidrUtil.$$$reportNull$$$0(1);
        }
        for (WSLDistribution distribution : WSLCidrUtil.getAvailableDistributions()) {
            if (!exePath.equals(distribution.getExecutablePath().toString())) continue;
            return distribution;
        }
        return null;
    }

    @Nullable
    static String getWindowsBuildAndVersion() {
        return (String)WINDOWS_BUILD_AND_VERSION.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByExecutionPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CidrWSLDistribution
    extends WSLDistribution {
        @Nullable
        private final String myWslRootInHost;

        public CidrWSLDistribution(@NotNull WSLDistribution wslDistribution) {
            if (wslDistribution == null) {
                CidrWSLDistribution.$$$reportNull$$$0(0);
            }
            super(wslDistribution);
            this.myWslRootInHost = (String)((Map)DISTRIBUTION_TO_ROOTFS.getValue()).get(wslDistribution.getMsId());
            if (this.myWslRootInHost == null) {
                WSL.LOG.warn("WSL rootfs is null");
            } else if (!FileUtil.exists((String)this.myWslRootInHost)) {
                WSL.LOG.warn("WSL rootfs doesn't exist: " + this.myWslRootInHost);
            }
        }

        @Nullable
        public String getWslPath(@NotNull String windowsPath) {
            if (windowsPath == null) {
                CidrWSLDistribution.$$$reportNull$$$0(1);
            }
            if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)windowsPath, (boolean)true)) {
                return FileUtil.toSystemIndependentName((String)windowsPath.substring(this.myWslRootInHost.length()));
            }
            return super.getWslPath(windowsPath);
        }

        @Nullable
        public String getWindowsPath(@NotNull String wslPath) {
            String windowsPath;
            if (wslPath == null) {
                CidrWSLDistribution.$$$reportNull$$$0(2);
            }
            if ((windowsPath = super.getWindowsPath(wslPath)) != null) {
                return CidrWSLDistribution.prepareWinPath(windowsPath);
            }
            if (this.myWslRootInHost == null) {
                return null;
            }
            return CidrWSLDistribution.prepareWinPath(FileUtil.toSystemDependentName((String)(this.myWslRootInHost + wslPath)));
        }

        @NotNull
        private static String prepareWinPath(@NotNull String path) {
            char c;
            if (path == null) {
                CidrWSLDistribution.$$$reportNull$$$0(3);
            }
            if (Character.isUpperCase(c = path.charAt(0))) {
                String string = path;
                if (string == null) {
                    CidrWSLDistribution.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = StringUtil.toUpperCase((char)c) + path.substring(1);
            if (string == null) {
                CidrWSLDistribution.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslDistribution";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowsPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$CidrWSLDistribution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/WSLCidrUtil$CidrWSLDistribution";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareWinPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getWslPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getWindowsPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareWinPath";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

