/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.openapi.util.Pair;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ValgrindCommandLineParametersBuilder {
    @NotNull
    public List<String> build(@NotNull String outputFile) {
        if (outputFile == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(0);
        }
        ValgrindSettings settings = ValgrindSettings.getInstance();
        List<String> list = this.build(settings.getAnalysisOptions(), settings.getSuppressionFiles(), outputFile);
        if (list == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<String> build(@NotNull String analysisOptions, @NotNull List<String> suppressionFiles, @NotNull String outputFile) {
        if (analysisOptions == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(2);
        }
        if (suppressionFiles == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(3);
        }
        if (outputFile == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(4);
        }
        List<Pair<String, String>> predefinedOptions = Arrays.asList(Pair.create((Object)"--tool", (Object)"memcheck"), Pair.create((Object)"--xml", (Object)"yes"), Pair.create((Object)"--xml-file", (Object)outputFile), Pair.create((Object)"--gen-suppressions", (Object)"all"));
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.addAll(predefinedOptions.stream().map(pair2 -> (String)pair2.first + "=" + (String)pair2.second).collect(Collectors.toList()));
        parameters.addAll(ValgrindCommandLineParametersBuilder.filterAnalysisOptions(analysisOptions, predefinedOptions));
        parameters.addAll(ValgrindCommandLineParametersBuilder.getSuppressionFiles(suppressionFiles));
        ArrayList<String> arrayList = parameters;
        if (arrayList == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static List<String> filterAnalysisOptions(@NotNull String analysisOptions, @NotNull List<Pair<String, String>> predefinedOptions) {
        if (analysisOptions == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(6);
        }
        if (predefinedOptions == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(7);
        }
        List predefinedParameters = predefinedOptions.stream().map(option -> (String)option.first).collect(Collectors.toList());
        List parameters = ParametersListUtil.parse((String)analysisOptions);
        return parameters.stream().filter(parameter -> predefinedParameters.stream().noneMatch(predefinedParameter -> parameter.startsWith((String)predefinedParameter))).collect(Collectors.toList());
    }

    private static List<String> getSuppressionFiles(@NotNull List<String> suppressionFiles) {
        if (suppressionFiles == null) {
            ValgrindCommandLineParametersBuilder.$$$reportNull$$$0(8);
        }
        return suppressionFiles.stream().map(suppressionFile -> "--suppressions=" + suppressionFile).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ValgrindCommandLineParametersBuilder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisOptions";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressionFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindCommandLineParametersBuilder";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterAnalysisOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

