/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.valgrind.ValgrindSettings;
import com.jetbrains.cidr.lang.settings.CPPLanguageConfigurable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindConfigurable
extends CPPLanguageConfigurable {
    private final ValgrindSettings mySettings = ValgrindSettings.getInstance();
    private JBTextField myValgrindPathTextField;
    private final RawCommandLineEditor myCommandLineEditor = new RawCommandLineEditor();
    private DefaultListModel<String> mySuppressionListModel;
    private List<String> mySuppressionFiles = new ArrayList<String>(this.mySettings.getSuppressionFiles());

    @Override
    @NotNull
    public String getId() {
        if ("ValgrindSettings" == null) {
            ValgrindConfigurable.$$$reportNull$$$0(0);
        }
        return "ValgrindSettings";
    }

    @Override
    @Nls
    public String getDisplayName() {
        return "Valgrind";
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        JBLabel label = new JBLabel("Valgrind executable:");
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myValgrindPathTextField = new JBTextField(this.mySettings.getValgrindPath(), 30);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)this.myValgrindPathTextField, "Valgrind Executable Path", "", descriptor2);
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton((JTextField)this.myValgrindPathTextField, (ActionListener)browseFilesListener);
        panel.add((Component)textFieldWithBrowseButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel.add((Component)this.createMemcheckSettings(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    @Override
    public boolean isModified() {
        return !this.myValgrindPathTextField.getText().equals(this.mySettings.getValgrindPath()) || !this.myCommandLineEditor.getText().equals(this.mySettings.getAnalysisOptions()) || !this.mySuppressionFiles.equals(this.mySettings.getSuppressionFiles());
    }

    @Override
    public void apply() throws ConfigurationException {
        this.mySettings.setValgrindPath(this.myValgrindPathTextField.getText());
        this.mySettings.setAnalysisOptions(this.myCommandLineEditor.getText());
        this.mySettings.setSuppressionFiles(this.mySuppressionFiles);
    }

    public void reset() {
        this.myValgrindPathTextField.setText(this.mySettings.getValgrindPath());
        this.myCommandLineEditor.setText(this.mySettings.getAnalysisOptions());
        this.mySuppressionFiles = new ArrayList<String>(this.mySettings.getSuppressionFiles());
        this.resetSuppressionFilesModel();
    }

    private JPanel createMemcheckSettings() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Memcheck", (boolean)false));
        panel.add((Component)new JLabel("Analysis options:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel.add((Component)this.myCommandLineEditor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JBLabel hintTitle = new JBLabel("These arguments will be added automatically:", UIUtil.ComponentStyle.SMALL);
        JBLabel hintArguments = new JBLabel("--tool=memcheck, --xml=yes, --xml-file=<file>, --gen-suppressions=all, <program>, program arguments and all suppression files", UIUtil.ComponentStyle.SMALL);
        panel.add((Component)hintTitle, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel.add((Component)hintArguments, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel suppressionFilesPanel = this.createSuppressionFilesPanel();
        panel.add((Component)suppressionFilesPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)25, (int)0, (int)0, (int)0), 0, 0));
        return panel;
    }

    private JPanel createSuppressionFilesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.mySuppressionListModel = new DefaultListModel();
        for (String suppressionFile : this.mySuppressionFiles) {
            this.mySuppressionListModel.addElement(suppressionFile);
        }
        final JBList suppressionFilesList = new JBList(this.mySuppressionListModel);
        suppressionFilesList.getEmptyText().setText("No suppression files");
        suppressionFilesList.setSelectionMode(0);
        suppressionFilesList.setVisibleRowCount(5);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)suppressionFilesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"supp");
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, null, files -> {
                    String filePath = ((VirtualFile)files.get(0)).getPath();
                    ValgrindConfigurable.this.mySuppressionListModel.addElement(filePath);
                    ValgrindConfigurable.this.mySuppressionFiles.add(filePath);
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedIndex = suppressionFilesList.getSelectedIndex();
                ValgrindConfigurable.this.mySuppressionListModel.remove(selectedIndex);
                ValgrindConfigurable.this.mySuppressionFiles.remove(selectedIndex);
            }
        }).setButtonComparator(new String[]{CommonActionsPanel.Buttons.ADD.getText(), CommonActionsPanel.Buttons.REMOVE.getText()});
        decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
        panel.add((Component)new JLabel("Add suppression files:"), "North");
        panel.add((Component)decorator.createPanel(), "Center");
        return panel;
    }

    private void resetSuppressionFilesModel() {
        this.mySuppressionListModel.removeAllElements();
        for (String suppressionFile : this.mySuppressionFiles) {
            this.mySuppressionListModel.addElement(suppressionFile);
        }
    }

    @Nullable
    public String getHelpTopic() {
        return "Valgrind";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurable", "getId"));
    }
}

