/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.StatusText;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.cpp.execution.CLionRunConfigurationExtensionBase;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.valgrind.ValgrindCommandLineParametersBuilder;
import com.jetbrains.cidr.cpp.valgrind.ValgrindConsoleViewWrapper;
import com.jetbrains.cidr.cpp.valgrind.ValgrindHandler;
import com.jetbrains.cidr.cpp.valgrind.ValgrindOutputConsumer;
import com.jetbrains.cidr.cpp.valgrind.ValgrindOutputReader;
import com.jetbrains.cidr.cpp.valgrind.ValgrindRunnerSettings;
import com.jetbrains.cidr.cpp.valgrind.ValgrindSettings;
import com.jetbrains.cidr.cpp.valgrind.ValgrindUtil;
import com.jetbrains.cidr.cpp.valgrind.model.ValgrindTreeDataModel;
import com.jetbrains.cidr.cpp.valgrind.tree.ValgrindTree;
import com.jetbrains.cidr.cpp.valgrind.ui.ValgrindOutputPanel;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindConfigurationExtension
extends CLionRunConfigurationExtensionBase {
    private static final Logger LOG = Logger.getInstance(ValgrindConfigurationExtension.class);

    protected boolean isApplicableFor(@NotNull CidrRunConfiguration configuration) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(0);
        }
        return configuration instanceof CMakeAppRunConfiguration;
    }

    protected boolean isEnabledFor(@NotNull CidrRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(1);
        }
        return ValgrindUtil.isAvailableForPlatform() && runnerSettings instanceof ValgrindRunnerSettings;
    }

    @Override
    protected void patchCommandLine(@NotNull CidrRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment env, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (env == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (cmdLine == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (!"ValgrindRunner".equals(runnerId) || !(runnerSettings instanceof ValgrindRunnerSettings)) {
            return;
        }
        String programPath = env.toEnvPath(cmdLine.getExePath());
        String valgrindPath = env.toEnvPath(ValgrindSettings.getInstance().getValgrindPath());
        if (!env.isFileExist(programPath)) {
            throw new ExecutionException(CidrBundle.message("run.fileNotFound", programPath));
        }
        if (!env.isFileExist(valgrindPath)) {
            throw new ExecutionException(CidrBundle.message("valgrind.fileNotFound", valgrindPath));
        }
        try {
            File outputFile = FileUtil.createTempFile((String)"valgrind", null, (boolean)true);
            String outputFilePath = env.toEnvPath(outputFile.getAbsolutePath());
            cmdLine.setExePath(valgrindPath);
            ValgrindCommandLineParametersBuilder parametersBuilder = new ValgrindCommandLineParametersBuilder();
            List<String> valgrindParameters = parametersBuilder.build(outputFilePath);
            valgrindParameters.add(programPath);
            cmdLine.getParametersList().prependAll(ArrayUtil.toStringArray(valgrindParameters));
            ((ValgrindRunnerSettings)runnerSettings).setOutputFile(outputFile);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Override
    protected void attachToProcess(@NotNull CidrRunConfiguration configuration, @NotNull ProcessHandler processHandler, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (!(runnerSettings instanceof ValgrindRunnerSettings)) {
            return;
        }
        ValgrindRunnerSettings valgrindRunnerSettings = (ValgrindRunnerSettings)runnerSettings;
        final File outputFile = valgrindRunnerSettings.getOutputFile();
        LOG.assertTrue(outputFile != null && outputFile.exists());
        ValgrindTreeDataModel treeDataModel = valgrindRunnerSettings.getTreeDataModel();
        LOG.assertTrue(treeDataModel != null);
        ValgrindOutputPanel outputPanel = valgrindRunnerSettings.getOutputPanel();
        LOG.assertTrue(outputPanel != null);
        try {
            ValgrindHandler handler = new ValgrindHandler(treeDataModel, environment);
            final ValgrindOutputConsumer consumer = new ValgrindOutputConsumer(handler);
            final ValgrindOutputReader outputReader = new ValgrindOutputReader(outputFile, consumer);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        outputReader.stop();
                        outputReader.waitFor();
                        Disposer.dispose((Disposable)consumer);
                        ValgrindConfigurationExtension.deleteFile(outputFile);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Exception during processListener cleanup: " + e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension$1", "processTerminated"));
                }
            });
            ValgrindConfigurationExtension.configureUIListeners(outputPanel, processHandler, configuration.getProject());
        }
        catch (IOException e) {
            LOG.warn("Exception during processListener setup: " + e);
        }
    }

    @Override
    protected void patchCommandLineState(@NotNull CidrRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId) {
        if (configuration == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(10);
        }
        if (state == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (runnerId == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(12);
        }
        if (!(runnerSettings instanceof ValgrindRunnerSettings)) {
            return;
        }
        ValgrindRunnerSettings valgrindRunnerSettings = (ValgrindRunnerSettings)runnerSettings;
        final Project project2 = configuration.getProject();
        ValgrindTreeDataModel treeDataModel = new ValgrindTreeDataModel(project2);
        final ValgrindOutputPanel outputPanel = new ValgrindOutputPanel(treeDataModel, project2);
        valgrindRunnerSettings.setTreeDataModel(treeDataModel);
        valgrindRunnerSettings.setOutputPanel(outputPanel);
        final ConsoleView console = state.getConsoleBuilder().getConsole();
        state.setConsoleBuilder((TextConsoleBuilder)new CidrConsoleBuilder(project2, environment, projectBaseDir){

            public ConsoleView getConsole() {
                return new ValgrindConsoleViewWrapper(console, outputPanel, project2);
            }
        });
    }

    private static void configureUIListeners(@NotNull ValgrindOutputPanel outputPanel, @NotNull ProcessHandler processHandler, @NotNull Project project2) {
        if (outputPanel == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(13);
        }
        if (processHandler == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(15);
        }
        final Application application = ApplicationManager.getApplication();
        final Condition expiredCondition = c -> {
            if (project2 == null) {
                ValgrindConfigurationExtension.$$$reportNull$$$0(17);
            }
            return !project2.isOpen() || project2.isDisposed();
        };
        final ValgrindTree tree = outputPanel.getTree();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                application.invokeLater(() -> {
                    tree.setPaintBusy(true);
                    tree.getEmptyText().setText(CidrBundle.message("valgrind.progress", new Object[0]));
                }, expiredCondition);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                application.invokeLater(() -> {
                    tree.setPaintBusy(false);
                    tree.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                }, expiredCondition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void deleteFile(@NotNull File file) {
        Application application;
        if (file == null) {
            ValgrindConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (!(application = ApplicationManager.getApplication()).isUnitTestMode() && !application.isInternal()) {
            FileUtil.delete((File)file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPanel";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProcess";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLineState";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "configureUIListeners";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$configureUIListeners$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

