/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindAuxiliaryData;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindError;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindFrame;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindMessage;
import com.jetbrains.cidr.cpp.valgrind.error.ValgrindStack;
import com.jetbrains.cidr.cpp.valgrind.model.ValgrindTreeDataModel;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValgrindHandler
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(ValgrindHandler.class);
    private static final String ERROR_ELEMENT = "error";
    private static final String KIND_ELEMENT = "kind";
    private static final String WHAT_ELEMENT = "what";
    private static final String XWHAT_ELEMENT = "xwhat";
    private static final String STACK_ELEMENT = "stack";
    private static final String FRAME_ELEMENT = "frame";
    private static final String IP_ELEMENT = "ip";
    private static final String OBJ_ELEMENT = "obj";
    private static final String FN_ELEMENT = "fn";
    private static final String DIR_ELEMENT = "dir";
    private static final String FILE_ELEMENT = "file";
    private static final String LINE_ELEMENT = "line";
    private static final String TEXT_ELEMENT = "text";
    private static final String AUXWHAT_ELEMENT = "auxwhat";
    private static final String XAUXWHAT_ELEMENT = "xauxwhat";
    private static final String SUPPRESSION_ELEMENT = "suppression";
    private static final String RAW_TEXT_ELEMENT = "rawtext";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    @NotNull
    private final ValgrindTreeDataModel myModel;
    private final CidrToolEnvironment myEnvironment;
    private boolean myInsideErrorElement;
    private boolean myInsideXWhatElement;
    private boolean myInsideXAuxWhatElement;
    private boolean myInsideSuppression;
    private boolean myPrimaryStackProcessed;
    private ValgrindError myCurrentError;
    private StringBuilder myElementText;

    public ValgrindHandler(@NotNull ValgrindTreeDataModel model2, @NotNull CidrToolEnvironment environment) {
        if (model2 == null) {
            ValgrindHandler.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            ValgrindHandler.$$$reportNull$$$0(1);
        }
        this.myModel = model2;
        this.myEnvironment = environment;
        this.myInsideErrorElement = false;
        this.myInsideXWhatElement = false;
        this.myInsideXAuxWhatElement = false;
        this.myInsideSuppression = false;
        this.myPrimaryStackProcessed = false;
        this.myCurrentError = null;
        this.myElementText = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ERROR_ELEMENT)) {
            this.myInsideErrorElement = true;
            this.myPrimaryStackProcessed = false;
            this.startNewError();
            this.clearTextBuffer();
            return;
        }
        if (!this.myInsideErrorElement) {
            return;
        }
        if (qName.equals(XAUXWHAT_ELEMENT)) {
            this.myInsideXAuxWhatElement = true;
        } else if (qName.equals(XWHAT_ELEMENT)) {
            this.myInsideXWhatElement = true;
        } else if (qName.equals(STACK_ELEMENT)) {
            if (this.myPrimaryStackProcessed) {
                this.myCurrentError.addAuxiliaryData(new ValgrindAuxiliaryData(new ValgrindStack()));
            } else {
                this.myCurrentError.setStack(new ValgrindStack());
            }
        } else if (qName.equals(FRAME_ELEMENT)) {
            this.getCurrentStack().pushFrame(new ValgrindFrame());
        } else if (qName.equals(SUPPRESSION_ELEMENT)) {
            this.myInsideSuppression = true;
        }
        this.clearTextBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myInsideErrorElement) {
            this.myElementText.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.myInsideErrorElement) {
            this.clearTextBuffer();
            return;
        }
        if (this.myInsideSuppression) {
            if (qName.equals(SUPPRESSION_ELEMENT)) {
                this.myInsideSuppression = false;
            } else if (qName.equals(RAW_TEXT_ELEMENT)) {
                String rawText = this.myElementText.toString();
                this.myCurrentError.setRawSuppression(ValgrindHandler.removeCDataFromRawText(rawText));
            }
            this.clearTextBuffer();
            return;
        }
        if (this.myInsideXAuxWhatElement) {
            if (qName.equals(TEXT_ELEMENT)) {
                this.getOrCreateAuxiliaryMessage().appendText(this.myElementText.toString());
            } else if (qName.equals(XAUXWHAT_ELEMENT)) {
                this.myInsideXAuxWhatElement = false;
            } else {
                this.getOrCreateAuxiliaryMessage().addExtraData(qName, this.myElementText.toString());
            }
        } else if (this.myInsideXWhatElement) {
            ValgrindMessage message = this.myCurrentError.getMessage();
            if (qName.equals(TEXT_ELEMENT)) {
                message.appendText(this.myElementText.toString());
            } else if (qName.equals(XWHAT_ELEMENT)) {
                this.myInsideXWhatElement = false;
            } else {
                message.addExtraData(qName, this.myElementText.toString());
            }
        } else if (qName.equals(ERROR_ELEMENT)) {
            this.myInsideErrorElement = false;
            ValgrindError error = this.myCurrentError;
            ApplicationManager.getApplication().invokeLater(() -> this.myModel.addError(error));
        } else if (qName.equals(KIND_ELEMENT)) {
            this.myCurrentError.setKind(this.myElementText.toString());
        } else if (qName.equals(WHAT_ELEMENT)) {
            ValgrindMessage message = this.myCurrentError.getMessage();
            message.appendText(this.myElementText.toString());
        } else if (qName.equals(STACK_ELEMENT)) {
            this.myPrimaryStackProcessed = true;
        } else if (qName.equals(IP_ELEMENT)) {
            this.getCurrentFrame().setInstructionPointer(this.myElementText.toString());
        } else if (qName.equals(OBJ_ELEMENT)) {
            this.getCurrentFrame().setObject(this.toLocalPath(this.myElementText.toString()));
        } else if (qName.equals(FN_ELEMENT)) {
            this.getCurrentFrame().setFunction(this.myElementText.toString());
        } else if (qName.equals(DIR_ELEMENT)) {
            this.getCurrentFrame().setDirectory(this.toLocalPath(this.myElementText.toString()));
        } else if (qName.equals(FILE_ELEMENT)) {
            this.getCurrentFrame().setFile(this.myElementText.toString());
        } else if (qName.equals(LINE_ELEMENT)) {
            this.getCurrentFrame().setLine(this.myElementText.toString());
        } else if (qName.equals(AUXWHAT_ELEMENT)) {
            this.getOrCreateAuxiliaryMessage().appendText(this.myElementText.toString());
        }
        this.clearTextBuffer();
    }

    @NotNull
    private ValgrindMessage getOrCreateAuxiliaryMessage() {
        ValgrindAuxiliaryData lastData;
        List<ValgrindAuxiliaryData> auxiliaryData = this.myCurrentError.getAuxiliaryDataList();
        if (!auxiliaryData.isEmpty() && (lastData = auxiliaryData.get(auxiliaryData.size() - 1)).isMessage()) {
            ValgrindMessage valgrindMessage = lastData.getMessage();
            if (valgrindMessage == null) {
                ValgrindHandler.$$$reportNull$$$0(2);
            }
            return valgrindMessage;
        }
        ValgrindMessage message = new ValgrindMessage();
        auxiliaryData.add(new ValgrindAuxiliaryData(message));
        ValgrindMessage valgrindMessage = message;
        if (valgrindMessage == null) {
            ValgrindHandler.$$$reportNull$$$0(3);
        }
        return valgrindMessage;
    }

    @NotNull
    private ValgrindStack getCurrentStack() {
        if (!this.myPrimaryStackProcessed) {
            ValgrindStack valgrindStack = this.myCurrentError.getStack();
            if (valgrindStack == null) {
                ValgrindHandler.$$$reportNull$$$0(4);
            }
            return valgrindStack;
        }
        List<ValgrindAuxiliaryData> auxiliaryData = this.myCurrentError.getAuxiliaryDataList();
        LOG.assertTrue(!auxiliaryData.isEmpty());
        ValgrindAuxiliaryData lastData = auxiliaryData.get(auxiliaryData.size() - 1);
        LOG.assertTrue(lastData.isStack());
        ValgrindStack valgrindStack = lastData.getStack();
        if (valgrindStack == null) {
            ValgrindHandler.$$$reportNull$$$0(5);
        }
        return valgrindStack;
    }

    @NotNull
    private String toLocalPath(@NotNull String path) {
        if (path == null) {
            ValgrindHandler.$$$reportNull$$$0(6);
        }
        String string = this.myEnvironment.toLocalPath(path);
        if (string == null) {
            ValgrindHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private ValgrindFrame getCurrentFrame() {
        ValgrindFrame valgrindFrame = this.getCurrentStack().getOutermostFrame();
        if (valgrindFrame == null) {
            ValgrindHandler.$$$reportNull$$$0(8);
        }
        return valgrindFrame;
    }

    private void startNewError() {
        this.myCurrentError = new ValgrindError();
    }

    private void clearTextBuffer() {
        this.myElementText = new StringBuilder();
    }

    private static String removeCDataFromRawText(@NotNull String rawText) {
        if (rawText == null) {
            ValgrindHandler.$$$reportNull$$$0(9);
        }
        StringBuilder filteredText = new StringBuilder();
        int restIndex = 0;
        int beginIndex = rawText.indexOf(CDATA_BEGIN);
        while (beginIndex != -1) {
            int endIndex = rawText.indexOf(CDATA_END, beginIndex);
            LOG.assertTrue(endIndex != -1);
            filteredText.append(rawText, beginIndex + CDATA_BEGIN.length(), endIndex);
            restIndex = endIndex + CDATA_END.length();
            beginIndex = rawText.indexOf(CDATA_BEGIN, restIndex);
        }
        if (restIndex < rawText.length()) {
            filteredText.append(rawText, restIndex, rawText.length());
        }
        return filteredText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/ValgrindHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/ValgrindHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAuxiliaryMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStack";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toLocalPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeCDataFromRawText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

